/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4;

import com.syllogic.miningmart.m4.BaseAttribute;
import com.syllogic.miningmart.m4.CaseAttribute;
import com.syllogic.miningmart.m4.CaseInput;
import com.syllogic.miningmart.m4.Chain;
import com.syllogic.miningmart.m4.Concept;
import com.syllogic.miningmart.m4.Documentation;
import com.syllogic.miningmart.m4.M4Interface;
import com.syllogic.miningmart.m4.M4Object;
import com.syllogic.miningmart.m4.MultiColumnFeature;
import com.syllogic.miningmart.m4.Relationship;
import com.syllogic.miningmart.m4.Step;
import com.syllogic.miningmart.m4.Value;
import com.syllogic.miningmart.m4.ejb.Cases;
import com.syllogic.miningmart.m4.ejb.CasesHome;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import miningmart.compilerInterface.CompilerAccess;
import miningmart.compilerInterface.M4CompilerInterfaceError;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import miningmart.m4.value.CaseV;
import miningmart.m4.value.DocumentationV;
import org.apache.log4j.Logger;

public class Case
extends M4Object
implements miningmart.m4.Case,
Serializable {
    private CaseV value;
    private static Logger logger = Logger.getLogger((String)"com.syllogic.miningmart.m4.Case");
    private boolean functionallyValid = false;
    private static Map cache = new HashMap();
    private static CasesHome home = null;

    public Case() {
        this.value = new CaseV();
        this.setExisting(false);
        this.setChanged(true);
    }

    public Case(CaseV value) {
        this.value = value;
        this.setExisting(true);
        this.setChanged(false);
    }

    public int getId() {
        return this.value.getId();
    }

    public String getName() {
        return this.value.getName();
    }

    public void setName(String name) throws NameExistsException {
        if (Case.getByName(name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        this.value.setName(name);
        this.setChanged(true);
    }

    public String getMode() {
        return this.value.getMode();
    }

    public void setMode(String mode) {
        this.value.setMode(mode);
        this.setChanged(true);
    }

    public miningmart.m4.Concept getPopulation() {
        if (this.value.getPopulationName() == null) {
            return null;
        }
        return Concept.getById(this.value.getPopulation());
    }

    public void setPopulation(miningmart.m4.Concept rec) throws StorageException {
        if (rec == null) {
            if (this.value.getPopulationName() != null) {
                this.value.setPopulationName(null);
                this.setChanged(true);
            }
            return;
        }
        Concept anObj = (Concept)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setPopulation(anObj.getId());
        this.value.setPopulationName(anObj.getName());
        this.setChanged(true);
    }

    public miningmart.m4.Concept getOutput() {
        if (this.value.getOutputName() == null) {
            return null;
        }
        return Concept.getById(this.value.getOutput());
    }

    public void setOutput(miningmart.m4.Concept rec) throws StorageException {
        if (rec == null) {
            if (this.value.getOutputName() != null) {
                this.value.setOutputName(null);
                this.setChanged(true);
            }
            return;
        }
        Concept anObj = (Concept)rec;
        if (!anObj.isExisting()) {
            anObj.store();
        }
        this.value.setOutput(anObj.getId());
        this.value.setOutputName(anObj.getName());
        this.setChanged(true);
    }

    public boolean isFunctionallyValid() {
        return this.functionallyValid;
    }

    public void setFunctionallyValid(boolean functionallyValid) {
        this.functionallyValid = functionallyValid;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRelationallyValid() {
        Cases anEJB = null;
        boolean valid = false;
        anEJB = Case.getEJB();
        valid = anEJB.getValidity(this.getId());
        Object var5_3 = null;
        if (anEJB == null) return valid;
        try {
            anEJB.remove();
            return valid;
        }
        catch (Exception exception) {}
        return valid;
        {
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
                Object var5_4 = null;
                if (anEJB == null) return valid;
                try {
                    anEJB.remove();
                    return valid;
                }
                catch (Exception exception) {}
                return valid;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var5_5 = null;
                if (anEJB == null) return valid;
                try {
                    anEJB.remove();
                    return valid;
                }
                catch (Exception exception) {}
                return valid;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Step createStep(String name) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null) {
            throw new miningmart.m4.CreateException("Name for Step should be included");
        }
        if (Step.getByCaseAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        Step step = new Step();
        try {
            step.setName(name);
            step.setCase(this);
        }
        catch (StorageException e) {
            logger.error((Object)"Could not connect case to step.");
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return step;
    }

    public void addStep(miningmart.m4.Step step) throws StorageException {
        step.setCase(this);
    }

    public miningmart.m4.Step getStep(String name) {
        return Step.getByCaseAndName(this.getId(), name);
    }

    public Collection getAllSteps() {
        return Step.getByCase(this.getId());
    }

    public Collection getAllStepNames() {
        return Step.getAllNames();
    }

    public void removeStep(String name) throws StorageException {
        this.getStep(name).delete();
    }

    public void removeAllSteps() throws StorageException {
        Iterator it = this.getAllSteps().iterator();
        while (it.hasNext()) {
            ((Step)it.next()).delete();
        }
    }

    public miningmart.m4.Chain createChain(String name) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null) {
            throw new miningmart.m4.CreateException("Name should be included");
        }
        if (Chain.getByCaseAndName(this.getId(), name) != null) {
            throw new NameExistsException("Duplicate name");
        }
        Chain rec = new Chain();
        try {
            rec.setName(name);
            rec.setCase(this);
        }
        catch (StorageException e) {
            logger.error((Object)"Could not connect case to chain.", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    public void addChain(miningmart.m4.Chain rec) throws StorageException {
        rec.setCase(this);
    }

    public miningmart.m4.Chain getChain(String name) {
        return Chain.getByCaseAndName(this.getId(), name);
    }

    public Collection getAllChains() {
        return Chain.getByCase(this.getId());
    }

    public Collection getAllChainNames() {
        return Chain.getAllNames();
    }

    public void removeChain(String name) throws StorageException {
        this.getChain(name).delete();
    }

    public void removeAllChains() throws StorageException {
        Iterator it = this.getAllChains().iterator();
        while (it.hasNext()) {
            ((Chain)it.next()).delete();
        }
    }

    public miningmart.m4.Concept createConcept(String name, String type) throws NameExistsException, miningmart.m4.CreateException {
        if (name == null || type == null) {
            throw new miningmart.m4.CreateException("Name and type should be included");
        }
        if (this.conceptNameExists(name)) {
            throw new NameExistsException("Duplicate name");
        }
        Concept rec = new Concept();
        try {
            rec.setName(name);
            rec.setCase(this);
            rec.setConceptType(type);
            rec.store();
            logger.info((Object)String.valueOf("Stored concept successfully:  ").concat(String.valueOf(rec.getName())));
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store Concept", (Throwable)e);
            throw new miningmart.m4.CreateException("A storage exception occurred.");
        }
        return rec;
    }

    private boolean conceptNameExists(String name) {
        return Concept.getByCaseAndName(this.getId(), name) != null;
    }

    public miningmart.m4.Concept getConcept(String name) {
        return Concept.getByCaseAndName(this.getId(), name);
    }

    public Collection getAllConcepts() {
        return Concept.getByCase(this.getId());
    }

    public Collection getAllConceptNames() {
        return Concept.getAllNames();
    }

    public void removeConcept(String name) throws StorageException {
        this.getConcept(name).delete();
    }

    public void removeAllConcepts() throws StorageException {
        Iterator it = this.getAllConcepts().iterator();
        while (it.hasNext()) {
            ((Concept)it.next()).delete();
        }
    }

    public Collection getAllValues() {
        return Value.getAllValues();
    }

    public Collection getAllValueNames() {
        return Value.getAllNames();
    }

    public void removeAllValues() throws StorageException {
        Iterator it = this.getAllValues().iterator();
        while (it.hasNext()) {
            ((Value)it.next()).delete();
        }
    }

    public Collection getConceptsByType(String type) {
        return Concept.getByCaseAndType(this.getId(), type);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCaseInput(miningmart.m4.M4Object rec) {
        M4Object anObj = (M4Object)rec;
        Cases anEJB = null;
        anEJB = Case.getEJB();
        String objType = null;
        if (anObj instanceof BaseAttribute) {
            objType = "BA";
        } else if (anObj instanceof MultiColumnFeature) {
            objType = "MCF";
        } else if (anObj instanceof Concept) {
            objType = "CON";
        } else if (anObj instanceof Relationship) {
            objType = "REL";
        } else if (anObj instanceof Value) {
            objType = "V";
        }
        anEJB.addCaseInput(this.getId(), anObj.getId(), objType);
        Object var6_7 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication failure", (Throwable)e);
                Object var6_8 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_9 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public Collection getAllCaseInputs() {
        return CaseInput.getByCase(this.getId());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeCaseInput(miningmart.m4.M4Object rec) {
        M4Object anObj = (M4Object)rec;
        Cases anEJB = null;
        anEJB = Case.getEJB();
        anEJB.removeCaseInput(this.getId(), anObj.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllCaseInputs() {
        Cases anEJB = null;
        anEJB = Case.getEJB();
        Iterator it = this.getAllCaseInputs().iterator();
        while (it.hasNext()) {
            anEJB.removeCaseInput(this.getId(), ((M4Object)it.next()).getId());
        }
        Object var4_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication failure", (Throwable)e);
                Object var4_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCaseAttribute(miningmart.m4.BaseAttribute rec) {
        BaseAttribute anObj = (BaseAttribute)rec;
        Cases anEJB = null;
        anEJB = Case.getEJB();
        anEJB.addCaseAttribute(this.getId(), anObj.getId(), "BA");
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public Collection getAllCaseAttributes() {
        return CaseAttribute.getByCase(this.getId());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeCaseAttribute(miningmart.m4.BaseAttribute rec) {
        BaseAttribute anObj = (BaseAttribute)rec;
        Cases anEJB = null;
        anEJB = Case.getEJB();
        anEJB.removeCaseAttribute(this.getId(), anObj.getId());
        Object var6_4 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication failure", (Throwable)e);
                Object var6_5 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllCaseAttributes() {
        Cases anEJB = null;
        anEJB = Case.getEJB();
        Iterator it = this.getAllCaseAttributes().iterator();
        while (it.hasNext()) {
            anEJB.removeCaseAttribute(this.getId(), ((M4Object)it.next()).getId());
        }
        Object var4_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication failure", (Throwable)e);
                Object var4_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static Cases getEJB() {
        try {
            Object initial;
            if (home == null) {
                initial = new InitialContext();
                home = (CasesHome)PortableRemoteObject.narrow((Object)initial.lookup("Cases"), Class.forName("com.syllogic.miningmart.m4.ejb.CasesHome"));
            }
            initial = home.create();
            return initial;
        }
        catch (ClassCastException e) {
            logger.error((Object)"Got the wrong EJB?:", (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)"Failed to create EJB reference:", (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to resolve JNDI name in initial context:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.error((Object)"Communication error.", (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static miningmart.m4.Case getById(int id) {
        Cases anEJB;
        Case aCase;
        block10: {
            Integer idObject = new Integer(id);
            aCase = (Case)cache.get(idObject);
            if (aCase != null) return aCase;
            anEJB = null;
            anEJB = Case.getEJB();
            CaseV val = anEJB.find(id);
            if (val == null) break block10;
            aCase = new Case(val);
            cache.put(idObject, aCase);
        }
        Object var6_7 = null;
        if (anEJB == null) return aCase;
        try {
            anEJB.remove();
            return aCase;
        }
        catch (Exception exception) {}
        return aCase;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication error.", (Throwable)e);
                Object var6_8 = null;
                if (anEJB == null) return aCase;
                try {
                    anEJB.remove();
                    return aCase;
                }
                catch (Exception exception) {}
                return aCase;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var6_9 = null;
                if (anEJB == null) return aCase;
                try {
                    anEJB.remove();
                    return aCase;
                }
                catch (Exception exception) {}
                return aCase;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public miningmart.m4.Case copy() throws NameExistsException {
        String caseName = this.getName();
        String caseMode = this.getMode();
        Case newCase = null;
        newCase = new Case();
        newCase.setName(caseName);
        newCase.setMode(caseMode);
        return newCase;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws StorageException {
        if (!this.isExisting()) {
            return;
        }
        CompilerAccess currentCompilerAccess = M4Interface.getCurrentCompilerAccess();
        if (currentCompilerAccess == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No currentCompilerAccess available!");
            }
        } else {
            logger.info((Object)"CompilerAccess found!");
            try {
                currentCompilerAccess.deleteTrashForCase((long)this.value.getId());
            }
            catch (M4CompilerInterfaceError e) {
                logger.warn((Object)"M4CompilerInterfaceError failure", (Throwable)e);
            }
            catch (RemoteException e) {
                logger.warn((Object)"Communication failure", (Throwable)e);
            }
        }
        Cases anEJB = null;
        anEJB = Case.getEJB();
        anEJB.delete(this.value.getId());
        this.setExisting(false);
        cache.remove(this);
        Object var5_5 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication failure", (Throwable)e);
                Object var5_6 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var5_7 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws StorageException {
        if (!this.isChanged()) {
            return;
        }
        Cases anEJB = null;
        anEJB = Case.getEJB();
        if (this.isExisting()) {
            anEJB.update(this.value);
        } else {
            this.value.setId(anEJB.create(this.value));
            cache.put(new Integer(this.value.getId()), this);
        }
        this.setChanged(false);
        this.setExisting(true);
        Object var4_2 = null;
        if (anEJB == null) return;
        try {
            anEJB.remove();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (RemoteException e) {
                logger.error((Object)"Communication failure", (Throwable)e);
                Object var4_3 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                Object var4_4 = null;
                if (anEJB == null) return;
                try {
                    anEJB.remove();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (anEJB == null) throw throwable;
            try {
                anEJB.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Case getByConcept(int id) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Case.getEJB();
                    it = anEJB.getIdByConcept(id).iterator();
                    if (!it.hasNext()) break block13;
                    anId = (Integer)it.next();
                    anObj = (Case)Case.cache.get(anId);
                    if (anObj == null && (val = anEJB.find(anId)) != null) {
                        anObj = new Case(val);
                        Case.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var5_7 = anObj;
                    var7_8 = null;
                    if (anEJB == null) return var5_7;
                }
                catch (RemoteException e) {
                    Case.logger.error((Object)"Communication failure", (Throwable)e);
                    var7_10 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var8_15) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Case.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var7_11 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var8_16) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var6_18) {
                var7_12 = null;
                if (anEJB == null) throw var6_18;
                ** try [egrp 2[TRYBLOCK] [3 : 165->174)] { 
lbl44:
                // 1 sources

                anEJB.remove();
                throw var6_18;
lbl46:
                // 1 sources

                catch (Exception var8_17) {
                    // empty catch block
                }
                throw var6_18;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 165->174)] { 
lbl51:
            // 1 sources

            anEJB.remove();
            return var5_7;
lbl53:
            // 1 sources

            catch (Exception var8_13) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var8_14) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Case getByName(String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Case.getEJB();
                    anId = anEJB.getIdByName(name);
                    if (anId == null) break block13;
                    anObj = (Case)Case.cache.get(anId);
                    if (anObj == null && (val = anEJB.find((int)anId)) != null) {
                        anObj = new Case(val);
                        Case.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var4_6 = anObj;
                    var6_7 = null;
                    if (anEJB == null) return var4_6;
                }
                catch (RemoteException e) {
                    Case.logger.error((Object)"Communication failure", (Throwable)e);
                    var6_9 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var7_14) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Case.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var6_10 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var7_15) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var5_17) {
                var6_11 = null;
                if (anEJB == null) throw var5_17;
                ** try [egrp 2[TRYBLOCK] [3 : 143->152)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var5_17;
lbl45:
                // 1 sources

                catch (Exception var7_16) {
                    // empty catch block
                }
                throw var5_17;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 143->152)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var4_6;
lbl52:
            // 1 sources

            catch (Exception var7_12) {
                // empty catch block
            }
            return var4_6;
        }
        var6_8 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var7_13) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Case getReadOnlyByName(String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Case.getEJB();
                    anId = anEJB.getIdByName(name);
                    if (anId == null) break block13;
                    anObj = (Case)Case.cache.get(anId);
                    if (anObj == null && (val = anEJB.find((int)anId)) != null) {
                        anObj = new Case(val);
                        Case.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var4_6 = anObj;
                    var6_7 = null;
                    if (anEJB == null) return var4_6;
                }
                catch (RemoteException e) {
                    Case.logger.error((Object)"Communication failure", (Throwable)e);
                    var6_9 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var7_14) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Case.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var6_10 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var7_15) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var5_17) {
                var6_11 = null;
                if (anEJB == null) throw var5_17;
                ** try [egrp 2[TRYBLOCK] [3 : 143->152)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var5_17;
lbl45:
                // 1 sources

                catch (Exception var7_16) {
                    // empty catch block
                }
                throw var5_17;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 143->152)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var4_6;
lbl52:
            // 1 sources

            catch (Exception var7_12) {
                // empty catch block
            }
            return var4_6;
        }
        var6_8 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var7_13) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Case getForUpdateByName(String name) {
        block13: {
            anEJB = null;
            try {
                try {
                    anEJB = Case.getEJB();
                    anId = anEJB.getIdByName(name);
                    if (anId == null) break block13;
                    anObj = (Case)Case.cache.get(anId);
                    if (anObj == null && (val = anEJB.find((int)anId)) != null) {
                        anObj = new Case(val);
                        Case.cache.put(anId, anObj);
                    }
                    if (anObj == null) break block13;
                    var4_6 = anObj;
                    var6_7 = null;
                    if (anEJB == null) return var4_6;
                }
                catch (RemoteException e) {
                    Case.logger.error((Object)"Communication failure", (Throwable)e);
                    var6_9 = null;
                    if (anEJB == null) return null;
                    try {
                        anEJB.remove();
                        return null;
                    }
                    catch (Exception var7_14) {
                        return null;
                    }
                }
                catch (SQLException e) {
                    Case.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var6_10 = null;
                    if (anEJB == null) return null;
                    try {}
                    catch (Exception var7_15) {
                        return null;
                    }
                    anEJB.remove();
                    return null;
                }
            }
            catch (Throwable var5_17) {
                var6_11 = null;
                if (anEJB == null) throw var5_17;
                ** try [egrp 2[TRYBLOCK] [3 : 143->152)] { 
lbl43:
                // 1 sources

                anEJB.remove();
                throw var5_17;
lbl45:
                // 1 sources

                catch (Exception var7_16) {
                    // empty catch block
                }
                throw var5_17;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 143->152)] { 
lbl50:
            // 1 sources

            anEJB.remove();
            return var4_6;
lbl52:
            // 1 sources

            catch (Exception var7_12) {
                // empty catch block
            }
            return var4_6;
        }
        var6_8 = null;
        if (anEJB == null) return null;
        try {}
        catch (Exception var7_13) {}
        anEJB.remove();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllNames() {
        block12: {
            aMap = null;
            anEJB = null;
            try {
                try {
                    anEJB = Case.getEJB();
                    aMap = anEJB.getNameIdMap();
                    if (aMap != null) break block12;
                    var2_2 = null;
                    var4_5 = null;
                    if (anEJB == null) return var2_2;
                }
                catch (RemoteException e) {
                    Case.logger.error((Object)"Communication failure", (Throwable)e);
                    var4_7 = null;
                    if (anEJB == null) return aMap.keySet();
                    try {
                        anEJB.remove();
                        return aMap.keySet();
                    }
                    catch (Exception var5_12) {
                        return aMap.keySet();
                    }
                }
                catch (SQLException e) {
                    Case.logger.error((Object)"Exception while executing SQL ", (Throwable)e);
                    var4_8 = null;
                    if (anEJB == null) return aMap.keySet();
                    try {}
                    catch (Exception var5_13) {
                        return aMap.keySet();
                    }
                    anEJB.remove();
                    return aMap.keySet();
                }
            }
            catch (Throwable var3_15) {
                var4_9 = null;
                if (anEJB == null) throw var3_15;
                ** try [egrp 2[TRYBLOCK] [3 : 78->87)] { 
lbl38:
                // 1 sources

                anEJB.remove();
                throw var3_15;
lbl40:
                // 1 sources

                catch (Exception var5_14) {
                    // empty catch block
                }
                throw var3_15;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 78->87)] { 
lbl45:
            // 1 sources

            anEJB.remove();
            return var2_2;
lbl47:
            // 1 sources

            catch (Exception var5_10) {
                // empty catch block
            }
            return var2_2;
        }
        var4_6 = null;
        if (anEJB == null) return aMap.keySet();
        try {}
        catch (Exception var5_11) {}
        anEJB.remove();
        return aMap.keySet();
        return aMap.keySet();
    }

    public void setDocumentation(String text) {
        this.removeAllDocumentation();
        if (text == null || text.equalsIgnoreCase("")) {
            return;
        }
        DocumentationV val = new DocumentationV();
        val.setText(text);
        val.setObjectId(this.getId());
        val.setObjectType("CA");
        Documentation.createByValueObject(val);
    }

    public String getDocumentation() {
        return Documentation.getByIdAndType(this.getId(), "CA");
    }

    public void removeAllDocumentation() {
        Documentation.deleteByIdAndType(this.getId(), "CA");
    }

    protected static void clearCache() {
        cache.clear();
    }
}

