/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerInvoker;
import org.jboss.ejb.ContainerInvokerContainer;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.Invoker;
import org.jboss.logging.Logger;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.naming.Util;
import org.jboss.proxy.ClientContainer;
import org.jboss.proxy.Interceptor;
import org.jboss.proxy.ejb.EJBMetaDataImpl;
import org.jboss.proxy.ejb.GenericEJBInterceptor;
import org.jboss.proxy.ejb.HomeInterceptor;
import org.jboss.proxy.ejb.handle.HomeHandleImpl;
import org.jboss.system.Registry;
import org.jboss.util.NestedRuntimeException;
import org.w3c.dom.Element;

public class ProxyFactory
implements ContainerInvoker {
    protected static final String HOME_INTERCEPTOR = "home";
    protected static final String BEAN_INTERCEPTOR = "bean";
    protected static final String LIST_ENTITY_INTERCEPTOR = "list-entity";
    public EJBMetaData ejbMetaData;
    protected static Logger log = Logger.getLogger((Class)(class$org$jboss$proxy$ejb$ProxyFactory == null ? (class$org$jboss$proxy$ejb$ProxyFactory = ProxyFactory.class$("org.jboss.proxy.ejb.ProxyFactory")) : class$org$jboss$proxy$ejb$ProxyFactory));
    protected EJBHome home;
    protected EJBObject statelessObject;
    protected String jndiName;
    protected int objectName;
    protected String jmxName;
    protected Invoker homeInvoker;
    protected Invoker beanInvoker;
    protected ArrayList homeInterceptorClasses = new ArrayList();
    protected ArrayList beanInterceptorClasses = new ArrayList();
    protected ArrayList listEntityInterceptorClasses = new ArrayList();
    protected Container container;
    static /* synthetic */ Class class$org$jboss$proxy$ejb$ProxyFactory;

    public void setContainer(Container con) {
        this.container = con;
    }

    public void create() throws Exception {
        InitialContext ctx = new InitialContext();
        this.jndiName = this.container.getBeanMetaData().getJndiName();
        this.jmxName = "jboss.j2ee:service=EJB,jndiName=" + this.jndiName;
        ObjectName jmx = new ObjectName(this.jmxName);
        this.objectName = jmx.hashCode();
        Registry.bind((Object)new Integer(this.objectName), (Object)jmx);
        log.debug((Object)("Bound jmxName=" + jmx + ", hash=" + this.objectName + "into Registry"));
        boolean isSession = !(this.container.getBeanMetaData() instanceof EntityMetaData);
        Class<?> pkClass = null;
        if (!isSession) {
            EntityMetaData metaData = (EntityMetaData)this.container.getBeanMetaData();
            String pkClassName = metaData.getPrimaryKeyClass();
            try {
                pkClass = pkClassName != null ? this.container.getClassLoader().loadClass(pkClassName) : this.container.getClassLoader().loadClass(metaData.getEjbClass()).getField(metaData.getPrimKeyField()).getClass();
            }
            catch (NoSuchFieldException e) {
                log.error((Object)"Unable to identify Bean's Primary Key class!  Did you specify a primary key class and/or field?  Does that field exist?");
                throw new RuntimeException("Primary Key Problem");
            }
            catch (NullPointerException e) {
                log.error((Object)"Unable to identify Bean's Primary Key class!  Did you specify a primary key class and/or field?  Does that field exist?");
                throw new RuntimeException("Primary Key Problem");
            }
        }
        this.ejbMetaData = new EJBMetaDataImpl(((ContainerInvokerContainer)this.container).getRemoteClass(), ((ContainerInvokerContainer)this.container).getHomeClass(), pkClass, isSession, isSession && ((SessionMetaData)this.container.getBeanMetaData()).isStateless(), new HomeHandleImpl(this.jndiName));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Proxy Factory for " + this.jndiName + " initialized"));
        }
        this.initInterceptorClasses();
    }

    public void start() throws Exception {
        this.setupInvokers();
        this.bindProxy();
    }

    protected void setupInvokers() throws Exception {
        ObjectName oname = new ObjectName(this.container.getBeanMetaData().getHomeInvoker());
        this.homeInvoker = (Invoker)Registry.lookup((Object)oname);
        if (this.homeInvoker == null) {
            throw new RuntimeException("homeInvoker is null: " + oname);
        }
        oname = new ObjectName(this.container.getBeanMetaData().getBeanInvoker());
        this.beanInvoker = (Invoker)Registry.lookup((Object)oname);
        if (this.beanInvoker == null) {
            throw new RuntimeException("beanInvoker is null: " + oname);
        }
    }

    protected void initInterceptorClasses() throws Exception {
        ConfigurationMetaData configMetaData = this.container.getBeanMetaData().getContainerConfiguration();
        Element homeInterceptorConf = configMetaData.getClientInterceptorConf(HOME_INTERCEPTOR);
        this.loadInterceptorClasses(this.homeInterceptorClasses, homeInterceptorConf);
        if (this.homeInterceptorClasses.size() == 0) {
            throw new DeploymentException("There are no home interface interceptors configured");
        }
        Element beanInterceptorConf = configMetaData.getClientInterceptorConf(BEAN_INTERCEPTOR);
        this.loadInterceptorClasses(this.beanInterceptorClasses, beanInterceptorConf);
        if (this.beanInterceptorClasses.size() == 0) {
            throw new DeploymentException("There are no bean interface interceptors configured");
        }
        Element listEntityInterceptorConf = configMetaData.getClientInterceptorConf(LIST_ENTITY_INTERCEPTOR);
        this.loadInterceptorClasses(this.listEntityInterceptorClasses, listEntityInterceptorConf);
    }

    protected void loadInterceptorClasses(ArrayList classes, Element interceptors) throws Exception {
        Iterator interceptorElements = MetaData.getChildrenByTagName((Element)interceptors, (String)"interceptor");
        ClassLoader loader = this.container.getClassLoader();
        Object last = null;
        while (interceptorElements != null && interceptorElements.hasNext()) {
            Element ielement = (Element)interceptorElements.next();
            String className = null;
            className = MetaData.getElementContent((Element)ielement);
            Class<?> clazz = loader.loadClass(className);
            classes.add(clazz);
        }
    }

    protected void loadInterceptorChain(ArrayList chain, ClientContainer client) throws Exception {
        Interceptor last = null;
        int i = 0;
        while (i < chain.size()) {
            Class clazz = (Class)chain.get(i);
            Interceptor interceptor = (Interceptor)clazz.newInstance();
            if (last == null) {
                last = interceptor;
                client.setNext(interceptor);
            } else {
                last.setNext(interceptor);
                last = interceptor;
            }
            ++i;
        }
    }

    protected void bindProxy() throws Exception {
        try {
            InvocationContext context = new InvocationContext();
            context.setObjectName(new Integer(this.objectName));
            context.setValue(GenericEJBInterceptor.JNDI_NAME, this.jndiName);
            context.setInvoker(this.homeInvoker);
            context.setValue(HomeInterceptor.EJB_METADATA, this.ejbMetaData);
            ClientContainer client = new ClientContainer(context);
            this.loadInterceptorChain(this.homeInterceptorClasses, client);
            ContainerInvokerContainer invoker = (ContainerInvokerContainer)this.container;
            this.home = (EJBHome)Proxy.newProxyInstance(invoker.getHomeClass().getClassLoader(), new Class[]{invoker.getHomeClass(), Class.forName("javax.ejb.Handle")}, (InvocationHandler)client);
            if (!(this.container.getBeanMetaData() instanceof EntityMetaData) && ((SessionMetaData)this.container.getBeanMetaData()).isStateless()) {
                context = new InvocationContext();
                context.setObjectName(new Integer(this.objectName));
                context.setValue(GenericEJBInterceptor.JNDI_NAME, this.jndiName);
                context.setInvoker(this.beanInvoker);
                client = new ClientContainer(context);
                this.loadInterceptorChain(this.beanInterceptorClasses, client);
                this.statelessObject = (EJBObject)Proxy.newProxyInstance(invoker.getRemoteClass().getClassLoader(), new Class[]{invoker.getRemoteClass()}, (InvocationHandler)client);
            }
            Util.rebind((Context)new InitialContext(), (String)this.container.getBeanMetaData().getJndiName(), (Object)this.getEJBHome());
            log.debug((Object)("Bound " + this.container.getBeanMetaData().getEjbName() + " to " + this.container.getBeanMetaData().getJndiName()));
        }
        catch (Exception e) {
            throw new ServerException("Could not bind home", e);
        }
    }

    public void stop() {
    }

    public void destroy() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this.container.getBeanMetaData().getJndiName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EJBMetaData getEJBMetaData() {
        return this.ejbMetaData;
    }

    public Object getEJBHome() {
        return this.home;
    }

    public Object getStatelessSessionEJBObject() {
        return this.statelessObject;
    }

    public Object getStatefulSessionEJBObject(Object id) {
        InvocationContext context = new InvocationContext();
        context.setObjectName(new Integer(this.objectName));
        context.setCacheId(id);
        context.setValue(GenericEJBInterceptor.JNDI_NAME, this.jndiName);
        context.setInvoker(this.beanInvoker);
        ClientContainer client = new ClientContainer(context);
        try {
            this.loadInterceptorChain(this.beanInterceptorClasses, client);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Failed to load interceptor chain", (Throwable)e);
        }
        ContainerInvokerContainer invoker = (ContainerInvokerContainer)this.container;
        return (EJBObject)Proxy.newProxyInstance(invoker.getRemoteClass().getClassLoader(), new Class[]{invoker.getRemoteClass()}, (InvocationHandler)client);
    }

    public Object getEntityEJBObject(Object id) {
        InvocationContext context = new InvocationContext();
        context.setObjectName(new Integer(this.objectName));
        context.setCacheId(id);
        context.setValue(GenericEJBInterceptor.JNDI_NAME, this.jndiName);
        context.setInvoker(this.beanInvoker);
        ClientContainer client = new ClientContainer(context);
        try {
            this.loadInterceptorChain(this.beanInterceptorClasses, client);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Failed to load interceptor chain", (Throwable)e);
        }
        ContainerInvokerContainer invoker = (ContainerInvokerContainer)this.container;
        return (EJBObject)Proxy.newProxyInstance(invoker.getRemoteClass().getClassLoader(), new Class[]{invoker.getRemoteClass()}, (InvocationHandler)client);
    }

    public Collection getEntityCollection(Collection ids) {
        ArrayList<Object> list = new ArrayList<Object>(ids.size());
        ContainerInvokerContainer invoker = (ContainerInvokerContainer)this.container;
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            InvocationContext context = new InvocationContext();
            context.setObjectName(new Integer(this.objectName));
            context.setCacheId(iter.next());
            context.setValue(GenericEJBInterceptor.JNDI_NAME, this.jndiName);
            context.setInvoker(this.beanInvoker);
            ClientContainer client = new ClientContainer(context);
            try {
                this.loadInterceptorChain(this.beanInterceptorClasses, client);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Failed to load interceptor chain", (Throwable)e);
            }
            list.add(Proxy.newProxyInstance(invoker.getRemoteClass().getClassLoader(), new Class[]{invoker.getRemoteClass()}, (InvocationHandler)client));
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

