/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.compiler;

import java.io.File;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.Type;
import org.jboss.logging.Logger;
import org.jboss.proxy.compiler.ProxyImplementationFactory;
import org.jboss.proxy.compiler.Runtime;
import org.jboss.proxy.compiler.Utility;

public class ProxyCompiler {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$proxy$compiler$ProxyCompiler == null ? (class$org$jboss$proxy$compiler$ProxyCompiler = ProxyCompiler.class$("org.jboss.proxy.compiler.ProxyCompiler")) : class$org$jboss$proxy$compiler$ProxyCompiler));
    public static final String CLASS_DUMP_PATH = System.getProperty((class$org$jboss$proxy$compiler$ProxyCompiler == null ? (class$org$jboss$proxy$compiler$ProxyCompiler = ProxyCompiler.class$("org.jboss.proxy.compiler.ProxyCompiler")) : class$org$jboss$proxy$compiler$ProxyCompiler).getName() + ".dumpPath", null);
    public static final String IMPL_SUFFIX = "$Proxy";
    Runtime runtime;
    Class superclass;
    Class[] targetTypes;
    java.lang.reflect.Method[] methods;
    Class proxyType;
    static /* synthetic */ Class class$org$jboss$proxy$compiler$ProxyCompiler;
    static /* synthetic */ Class class$org$jboss$proxy$compiler$Proxies$ProxyTarget;

    public ProxyCompiler(ClassLoader parent, Class superclass, Class[] targetTypes, java.lang.reflect.Method[] methods) throws Exception {
        this.superclass = superclass;
        this.targetTypes = targetTypes;
        this.methods = methods;
        this.runtime = new Runtime(parent);
        this.runtime.targetTypes = targetTypes;
        this.runtime.methods = methods;
        this.runtime.makeProxyType(this);
    }

    public Class getProxyType() {
        return this.proxyType;
    }

    public String getProxyClassName() {
        return this.targetTypes[0].getName() + IMPL_SUFFIX;
    }

    public byte[] getCode() {
        boolean trace = log.isTraceEnabled();
        String proxyClassName = this.getProxyClassName();
        String superClassName = this.superclass.getName();
        int icount = 1;
        int i = 0;
        while (i < this.targetTypes.length) {
            Class targetType = this.targetTypes[i];
            if (targetType.isInterface()) {
                ++icount;
            }
            ++i;
        }
        String[] interfaceNames = new String[icount];
        interfaceNames[0] = (class$org$jboss$proxy$compiler$Proxies$ProxyTarget == null ? (class$org$jboss$proxy$compiler$Proxies$ProxyTarget = ProxyCompiler.class$("org.jboss.proxy.compiler.Proxies$ProxyTarget")) : class$org$jboss$proxy$compiler$Proxies$ProxyTarget).getName();
        icount = 1;
        int i2 = 0;
        while (i2 < this.targetTypes.length) {
            Class targetType = this.targetTypes[i2];
            if (targetType.isInterface()) {
                interfaceNames[icount++] = targetType.getName();
            } else if (!this.superclass.isAssignableFrom(targetType)) {
                throw new RuntimeException("unexpected: " + targetType);
            }
            ++i2;
        }
        ClassGen cg = new ClassGen(proxyClassName, superClassName, "<generated>", 17, interfaceNames);
        ProxyImplementationFactory factory = new ProxyImplementationFactory(superClassName, proxyClassName, cg);
        cg.addField(factory.createInvocationHandlerField());
        cg.addField(factory.createRuntimeField());
        cg.addMethod(factory.createConstructor());
        cg.addMethod(factory.createGetInvocationHandler());
        cg.addMethod(factory.createGetTargetTypes());
        boolean haveToString = false;
        if (trace) {
            log.trace((Object)"Creating proxy methods...");
        }
        int i3 = 0;
        while (i3 < this.methods.length) {
            java.lang.reflect.Method m = this.methods[i3];
            if (trace) {
                log.trace((Object)("Reflected method: " + m));
            }
            String name = m.getName();
            Class<?> rTypeClass = m.getReturnType();
            String rTypeName = rTypeClass.getName();
            Type rType = Utility.getType(rTypeClass);
            Type[] pTypes = Utility.getTypes(m.getParameterTypes());
            String[] exceptionNames = this.getNames(m.getExceptionTypes());
            if (name.equals("toString") && pTypes.length == 0) {
                haveToString = true;
            }
            Method proxyMethod = factory.createProxyMethod(name, i3, rType, pTypes, exceptionNames);
            if (trace) {
                log.trace((Object)("Created proxy method: " + proxyMethod));
            }
            cg.addMethod(proxyMethod);
            ++i3;
        }
        if (!haveToString) {
            cg.addMethod(factory.createToString());
        }
        JavaClass jclass = cg.getJavaClass();
        if (trace) {
            log.trace((Object)("Generated Java class: " + jclass));
        }
        if (CLASS_DUMP_PATH != null) {
            try {
                String filename = CLASS_DUMP_PATH + File.separator + proxyClassName + ".class";
                log.info((Object)("Dumping generated proxy class to " + filename));
                jclass.dump(filename);
            }
            catch (Exception e) {
                log.error((Object)"Failed to dump class file", (Throwable)e);
            }
        }
        return jclass.getBytes();
    }

    private String[] getNames(Class[] classes) {
        String[] names = new String[classes.length];
        int i = 0;
        while (i < classes.length) {
            names[i] = classes[i].getName();
            ++i;
        }
        return names;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

