/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.Transaction;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledValue;

public class MarshalledInvocation
extends Invocation
implements Externalizable {
    static final long serialVersionUID = -718723094688127810L;
    Object tpc;
    transient Map methodMap;
    static Map hashMap = new WeakHashMap();

    public static Map getInterfaceHashes(Class intf) {
        Method[] methods = intf.getDeclaredMethods();
        HashMap<String, Long> map = new HashMap<String, Long>();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            String methodDesc = method.getName() + "(";
            int j = 0;
            while (j < parameterTypes.length) {
                methodDesc = methodDesc + MarshalledInvocation.getTypeString(parameterTypes[j]);
                ++j;
            }
            methodDesc = methodDesc + ")" + MarshalledInvocation.getTypeString(method.getReturnType());
            try {
                long hash = 0L;
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
                MessageDigest messagedigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
                dataoutputstream.writeUTF(methodDesc);
                dataoutputstream.flush();
                byte[] abyte0 = messagedigest.digest();
                int j2 = 0;
                while (j2 < Math.min(8, abyte0.length)) {
                    hash += (long)(abyte0[j2] & 0xFF) << j2 * 8;
                    ++j2;
                }
                map.put(method.toString(), new Long(hash));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return map;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + MarshalledInvocation.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    public static long calculateHash(Method method) {
        Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
        if (methodHashes == null) {
            methodHashes = MarshalledInvocation.getInterfaceHashes(method.getDeclaringClass());
            WeakHashMap newHashMap = new WeakHashMap();
            newHashMap.putAll(hashMap);
            newHashMap.put(method.getDeclaringClass(), methodHashes);
            hashMap = newHashMap;
        }
        return (Long)methodHashes.get(method.toString());
    }

    public MarshalledInvocation() {
    }

    public MarshalledInvocation(Invocation invocation) {
        super(invocation.payload);
        this.as_is_payload = invocation.as_is_payload;
    }

    public MarshalledInvocation(Map payload) {
        super(payload);
    }

    public MarshalledInvocation(Map payload, Map as_is_payload) {
        super(payload);
        this.as_is_payload = as_is_payload;
    }

    public MarshalledInvocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) {
        super(id, m, args, tx, identity, credential);
    }

    public Method getMethod() {
        Object value = this.getValue(Invocation.METHOD);
        if (value instanceof Method) {
            return (Method)value;
        }
        Method m = (Method)this.methodMap.get(value);
        if (m != null) {
            this.transient_payload.put(Invocation.METHOD, m);
            return m;
        }
        throw new NullPointerException("METHOD IS NOT FOUND: " + value);
    }

    public void setMethodMap(Map methods) {
        this.methodMap = methods;
    }

    public void setTransactionPropagationContext(Object tpc) {
        this.tpc = tpc;
    }

    public Object getTransactionPropagationContext() {
        return this.tpc;
    }

    public Object getValue(Object key) {
        Object value = super.getValue(key);
        if (value instanceof MarshalledValue) {
            try {
                MarshalledValue mv = (MarshalledValue)value;
                value = mv.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
        }
        return value;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tpc);
        HashMap<Integer, Serializable> sentData = new HashMap<Integer, Serializable>();
        Iterator keys = this.payload.keySet().iterator();
        while (keys.hasNext()) {
            Object currentKey = keys.next();
            if (currentKey == Invocation.METHOD) {
                sentData.put(Invocation.METHOD, new Long(MarshalledInvocation.calculateHash((Method)this.payload.get(Invocation.METHOD))));
                continue;
            }
            sentData.put((Integer)currentKey, new MarshalledValue(this.payload.get(currentKey)));
        }
        out.writeObject(sentData);
        out.writeObject(this.as_is_payload);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tpc = in.readObject();
        this.payload = (Map)in.readObject();
        this.as_is_payload = (Map)in.readObject();
    }
}

