/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.util;

import java.awt.Point;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.CreateCaseDialog;
import miningmart.hci.util.ColumnBARelation;
import miningmart.hci.util.ConnectionRelation;
import miningmart.hci.util.ExportParameter;
import miningmart.hci.util.ForeignKeyRelation;
import miningmart.hci.util.PointInformation;
import miningmart.hci.util.PrimaryKeyRelation;
import miningmart.hci.util.ProjectionRelation;
import miningmart.hci.util.RelationshipRelation;
import miningmart.hci.util.SubConceptRelation;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Chain;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.ForeignKey;
import miningmart.m4.M4Object;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.Parameter;
import miningmart.m4.PrimaryKey;
import miningmart.m4.Relationship;
import miningmart.m4.Step;
import miningmart.m4.Value;

public class CaseImporter {
    ObjectInputStream is;
    int retVal = 0;
    private Vector conns = new Vector();
    int nr = 1;
    private boolean withColumns = false;
    private boolean noFile = false;

    public void init() {
        this.withColumns = JOptionPane.showOptionDialog(Application.frame, "Do you want to import the Columns \n and ColumnSets, too? (if any) \nThis only makes sense if you use \n the same business data tables", "Import Columns and ColumnSets?", 0, 3, null, null, null) == 0;
        JFileChooser chooser = new JFileChooser(Application.systemHome);
        this.retVal = chooser.showOpenDialog(Application.frame);
        File file = chooser.getSelectedFile();
        if (file == null) {
            this.noFile = true;
            return;
        }
        this.noFile = false;
        String filename = file.getPath();
        try {
            this.is = new ObjectInputStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            this.retVal = 2;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.retVal = 2;
        }
    }

    public int importCase() {
        if (this.noFile) {
            return -1;
        }
        Case newCase = null;
        Chain newChain = null;
        Step newStep = null;
        Parameter newParameter = null;
        Concept newConcept = null;
        BaseAttribute newBaseAttribute = null;
        MultiColumnFeature newMCF = null;
        ColumnSet newColumnSet = null;
        Column newColumn = null;
        Relationship newRelationship = null;
        PrimaryKey newPrimaryKey = null;
        ForeignKey newForeignKey = null;
        ExportParameter eParam = null;
        M4Object paramObject = null;
        Concept refConcept = null;
        Concept refConcept2 = null;
        boolean empty = false;
        Object object = null;
        try {
            object = this.is.readObject();
        }
        catch (Exception ex) {
            empty = true;
            ex.printStackTrace();
        }
        System.out.println("Start import");
        while (!empty) {
            block84: {
                try {
                    PrimaryKey key;
                    ColumnSet columnSet;
                    Concept concept;
                    String columnSetName;
                    String conceptName;
                    if (object instanceof Case) {
                        CreateCaseDialog caseDialog = new CreateCaseDialog(Application.frame, "Set Name for imported Case", true);
                        newCase = caseDialog.showCreateDialog();
                        if (newCase == null) {
                            int n = -1;
                            return n;
                        }
                    } else if (object instanceof Chain) {
                        newChain = ((Chain)object).copy(newCase);
                        newChain.store();
                    } else if (object instanceof Step) {
                        newStep = ((Step)object).copy(newCase, newChain);
                        newStep.store();
                    } else if (object instanceof ExportParameter) {
                        Parameter p;
                        eParam = (ExportParameter)object;
                        paramObject = eParam.getParameterObject();
                        if (paramObject instanceof Value) {
                            p = eParam.getParameter();
                            Value v = (Value)paramObject;
                            newParameter = newStep.createValueParameter(v.getValue(), v.getDatatype(), p.getParameterName(), p.getOperator(), p.getParameterNr(), p.getParameterType());
                        } else {
                            p = eParam.getParameter();
                            Concept newParamObject = null;
                            if (paramObject instanceof Concept) {
                                newParamObject = newCase.getConcept(((Concept)paramObject).getName());
                            } else if (paramObject instanceof BaseAttribute) {
                                refConcept = newCase.getConcept(eParam.getNameOfContextObject());
                                newParamObject = refConcept.getBaseAttribute(((BaseAttribute)paramObject).getName());
                            } else if (paramObject instanceof MultiColumnFeature) {
                                refConcept = newCase.getConcept(eParam.getNameOfContextObject());
                                newParamObject = refConcept.getMultiColumnFeature(((BaseAttribute)paramObject).getName());
                            } else if (paramObject instanceof Relationship) {
                                refConcept = newCase.getConcept(eParam.getNameOfContextObject());
                                refConcept2 = newCase.getConcept(eParam.getNameOfContextObject2());
                                newParamObject = refConcept.getFromConceptRelationship(((Relationship)paramObject).getName(), refConcept2);
                            }
                            newParameter = newStep.createParameter(p.getParameterName(), (M4Object)newParamObject, p.getOperator(), p.getParameterNr(), p.getParameterType());
                        }
                        newParameter.setLoopNr(p.getLoopNr());
                        newParameter.store();
                    } else if (object instanceof PointInformation) {
                        PointInformation inf = (PointInformation)object;
                        Chain context = null;
                        if (inf.getThird() != null) {
                            context = newCase.getChain(((Chain)inf.getThird()).getName());
                        }
                        if (inf.getSecond() instanceof Step) {
                            newStep.setPoint(context, (Point)inf.getFirst());
                            newStep.store();
                        } else if (inf.getSecond() instanceof Chain) {
                            newChain.setPoint(context, (Point)inf.getFirst());
                            newChain.store();
                        }
                    } else if (object instanceof Point) {
                        Point point = (Point)object;
                        newStep.setPoint(newChain, point);
                        newStep.store();
                    } else if (object instanceof ConnectionRelation) {
                        this.conns.add(object);
                    } else if (object instanceof Concept) {
                        Concept c = (Concept)object;
                        newConcept = c.copy(newCase);
                        newConcept.store();
                    } else if (object instanceof BaseAttribute) {
                        BaseAttribute ba = (BaseAttribute)object;
                        newBaseAttribute = ba.copy(newConcept);
                        newBaseAttribute.store();
                    } else if (object instanceof MultiColumnFeature) {
                        MultiColumnFeature mcf = (MultiColumnFeature)object;
                        newMCF = mcf.copy(newConcept);
                        newMCF.store();
                    } else if (object instanceof ColumnSet) {
                        if (this.withColumns) {
                            ColumnSet cs = (ColumnSet)object;
                            newColumnSet = cs.copy(newConcept);
                            newColumnSet.store();
                        } else {
                            System.out.println("Column or ColumnSet in file ignored");
                        }
                    } else if (object instanceof ColumnBARelation) {
                        if (this.withColumns) {
                            ColumnBARelation columnBA = (ColumnBARelation)object;
                            Column c = (Column)columnBA.getFirst();
                            BaseAttribute ba = (BaseAttribute)columnBA.getSecond();
                            String baName = " ";
                            if (ba != null) {
                                baName = ba.getName();
                            }
                            BaseAttribute newBA = newConcept.getBaseAttribute(baName);
                            newColumn = c.copy(newColumnSet);
                            newColumn.store();
                            if (newBA != null) {
                                newColumn.setBaseAttribute(newBA);
                                newColumn.store();
                            }
                        } else {
                            System.out.println("Column or ColumnSet in file ignored");
                        }
                    } else if (object instanceof RelationshipRelation) {
                        RelationshipRelation rel = (RelationshipRelation)object;
                        Relationship r = (Relationship)rel.getFirst();
                        Concept c = (Concept)rel.getSecond();
                        String from = " ";
                        String to = " ";
                        if (c != null) {
                            from = c.getName();
                        }
                        Concept fromConcept = newCase.getConcept(from);
                        c = (Concept)rel.getThird();
                        if (c != null) {
                            to = c.getName();
                        }
                        Concept toConcept = newCase.getConcept(to);
                        if (r != null) {
                            newRelationship = r.copy(fromConcept, toConcept);
                            newRelationship.store();
                        }
                    } else if (object instanceof SubConceptRelation) {
                        SubConceptRelation rel = (SubConceptRelation)object;
                        conceptName = " ";
                        String subConceptName = " ";
                        Concept concept2 = (Concept)rel.getFirst();
                        if (concept2 != null) {
                            conceptName = concept2.getName();
                        }
                        concept2 = newCase.getConcept(conceptName);
                        Concept subConcept = (Concept)rel.getSecond();
                        if (subConcept != null) {
                            subConceptName = subConcept.getName();
                        }
                        subConcept = newCase.getConcept(subConceptName);
                        concept2.addSubConcept(subConcept);
                    } else if (object instanceof ProjectionRelation) {
                        ProjectionRelation rel = (ProjectionRelation)object;
                        conceptName = " ";
                        String toConceptName = " ";
                        Concept concept3 = (Concept)rel.getFirst();
                        if (concept3 != null) {
                            conceptName = concept3.getName();
                        }
                        concept3 = newCase.getConcept(conceptName);
                        Concept toConcept = (Concept)rel.getSecond();
                        if (toConcept != null) {
                            toConceptName = toConcept.getName();
                        }
                        toConcept = newCase.getConcept(toConceptName);
                        toConcept.setFromProjection(concept3);
                    } else if (object instanceof PrimaryKeyRelation) {
                        if (this.withColumns) {
                            PrimaryKeyRelation rel = (PrimaryKeyRelation)object;
                            String conceptName2 = " ";
                            columnSetName = " ";
                            concept = (Concept)rel.getFirst();
                            if (concept != null) {
                                conceptName2 = concept.getName();
                            }
                            concept = newCase.getConcept(conceptName2);
                            columnSet = (ColumnSet)rel.getSecond();
                            if (columnSet != null) {
                                columnSetName = columnSet.getName();
                            }
                            columnSet = concept.getColumnSet(columnSetName);
                            key = (PrimaryKey)rel.getThird();
                            if (key != null) {
                                newPrimaryKey = key.copy(columnSet);
                                newPrimaryKey.store();
                            }
                        } else {
                            System.out.println("Primary Key in file ignored");
                        }
                    } else if (object instanceof ForeignKeyRelation) {
                        if (this.withColumns) {
                            ForeignKeyRelation rel = (ForeignKeyRelation)object;
                            String conceptName3 = " ";
                            columnSetName = " ";
                            concept = (Concept)rel.getFirst();
                            if (concept != null) {
                                conceptName3 = concept.getName();
                            }
                            concept = newCase.getConcept(conceptName3);
                            columnSet = (ColumnSet)rel.getSecond();
                            if (columnSet != null) {
                                columnSetName = columnSet.getName();
                            }
                            columnSet = concept.getColumnSet(columnSetName);
                            key = (ForeignKey)rel.getThird();
                            if (key != null) {
                                newForeignKey = key.copy(columnSet);
                                newForeignKey.store();
                            }
                        } else {
                            System.out.println("Foreign Key in file ignored");
                        }
                    } else {
                        System.out.println(String.valueOf("+++++ Unknown Object: ").concat(String.valueOf(object)));
                        int val = JOptionPane.showConfirmDialog(Application.frame, String.valueOf(String.valueOf("Unknown Object: ").concat(String.valueOf(object))).concat(String.valueOf("\nThis may cause more errors.\nContinue anyway?")), "Error while reading Object", 2);
                        if (val == 2) {
                            int conceptName3 = 2;
                            return conceptName3;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(String.valueOf(String.valueOf("exception while importing object ").concat(String.valueOf(object))).concat(String.valueOf("\n"))).concat(String.valueOf(e.getMessage())));
                    int val = JOptionPane.showConfirmDialog(Application.frame, String.valueOf(String.valueOf(String.valueOf("exception while reading object ").concat(String.valueOf(object))).concat(String.valueOf("\nThis may cause more errors."))).concat(String.valueOf("\nContinue anyway?")), "Error while Reading Object", 2);
                    this.retVal = 2;
                    if (val != 2) break block84;
                    int n = 2;
                    return n;
                }
            }
            try {
                object = this.is.readObject();
                System.out.print(".");
            }
            catch (ClassNotFoundException e) {
                System.out.println(String.valueOf(String.valueOf(String.valueOf("exception while importing object ").concat(String.valueOf(object))).concat(String.valueOf("\n"))).concat(String.valueOf(e.getMessage())));
            }
            catch (EOFException e) {
                empty = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                empty = true;
            }
        }
        try {
            this.is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.buildStepSequence(newCase);
        System.out.println(" ..done");
        return this.retVal;
    }

    private void buildStepSequence(Case newCase) {
        Iterator it = this.conns.iterator();
        Step start = null;
        Step end = null;
        while (it.hasNext()) {
            ConnectionRelation c = (ConnectionRelation)it.next();
            if (c.getFirst() != null) {
                start = newCase.getStep(((Step)c.getFirst()).getName());
            }
            if (c.getSecond() != null) {
                end = newCase.getStep(((Step)c.getSecond()).getName());
            }
            if (start == null || end == null) continue;
            start.addSuccessor(end);
        }
    }
}

