/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.util;

import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import miningmart.hci.gui.main.Application;
import miningmart.hci.util.ColumnBARelation;
import miningmart.hci.util.ConnectionRelation;
import miningmart.hci.util.ExportParameter;
import miningmart.hci.util.ForeignKeyRelation;
import miningmart.hci.util.PointInformation;
import miningmart.hci.util.PrimaryKeyRelation;
import miningmart.hci.util.ProjectionRelation;
import miningmart.hci.util.RelationshipRelation;
import miningmart.hci.util.SubConceptRelation;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Chain;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.ForeignKey;
import miningmart.m4.M4Object;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.MultipleResultException;
import miningmart.m4.Parameter;
import miningmart.m4.Relationship;
import miningmart.m4.Step;

public class CaseExporter {
    Case caseToExport;
    ObjectOutputStream os;
    int retVal = 0;
    private boolean withColumns = false;
    private boolean noFile = true;

    public void init() {
        this.withColumns = JOptionPane.showOptionDialog(Application.frame, "Do you want to export the Columns and ColumnSets, too? \nThis only makes sence if the same \n business data tables are used", "Export Columns and ColumnSets?", 0, 3, null, null, null) == 0;
        JFileChooser chooser = new JFileChooser(Application.systemHome);
        this.retVal = chooser.showSaveDialog(Application.frame);
        File file = chooser.getSelectedFile();
        if (file == null) {
            this.noFile = true;
            return;
        }
        this.noFile = false;
        String filename = file.getPath();
        try {
            this.os = new ObjectOutputStream(new FileOutputStream(filename));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            this.retVal = 2;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.retVal = 2;
        }
    }

    public int exportCase(Case caseToExport) {
        block3: {
            if (this.noFile) {
                return -1;
            }
            this.caseToExport = caseToExport;
            try {
                this.writeObj(caseToExport);
                this.writeConcepts(caseToExport.getAllConcepts());
                this.writeChains(caseToExport.getAllChains());
                this.os.close();
            }
            catch (IOException ioe) {
                int val = JOptionPane.showConfirmDialog(Application.frame, "Error while writing Object", "This may cause more errors\nor makes the file unusable.\nContinue anyway?", 2);
                ioe.printStackTrace();
                this.retVal = 2;
                if (val != 2) break block3;
                int n = 2;
                return n;
            }
        }
        return this.retVal;
    }

    private void writeChains(Collection chains) throws IOException {
        String parentChainName = "";
        int index = 0;
        Iterator it = chains.iterator();
        while (it.hasNext()) {
            Chain chain = (Chain)it.next();
            this.writeObj(chain);
            index = chain.getName().lastIndexOf(".");
            if (index > 0) {
                parentChainName = chain.getName().substring(0, chain.getName().lastIndexOf("."));
            }
            Chain context = this.caseToExport.getChain(parentChainName);
            this.writePoint(chain.getPoint(context), (M4Object)chain, context);
            this.writeSteps(chain.getAllSteps(), chain);
        }
    }

    private void writeSteps(Collection steps, Chain chain) throws IOException {
        Iterator it = steps.iterator();
        while (it.hasNext()) {
            Step step = (Step)it.next();
            this.writeObj(step);
            this.writePoint(step.getPoint(chain), (M4Object)step, chain);
            this.writeParameters(step.getAllParameters());
            this.writeSuccessors(step, step.getAllSuccessors());
        }
    }

    private void writeParameters(Collection parameters) throws IOException {
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            ExportParameter eParam = new ExportParameter();
            eParam.setParameter(param);
            M4Object obj = param.getParameterObject();
            try {
                if (obj instanceof BaseAttribute) {
                    eParam.setNameOfContextObject(((BaseAttribute)obj).getConcept().getName());
                } else if (obj instanceof MultiColumnFeature) {
                    eParam.setNameOfContextObject(((MultiColumnFeature)obj).getConcept().getName());
                } else if (obj instanceof Relationship) {
                    eParam.setNameOfContextObject(((Relationship)obj).getFromConcept().getName());
                    eParam.setNameOfContextObject2(((Relationship)obj).getToConcept().getName());
                }
            }
            catch (MultipleResultException mre) {
                mre.printStackTrace();
            }
            eParam.setParameterObject(obj);
            this.writeObj(eParam);
        }
    }

    private void writeSuccessors(Step start, Collection succs) throws IOException {
        Iterator it = succs.iterator();
        while (it.hasNext()) {
            Step succ = (Step)it.next();
            ConnectionRelation conn = new ConnectionRelation();
            conn.setFirst((M4Object)start);
            conn.setSecond((M4Object)succ);
            this.writeObj(conn);
        }
    }

    private void writeConcepts(Collection concepts) throws IOException {
        Concept concept;
        Iterator it = concepts.iterator();
        while (it.hasNext()) {
            concept = (Concept)it.next();
            this.writeObj(concept);
            this.writeBaseAttributes(concept.getAllBaseAttributes());
            this.writeMultiColumnFeatures(concept.getAllMultiColumnFeatures());
            if (!this.withColumns) continue;
            this.writeColumnSets(concept.getAllColumnSets());
        }
        it = concepts.iterator();
        while (it.hasNext()) {
            concept = (Concept)it.next();
            this.writeSubConcepts(concept);
            this.writeProjections(concept);
            this.writeRelationships(concept);
            if (!this.withColumns) continue;
            this.writePrimaryKeys(concept);
            this.writeForeignKeys(concept);
        }
    }

    private void writeBaseAttributes(Collection bas) throws IOException {
        Iterator it = bas.iterator();
        while (it.hasNext()) {
            BaseAttribute ba = (BaseAttribute)it.next();
            this.writeObj(ba);
        }
    }

    private void writeMultiColumnFeatures(Collection mCFs) throws IOException {
        Iterator it = mCFs.iterator();
        while (it.hasNext()) {
            MultiColumnFeature mcf = (MultiColumnFeature)it.next();
            this.writeObj(mcf);
        }
    }

    private void writeColumnSets(Collection css) throws IOException {
        Iterator it = css.iterator();
        while (it.hasNext()) {
            ColumnSet cs = (ColumnSet)it.next();
            this.writeObj(cs);
            this.writeColumns(cs.getAllColumns());
        }
    }

    private void writeColumns(Collection columns) throws IOException {
        Iterator it = columns.iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            BaseAttribute ba = column.getBaseAttribute();
            ColumnBARelation columnBA = new ColumnBARelation();
            columnBA.setFirst((M4Object)column);
            columnBA.setSecond((M4Object)ba);
            this.writeObj(columnBA);
        }
    }

    private void writeSubConcepts(Concept fromConcept) throws IOException {
        Collection subConcepts = fromConcept.getAllSubConcepts();
        Iterator it = subConcepts.iterator();
        while (it.hasNext()) {
            SubConceptRelation rel = new SubConceptRelation();
            rel.setFirst((M4Object)fromConcept);
            Concept concept = (Concept)it.next();
            rel.setSecond((M4Object)concept);
            this.writeObj(rel);
        }
    }

    private void writeRelationships(Concept fromConcept) throws IOException {
        RelationshipRelation rel = null;
        Collection fromRelationships = fromConcept.getAllFromConceptRelationships();
        Iterator it = fromRelationships.iterator();
        while (it.hasNext()) {
            Relationship relationship = (Relationship)it.next();
            rel = new RelationshipRelation();
            rel.setFirst((M4Object)relationship);
            rel.setSecond((M4Object)fromConcept);
            rel.setThird((M4Object)relationship.getToConcept());
            this.writeObj(rel);
        }
    }

    private void writeProjections(Concept fromConcept) throws IOException {
        Collection toProjections = fromConcept.getAllToProjections();
        Iterator it = toProjections.iterator();
        while (it.hasNext()) {
            ProjectionRelation rel = new ProjectionRelation();
            rel.setFirst((M4Object)fromConcept);
            Concept toConcept = (Concept)it.next();
            rel.setSecond((M4Object)toConcept);
            this.writeObj(rel);
        }
    }

    private void writePrimaryKeys(Concept concept) throws IOException {
        Collection columnSets = concept.getAllColumnSets();
        Iterator it = columnSets.iterator();
        while (it.hasNext()) {
            PrimaryKeyRelation rel = new PrimaryKeyRelation();
            rel.setFirst((M4Object)concept);
            ColumnSet columnSet = (ColumnSet)it.next();
            rel.setSecond((M4Object)columnSet);
            rel.setThird((M4Object)columnSet.getPrimaryKey());
            this.writeObj(rel);
        }
    }

    private void writeForeignKeys(Concept concept) throws IOException {
        Collection columnSets = concept.getAllColumnSets();
        Iterator it = columnSets.iterator();
        while (it.hasNext()) {
            ColumnSet columnSet = (ColumnSet)it.next();
            Iterator keyIt = columnSet.getAllForeignKeys().iterator();
            while (keyIt.hasNext()) {
                ForeignKeyRelation rel = new ForeignKeyRelation();
                ForeignKey key = (ForeignKey)keyIt.next();
                rel.setFirst((M4Object)concept);
                rel.setSecond((M4Object)columnSet);
                rel.setThird((M4Object)key);
                this.writeObj(rel);
            }
        }
    }

    private void writePoint(Point point, M4Object obj, Chain context) throws IOException {
        if (point != null) {
            PointInformation inf = new PointInformation();
            inf.setFirst(point);
            inf.setSecond(obj);
            inf.setThird((M4Object)context);
            this.writeObj(inf);
        }
    }

    private void writeObj(Object obj) throws IOException {
        if (obj != null) {
            this.os.writeObject(obj);
        }
    }
}

