/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.util.Spinner;

public class LoopPanel
extends JPanel
implements ActionListener {
    FlowLayout flowLayout1 = new FlowLayout();
    JLabel jLabel1 = new JLabel();
    JTextField nrOfLoopsField = new JTextField("0", 2);
    JButton changeNrOfLoopsButton = new JButton();
    JLabel jLabel2 = new JLabel();
    Spinner loopSpinner = new Spinner();
    int oldNumber = 0;

    public LoopPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setHorizontalTextPosition(2);
        this.jLabel1.setText("Number of loops:");
        this.setLayout(this.flowLayout1);
        this.changeNrOfLoopsButton.setText("change");
        this.jLabel2.setText("Show loop number");
        this.nrOfLoopsField.setHorizontalAlignment(4);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.nrOfLoopsField, null);
        this.add((Component)this.changeNrOfLoopsButton, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.loopSpinner, null);
        this.changeNrOfLoopsButton.addActionListener(this);
        if (Application.mmWorkspace.isReadOnly()) {
            this.changeNrOfLoopsButton.setEnabled(false);
            this.nrOfLoopsField.setEnabled(false);
        } else {
            this.changeNrOfLoopsButton.setEnabled(true);
            this.nrOfLoopsField.setEnabled(true);
        }
    }

    public void init(int nrOfLoops) {
        this.nrOfLoopsField.setText(String.valueOf(nrOfLoops).concat(String.valueOf("")));
        this.setData(nrOfLoops);
    }

    public int getNumberOfLoops() {
        int nr = 0;
        try {
            nr = Integer.parseInt(this.nrOfLoopsField.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("!!!!!! No int !!!!!");
        }
        return nr;
    }

    public int getShownLoop() {
        int erg = 0;
        if (this.getNumberOfLoops() > 0) {
            String value = this.loopSpinner.getSelected();
            try {
                erg = Integer.parseInt(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return erg;
    }

    public void setData(int maxNr) {
        String[] data;
        if (maxNr == 0) {
            data = new String[]{""};
        } else {
            data = new String[maxNr];
            for (int i = 0; i < maxNr; ++i) {
                data[i] = String.valueOf("").concat(String.valueOf(i + 1));
            }
        }
        this.loopSpinner.setData(data);
        this.oldNumber = this.getNumberOfLoops();
    }

    public void actionPerformed(ActionEvent e) {
        int old = this.oldNumber;
        int newNumber = -1;
        if (this.testInput(this.nrOfLoopsField.getText()) && this.oldNumber != (newNumber = this.getNumberOfLoops())) {
            this.setData(newNumber);
            this.firePropertyChange("loop_number", old, newNumber);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pCL) {
        super.addPropertyChangeListener(pCL);
        this.loopSpinner.addPropertyChangeListener(pCL);
    }

    private boolean testInput(String value) {
        try {
            int i = Integer.parseInt(value);
            if (i < 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Application.frame, "Number of loops has to be an interger >=0", "Wrong input", 0);
            boolean bl = false;
            return bl;
        }
        return true;
    }
}

