/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.timeSeries;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.timeSeries.WeightMovFctOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;

public class WeightMovFctOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField timeBaseAttrib = new JTextField("", 15);
    JTextField valueBaseAttrib = new JTextField("", 15);
    JTextField distance = new JTextField("", 5);
    RestrictedTextField timeStart = new RestrictedTextField("", 10);
    RestrictedTextField timeEnd = new RestrictedTextField("", 10);
    RestrictedTextField outputValueBAField = new RestrictedTextField("", 20);
    MmDataList weightValues = new MmDataList();
    RestrictedTextField outputConceptName = new RestrictedTextField("", 20);
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton changeTBAButton = new JButton("Change");
    JButton changeVBAButton = new JButton("Change");
    JButton addWeightButton = new JButton("Add");
    JButton removeWeightButton = new JButton("Remove");
    private WeightMovFctOperator op;
    private DataChooser chooser;

    public WeightMovFctOperatorView(WeightMovFctOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.label = new JLabel("Inputs");
        this.insets = new Insets(0, 0, 10, 0);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept", 2);
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 5, 5, 0);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.changeConceptButton.addActionListener(this);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.timeBaseAttrib.setEditable(false);
        this.timeBaseAttrib.setBackground(Color.white);
        this.label = new JLabel("TimeBaseAttrib", 2);
        this.label.setLabelFor(this.timeBaseAttrib);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.timeBaseAttrib, this.constraints);
        this.changeTBAButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeTBAButton, this.constraints);
        this.valueBaseAttrib.setEditable(false);
        this.valueBaseAttrib.setBackground(Color.white);
        this.label = new JLabel("ValueBaseAttrib", 2);
        this.label.setLabelFor(this.valueBaseAttrib);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.valueBaseAttrib, this.constraints);
        this.changeVBAButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeVBAButton, this.constraints);
        this.label = new JLabel("Distance", 2);
        this.label.setLabelFor(this.distance);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.distance, this.constraints);
        this.label = new JLabel("Outputs");
        this.insets = new Insets(15, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.insets = new Insets(0, 5, 5, 0);
        this.label = new JLabel("Weights");
        this.label.setLabelFor(this.weightValues);
        this.constraints = new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("TimeStart");
        this.label.setLabelFor(this.timeStart);
        this.constraints = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("TimeEnd");
        this.label.setLabelFor(this.timeEnd);
        this.constraints = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("Output Value BA");
        this.label.setLabelFor(this.outputValueBAField);
        this.constraints = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("OutputConcept");
        this.label.setLabelFor(this.outputConceptName);
        this.constraints = new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.timeStart, this.constraints);
        this.constraints = new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.timeEnd, this.constraints);
        this.constraints = new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputValueBAField, this.constraints);
        this.constraints = new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        this.scrollPane = new JScrollPane(this.weightValues);
        this.constraints = new GridBagConstraints(3, 7, 2, 4, 0.0, 0.0, 17, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.constraints = new GridBagConstraints(3, 11, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.addWeightButton, this.constraints);
        this.addWeightButton.addActionListener(this);
        this.constraints = new GridBagConstraints(4, 11, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.removeWeightButton, this.constraints);
        this.removeWeightButton.addActionListener(this);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.changeTBAButton.setEnabled(enable);
        this.changeVBAButton.setEnabled(enable);
        this.addWeightButton.setEnabled(enable);
        this.removeWeightButton.setEnabled(enable);
        this.outputConceptName.setEditable(enable);
        this.distance.setEditable(enable);
        this.timeStart.setEditable(enable);
        this.timeEnd.setEditable(enable);
        this.outputValueBAField.setEnabled(enable);
        if (!enable) {
            this.outputConceptName.setBackground(Color.white);
            this.distance.setBackground(Color.white);
            this.timeStart.setBackground(Color.white);
            this.timeEnd.setBackground(Color.white);
            this.outputValueBAField.setBackground(Color.white);
        }
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        if (this.op.timeBaseAttrib != null) {
            this.timeBaseAttrib.setText(this.op.timeBaseAttrib.getName());
        } else {
            this.timeBaseAttrib.setText("");
        }
        if (this.op.valueBaseAttrib != null) {
            this.valueBaseAttrib.setText(this.op.valueBaseAttrib.getName());
        } else {
            this.valueBaseAttrib.setText("");
        }
        if (this.op.weightStrings != null) {
            this.weightValues.setListData(this.op.weightStrings);
        }
        this.outputConceptName.setText(this.op.outputConceptName);
        this.outputValueBAField.setText(this.op.outputValueBAName);
        this.distance.setText(this.op.distanceString);
        this.timeStart.setText(this.op.timeStartString);
        this.timeEnd.setText(this.op.timeEndString);
    }

    public void actionPerformed(ActionEvent e) {
        block30: {
            BaseAttribute newAttrib;
            super.actionPerformed(e);
            if (e.getSource() == this.changeConceptButton) {
                this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, (M4Object)Application.m4Case, true);
                this.chooser.setDepenceFromStep(this.op);
                Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
                boolean bl = this.op.icChanged = newConcept != null && !newConcept.equals(this.op.theInputConcept);
                if (this.op.icChanged) {
                    this.op.theInputConcept = newConcept;
                }
            } else if (e.getSource() == this.changeTBAButton) {
                if (this.op.theInputConcept == null) {
                    JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                    return;
                }
                this.chooser = new DataChooser(Application.frame, "Select time stamp Base Attribute", 7, (M4Object)this.op.theInputConcept, true);
                this.chooser.setDepenceFromStep(this.op);
                newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
                boolean bl = this.op.tbChanged = newAttrib != null && !newAttrib.equals(this.timeBaseAttrib);
                if (this.op.tbChanged) {
                    this.op.timeBaseAttrib = newAttrib;
                }
            } else if (e.getSource() == this.changeVBAButton) {
                if (this.op.theInputConcept == null) {
                    JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                    return;
                }
                this.chooser = new DataChooser(Application.frame, "Select value base Attribute", 8, (M4Object)this.op.theInputConcept, true);
                this.chooser.setDepenceFromStep(this.op);
                newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
                boolean bl = this.op.vbChanged = newAttrib != null && !newAttrib.equals(this.valueBaseAttrib);
                if (this.op.vbChanged) {
                    this.op.valueBaseAttrib = newAttrib;
                }
            } else if (e.getSource() == this.addWeightButton) {
                String newValue = JOptionPane.showInputDialog(Application.frame, "Enter new wight", "Enter Input", 3);
                try {
                    double d = Double.parseDouble(newValue);
                    if (d > 0.0 && d <= 1.0) {
                        this.op.weightStrings.addElement(newValue);
                        break block30;
                    }
                    JOptionPane.showMessageDialog(Application.frame, "Weight has to be a real between 0 and 1", "Wrong Input", 0);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Application.frame, "Weight has to be a real between 0 and 1", "Wrong Input", 0);
                }
            } else if (e.getSource() == this.removeWeightButton) {
                Object[] selected = this.weightValues.getSelectedValues();
                if (selected.length > 0) {
                    for (int i = 0; i < selected.length; ++i) {
                        this.op.weightStrings.removeElement(selected[i]);
                    }
                }
            } else {
                if (e.getSource() == this.cancelButton) {
                    this.op.setParameter();
                    this.updateView();
                    return;
                }
                if (e.getSource() == this.closeButton) {
                    this.op.setParameter();
                    Application.menuWindowClose.doClick();
                }
            }
        }
        String value = this.distance.getText();
        if (!value.equals(this.op.distanceString) && this.testValueGE("Distance", value, 1, 1.0)) {
            this.op.distanceString = this.distance.getText();
            this.op.dChanged = true;
        }
        boolean bl = this.op.tsChanged = (!this.timeStart.getText().equals(this.op.timeStartString) || this.op.tsChanged) && this.timeStart.hasValidInput();
        if (this.op.tsChanged) {
            this.op.timeStartString = this.timeStart.getText();
        }
        boolean bl2 = this.op.teChanged = (!this.timeEnd.getText().equals(this.op.timeEndString) || this.op.teChanged) && this.timeEnd.hasValidInput();
        if (this.op.teChanged) {
            this.op.timeEndString = this.timeEnd.getText();
        }
        boolean bl3 = this.op.ovChanged = (!this.outputValueBAField.getText().equals(this.op.outputValueBAName) || this.op.ovChanged) && this.outputValueBAField.hasValidInput();
        if (this.op.ovChanged) {
            this.op.outputValueBAName = this.outputValueBAField.getText();
        }
        boolean bl4 = this.op.ocChanged = (!this.outputConceptName.getText().equals(this.op.outputConceptName) || this.op.ocChanged) && this.outputConceptName.hasValidInput();
        if (this.op.ocChanged) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (e.getSource() == this.saveButton) {
            double sum = 0.0;
            for (int i = 0; i < this.op.weightStrings.size(); ++i) {
                sum += Double.parseDouble((String)this.op.weightStrings.get(i));
            }
            if (sum != 1.0) {
                JOptionPane.showMessageDialog(Application.frame, "The sum of the weights must be 1", "", 0);
            }
            this.op.saveM4Object();
        }
        this.updateView();
    }
}

