/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.timeSeries;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.timeSeries.Sig2SymProcOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;

public class Sig2SymProcOperatorView
extends MMStepView {
    JTextField inputConceptField = new JTextField("", 20);
    JTextField inputTimeBAField = new JTextField("", 15);
    JTextField inputValueBAField = new JTextField("", 15);
    JTextField toleranceField = new JTextField("", 5);
    RestrictedTextField timeStartBAField = new RestrictedTextField("", 15);
    RestrictedTextField timeEndBAField = new RestrictedTextField("", 15);
    RestrictedTextField averageValueBAField = new RestrictedTextField("", 15);
    RestrictedTextField increasingValueBAField = new RestrictedTextField("", 15);
    RestrictedTextField outputConceptField = new RestrictedTextField("", 20);
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton changeTBAButton = new JButton("Change");
    JButton changeVBAButton = new JButton("Change");
    private Sig2SymProcOperator op;
    private DataChooser chooser;

    public Sig2SymProcOperatorView(Sig2SymProcOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.label = new JLabel("Inputs");
        this.insets = new Insets(0, 0, 10, 0);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.inputConceptField.setEditable(false);
        this.inputConceptField.setBackground(Color.white);
        this.label = new JLabel("InputConcept", 2);
        this.label.setLabelFor(this.inputConceptField);
        this.insets = new Insets(0, 5, 5, 0);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptField, this.constraints);
        this.constraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.changeConceptButton.addActionListener(this);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.inputTimeBAField.setEditable(false);
        this.inputTimeBAField.setBackground(Color.white);
        this.label = new JLabel("TimeBaseAttrib", 2);
        this.label.setLabelFor(this.inputTimeBAField);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputTimeBAField, this.constraints);
        this.changeTBAButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeTBAButton, this.constraints);
        this.inputValueBAField.setEditable(false);
        this.inputValueBAField.setBackground(Color.white);
        this.label = new JLabel("ValueBaseAttrib", 2);
        this.label.setLabelFor(this.inputValueBAField);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputValueBAField, this.constraints);
        this.changeVBAButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeVBAButton, this.constraints);
        this.label = new JLabel("Tolerance", 2);
        this.label.setLabelFor(this.toleranceField);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.toleranceField, this.constraints);
        this.label = new JLabel("Outputs");
        this.insets = new Insets(15, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.insets = new Insets(0, 5, 5, 0);
        this.label = new JLabel("AverageValue");
        this.label.setLabelFor(this.averageValueBAField);
        this.constraints = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.averageValueBAField, this.constraints);
        this.label = new JLabel("IncreasingValue");
        this.label.setLabelFor(this.increasingValueBAField);
        this.constraints = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.increasingValueBAField, this.constraints);
        this.label = new JLabel("TimeStart");
        this.label.setLabelFor(this.timeStartBAField);
        this.constraints = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.timeStartBAField, this.constraints);
        this.label = new JLabel("TimeEnd");
        this.label.setLabelFor(this.timeEndBAField);
        this.constraints = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.timeEndBAField, this.constraints);
        this.label = new JLabel("Output Concept");
        this.label.setLabelFor(this.outputConceptField);
        this.constraints = new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptField, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.changeTBAButton.setEnabled(enable);
        this.changeVBAButton.setEnabled(enable);
        this.outputConceptField.setEditable(enable);
        this.toleranceField.setEditable(enable);
        this.timeStartBAField.setEditable(enable);
        this.timeEndBAField.setEditable(enable);
        if (!enable) {
            this.outputConceptField.setBackground(Color.white);
            this.toleranceField.setBackground(Color.white);
            this.timeStartBAField.setBackground(Color.white);
            this.timeEndBAField.setBackground(Color.white);
        }
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptField.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptField.setText("");
        }
        if (this.op.inputTimeBA != null) {
            this.inputTimeBAField.setText(this.op.inputTimeBA.getName());
        } else {
            this.inputTimeBAField.setText("");
        }
        if (this.op.inputValueBA != null) {
            this.inputValueBAField.setText(this.op.inputValueBA.getName());
        } else {
            this.inputValueBAField.setText("");
        }
        this.toleranceField.setText(this.op.toleranceString);
        this.averageValueBAField.setText(this.op.averageValueBAName);
        this.increasingValueBAField.setText(this.op.increasingValueBAName);
        this.timeStartBAField.setText(this.op.timeStartString);
        this.timeEndBAField.setText(this.op.timeEndString);
        this.outputConceptField.setText(this.op.outputConceptName);
    }

    public void actionPerformed(ActionEvent e) {
        String value;
        BaseAttribute newAttrib;
        super.actionPerformed(e);
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, (M4Object)Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.icChanged = newConcept != null && !newConcept.equals(this.op.theInputConcept);
            if (this.op.icChanged) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.changeTBAButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select time stamp Base Attribute", 7, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.tbChanged = newAttrib != null && !newAttrib.equals(this.inputTimeBAField);
            if (this.op.tbChanged) {
                this.op.inputTimeBA = newAttrib;
            }
        } else if (e.getSource() == this.changeVBAButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select value base Attribute", 8, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.vbChanged = newAttrib != null && !newAttrib.equals(this.inputValueBAField);
            if (this.op.vbChanged) {
                this.op.inputValueBA = newAttrib;
            }
        }
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
        }
        if (!(value = this.toleranceField.getText()).equals(this.op.toleranceString) && this.testValueGE("Tolerance", value, 1, 1.0)) {
            this.op.toleranceString = this.toleranceField.getText();
            this.op.tChanged = true;
        }
        boolean bl = this.op.avChanged = (!this.averageValueBAField.getText().equals(this.op.averageValueBAName) || this.op.avChanged) && this.averageValueBAField.hasValidInput();
        if (this.op.avChanged) {
            this.op.averageValueBAName = this.averageValueBAField.getText();
        }
        boolean bl2 = this.op.ivChanged = (!this.increasingValueBAField.getText().equals(this.op.increasingValueBAName) || this.op.avChanged) && this.increasingValueBAField.hasValidInput();
        if (this.op.ivChanged) {
            this.op.increasingValueBAName = this.increasingValueBAField.getText();
        }
        boolean bl3 = this.op.tsChanged = (!this.timeStartBAField.getText().equals(this.op.timeStartString) || this.op.tsChanged) && this.timeStartBAField.hasValidInput();
        if (this.op.tsChanged) {
            this.op.timeStartString = this.timeStartBAField.getText();
        }
        boolean bl4 = this.op.teChanged = (!this.timeEndBAField.getText().equals(this.op.timeEndString) || this.op.teChanged) && this.timeEndBAField.hasValidInput();
        if (this.op.teChanged) {
            this.op.timeEndString = this.timeEndBAField.getText();
        }
        boolean bl5 = this.op.ocChanged = (!this.outputConceptField.getText().equals(this.op.outputConceptName) || this.op.ocChanged) && this.outputConceptField.hasValidInput();
        if (this.op.ocChanged) {
            this.op.outputConceptName = this.outputConceptField.getText();
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }
}

