/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.timeSeries;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.timeSeries.ExpMovFctOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;

public class ExpMovFctOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField inputTimeBAField = new JTextField("", 15);
    JTextField inputValueBAField = new JTextField("", 15);
    JTextField headWeightField = new JTextField("", 5);
    JTextField tailWeightField = new JTextField("", 5);
    JTextField distance = new JTextField("", 5);
    RestrictedTextField outputTimeBAField = new RestrictedTextField("", 20);
    RestrictedTextField outputValueBAField = new RestrictedTextField("", 20);
    RestrictedTextField outputConceptName = new RestrictedTextField("", 20);
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton changeTBAButton = new JButton("Change");
    JButton changeVBAButton = new JButton("Change");
    private ExpMovFctOperator op;
    private DataChooser chooser;

    public ExpMovFctOperatorView(ExpMovFctOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.label = new JLabel("Inputs");
        this.insets = new Insets(0, 0, 10, 0);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("Input Concept", 2);
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 5, 5, 0);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.changeConceptButton.addActionListener(this);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.inputTimeBAField.setEditable(false);
        this.inputTimeBAField.setBackground(Color.white);
        this.label = new JLabel("Time Base Attribute", 2);
        this.label.setLabelFor(this.inputTimeBAField);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputTimeBAField, this.constraints);
        this.changeTBAButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeTBAButton, this.constraints);
        this.inputValueBAField.setEditable(false);
        this.inputValueBAField.setBackground(Color.white);
        this.label = new JLabel("Value Base Attribute", 2);
        this.label.setLabelFor(this.inputValueBAField);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputValueBAField, this.constraints);
        this.changeVBAButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeVBAButton, this.constraints);
        this.label = new JLabel("Head Weight", 2);
        this.label.setLabelFor(this.headWeightField);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.headWeightField, this.constraints);
        this.label = new JLabel("Tail Weight", 2);
        this.label.setLabelFor(this.tailWeightField);
        this.constraints = new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.tailWeightField, this.constraints);
        this.label = new JLabel("Distance", 2);
        this.label.setLabelFor(this.distance);
        this.constraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.distance, this.constraints);
        this.label = new JLabel("Outputs");
        this.insets = new Insets(15, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.insets = new Insets(0, 5, 5, 0);
        this.label = new JLabel("Output Time BA");
        this.label.setLabelFor(this.outputTimeBAField);
        this.constraints = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("Output Value BA");
        this.label.setLabelFor(this.outputValueBAField);
        this.constraints = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("Output Concept");
        this.label.setLabelFor(this.outputConceptName);
        this.constraints = new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputTimeBAField, this.constraints);
        this.constraints = new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputValueBAField, this.constraints);
        this.constraints = new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.changeTBAButton.setEnabled(enable);
        this.changeVBAButton.setEnabled(enable);
        this.outputConceptName.setEditable(enable);
        this.outputValueBAField.setEditable(enable);
        this.distance.setEditable(enable);
        this.outputTimeBAField.setEditable(enable);
        this.headWeightField.setEnabled(enable);
        this.tailWeightField.setEnabled(enable);
        if (!enable) {
            this.outputConceptName.setBackground(Color.white);
            this.headWeightField.setBackground(Color.white);
            this.tailWeightField.setBackground(Color.white);
            this.distance.setBackground(Color.white);
            this.outputTimeBAField.setBackground(Color.white);
            this.outputValueBAField.setBackground(Color.white);
        }
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        if (this.op.inputTimeBA != null) {
            this.inputTimeBAField.setText(this.op.inputTimeBA.getName());
        } else {
            this.inputTimeBAField.setText("");
        }
        if (this.op.inputValueBA != null) {
            this.inputValueBAField.setText(this.op.inputValueBA.getName());
        } else {
            this.inputValueBAField.setText("");
        }
        this.outputConceptName.setText(this.op.outputConceptName);
        this.outputValueBAField.setText(this.op.outputValueBAName);
        this.outputTimeBAField.setText(this.op.outputTimeBAName);
        this.distance.setText(this.op.distanceString);
        this.headWeightField.setText(this.op.headWeightString);
        this.tailWeightField.setText(this.op.tailWeightString);
    }

    public void actionPerformed(ActionEvent e) {
        String value;
        BaseAttribute newAttrib;
        super.actionPerformed(e);
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, (M4Object)Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.icChanged = newConcept != null && !newConcept.equals(this.op.theInputConcept);
            if (this.op.icChanged) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.changeTBAButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select time stamp Base Attribute", 7, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.itChanged = newAttrib != null && !newAttrib.equals(this.inputTimeBAField);
            if (this.op.itChanged) {
                this.op.inputTimeBA = newAttrib;
            }
        } else if (e.getSource() == this.changeVBAButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select value base Attribute", 8, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.ivChanged = newAttrib != null && !newAttrib.equals(this.inputValueBAField);
            if (this.op.ivChanged) {
                this.op.inputValueBA = newAttrib;
            }
        }
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
        }
        if (!(value = this.headWeightField.getText()).equals(this.op.headWeightString) && this.testValueIN("head weight", value, 0, 0.0, 1.0)) {
            this.op.headWeightString = this.headWeightField.getText();
            this.op.hwChanged = true;
        }
        if (!(value = this.tailWeightField.getText()).equals(this.op.tailWeightString) && this.testValueIN("tail weight", value, 0, 0.0, 1.0)) {
            this.op.tailWeightString = this.tailWeightField.getText();
            this.op.twChanged = true;
        }
        if (!(value = this.distance.getText()).equals(this.op.distanceString) && this.testValueGE("Distance", value, 1, 1.0)) {
            this.op.distanceString = this.distance.getText();
            this.op.dChanged = true;
        }
        boolean bl = this.op.otChanged = (!this.outputTimeBAField.getText().equals(this.op.outputTimeBAName) || this.op.otChanged) && this.outputTimeBAField.hasValidInput();
        if (this.op.otChanged) {
            this.op.outputTimeBAName = this.outputTimeBAField.getText();
        }
        boolean bl2 = this.op.ovChanged = (!this.outputValueBAField.getText().equals(this.op.outputValueBAName) || this.op.ovChanged) && this.outputValueBAField.hasValidInput();
        if (this.op.ovChanged) {
            this.op.outputValueBAName = this.outputValueBAField.getText();
        }
        boolean bl3 = this.op.ocChanged = (!this.outputConceptName.getText().equals(this.op.outputConceptName) || this.op.ocChanged) && this.outputConceptName.hasValidInput();
        if (this.op.ocChanged) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (e.getSource() == this.saveButton) {
            double sum;
            if (!this.headWeightField.getText().equals("") && !this.tailWeightField.getText().equals("") && (sum = Double.parseDouble(this.headWeightField.getText()) + Double.parseDouble(this.tailWeightField.getText())) != 1.0) {
                JOptionPane.showMessageDialog(Application.frame, "The sum of the weights must be 1", "", 0);
            }
            this.op.saveM4Object();
        }
        this.updateView();
    }
}

