/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.svm.SvmfrOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;
import miningmart.m4.Value;

public class SvmfrOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField targetAttributeName = new JTextField("", 20);
    JTextField kernelType = new JTextField("", 10);
    JTextField size = new JTextField("", 5);
    JTextField lossPos = new JTextField("", 5);
    JTextField lossNeg = new JTextField("", 5);
    JTextField c = new JTextField("", 5);
    JTextField epsilon = new JTextField("", 5);
    RestrictedTextField outputAttributeName = new RestrictedTextField("", 20);
    MmDataList predictingAttribs = new MmDataList();
    JCheckBox useDBCheckBox = new JCheckBox();
    JTextField keyName = new JTextField("", 20);
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton changeAttributeButton = new JButton("Change");
    JButton changeKernelTypeButton = new JButton("Change");
    JButton addAttribButton = new JButton("Add");
    JButton deleteAttribButton = new JButton("Remove");
    JButton changeKeyButton = new JButton("Change");
    private SvmfrOperator op;
    private DataChooser chooser;

    public SvmfrOperatorView(SvmfrOperator op) {
        this.op = op;
        this.initControls();
        this.loopPanel.init(op.stepLoopNr);
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept");
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 0, 10, 5);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.changeConceptButton.addActionListener(this);
        this.targetAttributeName.setEditable(false);
        this.targetAttributeName.setBackground(Color.white);
        this.label = new JLabel("Target Attribute");
        this.label.setLabelFor(this.inputConceptName);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.targetAttributeName, this.constraints);
        this.constraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeAttributeButton, this.constraints);
        this.changeAttributeButton.addActionListener(this);
        this.kernelType.setEditable(false);
        this.kernelType.setBackground(Color.white);
        this.label = new JLabel("Kernel Type ");
        this.label.setLabelFor(this.kernelType);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.kernelType, this.constraints);
        this.constraints = new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeKernelTypeButton, this.constraints);
        this.changeKernelTypeButton.addActionListener(this);
        this.label = new JLabel("Sample Size");
        this.label.setLabelFor(this.size);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.size, this.constraints);
        this.label = new JLabel("LossFunction Pos");
        this.label.setLabelFor(this.lossPos);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.lossPos, this.constraints);
        this.label = new JLabel("LossFunction Neg");
        this.label.setLabelFor(this.lossNeg);
        this.constraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.lossNeg, this.constraints);
        this.label = new JLabel("C");
        this.label.setLabelFor(this.c);
        this.constraints = new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.c, this.constraints);
        this.label = new JLabel("Epsilon");
        this.label.setLabelFor(this.epsilon);
        this.constraints = new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.epsilon, this.constraints);
        this.label = new JLabel("UseDB_SVM");
        this.label.setLabelFor(this.useDBCheckBox);
        this.constraints = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.useDBCheckBox, this.constraints);
        this.useDBCheckBox.addActionListener(this);
        this.keyName.setEditable(false);
        this.keyName.setBackground(Color.white);
        this.label = new JLabel("The Key");
        this.label.setLabelFor(this.keyName);
        this.constraints = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.keyName, this.constraints);
        this.constraints = new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeKeyButton, this.constraints);
        this.changeKeyButton.addActionListener(this);
        this.label = new JLabel("Predicting Attributes");
        this.label.setLabelFor(this.scrollPane);
        this.constraints = new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 10, 1, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.scrollPane = new JScrollPane(this.predictingAttribs);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.constraints = new GridBagConstraints(4, 2, 2, 5, 0.0, 0.0, 10, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.addAttribButton, this.constraints);
        this.addAttribButton.addActionListener(this);
        this.constraints = new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteAttribButton, this.constraints);
        this.deleteAttribButton.addActionListener(this);
        this.insets = new Insets(0, 0, 15, 0);
        this.label = new JLabel("Output Attribute");
        this.label.setLabelFor(this.outputAttributeName);
        this.constraints = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputAttributeName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.changeAttributeButton.setEnabled(enable);
        this.changeKernelTypeButton.setEnabled(enable);
        this.addAttribButton.setEnabled(enable);
        this.size.setEditable(enable);
        this.lossPos.setEditable(enable);
        this.lossNeg.setEditable(enable);
        this.c.setEditable(enable);
        this.epsilon.setEditable(enable);
        this.outputAttributeName.setEditable(enable);
        if (!enable) {
            this.outputAttributeName.setBackground(Color.white);
            this.epsilon.setBackground(Color.white);
            this.c.setBackground(Color.white);
            this.lossNeg.setBackground(Color.white);
            this.lossPos.setBackground(Color.white);
            this.size.setBackground(Color.white);
        }
        this.loopPanel.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        int loopNr = this.getShownLoopNr();
        if (loopNr > 0) {
            --loopNr;
        }
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        BaseAttribute ba = (BaseAttribute)this.op.theTargetAttributes.get(loopNr);
        if (ba != null) {
            this.targetAttributeName.setText(ba.getName());
        } else {
            this.targetAttributeName.setText("");
        }
        this.keyName.setText((String)this.op.theKeys.get(loopNr));
        Value v = (Value)this.op.kernelTypes.get(loopNr);
        if (v != null) {
            this.kernelType.setText(v.getValue());
        } else {
            this.kernelType.setText("");
        }
        this.size.setText((String)this.op.sizeStrings.get(loopNr));
        this.lossNeg.setText((String)this.op.fktNegStrings.get(loopNr));
        this.lossPos.setText((String)this.op.fktPosStrings.get(loopNr));
        this.c.setText((String)this.op.cStrings.get(loopNr));
        this.epsilon.setText((String)this.op.epsilonStrings.get(loopNr));
        String value = (String)this.op.useDB_SvmStrings.get(loopNr);
        if (value != null) {
            this.useDBCheckBox.setSelected(value.equals("true"));
        } else {
            this.useDBCheckBox.setSelected(false);
        }
        Vector vector = (Vector)this.op.predAttribVectors.get(loopNr);
        if (vector != null) {
            this.predictingAttribs.setListData(vector);
        } else {
            this.predictingAttribs.setListData(new Vector());
        }
        this.outputAttributeName.setText((String)this.op.outputAttribNames.get(loopNr));
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
            return;
        }
        int index = this.getShownLoopNr();
        if (index > 0) {
            --index;
        }
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, (M4Object)Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.changeAttributeButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "select new Attribute", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newBA = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newBA != null) {
                this.op.theTargetAttributes.setElementAt(newBA, index);
            }
        } else if (e.getSource() == this.changeKeyButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "select new Attribute", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newBA = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newBA != null) {
                this.op.theKeys.setElementAt(newBA, index);
            }
        } else if (e.getSource() == this.changeKernelTypeButton) {
            this.chooser = new DataChooser(Application.frame, "select new Kernel Type", 6, true);
            this.chooser.setDepenceFromStep(this.op);
            Value newKT = (Value)this.chooser.showChooseSingleDialog();
            if (newKT != null) {
                if (this.useDBCheckBox.isSelected() && !newKT.getValue().equals("dot") && !newKT.getValue().equals("radial")) {
                    JOptionPane.showMessageDialog(Application.frame, "For DB_SVM only kernel type \n \"dot\" or \"radial\" is allowed", "", 0);
                } else {
                    this.op.kernelTypes.setElementAt(newKT, index);
                }
            }
        } else if (e.getSource() == this.useDBCheckBox) {
            if (this.useDBCheckBox.isSelected()) {
                this.op.useDB_SvmStrings.setElementAt("true", index);
                Value v = (Value)this.op.kernelTypes.get(index);
                if (v != null && !v.getValue().equals("dot") && !v.getValue().equals("radial")) {
                    JOptionPane.showMessageDialog(Application.frame, "For DB_SVM only kernel type \n \"dot\" or \"radial\" is allowed", "", 0);
                }
                if (this.op.theKeys.get(index) == null) {
                    JOptionPane.showMessageDialog(Application.frame, "For DB_SVM a key- attribute is required!", "", 0);
                }
            } else {
                this.op.useDB_SvmStrings.setElementAt("false", index);
            }
        } else if (e.getSource() == this.addAttribButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select Attributes", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            Vector newAttribs = this.chooser.showChooseDialog();
            if (newAttribs != null) {
                Iterator it = newAttribs.iterator();
                BaseAttribute ba = null;
                while (it.hasNext()) {
                    ba = (BaseAttribute)it.next();
                    if (((Vector)this.op.predAttribVectors.get(index)).contains(ba)) continue;
                    ((Vector)this.op.predAttribVectors.get(index)).addElement(ba);
                }
            }
        } else if (e.getSource() == this.deleteAttribButton) {
            Object[] selected = this.predictingAttribs.getSelectedValues();
            if (selected.length > 0) {
                for (int i = 0; i < selected.length; ++i) {
                    ((Vector)this.op.predAttribVectors.get(index)).removeElement(selected[i]);
                }
            }
        } else if (!this.size.getText().equals("") && this.testValueGE("SampleSize", this.size.getText(), 1, 0.0)) {
            this.op.sizeStrings.setElementAt(this.size.getText(), index);
        }
        if (!this.lossPos.getText().equals("") && this.testValueGE("LossFunction Pos", this.lossPos.getText(), 0, 0.0)) {
            this.op.fktPosStrings.setElementAt(this.lossPos.getText(), index);
        }
        if (!this.lossNeg.getText().equals("") && this.testValueGE("LossFunction Neg", this.lossNeg.getText(), 0, 0.0)) {
            this.op.fktNegStrings.setElementAt(this.lossNeg.getText(), index);
        }
        if (!this.c.getText().equals("") && this.testValueGE("C", this.c.getText(), 0, 0.0)) {
            this.op.cStrings.setElementAt(this.c.getText(), index);
        }
        if (!this.epsilon.getText().equals("") && this.testValueGE("Epsilon", this.epsilon.getText(), 0, 0.0)) {
            this.op.epsilonStrings.setElementAt(this.epsilon.getText(), index);
        }
        if (this.outputAttributeName.hasValidInput()) {
            this.op.outputAttribNames.setElementAt(this.outputAttributeName.getText(), index);
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        block14: {
            block13: {
                super.propertyChange(evt);
                if (!evt.getPropertyName().equals("loop_number")) break block13;
                int newVal = (Integer)evt.getNewValue();
                if (newVal == 0) {
                    this.op.resizeVector(1);
                } else {
                    this.op.resizeVector(newVal);
                }
                this.op.stepLoopNr = newVal;
                this.loopPanel.init(newVal);
                this.updateView();
                break block14;
            }
            if (!evt.getPropertyName().equals("loopToShow")) break block14;
            int index = Integer.parseInt((String)evt.getOldValue());
            if (index > 0) {
                --index;
            }
            if (!this.size.getText().equals("") && this.testValueGE("SampleSize", this.size.getText(), 1, 0.0)) {
                this.op.sizeStrings.setElementAt(this.size.getText(), index);
            }
            if (!this.lossPos.getText().equals("") && this.testValueGE("LossFunction Pos", this.lossPos.getText(), 0, 0.0)) {
                this.op.fktPosStrings.setElementAt(this.lossPos.getText(), index);
            }
            if (!this.lossNeg.getText().equals("") && this.testValueGE("LossFunction Neg", this.lossNeg.getText(), 0, 0.0)) {
                this.op.fktNegStrings.setElementAt(this.lossNeg.getText(), index);
            }
            if (!this.c.getText().equals("") && this.testValueGE("C", this.c.getText(), 0, 0.0)) {
                this.op.cStrings.setElementAt(this.c.getText(), index);
            }
            if (!this.epsilon.getText().equals("") && this.testValueGE("Epsilon", this.epsilon.getText(), 0, 0.0)) {
                this.op.epsilonStrings.setElementAt(this.epsilon.getText(), index);
            }
            if (this.useDBCheckBox.isSelected()) {
                this.op.useDB_SvmStrings.setElementAt("true", index);
                Value v = (Value)this.op.kernelTypes.get(index);
                if (v != null && !v.getValue().equals("dot") && !v.getValue().equals("radial")) {
                    JOptionPane.showMessageDialog(Application.frame, "For DB_SVM only kernel type \n \"dot\" or \"radial\" is allowed", "", 0);
                }
                if (this.op.theKeys.get(index) == null) {
                    JOptionPane.showMessageDialog(Application.frame, "For DB_SVM a key- attribute is required!", "", 0);
                }
            } else {
                this.op.useDB_SvmStrings.setElementAt("false", index);
            }
            if (!this.outputAttributeName.getText().equals("") && this.outputAttributeName.hasValidInput()) {
                this.op.outputAttribNames.setElementAt(this.outputAttributeName.getText(), index);
            }
            this.updateView();
        }
    }
}

