/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.specifiedStatistics;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.specifiedStatistics.SpecStatOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;

public class SpecStatOperatorView
extends MMStepView
implements ListSelectionListener {
    JTextField inputConceptField = new JTextField("", 20);
    MmDataList computeSumList = new MmDataList();
    MmDataList computeCountList = new MmDataList();
    MmDataList computeUniqueList = new MmDataList();
    MmDataList computeDistribList = new MmDataList();
    MmDataList distribValuesList = new MmDataList();
    RestrictedTextField outputConceptName = new RestrictedTextField("", 20);
    JButton changeInputConceptButton = new JButton("Change");
    JButton addSumButton = new JButton("Add");
    JButton deleteSumButton = new JButton("Remove");
    JButton addCountButton = new JButton("Add");
    JButton deleteCountButton = new JButton("Remove");
    JButton addUniqueButton = new JButton("Add");
    JButton deleteUniqueButton = new JButton("Remove");
    JButton addDistribButton = new JButton("Add");
    JButton deleteDistribButton = new JButton("Remove");
    JButton changeValueButton = new JButton("Change");
    private SpecStatOperator op;
    private DataChooser chooser;
    private boolean changeValueIsEnabled = false;

    public SpecStatOperatorView(SpecStatOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.label = new JLabel("Input Concept", 2);
        this.label.setLabelFor(this.inputConceptField);
        this.inputConceptField.setEditable(false);
        this.inputConceptField.setBackground(Color.white);
        this.insets = new Insets(0, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 0, 3, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptField, this.constraints);
        this.constraints = new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.changeInputConceptButton, this.constraints);
        this.changeInputConceptButton.addActionListener(this);
        this.insets = new Insets(0, 5, 5, 0);
        this.scrollPane = new JScrollPane(this.computeSumList);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Sum Attributes", 2);
        this.label.setLabelFor(this.scrollPane);
        this.constraints = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.addSumButton.addActionListener(this);
        this.panel.add((Component)this.addSumButton, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteSumButton, this.constraints);
        this.deleteSumButton.addActionListener(this);
        this.scrollPane = new JScrollPane(this.computeCountList);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Count Attributes", 2);
        this.label.setLabelFor(this.scrollPane);
        this.constraints = new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.addCountButton.addActionListener(this);
        this.panel.add((Component)this.addCountButton, this.constraints);
        this.constraints = new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteCountButton, this.constraints);
        this.deleteCountButton.addActionListener(this);
        this.scrollPane = new JScrollPane(this.computeUniqueList);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Unique Attributes", 2);
        this.label.setLabelFor(this.scrollPane);
        this.constraints = new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(4, 2, 2, 1, 0.0, 0.0, 10, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.addUniqueButton.addActionListener(this);
        this.panel.add((Component)this.addUniqueButton, this.constraints);
        this.constraints = new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteUniqueButton, this.constraints);
        this.deleteUniqueButton.addActionListener(this);
        this.scrollPane = new JScrollPane(this.computeDistribList);
        this.computeDistribList.addListSelectionListener(this);
        this.computeDistribList.setSelectionMode(0);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Distrib Attributes", 2);
        this.label.setLabelFor(this.scrollPane);
        this.constraints = new GridBagConstraints(6, 1, 2, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(6, 2, 2, 1, 0.0, 0.0, 10, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.addDistribButton.addActionListener(this);
        this.panel.add((Component)this.addDistribButton, this.constraints);
        this.constraints = new GridBagConstraints(7, 3, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteDistribButton, this.constraints);
        this.deleteDistribButton.addActionListener(this);
        this.scrollPane = new JScrollPane(this.distribValuesList);
        this.distribValuesList.addListSelectionListener(this);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Distrib Values", 2);
        this.label.setLabelFor(this.scrollPane);
        this.constraints = new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(8, 2, 1, 1, 0.0, 0.0, 10, 1, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(8, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.changeValueButton.addActionListener(this);
        this.panel.add((Component)this.changeValueButton, this.constraints);
        this.outputConceptName.setEditable(true);
        this.label = new JLabel("Output Concept", 2);
        this.label.setLabelFor(this.outputConceptName);
        this.insets = new Insets(10, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 4, 3, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeValueButton.setEnabled(enable && this.changeValueIsEnabled);
        this.outputConceptName.setEditable(enable);
        if (!enable) {
            this.outputConceptName.setBackground(Color.white);
        }
        this.addSumButton.setEnabled(enable);
        this.deleteSumButton.setEnabled(enable);
        this.addCountButton.setEnabled(enable);
        this.deleteCountButton.setEnabled(enable);
        this.addUniqueButton.setEnabled(enable);
        this.deleteUniqueButton.setEnabled(enable);
        this.addDistribButton.setEnabled(enable);
        this.deleteDistribButton.setEnabled(enable);
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptField.setText(this.op.theInputConcept.getName());
        }
        this.outputConceptName.setText(this.op.outputConceptName);
        this.computeSumList.setListData(this.op.attributesComputeSum);
        this.computeCountList.setListData(this.op.attributesComputeCount);
        this.computeUniqueList.setListData(this.op.attributesComputeUnique);
        this.computeDistribList.setListData(this.op.attributesComputeDistrib);
        this.distribValuesList.setListData(this.op.distribValues);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.changeInputConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, (M4Object)Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.icChanged = newConcept != null && !newConcept.equals(this.op.theInputConcept);
            if (this.op.icChanged) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.addSumButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select an Attribute", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newAttrib != null) {
                this.op.attributesComputeSum.addElement(newAttrib);
            }
        } else if (e.getSource() == this.deleteSumButton) {
            int[] selected = this.computeSumList.getSelectedIndices();
            for (int i = 0; i < selected.length; ++i) {
                this.op.attributesComputeSum.remove(selected[i]);
            }
        } else if (e.getSource() == this.addCountButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select an Attribute", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newAttrib != null) {
                this.op.attributesComputeCount.addElement(newAttrib);
            }
        } else if (e.getSource() == this.deleteCountButton) {
            int[] selected = this.computeCountList.getSelectedIndices();
            for (int i = 0; i < selected.length; ++i) {
                this.op.attributesComputeCount.remove(selected[i]);
            }
        } else if (e.getSource() == this.addUniqueButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select an Attribute", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newAttrib != null) {
                this.op.attributesComputeUnique.addElement(newAttrib);
            }
        } else if (e.getSource() == this.deleteUniqueButton) {
            int[] selected = this.computeUniqueList.getSelectedIndices();
            for (int i = 0; i < selected.length; ++i) {
                this.op.attributesComputeUnique.remove(selected[i]);
            }
        } else if (e.getSource() == this.addDistribButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select an Attribute", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newAttrib != null) {
                this.op.attributesComputeDistrib.addElement(newAttrib);
                String newValue = "dummy";
                newValue = JOptionPane.showInputDialog(Application.frame, "Enter values for the new Attribute \n Seperated by ,", "", 3);
                this.op.distribValues.addElement(newValue);
            }
        } else if (e.getSource() == this.deleteDistribButton) {
            int selected = this.computeDistribList.getSelectedIndex();
            this.op.attributesComputeDistrib.remove(selected);
            this.op.distribValues.remove(selected);
        } else if (e.getSource() == this.changeValueButton) {
            int index = this.distribValuesList.getSelectedIndex();
            String newValue = JOptionPane.showInputDialog(Application.frame, "Enter new values for the selected Distribution Attribute \n Seperated by ,", "", 3);
            this.op.distribValues.remove(index);
            this.op.distribValues.add(index, newValue);
            this.distribValuesList.setListData(this.op.distribValues);
        } else {
            if (e.getSource() == this.cancelButton) {
                this.op.setParameter();
                this.updateView();
                return;
            }
            if (e.getSource() == this.closeButton) {
                Application.menuWindowClose.doClick();
            }
        }
        boolean bl = this.op.ocChanged = (!this.op.outputConceptName.equals(this.outputConceptName.getText()) || this.op.ocChanged) && this.outputConceptName.hasValidInput();
        if (this.op.ocChanged) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = this.computeDistribList.getSelectedIndex();
        if (selected >= 0) {
            this.distribValuesList.setSelectedIndex(selected);
            this.changeValueButton.setEnabled(true);
            this.changeValueIsEnabled = true;
        } else {
            this.changeValueButton.setEnabled(false);
            this.changeValueIsEnabled = false;
            if (this.distribValuesList.getSelectedIndex() >= 0) {
                this.distribValuesList.clearSelection();
            }
        }
    }
}

