/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.segmentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.segmentation.SegmKMeanOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;

public class SegmKMeanOperatorView
extends MMStepView {
    JTextField inputConceptField = new JTextField("", 20);
    JTextField howManyField = new JTextField("", 5);
    JCheckBox optimizeCheckBox = new JCheckBox();
    JTextField sizeField = new JTextField("", 5);
    RestrictedTextField outputConceptField = new RestrictedTextField("", 20);
    MmDataList predictingAttribs = new MmDataList();
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton addAttribButton = new JButton("Add");
    JButton deleteAttribButton = new JButton("Remove");
    private SegmKMeanOperator op;
    private DataChooser chooser;

    public SegmKMeanOperatorView(SegmKMeanOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.inputConceptField.setEditable(false);
        this.inputConceptField.setBackground(Color.white);
        this.label = new JLabel("Input Concept");
        this.label.setLabelFor(this.inputConceptField);
        this.insets = new Insets(0, 0, 10, 5);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptField, this.constraints);
        this.constraints = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.changeConceptButton.addActionListener(this);
        this.label = new JLabel("How Many Partitions");
        this.label.setLabelFor(this.inputConceptField);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.howManyField, this.constraints);
        this.label = new JLabel("Optimize Number?");
        this.label.setLabelFor(this.optimizeCheckBox);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.optimizeCheckBox, this.constraints);
        this.optimizeCheckBox.addActionListener(this);
        this.label = new JLabel("Sample Size");
        this.label.setLabelFor(this.sizeField);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.sizeField, this.constraints);
        this.label = new JLabel("Predicting Attributes");
        this.label.setLabelFor(this.scrollPane);
        this.constraints = new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.scrollPane = new JScrollPane(this.predictingAttribs);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.constraints = new GridBagConstraints(2, 2, 2, 3, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, this.insets, 0, 0);
        this.panel.add((Component)this.addAttribButton, this.constraints);
        this.addAttribButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteAttribButton, this.constraints);
        this.deleteAttribButton.addActionListener(this);
        this.insets = new Insets(0, 0, 15, 5);
        this.label = new JLabel("Output Concept");
        this.label.setLabelFor(this.outputConceptField);
        this.constraints = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptField, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.optimizeCheckBox.setEnabled(enable);
        this.outputConceptField.setEditable(enable);
        this.addAttribButton.setEnabled(enable);
        this.deleteAttribButton.setEnabled(enable);
        if (!enable) {
            this.outputConceptField.setBackground(Color.white);
            this.sizeField.setBackground(Color.white);
        }
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptField.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptField.setText("");
        }
        if (this.op.thePredictingAttributes != null) {
            this.predictingAttribs.setListData(this.op.thePredictingAttributes);
        }
        this.howManyField.setText(this.op.howManyString);
        this.sizeField.setText(this.op.sizeString);
        this.optimizeCheckBox.setSelected(this.op.optimize);
        this.outputConceptField.setText(this.op.outputConceptString);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, (M4Object)Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.addAttribButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select Attributes", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            Vector newAttribs = this.chooser.showChooseDialog();
            if (newAttribs != null) {
                Iterator it = newAttribs.iterator();
                BaseAttribute ba = null;
                while (it.hasNext()) {
                    ba = (BaseAttribute)it.next();
                    if (this.op.thePredictingAttributes.contains(ba)) continue;
                    this.op.thePredictingAttributes.addElement(ba);
                }
            }
        } else if (e.getSource() == this.deleteAttribButton) {
            Object[] selected = this.predictingAttribs.getSelectedValues();
            if (selected.length > 0) {
                for (int i = 0; i < selected.length; ++i) {
                    this.op.thePredictingAttributes.removeElement(selected[i]);
                }
            }
        } else if (e.getSource() == this.optimizeCheckBox) {
            this.op.optimize = this.optimizeCheckBox.isSelected();
        } else if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.updateView();
        } else if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
        }
        if (this.testValueGE("Sample Size", this.sizeField.getText(), 1, 1.0)) {
            this.op.sizeString = this.sizeField.getText();
        }
        if (this.testValueGE("How Many", this.howManyField.getText(), 1, 1.0)) {
            this.op.howManyString = this.howManyField.getText();
        }
        if (this.outputConceptField.hasValidInput()) {
            this.op.outputConceptString = this.outputConceptField.getText();
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }
}

