/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.rowSelection;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.rowSelection.RsbrOperator;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;

public class RsbrOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField howMany = new JTextField("", 5);
    RestrictedTextField outputConceptName = new RestrictedTextField("", 20);
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    private RsbrOperator op;
    private DataChooser chooser;

    public RsbrOperatorView(RsbrOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept");
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 0, 10, 5);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.changeConceptButton.addActionListener(this);
        this.label = new JLabel("How Many Rows");
        this.label.setLabelFor(this.howMany);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.howMany, this.constraints);
        this.insets = new Insets(0, 0, 15, 0);
        this.label = new JLabel("Output Concept");
        this.label.setLabelFor(this.outputConceptName);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.outputConceptName.setEditable(enable);
        this.howMany.setEditable(enable);
        if (!enable) {
            this.outputConceptName.setBackground(Color.white);
            this.howMany.setBackground(Color.white);
        }
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        this.howMany.setText(this.op.howManyString);
        this.outputConceptName.setText(this.op.outputConceptName);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, (M4Object)Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theInputConcept = newConcept;
            }
        } else {
            if (e.getSource() == this.cancelButton) {
                this.op.setParameter();
                this.updateView();
                return;
            }
            if (e.getSource() == this.closeButton) {
                this.op.setParameter();
                Application.menuWindowClose.doClick();
            }
        }
        if (this.testValueGE("How Many", this.howMany.getText(), 1, 1.0)) {
            this.op.howManyString = this.howMany.getText();
        }
        if (this.outputConceptName.hasValidInput()) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }
}

