/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.missingValue;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.missingValue.MvwDecOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;

public class MvwDecOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField targetAttributeName = new JTextField("", 20);
    JTextField sampleSizeField = new JTextField("", 5);
    JTextField pruningConfField = new JTextField("", 5);
    RestrictedTextField outputAttributeName = new RestrictedTextField("", 20);
    MmDataList predictingAttribs = new MmDataList();
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton changeAttributeButton = new JButton("Change");
    JButton addAttribButton = new JButton("Add");
    JButton deleteAttribButton = new JButton("Remove");
    private MvwDecOperator op;
    private DataChooser chooser;

    public MvwDecOperatorView(MvwDecOperator op) {
        this.op = op;
        this.initControls();
        this.loopPanel.init(op.stepLoopNr);
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept");
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 0, 10, 5);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.changeConceptButton.addActionListener(this);
        this.targetAttributeName.setEditable(false);
        this.targetAttributeName.setBackground(Color.white);
        this.label = new JLabel("Target Attribute");
        this.label.setLabelFor(this.inputConceptName);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.targetAttributeName, this.constraints);
        this.constraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeAttributeButton, this.constraints);
        this.changeAttributeButton.addActionListener(this);
        this.label = new JLabel("Sample Size");
        this.label.setLabelFor(this.sampleSizeField);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.sampleSizeField, this.constraints);
        this.label = new JLabel("Pruning Conf");
        this.label.setLabelFor(this.pruningConfField);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.pruningConfField, this.constraints);
        this.label = new JLabel("Predicting Attributes");
        this.label.setLabelFor(this.scrollPane);
        this.constraints = new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.scrollPane = new JScrollPane(this.predictingAttribs);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.constraints = new GridBagConstraints(3, 1, 2, 3, 0.0, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.addAttribButton, this.constraints);
        this.addAttribButton.addActionListener(this);
        this.constraints = new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteAttribButton, this.constraints);
        this.deleteAttribButton.addActionListener(this);
        this.insets = new Insets(0, 0, 15, 5);
        this.label = new JLabel("Output Attribute");
        this.label.setLabelFor(this.outputAttributeName);
        this.constraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputAttributeName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.changeAttributeButton.setEnabled(enable);
        this.addAttribButton.setEnabled(enable);
        this.outputAttributeName.setEditable(enable);
        if (!enable) {
            this.outputAttributeName.setBackground(Color.white);
        }
        this.loopPanel.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        int loopNr = this.getShownLoopNr();
        if (loopNr > 0) {
            --loopNr;
        }
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        BaseAttribute ba = (BaseAttribute)this.op.theTargetAttributes.get(loopNr);
        if (ba != null) {
            this.targetAttributeName.setText(ba.getName());
        } else {
            this.targetAttributeName.setText("");
        }
        Vector vector = (Vector)this.op.predAttribVectors.get(loopNr);
        if (vector != null) {
            this.predictingAttribs.setListData(vector);
        } else {
            this.predictingAttribs.setListData(new Vector());
        }
        this.sampleSizeField.setText((String)this.op.sizeStrings.get(loopNr));
        this.pruningConfField.setText((String)this.op.confStrings.get(loopNr));
        this.outputAttributeName.setText((String)this.op.outputAttribNames.get(loopNr));
    }

    public void actionPerformed(ActionEvent e) {
        Object[] selected;
        super.actionPerformed(e);
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.loopPanel.init(this.op.stepLoopNr);
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
            return;
        }
        int index = this.getShownLoopNr();
        if (index > 0) {
            --index;
        }
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, (M4Object)Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.changeAttributeButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "select new Attribute", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newBA = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newBA != null) {
                this.op.theTargetAttributes.setElementAt(newBA, index);
            }
        } else if (e.getSource() == this.addAttribButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select Attributes", 3, (M4Object)this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            Vector newAttribs = this.chooser.showChooseDialog();
            if (newAttribs != null) {
                Iterator it = newAttribs.iterator();
                BaseAttribute ba = null;
                while (it.hasNext()) {
                    ba = (BaseAttribute)it.next();
                    if (((Vector)this.op.predAttribVectors.get(index)).contains(ba)) continue;
                    ((Vector)this.op.predAttribVectors.get(index)).addElement(ba);
                }
            }
        } else if (e.getSource() == this.deleteAttribButton && (selected = this.predictingAttribs.getSelectedValues()).length > 0) {
            for (int i = 0; i < selected.length; ++i) {
                ((Vector)this.op.predAttribVectors.get(index)).removeElement(selected[i]);
            }
        }
        if (this.outputAttributeName.hasValidInput()) {
            this.op.outputAttribNames.setElementAt(this.outputAttributeName.getText(), index);
        }
        if (this.testValue("Sample Size", this.sampleSizeField.getText(), 1)) {
            this.op.sizeStrings.setElementAt(this.sampleSizeField.getText(), index);
        }
        if (this.testValueGE("Pruning Conf", this.pruningConfField.getText(), 1, 0.0) && this.testValueLE("Pruning Conf", this.pruningConfField.getText(), 1, 100.0)) {
            this.op.confStrings.setElementAt(this.pruningConfField.getText(), index);
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("loop_number")) {
            int newVal = (Integer)evt.getNewValue();
            if (newVal == 0) {
                this.op.resizeVector(1);
            } else {
                this.op.resizeVector(newVal);
            }
            this.op.stepLoopNr = newVal;
            this.loopPanel.init(newVal);
            this.updateView();
        } else if (evt.getPropertyName().equals("loopToShow")) {
            int index = Integer.parseInt((String)evt.getOldValue());
            if (index > 0) {
                --index;
            }
            if (!this.sampleSizeField.getText().equals("")) {
                this.op.sizeStrings.setElementAt(this.sampleSizeField.getText(), index);
            }
            if (this.pruningConfField.getText().equals("")) {
                this.op.confStrings.setElementAt(this.pruningConfField.getText(), index);
            }
            if (!this.outputAttributeName.getText().equals("") && this.outputAttributeName.hasValidInput()) {
                this.op.outputAttribNames.setElementAt(this.outputAttributeName.getText(), index);
            }
            this.updateView();
        }
    }
}

