/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.joinByKey;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.joinByKey.UnionByKeyOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;

public class UnionByKeyOperatorView
extends MMStepView
implements ListSelectionListener {
    MmDataList conceptList = new MmDataList();
    MmDataList keyList = new MmDataList();
    JTextField mapInputField = new JTextField("", 20);
    JTextField mapOutputField = new JTextField("", 20);
    RestrictedTextField outputConceptName = new RestrictedTextField("", 20);
    JScrollPane scrollPane;
    JButton addConceptButton = new JButton("Add");
    JButton deleteConceptButton = new JButton("Remove");
    JButton changeKeyButton = new JButton("Change");
    JButton changeMapInputButton = new JButton("Change");
    private UnionByKeyOperator op;
    private DataChooser chooser;
    private boolean changeKeyIsEnabled = false;

    public UnionByKeyOperatorView(UnionByKeyOperator op) {
        this.op = op;
        this.initControls();
        this.loopPanel.init(op.stepLoopNr);
        this.updateView();
    }

    public void initControls() {
        super.initControls(true);
        this.scrollPane = new JScrollPane(this.conceptList);
        this.conceptList.setSelectionMode(0);
        this.conceptList.addListSelectionListener(this);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("Concepts", 2);
        this.label.setLabelFor(this.scrollPane);
        this.insets = new Insets(0, 10, 5, 0);
        this.constraints = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 10, 2, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.addConceptButton.addActionListener(this);
        this.panel.add((Component)this.addConceptButton, this.constraints);
        this.insets = new Insets(0, 5, 5, 0);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0);
        this.panel.add((Component)this.deleteConceptButton, this.constraints);
        this.deleteConceptButton.addActionListener(this);
        this.scrollPane = new JScrollPane(this.keyList);
        this.keyList.addListSelectionListener(this);
        this.keyList.setSelectionMode(0);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.label = new JLabel("The Keys", 2);
        this.label.setLabelFor(this.scrollPane);
        this.insets = new Insets(0, 10, 5, 0);
        this.constraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 17, 2, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        this.constraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.changeKeyButton.addActionListener(this);
        this.panel.add((Component)this.changeKeyButton, this.constraints);
        this.changeKeyButton.setEnabled(false);
        this.mapInputField.setEditable(false);
        this.mapInputField.setBackground(Color.white);
        this.label = new JLabel("MapInput");
        this.label.setLabelFor(this.mapInputField);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.mapInputField, this.constraints);
        this.constraints = new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeMapInputButton, this.constraints);
        this.changeMapInputButton.addActionListener(this);
        this.label = new JLabel("MapOutput");
        this.label.setLabelFor(this.mapOutputField);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.mapOutputField, this.constraints);
        this.outputConceptName.setEditable(true);
        this.label = new JLabel("Output Concept", 2);
        this.label.setLabelFor(this.outputConceptName);
        this.insets = new Insets(10, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeKeyButton.setEnabled(enable && this.changeKeyIsEnabled);
        this.changeMapInputButton.setEnabled(enable);
        this.outputConceptName.setEditable(enable);
        if (!enable) {
            this.outputConceptName.setBackground(Color.white);
        }
        this.addConceptButton.setEnabled(enable);
        this.deleteConceptButton.setEnabled(enable);
        this.loopPanel.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        int loopNr = this.getShownLoopNr();
        if (loopNr > 0) {
            this.changeMapInputButton.setEnabled(true);
            this.mapInputField.setBackground(Color.white);
            this.mapOutputField.setEditable(true);
            BaseAttribute ba = (BaseAttribute)this.op.mapInputs.get(--loopNr);
            if (ba != null) {
                this.mapInputField.setText(ba.getName());
            } else {
                this.mapInputField.setText("");
            }
            this.mapOutputField.setText((String)this.op.outputStrings.get(loopNr));
        } else {
            this.mapOutputField.setText("");
            this.mapInputField.setText("");
            this.mapOutputField.setEditable(false);
            this.changeMapInputButton.setEnabled(false);
            this.mapInputField.setBackground(this.mapOutputField.getBackground());
        }
        this.outputConceptName.setText(this.op.outputConceptName);
        this.conceptList.setListData(this.op.theConcepts);
        this.keyList.setListData(this.op.theKeys);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            Application.menuWindowClose.doClick();
            return;
        }
        int loopNr = this.getShownLoopNr();
        if (loopNr > 0) {
            --loopNr;
        }
        if (e.getSource() == this.addConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select a concept", 1, (M4Object)Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            if (newConcept != null && !this.op.theConcepts.contains(newConcept)) {
                this.op.theConcepts.addElement(newConcept);
                this.chooser = new DataChooser(Application.frame, "Select the Key", 3, (M4Object)newConcept, true);
                this.chooser.setDepenceFromStep(this.op);
                BaseAttribute newKey = (BaseAttribute)this.chooser.showChooseSingleDialog();
                this.op.theKeys.addElement(newKey);
            }
        } else if (e.getSource() == this.deleteConceptButton) {
            int selected = this.conceptList.getSelectedIndex();
            if (selected >= 0) {
                this.op.theConcepts.remove(selected);
                if (selected < this.op.theKeys.size()) {
                    this.op.theKeys.remove(selected);
                }
            }
        } else if (e.getSource() == this.changeKeyButton) {
            Concept c = (Concept)this.conceptList.getSelectedValue();
            int index = this.conceptList.getSelectedIndex();
            this.chooser = new DataChooser(Application.frame, "Select a Key", 3, (M4Object)c, true);
            this.chooser.setDepenceFromStep(this.op);
            BaseAttribute newKey = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newKey != null && !this.op.containsSameBA(this.op.theKeys, newKey)) {
                if (index < this.op.theKeys.size()) {
                    this.op.theKeys.remove(index);
                }
                this.op.theKeys.add(index, newKey);
            }
        } else if (e.getSource() == this.changeMapInputButton) {
            this.chooser = new DataChooser(Application.frame, "Select a Base Attribute", true);
            this.chooser.setDepenceFromStep(this.op);
            this.chooser.setWithContext(true);
            this.chooser.setDataType(3, this.op.theConcepts);
            BaseAttribute newBA = (BaseAttribute)this.chooser.showChooseSingleDialog();
            if (newBA != null) {
                this.op.mapInputs.setElementAt(newBA, loopNr);
            }
        }
        if (this.outputConceptName.hasValidInput()) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (!this.mapOutputField.getText().equals("")) {
            this.op.outputStrings.setElementAt(this.mapOutputField.getText(), loopNr);
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = this.conceptList.getSelectedIndex();
        if (selected >= 0) {
            this.keyList.setSelectedIndex(selected);
            this.changeKeyButton.setEnabled(true);
            this.changeKeyIsEnabled = true;
        } else {
            this.changeKeyButton.setEnabled(false);
            this.changeKeyIsEnabled = false;
            if (this.keyList.getSelectedIndex() >= 0) {
                this.keyList.clearSelection();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("loop_number")) {
            int newVal = (Integer)evt.getNewValue();
            if (newVal == 0) {
                this.op.resizeVector(1);
            } else {
                this.op.resizeVector(newVal);
            }
            this.op.stepLoopNr = newVal;
            this.loopPanel.init(newVal);
            this.updateView();
        } else if (evt.getPropertyName().equals("loopToShow")) {
            int index = Integer.parseInt((String)evt.getOldValue());
            if (index > 0) {
                --index;
            }
            if (!this.mapOutputField.getText().equals("")) {
                this.op.outputStrings.setElementAt(this.mapOutputField.getText(), index);
            }
            if (!this.outputConceptName.getText().equals("") && this.outputConceptName.hasValidInput()) {
                this.op.outputConceptName = this.outputConceptName.getText();
            }
            this.updateView();
        }
    }
}

