/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.Constraint;
import miningmart.m4.FeatureAttribute;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.MultipleResultException;
import miningmart.m4.Parameter;
import miningmart.m4.Step;
import miningmart.m4.Value;

public class StepConstraint {
    private Constraint constr = null;
    private String constrType = "";
    private Object object1 = null;
    private Vector objects2 = new Vector();
    private int loopNr = -1;

    public StepConstraint(Constraint constraint, int loopNr) {
        this.constr = constraint;
        this.constrType = constraint.getConstraintType();
        this.loopNr = loopNr;
    }

    public void setParamObject1(Object object) {
        this.object1 = object;
    }

    public void addObject2(Object object) {
        this.objects2.add(object);
    }

    public void addAllObject2(Vector objects) {
        this.objects2.addAll(objects);
    }

    private boolean checkFeatInConcepts(FeatureAttribute obj1) {
        Concept c = null;
        boolean erg = false;
        Iterator i = this.objects2.iterator();
        while (i.hasNext() && !erg) {
            c = (Concept)i.next();
            if (obj1 instanceof MultiColumnFeature) {
                erg = erg || c.getMultiColumnFeature(obj1.getName()) != null;
                continue;
            }
            erg = erg || c.getBaseAttribute(obj1.getName()) != null;
        }
        return erg;
    }

    private boolean checkCreationSteps(FeatureAttribute obj1, Concept c) {
        if (obj1 == null) {
            return false;
        }
        boolean erg = false;
        Step feaStep = null;
        Step conStep = null;
        Parameter p1 = null;
        Parameter p2 = null;
        try {
            p1 = obj1.getOutputParameter();
            p2 = c.getOutputParameter();
        }
        catch (MultipleResultException multipleResultException) {
            // empty catch block
        }
        if (p1 == null || p2 == null) {
            return erg;
        }
        feaStep = p1.getStep();
        conStep = p2.getStep();
        erg = erg || feaStep == conStep;
        erg = erg || !this.getEveryStepPredecessors(conStep).contains(feaStep);
        return erg;
    }

    private boolean checkFloat() {
        String value1 = ((Value)this.object1).getValue();
        String value2 = this.objects2.get(0) instanceof Value ? ((Value)this.objects2.get(0)).getValue() : (String)this.objects2.get(0);
        try {
            float f1 = Float.parseFloat(value1);
            float f2 = Float.parseFloat(value2);
            boolean bl = f1 > f2 || this.constrType.equals("GE") && f1 == f2;
            return bl;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean testDataType(String type2) {
        String type1;
        if (this.object1 instanceof Value) {
            type1 = ((Value)this.object1).getDatatype();
            if (type2.equals("NUMERIC") && type1 != null) {
                try {
                    Float.parseFloat(((Value)this.object1).getValue());
                }
                catch (NumberFormatException e) {
                    boolean bl = false;
                    return bl;
                }
            }
        } else {
            type1 = ((BaseAttribute)this.object1).getDatatype();
        }
        return type1.equals(type2) || type1.equals("NUMERIC") && type2.equals("SCALAR") || type2.equals("NUMERIC") && type1.equals("SCALAR");
    }

    public boolean checkConstraint() {
        boolean erg;
        block22: {
            erg = true;
            if (this.constrType.equals("IN")) {
                if (this.object1 instanceof MultiColumnFeature) {
                    erg = erg && this.checkFeatInConcepts((FeatureAttribute)((MultiColumnFeature)this.object1));
                } else if (this.object1 instanceof BaseAttribute) {
                    erg = erg && this.checkFeatInConcepts((FeatureAttribute)((BaseAttribute)this.object1));
                } else if (this.object1 instanceof Concept) {
                    Concept c1 = (Concept)this.object1;
                    boolean erg3 = true;
                    Iterator baIt = c1.getAllBaseAttributes().iterator();
                    while (baIt.hasNext() && erg3) {
                        BaseAttribute ba = (BaseAttribute)baIt.next();
                        erg3 = erg3 && this.checkFeatInConcepts((FeatureAttribute)ba);
                    }
                    erg = erg && erg3;
                }
            } else if (this.constrType.equals("GE") || this.constrType.equals("GT")) {
                erg = this.checkFloat();
            } else if (this.constrType.equals("ONE_OF")) {
                String str1 = ((Value)this.object1).getValue().toLowerCase();
                String str2 = ((String)this.objects2.get(0)).toLowerCase();
                erg = str2.indexOf(str1) >= 0;
            } else if (this.constrType.equals("SAME_FEAT")) {
                Concept c = (Concept)this.object1;
                Concept c2 = (Concept)this.objects2.get(0);
                Collection cFeatures = c.getAllBaseAttributes();
                cFeatures.addAll(c.getAllMultiColumnFeatures());
                Collection c2Features = c2.getAllBaseAttributes();
                c2Features.addAll(c2.getAllMultiColumnFeatures());
                Vector<FeatureAttribute> restFas = new Vector<FeatureAttribute>();
                FeatureAttribute fa = null;
                BaseAttribute fa2 = null;
                Iterator it = cFeatures.iterator();
                while (it.hasNext()) {
                    fa = (FeatureAttribute)it.next();
                    String faName = fa.getName();
                    fa2 = c2.getBaseAttribute(faName);
                    if (fa2 == null) {
                        fa2 = c2.getMultiColumnFeature(faName);
                    }
                    if (fa2 != null) {
                        c2Features.remove(fa2);
                        continue;
                    }
                    restFas.add(fa);
                }
                it = restFas.iterator();
                while (it.hasNext() && erg) {
                    erg = erg && this.checkCreationSteps((FeatureAttribute)it.next(), c2);
                }
                it = c2Features.iterator();
                while (it.hasNext() && erg) {
                    erg = erg && this.checkCreationSteps((FeatureAttribute)it.next(), c);
                }
            } else if (this.constrType.equals("SAME_TYPE")) {
                String type2 = ((BaseAttribute)this.objects2.get(0)).getDatatype();
                erg = this.testDataType(type2);
            } else if (this.constrType.equals("TYPE")) {
                erg = this.testDataType((String)this.objects2.get(0));
            }
            if (erg) break block22;
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Constraint > ").concat(String.valueOf(this.constr.getConstraintType()))).concat(String.valueOf(" "))).concat(String.valueOf(this.constr.getObject1()))).concat(String.valueOf(" "))).concat(String.valueOf(this.constr.getObject2()))).concat(String.valueOf(" < doesn't hold for loop number "))).concat(String.valueOf(this.loopNr)));
            System.out.println(String.valueOf("--- Constraint is violated by object ").concat(String.valueOf(this.object1)));
        }
        return erg;
    }

    public Vector getEveryStepPredecessors(Step m4Step) {
        int index = 0;
        Vector<Step> preds = new Vector<Step>();
        preds.addElement(m4Step);
        while (index < preds.size()) {
            Step st = (Step)preds.get(index++);
            Iterator it = st.getAllPredecessors().iterator();
            while (it.hasNext()) {
                Step newSt = (Step)it.next();
                if (preds.contains(newSt)) continue;
                preds.addElement(newSt);
            }
        }
        return preds;
    }
}

