/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators;

import cocon.CoConnection;
import cocon.CoConnectionChangeEvent;
import cocon.CoModel;
import cocon.CoView;
import cocon.CoViewConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import miningmart.hci.gui.main.Application;
import miningmart.hci.operators.MMStep;
import miningmart.hci.operators.util.LoopPanel;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.M4Object;
import miningmart.m4.NameExistsException;
import miningmart.m4.Relationship;
import miningmart.m4.StorageException;
import miningmart.m4.Value;

public abstract class MMStepView
extends CoView
implements ActionListener {
    public final int REAL = 0;
    public final int INT = 1;
    private String windowTitle = "";
    public JLabel label;
    public GridBagConstraints constraints;
    public Insets insets;
    public JPanel panel = new JPanel(new GridBagLayout());
    public JScrollPane scrollPane;
    public Dimension scrollPaneSize = new Dimension(50, 100);
    public JButton saveButton = new JButton("Save");
    public JButton closeButton = new JButton("Close");
    public JButton cancelButton = new JButton("Cancel");
    public JButton testValidityButton = new JButton("Valid?");
    public LoopPanel loopPanel = new LoopPanel();

    public void initControls(boolean loopable) {
        this.getViewPanel().removeAll();
        this.getViewPanel().setOpaque(true);
        this.getViewPanel().setLayout(new BorderLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 10, 10));
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.testValidityButton.addActionListener(this);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.closeButton);
        buttonPanel.add(this.testValidityButton);
        this.getViewPanel().add((Component)this.panel, "Center");
        this.getViewPanel().add((Component)buttonPanel, "South");
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.saveButton.setEnabled(enable);
        this.cancelButton.setEnabled(enable);
        this.testValidityButton.setEnabled(enable);
        if (loopable) {
            this.getViewPanel().add((Component)this.loopPanel, "North");
        }
    }

    public String getWindowTitle() {
        CoModel model = this.getModel();
        if (model != null) {
            this.windowTitle = model.getName();
            if (!this.windowTitle.equals("")) {
                this.windowTitle = String.valueOf(this.windowTitle).concat(String.valueOf(" - "));
            }
            this.windowTitle = String.valueOf(this.windowTitle).concat(String.valueOf(((MMStep)model).operatorName));
        }
        Application.mainHB.enableHelpKey((Component)this.getViewPanel(), String.valueOf("operator.").concat(String.valueOf(((MMStep)this.getModel()).operatorName)), null);
        return this.windowTitle;
    }

    public String getWindowMenuName() {
        return this.getWindowTitle();
    }

    public boolean parameterChanged(String newVal, M4Object paramObject) {
        boolean retVal = !newVal.equals("") && !newVal.equals(" ");
        String paramName = "";
        if (paramObject == null) {
            return retVal;
        }
        if (paramObject instanceof Value) {
            paramName = ((Value)paramObject).getValue();
        } else if (paramObject instanceof BaseAttribute) {
            paramName = ((BaseAttribute)paramObject).getName();
        } else if (paramObject instanceof Concept) {
            paramName = ((Concept)paramObject).getName();
        } else if (paramObject instanceof Relationship) {
            paramName = ((Relationship)paramObject).getName();
        } else {
            System.out.println("*** no matching objetctype! ***");
        }
        retVal = retVal && !paramName.equals(newVal);
        return retVal;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        MMStep model = (MMStep)this.getModel();
        String propertyName = evt.getPropertyName();
        if (model != null && (propertyName.equals("name") || propertyName.equals("icons") || propertyName.equals("state"))) {
            if (evt.getSource() == model) {
                this.updateView();
            }
            if (propertyName.equals("name")) {
                try {
                    model.m4Step.setName(evt.getNewValue().toString());
                    model.m4Step.store();
                }
                catch (NameExistsException nee) {
                    JOptionPane.showMessageDialog(Application.frame, "Please choose another step name", "Name already exists!", 0);
                }
                catch (StorageException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean testValueGT(String name, String value, int type, double min) {
        if (value.equals("")) {
            return true;
        }
        switch (type) {
            case 1: {
                try {
                    float v = Integer.parseInt(value);
                    if ((double)v <= min) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(String.valueOf(name).concat(String.valueOf(" has to be an interger > "))).concat(String.valueOf(min)), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
            case 0: {
                try {
                    float v = Float.parseFloat(value);
                    if ((double)v <= min) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(String.valueOf(name).concat(String.valueOf(" has to be a real > "))).concat(String.valueOf(min)), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
        }
        return false;
    }

    public boolean testValueGE(String name, String value, int type, double min) {
        if (value.equals("")) {
            return true;
        }
        switch (type) {
            case 1: {
                try {
                    float v = Integer.parseInt(value);
                    if ((double)v < min) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(String.valueOf(name).concat(String.valueOf(" has to be an interger >= "))).concat(String.valueOf(min)), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
            case 0: {
                try {
                    float v = Float.parseFloat(value);
                    if ((double)v <= min) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(String.valueOf(name).concat(String.valueOf(" has to be a real >= "))).concat(String.valueOf(min)), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
        }
        return false;
    }

    public boolean testValueLE(String name, String value, int type, double max) {
        if (value.equals("")) {
            return true;
        }
        switch (type) {
            case 1: {
                try {
                    float v = Integer.parseInt(value);
                    if ((double)v > max) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(String.valueOf(name).concat(String.valueOf(" has to be an interger <= "))).concat(String.valueOf(max)), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
            case 0: {
                try {
                    float v = Float.parseFloat(value);
                    if ((double)v > max) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(String.valueOf(name).concat(String.valueOf(" has to be a real <= "))).concat(String.valueOf(max)), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
        }
        return false;
    }

    public boolean testValue(String name, String value, int type) {
        if (value.equals("")) {
            return true;
        }
        switch (type) {
            case 1: {
                try {
                    Integer.parseInt(value);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(name).concat(String.valueOf(" has to be an interger")), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
            case 0: {
                try {
                    Float.parseFloat(value);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(name).concat(String.valueOf(" has to be a real")), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
        }
        return false;
    }

    public boolean testValueIN(String name, String value, int type, double min, double max) {
        switch (type) {
            case 1: {
                try {
                    float v = Integer.parseInt(value);
                    if ((double)v < min || (double)v > max) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(name).concat(String.valueOf(" has to be an interger in ["))).concat(String.valueOf(min))).concat(String.valueOf(".."))).concat(String.valueOf(max))).concat(String.valueOf("]")), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
            case 0: {
                try {
                    float v = Float.parseFloat(value);
                    if ((double)v < min || (double)v > max) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Application.frame, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(name).concat(String.valueOf(" has to be a real in ["))).concat(String.valueOf(min))).concat(String.valueOf(".."))).concat(String.valueOf(max))).concat(String.valueOf("]")), "Wrong input", 0);
                    boolean bl = false;
                    return bl;
                }
                return true;
            }
        }
        return false;
    }

    public int getShownLoopNr() {
        return this.loopPanel.getShownLoop();
    }

    public void updateView() {
        super.updateView();
        CoModel model = this.getModel();
        if (model != null) {
            MMStep step = (MMStep)model;
            switch (step.getValidity()) {
                case 0: {
                    this.testValidityButton.setBackground(Color.YELLOW);
                    break;
                }
                case -1: {
                    this.testValidityButton.setBackground(Color.RED);
                    break;
                }
                case 1: {
                    this.testValidityButton.setBackground(Color.GREEN);
                }
            }
        }
    }

    public void addedInConnection(CoConnectionChangeEvent cce) {
        super.addedInConnection(cce);
    }

    public void addedOutConnection(CoConnectionChangeEvent cce) {
        super.addedOutConnection(cce);
    }

    public void addedConnection(CoConnectionChangeEvent cce) {
        super.addedConnection(cce);
        CoConnection connection = cce.getConnection();
        if (connection instanceof CoViewConnection && cce.getSource() == this) {
            this.updateView();
        }
    }

    public void removedInConnection(CoConnectionChangeEvent cce) {
        super.removedInConnection(cce);
    }

    public void removedOutConnection(CoConnectionChangeEvent cce) {
        super.removedOutConnection(cce);
    }

    public void removedConnection(CoConnectionChangeEvent cce) {
        super.removedConnection(cce);
        CoConnection connection = cce.getConnection();
        if (!(connection instanceof CoViewConnection) || cce.getSource() == this) {
            // empty if block
        }
    }

    public void actionPerformed(ActionEvent e) {
        CoModel model;
        if (e.getSource() == this.testValidityButton && (model = this.getModel()) != null) {
            ((MMStep)model).testValidity();
        }
    }
}

