/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.gui.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Chain;
import miningmart.m4.Concept;
import miningmart.m4.FeatureAttribute;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.MultipleResultException;
import miningmart.m4.Relationship;
import miningmart.m4.Value;

public class MmCellRenderer
extends JLabel
implements ListCellRenderer {
    Color colorSelected = Color.lightGray;
    Color colorUnselected = Color.white;
    Color colorFocus = Color.cyan;
    private boolean showContext = false;

    public MmCellRenderer() {
        this.setForeground(Color.black);
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = " ";
        this.setForeground(Color.black);
        if (value instanceof Case) {
            Case c = (Case)value;
            s = c.getName();
        } else if (value instanceof Chain) {
            s = ((Chain)value).getName();
        } else if (value instanceof Concept) {
            s = ((Concept)value).getName();
        } else if (value instanceof BaseAttribute) {
            BaseAttribute ba = (BaseAttribute)value;
            if (this.isShowingContext()) {
                try {
                    s = String.valueOf(String.valueOf(String.valueOf(ba.getName()).concat(String.valueOf(" ("))).concat(String.valueOf(ba.getConcept().getName()))).concat(String.valueOf(")"));
                }
                catch (MultipleResultException mre) {
                    mre.printStackTrace();
                }
            } else {
                s = ba.getName();
            }
        } else if (value instanceof MultiColumnFeature) {
            s = ((FeatureAttribute)value).getName();
        } else if (value instanceof Relationship) {
            s = ((Relationship)value).getName();
        } else if (value instanceof Value) {
            s = ((Value)value).getValue();
        } else if (value != null) {
            s = value.toString();
        }
        this.setText(s);
        if (cellHasFocus) {
            this.setBackground(this.colorFocus);
        } else if (isSelected) {
            this.setBackground(this.colorSelected);
        } else {
            this.setBackground(this.colorUnselected);
        }
        return this;
    }

    public boolean isShowingContext() {
        return this.showContext;
    }

    public void setListShowContext(boolean showContext) {
        this.showContext = showContext;
    }
}

