/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.gui.main;

import cocon.CiConnectable;
import cocon.CoConnection;
import cocon.CoConnectionChangeEvent;
import cocon.CoFolder;
import cocon.CoGraphView;
import cocon.CoMMFolder;
import cocon.CoModel;
import cocon.CoModelConnection;
import cocon.CoObject;
import cocon.CoObjectConnectionView;
import cocon.CoObjectPropertiesView;
import cocon.CoObjectTreeView;
import cocon.CoView;
import cocon.CoViewConnection;
import cocon.CoWindow;
import cocon.util.SpinTree;
import com.syllogic.miningmart.m4.Case;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import miningmart.compilerInterface.M4CompilerInterfaceError;
import miningmart.hci.gui.chInterface.ComponentFigureI;
import miningmart.hci.gui.chInterface.SpinPanelI;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.CreateCaseDialog;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.CompilerOutputThread;
import miningmart.hci.operators.MMStep;
import miningmart.hci.operators.NonSegmentationStep;
import miningmart.hci.operators.featureConstruction.MrfcOperator;
import miningmart.hci.operators.featureConstruction.PredWDecRulesOperator;
import miningmart.hci.operators.featureConstruction.PredWDecTreeOperator;
import miningmart.hci.operators.genericOperator.GenericOperator;
import miningmart.hci.operators.joinByKey.JoinByKeyOperator;
import miningmart.hci.operators.joinByKey.UnionByKeyOperator;
import miningmart.hci.operators.missingValue.AssAvValueOperator;
import miningmart.hci.operators.missingValue.AssDefValueOperator;
import miningmart.hci.operators.missingValue.AssMedValueOperator;
import miningmart.hci.operators.missingValue.AssModValueOperator;
import miningmart.hci.operators.missingValue.AssPredValOperator;
import miningmart.hci.operators.missingValue.DrwmvOperator;
import miningmart.hci.operators.missingValue.MvwDecRulesOperator;
import miningmart.hci.operators.missingValue.MvwDecTreeOperator;
import miningmart.hci.operators.missingValue.MvwRegSVMOperator;
import miningmart.hci.operators.rowSelection.RsbqOperator;
import miningmart.hci.operators.rowSelection.RsbrOperator;
import miningmart.hci.operators.scaling.LinScalOperator;
import miningmart.hci.operators.scaling.LogScalOperator;
import miningmart.hci.operators.segmentation.SegmByPartOperator;
import miningmart.hci.operators.segmentation.SegmKMeanOperator;
import miningmart.hci.operators.segmentation.SegmStratOperator;
import miningmart.hci.operators.specifiedStatistics.SpecStatOperator;
import miningmart.hci.operators.timeSeries.ExpMovFctOperator;
import miningmart.hci.operators.timeSeries.Sig2SymProcOperator;
import miningmart.hci.operators.timeSeries.SimpleMovFctOperator;
import miningmart.hci.operators.timeSeries.WeightMovFctOperator;
import miningmart.hci.operators.unSegment.UnSegmentOperator;
import miningmart.hci.util.CaseExporter;
import miningmart.hci.util.CaseImporter;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Chain;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.M4Interface;
import miningmart.m4.M4Object;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.NameExistsException;
import miningmart.m4.Operator;
import miningmart.m4.Parameter;
import miningmart.m4.Step;
import miningmart.m4.StorageException;
import socrat.Workspace;

public class Dispatcher
implements WindowListener,
PropertyChangeListener,
TreeSelectionListener {
    private boolean testGenericOp = false;

    public void updateControls() {
        boolean enabled = false;
        if (Application.m4Case != null) {
            String title = String.valueOf(String.valueOf(Application.mmTitle).concat(String.valueOf(" - "))).concat(String.valueOf(Application.m4Case.getName()));
            if (Application.mmWorkspace != null && Application.mmWorkspace.isReadOnly()) {
                title = String.valueOf(title).concat(String.valueOf(" (read only)"));
            }
            enabled = true;
            Application.frame.setTitle(title);
        }
        Application.actionFileClose.setEnabled(enabled);
        if (Application.mmWorkspace == null) {
            Application.actionFileClose.setEnabled(false);
        }
        Application.actionCopyConcept.update();
        Application.updateMenuEdit();
        Application.updateMenuInsert();
        Application.updateMenuCompile();
        Application.updateMenuFile();
    }

    public int caseNew() {
        int retVal = 2;
        if (Application.mmWorkspace != null && (retVal = this.fileClose()) != 0 && retVal != 1) {
            return 2;
        }
        CreateCaseDialog createCaseDialog = new CreateCaseDialog(Application.frame, "Create Case", true);
        miningmart.m4.Case m4Case = createCaseDialog.showCreateDialog();
        if (m4Case != null) {
            try {
                m4Case.createChain(m4Case.getName()).store();
            }
            catch (NameExistsException nee) {
                nee.printStackTrace();
            }
            catch (CreateException ce) {
                ce.printStackTrace();
            }
            catch (StorageException se) {
                se.printStackTrace();
            }
            Application.m4Case = m4Case;
            M4Interface.setCurrentCase((miningmart.m4.Case)m4Case);
        }
        return this.doOpenCase(false);
    }

    public int caseOpen(boolean readOnly) {
        int retVal;
        if (Application.mmWorkspace != null && (retVal = this.fileClose()) != 0 && retVal != 1) {
            return 2;
        }
        Vector m4Cases = null;
        DataChooser dataChooser = new DataChooser(Application.frame, "Select a Case", 4, true);
        dataChooser.setSingleSelection(true);
        m4Cases = dataChooser.showChooseDialog();
        if (m4Cases == null) {
            return 2;
        }
        if (m4Cases.size() == 0) {
            retVal = 2;
        } else {
            retVal = 0;
            try {
                Application.m4Case = readOnly ? Application.m4Interface.findCaseForReadOnlyAccess(m4Cases.get(0).toString(), true) : Application.m4Interface.findCaseForUpdate(m4Cases.get(0).toString(), true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Application.frame, "Choose another Case", "Case locked!", 0);
                int n = 2;
                return n;
            }
        }
        return this.doOpenCase(readOnly);
    }

    private int doOpenCase(boolean readOnly) {
        int retVal = -1;
        if (Application.m4Case == null) {
            return 2;
        }
        Application.mmWorkspace = new Workspace(Application.m4Case.getName());
        Application.mmWorkspace.setReadOnly(readOnly);
        retVal = this.openChainEditor();
        this.openConceptEditor();
        return retVal;
    }

    public int exportCase() {
        CaseExporter ce = Application.getCaseExporter();
        return ce.exportCase(Application.m4Case);
    }

    public int importCase() {
        CaseImporter ci = Application.getCaseImporter();
        return ci.importCase();
    }

    public int openChainEditor() {
        CoMMFolder chainFolder;
        Chain chain;
        int maxX = 0;
        int maxY = 0;
        int retVal = 2;
        Iterator chainIt = Application.m4Case.getAllChains().iterator();
        Hashtable<String, CoMMFolder> allChains = new Hashtable<String, CoMMFolder>();
        Vector<Step> m4Steps = new Vector<Step>();
        Vector<NonSegmentationStep> mmSteps = new Vector<NonSegmentationStep>();
        while (chainIt.hasNext()) {
            chain = (Chain)chainIt.next();
            chainFolder = new CoMMFolder(chain);
            allChains.put(chain.getName(), chainFolder);
        }
        CoMMFolder chainF = null;
        CoMMFolder parentFolder = null;
        Iterator<Object> it = allChains.values().iterator();
        while (it.hasNext()) {
            chainF = (CoMMFolder)((Object)it.next());
            String chainName = chainF.getChainName();
            if (chainName.indexOf(".") > 0) {
                String parentChainName = chainName.substring(0, chainName.lastIndexOf("."));
                parentFolder = (CoMMFolder)((Object)allChains.get(parentChainName));
                if (parentFolder != null) {
                    parentFolder.add((MutableTreeNode)((Object)chainF));
                    parentFolder.addPropertyChangeListener((PropertyChangeListener)((Object)chainF));
                } else {
                    Application.mmWorkspace.add((MutableTreeNode)((Object)chainF));
                }
            } else {
                Application.mmWorkspace.add((MutableTreeNode)((Object)chainF));
            }
            chainF.setChainPosition();
            Point p = chainF.getChainPosition();
            if (p == null) continue;
            if (maxX < p.x) {
                maxX = p.x;
            }
            if (maxY >= p.y) continue;
            maxY = p.y;
        }
        chainIt = Application.m4Case.getAllChains().iterator();
        while (chainIt.hasNext()) {
            Application.mmWorkspace.getStepNr();
            chain = (Chain)chainIt.next();
            chainFolder = (CoMMFolder)((Object)allChains.get(chain.getName()));
            if (chainFolder == null) continue;
            Collection stepCollection = chain.getAllSteps();
            it = stepCollection.iterator();
            MMStep mStep = null;
            while (it.hasNext()) {
                Application.mmWorkspace.getStepNr();
                Step step = (Step)it.next();
                m4Steps.addElement(step);
                Operator op = step.getOperator();
                mStep = this.testGenericOp ? new GenericOperator(step) : (op.getName().equalsIgnoreCase("MultiRelationalFeatureConstruction") ? new MrfcOperator(step) : (op.getName().equalsIgnoreCase("PredictionWithDecisionTree") ? new PredWDecTreeOperator(step) : (op.getName().equalsIgnoreCase("PredictionWithDecisionRules") ? new PredWDecRulesOperator(step) : (op.getName().equalsIgnoreCase("JoinByKey") ? new JoinByKeyOperator(step) : (op.getName().equalsIgnoreCase("UnionByKey") ? new UnionByKeyOperator(step) : (op.getName().equalsIgnoreCase("SpecifiedStatistics") ? new SpecStatOperator(step) : (op.getName().equalsIgnoreCase("RowSelectionByQuery") ? new RsbqOperator(step) : (op.getName().equalsIgnoreCase("RowSelectionByRandomSampling") ? new RsbrOperator(step) : (op.getName().equalsIgnoreCase("DeleteRecordsWithMissingValues") ? new DrwmvOperator(step) : (op.getName().equalsIgnoreCase("AssignAverageValue") ? new AssAvValueOperator(step) : (op.getName().equalsIgnoreCase("AssignModalValue") ? new AssModValueOperator(step) : (op.getName().equalsIgnoreCase("AssignMedianValue") ? new AssMedValueOperator(step) : (op.getName().equalsIgnoreCase("AssignPredictedValueCategorial") ? new AssPredValOperator(step) : (op.getName().equalsIgnoreCase("AssignDefault") ? new AssDefValueOperator(step) : (op.getName().equalsIgnoreCase("MissingValueWithDecisionTree") ? new MvwDecTreeOperator(step) : (op.getName().equalsIgnoreCase("MissingValueWithDecisionRules") ? new MvwDecRulesOperator(step) : (op.getName().equalsIgnoreCase("MissingValuesWithRegressionSVM") ? new MvwRegSVMOperator(step) : (op.getName().equalsIgnoreCase("SegmentationStratified") ? new SegmStratOperator(step) : (op.getName().equalsIgnoreCase("SegmentationByPartitioning") ? new SegmByPartOperator(step) : (op.getName().equalsIgnoreCase("SegmentationWithKMean") ? new SegmKMeanOperator(step) : (op.getName().equalsIgnoreCase("UnSegment") ? new UnSegmentOperator(step) : (op.getName().equalsIgnoreCase("SimpleMovingFunction") ? new SimpleMovFctOperator(step) : (op.getName().equalsIgnoreCase("WeightedMovingFunction") ? new WeightMovFctOperator(step) : (op.getName().equalsIgnoreCase("ExponentialMovingFunction") ? new ExpMovFctOperator(step) : (op.getName().equalsIgnoreCase("SignalToSymbolProcessing") ? new Sig2SymProcOperator(step) : (op.getName().equalsIgnoreCase("LinearScaling") ? new LinScalOperator(step) : (op.getName().equalsIgnoreCase("LogScaling") ? new LogScalOperator(step) : new GenericOperator(step))))))))))))))))))))))))))));
                chainFolder.add((MutableTreeNode)((Object)mStep));
                mStep.setStepPosition();
                Point p = mStep.getStepPosition();
                if (p != null) {
                    if (maxX < p.x) {
                        maxX = p.x;
                    }
                    if (maxY < p.y) {
                        maxY = p.y;
                    }
                }
                mmSteps.addElement((NonSegmentationStep)mStep);
            }
        }
        it = m4Steps.iterator();
        while (it.hasNext()) {
            Step st = (Step)it.next();
            Collection successors = st.getAllSuccessors();
            Iterator succIt = successors.iterator();
            int indexFrom = m4Steps.indexOf(st);
            while (succIt.hasNext()) {
                Step succ = (Step)succIt.next();
                int indexTo = m4Steps.indexOf(succ);
                MMStep from = (MMStep)((Object)mmSteps.get(indexFrom));
                if (indexTo < 0) continue;
                MMStep to = (MMStep)((Object)mmSteps.get(indexTo));
                from.addConnection((CoConnection)new CoModelConnection(), (CiConnectable)to);
                from.addFolderConnection(to);
            }
        }
        if (Application.documentView == null) {
            Application.documentView = new CoObjectTreeView();
            Application.documentView.addPropertyChangeListener((PropertyChangeListener)this);
            ((CoObjectTreeView)Application.documentView).getTreePanel().addTreeSelectionListener(this);
            Application.documentView.addConnection((CoConnection)new CoViewConnection(), (CiConnectable)Application.mmWorkspace);
            CoWindow documentWindow = new CoWindow(2, Application.documentView);
            documentWindow.addPropertyChangeListener(this);
            Application.windowList.addWindow(documentWindow);
            Application.windowList.showWindow(documentWindow);
            Application.windowList.setActiveWindow(documentWindow);
            documentWindow.setWindowSize(450, 200);
            documentWindow.setWindowCloseable(false);
            Application.graphDocumentView = Application.getNewGraphView();
            if (Application.graphDocumentView != null) {
                this.openHotdrawView();
                SpinPanelI panel = (SpinPanelI)((Object)Application.graphDocumentView.getViewPanel());
                panel.setDrawingViewSize(maxX + 50, maxY + 50);
            }
        }
        this.updateControls();
        if (Application.graphDocumentView != null) {
            Application.mainHB.enableHelpKey((Component)Application.graphDocumentView.getViewPanel(), "operator.Apriori", null);
        }
        Application.mainHB.enableHelpKey((Component)Application.documentView.getViewPanel(), "operator.AssignAverageValue", null);
        return retVal;
    }

    public int openConceptEditor() {
        CoWindow conceptEditorWindow = new CoWindow((JInternalFrame)Application.conceptEditor);
        conceptEditorWindow.setWindowSize(450, 200);
        conceptEditorWindow.setWindowCloseable(false);
        conceptEditorWindow.getWindowView().setName(Application.conceptEditor.getTitle());
        Application.windowList.addWindow(conceptEditorWindow);
        Application.windowList.showWindow(conceptEditorWindow);
        conceptEditorWindow.windowInternalFrame.setLocation(0, 210);
        conceptEditorWindow.getWindowView().addPropertyChangeListener((PropertyChangeListener)Application.dispatcher);
        Application.conceptEditor.init();
        return 0;
    }

    public void editDelete() {
        CoModel model;
        int i;
        CoObject selectedNode = Application.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        CoConnection connection = selectedNode.getInConnection(Class.forName("cocon.CoChildConnection"), 0);
        if (connection == null) {
            return;
        }
        CoConnectionChangeEvent cce = new CoConnectionChangeEvent((Object)selectedNode, connection, (Object)connection.getSource(), (Object)connection.getDestination());
        ((CoObject)connection.getSource()).canRemoveConnection(cce);
        if (cce.getError() < 0) {
            return;
        }
        ((CoObject)connection.getDestination()).canRemoveConnection(cce);
        if (cce.getError() < 0) {
            return;
        }
        int windowCount = Application.windowList.getWindowCount();
        boolean[] windowsToClose = new boolean[windowCount];
        for (i = 0; i < windowCount; ++i) {
            CoView view = Application.windowList.getWindowAt(i).getWindowView();
            if (view == null || (model = view.getModel()) == null || !selectedNode.isNodeDescendant((TreeNode)model)) continue;
            windowsToClose[i] = true;
        }
        for (i = windowCount; i > 0; --i) {
            if (!windowsToClose[i - 1]) continue;
            Application.windowList.removeWindow(Application.windowList.getWindowAt(i - 1));
        }
        selectedNode.removeAllOutConnections(Class.forName("cocon.CoModelConnection"));
        selectedNode.removeAllInConnections(Class.forName("cocon.CoModelConnection"));
        Enumeration modelEnumeration = selectedNode.depthFirstEnumeration();
        while (modelEnumeration.hasMoreElements()) {
            model = (CoModel)modelEnumeration.nextElement();
            model.removeAllOutConnections(Class.forName("cocon.CoModelConnection"));
            model.removeAllInConnections(Class.forName("cocon.CoModelConnection"));
        }
        CoObject parentNode = (CoObject)selectedNode.getParent();
        int selectedNodeIndex = parentNode.getIndex((TreeNode)selectedNode);
        selectedNode.removeFromParent();
        if (selectedNode instanceof MMStep) {
            MMStep stepToDelete = (MMStep)selectedNode;
            try {
                M4Object outObject = null;
                Parameter p = null;
                Iterator it = stepToDelete.m4Step.getAllOutputParameters().iterator();
                while (it.hasNext()) {
                    p = (Parameter)it.next();
                    outObject = p.getParameterObject();
                    if (outObject instanceof Concept) {
                        this.deleteConcept((Concept)outObject);
                        continue;
                    }
                    if (outObject instanceof BaseAttribute) {
                        BaseAttribute ba = (BaseAttribute)outObject;
                        ba.delete();
                        continue;
                    }
                    if (!(outObject instanceof MultiColumnFeature)) continue;
                    MultiColumnFeature fea = (MultiColumnFeature)outObject;
                    fea.delete();
                }
                Application.m4Case.removeStep(stepToDelete.getName());
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        }
        if (selectedNode instanceof CoMMFolder) {
            String chainToDelete = ((CoMMFolder)selectedNode).getChainName();
            try {
                Application.m4Case.removeChain(chainToDelete);
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        }
        if (selectedNodeIndex < parentNode.getChildCount()) {
            Application.setSelectedNode((CoObject)parentNode.getChildAt(selectedNodeIndex));
        } else if (selectedNodeIndex > 0) {
            Application.setSelectedNode((CoObject)parentNode.getChildAt(selectedNodeIndex - 1));
        } else {
            Application.setSelectedNode(parentNode);
        }
        this.updateControls();
    }

    public int fileClose() {
        if (Application.m4Case.getChain("Clipboard") != null) {
            try {
                Application.m4Case.removeChain("ClipBoard");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Application.m4Case != null) {
            Application.m4Interface.releaseCase(Application.m4Case.getName());
        }
        if (Application.mmWorkspace == null) {
            return 0;
        }
        Application.windowList.removeAllWindows();
        Application.documentView = null;
        Application.mmWorkspace = null;
        this.killCompilation();
        Application.m4Case = null;
        Application.frame.setTitle(Application.mmTitle);
        Application.graphDocumentView = null;
        this.updateControls();
        return 0;
    }

    public void editOpen() {
        CoObjectPropertiesView selectedNodeView = null;
        CoWindow selectedNodeWindow = null;
        CoObject selectedNode = Application.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        if (!(selectedNode instanceof CoObject)) {
            System.out.println("WARNING! Dispatcher::editOpen(): cannot visualize this object.");
            return;
        }
        selectedNodeView = selectedNode instanceof CoFolder ? new CoObjectPropertiesView() : ((MMStep)selectedNode).openView();
        selectedNodeView.addPropertyChangeListener(this);
        selectedNodeView.addConnection((CoConnection)new CoViewConnection(), (CiConnectable)selectedNode);
        selectedNodeWindow = new CoWindow(2, selectedNodeView);
        Application.windowList.addWindow(selectedNodeWindow);
        Application.windowList.showWindow(selectedNodeWindow);
        Application.windowList.setActiveWindow(selectedNodeWindow);
    }

    public void editProperties() {
        CoObject selectedNode = Application.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        if (!(selectedNode instanceof CoObject)) {
            System.out.println("WARNING: Dispatcher::editProperties(): Cannot visualise this object.");
            return;
        }
        CoObjectPropertiesView propertiesView = new CoObjectPropertiesView();
        propertiesView.addPropertyChangeListener(this);
        propertiesView.addConnection((CoConnection)new CoViewConnection(), (CiConnectable)selectedNode);
        CoWindow propertiesWindow = new CoWindow(3, propertiesView);
        Application.windowList.addWindow(propertiesWindow);
        Application.windowList.showWindow(propertiesWindow);
        Application.windowList.setActiveWindow(Application.windowList.getTopWindow());
        this.updateControls();
    }

    public int fileSave() {
        return 0;
    }

    public void editConnections() {
        CoObject selectedNode = Application.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        if (!(selectedNode instanceof CoObject)) {
            System.out.println("WARNING: Dispatcher::editConnections(): Cannot visualise this object.");
            return;
        }
        CoObjectConnectionView connectionView = new CoObjectConnectionView();
        connectionView.addPropertyChangeListener(this);
        connectionView.addConnection((CoConnection)new CoViewConnection(), (CiConnectable)selectedNode);
        CoWindow connectionWindow = new CoWindow(3, connectionView);
        Application.windowList.addWindow(connectionWindow);
        Application.windowList.showWindow(connectionWindow);
        Application.windowList.setActiveWindow(Application.windowList.getTopWindow());
        this.updateControls();
    }

    public void unmergeChain(CoObject o) {
        block10: {
            if (!(o instanceof CoMMFolder) || o.getParent() == Application.mmWorkspace) break block10;
            CoMMFolder folderToUnmerge = (CoMMFolder)o;
            int retVal = JOptionPane.showConfirmDialog(Application.frame, "Replace chain with steps and subchains?", "Unmerge Chain?", 2, 3);
            if (retVal == 0) {
                int count = o.getChildCount();
                CoMMFolder parentFolder = (CoMMFolder)((Object)o.getParent());
                for (int i = 0; i < count; ++i) {
                    TreeNode child = o.getChildAt(i);
                    if (child instanceof MMStep) {
                        Chain chain = parentFolder.getChain();
                        Step m4Step = ((MMStep)((Object)child)).m4Step;
                        try {
                            m4Step.removeChain();
                            m4Step.setChain(chain);
                            m4Step.store();
                        }
                        catch (StorageException se) {
                            se.printStackTrace();
                        }
                        continue;
                    }
                    if (!(child instanceof CoMMFolder)) continue;
                    CoMMFolder childFolder = (CoMMFolder)((Object)child);
                    String newName = childFolder.getChainName().replaceFirst(folderToUnmerge.getChainName(), parentFolder.getChainName());
                    Chain chain = childFolder.getChain();
                    try {
                        chain.setName(newName);
                        chain.store();
                        continue;
                    }
                    catch (NameExistsException nee) {
                        nee.printStackTrace();
                        continue;
                    }
                    catch (StorageException se) {
                        se.printStackTrace();
                    }
                }
                try {
                    Application.m4Case.removeChain(folderToUnmerge.getChainName());
                    Application.m4Case.store();
                }
                catch (StorageException se) {
                    se.printStackTrace();
                }
                parentFolder.remove((MutableTreeNode)((Object)folderToUnmerge));
                this.redrawChainEditor();
            }
        }
    }

    public void mergeToChain(Vector steps, Point p) {
        block9: {
            String chainName = JOptionPane.showInputDialog(Application.frame, "Chain Name", "Create Chain", 2);
            Chain newChain = null;
            if (chainName == null || chainName.equals("")) break block9;
            CoMMFolder shownFolder = (CoMMFolder)Application.graphDocumentView.getShownFolder();
            String shownChainName = shownFolder.getChainName();
            String newChainName = String.valueOf(String.valueOf(shownChainName).concat(String.valueOf("."))).concat(String.valueOf(chainName));
            try {
                newChain = Application.m4Case.createChain(newChainName);
                newChain.store();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Application.frame, "Choose another name", "Name already exists", 0);
            }
            if (newChain != null) {
                Iterator it = steps.iterator();
                while (it.hasNext()) {
                    CoObject o = (CoObject)it.next();
                    if (o instanceof MMStep) {
                        Step step = ((MMStep)o).m4Step;
                        try {
                            step.removeChain();
                            step.setChain(newChain);
                            step.store();
                        }
                        catch (Exception se) {
                            se.printStackTrace();
                        }
                        continue;
                    }
                    if (!(o instanceof CoMMFolder)) continue;
                    Chain chain = ((CoMMFolder)o).getChain();
                    try {
                        chain.setName(String.valueOf(String.valueOf(newChainName).concat(String.valueOf("."))).concat(String.valueOf(o.getName())));
                        chain.store();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.redrawChainEditor();
        }
    }

    public void redrawChainEditor() {
        CoFolder f = Application.graphDocumentView.getShownFolder();
        Application.mmWorkspace.remove(0);
        this.openChainEditor();
        Application.graphDocumentView.updateView();
        Application.setSelectedNode((CoObject)f);
    }

    public void doCopyToClipBoard() {
        Application.clipBoard = new Vector();
        Application.copyFromFolderName = ((CoMMFolder)Application.graphDocumentView.getShownFolder()).getChainName();
        Application.isCut = false;
        Enumeration elems = Application.graphDocumentView.getSelectionElements();
        while (elems.hasMoreElements()) {
            CoObject figObj;
            Object o = elems.nextElement();
            if (!(o instanceof ComponentFigureI) || !((figObj = ((ComponentFigureI)o).getObject()) instanceof MMStep) && !(figObj instanceof CoMMFolder)) continue;
            Application.clipBoard.add(figObj);
        }
        Application.updateMenuEdit();
    }

    public void doCutToClipBoard() {
        Application.clipBoard = new Vector();
        Application.copyFromFolderName = ((CoMMFolder)Application.graphDocumentView.getShownFolder()).getChainName();
        Application.isCut = true;
        Enumeration elems = Application.graphDocumentView.getSelectionElements();
        while (elems.hasMoreElements()) {
            CoObject figObj;
            Object o = elems.nextElement();
            if (!(o instanceof ComponentFigureI) || !((figObj = ((ComponentFigureI)o).getObject()) instanceof CoMMFolder) && !(figObj instanceof MMStep)) continue;
            Application.clipBoard.add(figObj);
        }
        Application.updateMenuEdit();
    }

    public void doInsertFromClipBoard() {
        CoObject o = null;
        Chain shownChain = ((CoMMFolder)Application.graphDocumentView.getShownFolder()).getChain();
        String shownChainName = shownChain.getName();
        if (Application.isCut) {
            Iterator it = Application.clipBoard.iterator();
            while (it.hasNext()) {
                o = (CoObject)it.next();
                if (o instanceof MMStep) {
                    Step step = ((MMStep)o).m4Step;
                    try {
                        step.setChain(shownChain);
                        step.store();
                    }
                    catch (StorageException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(o instanceof CoMMFolder)) continue;
                Chain chain = ((CoMMFolder)o).getChain();
                String oldName = chain.getName();
                Iterator it2 = Application.m4Case.getAllChains().iterator();
                while (it2.hasNext()) {
                    Chain ch = (Chain)it2.next();
                    String name = ch.getName();
                    if (!name.startsWith(oldName)) continue;
                    String newName = name.replaceFirst(Application.copyFromFolderName, shownChainName);
                    try {
                        ch.setName(newName);
                        ch.store();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            Application.clipBoard.removeAllElements();
        } else {
            Iterator it = Application.clipBoard.iterator();
            while (it.hasNext()) {
                boolean x = false;
                boolean y = false;
                o = (CoObject)it.next();
                Vector stepCollection = new Vector();
                if (o instanceof MMStep) {
                    Step step = ((MMStep)o).m4Step;
                    int i = 1;
                    String name = step.getName();
                    String newName = String.valueOf(name).concat(String.valueOf("_0"));
                    while (Application.m4Case.getStep(newName) != null) {
                        newName = String.valueOf(String.valueOf(name).concat(String.valueOf("_"))).concat(String.valueOf(i++));
                    }
                    try {
                        Step newStep = Application.m4Case.createStep(newName);
                        newStep.setStepNr(Application.getStepNr());
                        newStep.setOperator(step.getOperator());
                        newStep.setStepLoopNr(step.getStepLoopNr());
                        newStep.setMultiStepCondition(step.getMultiStepCondition());
                        newStep.setChain(shownChain);
                        newStep.setPoint(shownChain, step.getPoint(step.getChain()));
                        newStep.store();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (o instanceof CoMMFolder) {
                    Chain chain = ((CoMMFolder)o).getChain();
                    String oldName = chain.getName();
                    Iterator it2 = Application.m4Case.getAllChains().iterator();
                    while (it2.hasNext()) {
                        Chain ch = (Chain)it2.next();
                        if (!ch.getName().startsWith(oldName)) continue;
                        stepCollection.addAll(ch.getAllSteps());
                        String name = ch.getName();
                        String newName = name.replaceFirst(Application.copyFromFolderName, shownChainName);
                        int i = 1;
                        while (Application.m4Case.getChain(newName) != null) {
                            newName = String.valueOf(String.valueOf(name).concat(String.valueOf("_"))).concat(String.valueOf(i));
                        }
                        try {
                            Chain newChain = Application.m4Case.createChain(newName);
                            newChain.setDescription(ch.getDescription());
                            newChain.store();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Iterator it3 = stepCollection.iterator();
                while (it3.hasNext()) {
                    Step step = null;
                    Step newStep = null;
                    step = (Step)it3.next();
                    String chainName = step.getChain().getName();
                    String newName = chainName.replaceFirst(Application.copyFromFolderName, shownChainName);
                    Chain chain = Application.m4Case.getChain(newName);
                    if (chain == null) continue;
                    String name = step.getName();
                    newName = String.valueOf(name).concat(String.valueOf("_0"));
                    int i = 1;
                    while (Application.m4Case.getStep(newName) != null) {
                        newName = String.valueOf(String.valueOf(name).concat(String.valueOf("_"))).concat(String.valueOf(i++));
                    }
                    try {
                        newStep = Application.m4Case.createStep(newName);
                        newStep.setStepNr(Application.getStepNr());
                        newStep.setOperator(step.getOperator());
                        newStep.setStepLoopNr(step.getStepLoopNr());
                        newStep.setMultiStepCondition(step.getMultiStepCondition());
                        newStep.setChain(chain);
                        newStep.setPoint(shownChain, step.getPoint(step.getChain()));
                        newStep.store();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        Application.isCut = false;
        this.redrawChainEditor();
        Application.updateMenuEdit();
    }

    public int fileOpenFile() {
        return -1;
    }

    public int fileOpenDatabase() {
        return -1;
    }

    public int fileSaveAsFile() {
        return -1;
    }

    public int fileSaveAsDatabase() {
        return -1;
    }

    public void openHotdrawView() {
        CoGraphView graphView = Application.graphDocumentView;
        graphView.openPanel();
        graphView.addPropertyChangeListener(Application.dispatcher);
        graphView.addConnection((CoConnection)new CoViewConnection(), (CiConnectable)Application.mmWorkspace);
        CoWindow docWindow = new CoWindow(2, graphView);
        graphView.addPropertyChangeListener((PropertyChangeListener)((Object)docWindow));
        Application.windowList.addWindow(docWindow);
        docWindow.setWindowSize(400, 400);
        docWindow.setWindowCloseable(false);
        docWindow.windowInternalFrame.setLocation(Application.frame.getWidth() - 410, 0);
        Application.windowList.showWindow(docWindow);
        graphView.addTreeSelListener(this);
        ((CoObjectTreeView)Application.documentView).getTreeModel().addTreeModelListener(graphView);
    }

    public void checkValidityStep() {
        MMStep mmStep = (MMStep)Application.getSelectedNode();
        mmStep.setParameter();
        if (!mmStep.testValidity()) {
            System.out.println(String.valueOf(String.valueOf("Step > ").concat(String.valueOf((Object)mmStep))).concat(String.valueOf(" < not valid!")));
        }
    }

    public void checkValidityAllSteps() {
        Vector allNodes = Application.mmWorkspace.getReachableNodes();
        Iterator it = allNodes.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof MMStep)) continue;
            MMStep step = (MMStep)((Object)o);
            step.setParameter();
            if (step.testValidity()) continue;
            System.out.println(String.valueOf(String.valueOf("Step > ").concat(String.valueOf(o))).concat(String.valueOf(" < not valid!")));
        }
        Application.frame.repaint();
    }

    public void compileAll() {
        System.out.println("Start compiling ...");
        Application.cot = new CompilerOutputThread(((Case)Application.m4Case).getId());
        Application.compilerThread = new Thread(){

            public void run() {
                try {
                    if (Application.showStatusMsg) {
                        Application.getCompilerAccess().compileAll((long)((Case)Application.m4Case).getId(), Application.compileLazy, Application.verbosity);
                    } else {
                        Application.getCompilerAccess().compileAll((long)((Case)Application.m4Case).getId(), Application.compileLazy);
                    }
                }
                catch (M4CompilerInterfaceError ce) {
                    System.out.println("Error while compiling all steps or compilation killed by client");
                    ce.printStackTrace();
                    Application.refreshCompilerAccess();
                }
                catch (RemoteException re) {
                    JOptionPane.showMessageDialog(Application.frame, "Error while accessing Compiler.\n Please check if the compiler \n is running on the correct server.", "Remote Exception!", 0);
                    Application.refreshCompilerAccess();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                System.out.println("... done");
                Application.cot.setDone(true);
            }
        };
        Application.compilerThread.start();
        Application.updateMenuCompile();
        this.openCompilerLogWindow();
    }

    public void compileStep() {
        MMStep mmStep = (MMStep)Application.getSelectedNode();
        final long stepID = mmStep.getStepId();
        boolean isReady = false;
        mmStep.setParameter();
        boolean compile = true;
        if (!mmStep.testValidity()) {
            boolean bl = compile = JOptionPane.showConfirmDialog(Application.frame, "Step isn't valid. \nThis can cause a compile error.", "Continue?", 2, 0) == 0;
            if (!compile) {
                return;
            }
        }
        try {
            isReady = Application.getCompilerAccess().isReadyForCompilation(stepID);
        }
        catch (M4CompilerInterfaceError e) {
            e.printStackTrace();
            Application.refreshCompilerAccess();
        }
        catch (RemoteException re) {
            JOptionPane.showMessageDialog(Application.frame, "Error while accessing Compiler.\n Please check if the compiler \n is running on the correct server.", "Remote Exception!", 0);
            Application.refreshCompilerAccess();
            return;
        }
        if (!isReady) {
            JOptionPane.showMessageDialog(Application.frame, "Some predecessor isn't compiled.\nPlease compiler all predecessors first", "Couldn't compile step", 0);
            return;
        }
        if (!compile) {
            return;
        }
        System.out.println("Start compiling ...");
        Application.cot = new CompilerOutputThread(((Case)Application.m4Case).getId());
        Application.compilerThread = new Thread(null){
            final /* synthetic */ Dispatcher this$0;

            public void run() {
                try {
                    if (Application.showStatusMsg) {
                        Application.getCompilerAccess().compileStep(stepID, Application.compileLazy, Application.verbosity);
                    } else {
                        Application.getCompilerAccess().compileStep(stepID, Application.compileLazy);
                    }
                }
                catch (M4CompilerInterfaceError ce) {
                    System.out.println("Error while compiling the step or compilation killed by client");
                    ce.printStackTrace();
                }
                catch (RemoteException re) {
                    JOptionPane.showMessageDialog(Application.frame, "Error while accessing Compiler.\n Please check if the compiler \n is running on the correct server.", "Remote Exception!", 0);
                    Application.refreshCompilerAccess();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                System.out.println("... done");
                Application.cot.setDone(true);
            }
            {
                this.this$0 = this$0;
            }
        };
        Application.compilerThread.start();
        Application.updateMenuCompile();
        this.openCompilerLogWindow();
    }

    public void compileStepFrom() {
        final long stepID = ((MMStep)Application.getSelectedNode()).getStepId();
        boolean isReady = false;
        try {
            isReady = Application.getCompilerAccess().isReadyForCompilation(stepID);
        }
        catch (M4CompilerInterfaceError e) {
            e.printStackTrace();
        }
        catch (RemoteException re) {
            JOptionPane.showMessageDialog(Application.frame, "Error while accessing Compiler.\n Please check if the compiler \n is running on the correct server.", "Remote Exception!", 0);
            Application.refreshCompilerAccess();
            return;
        }
        if (isReady) {
            System.out.println("Start compiling ...");
            Application.cot = new CompilerOutputThread(((Case)Application.m4Case).getId());
            Application.compilerThread = new Thread(null){
                final /* synthetic */ Dispatcher this$0;

                public void run() {
                    try {
                        if (Application.showStatusMsg) {
                            Application.getCompilerAccess().compileStepFrom(stepID, Application.compileLazy, Application.verbosity);
                        } else {
                            Application.getCompilerAccess().compileStepFrom(stepID, Application.compileLazy);
                        }
                    }
                    catch (M4CompilerInterfaceError ce) {
                        System.out.println("Error while compiling or compilation killed by client");
                        ce.printStackTrace();
                    }
                    catch (RemoteException re) {
                        JOptionPane.showMessageDialog(Application.frame, "Error while accessing Compiler.\n Please check if the compiler \n is running on the correct server.", "Remote Exception!", 0);
                        Application.refreshCompilerAccess();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    System.out.println("... done");
                    Application.cot.setDone(true);
                }
                {
                    this.this$0 = this$0;
                }
            };
            Application.compilerThread.start();
            this.openCompilerLogWindow();
            Application.updateMenuCompile();
        } else {
            JOptionPane.showMessageDialog(Application.frame, "Some predecessor isn't compiled.\nPlease compiler all predecessors first", "Couldn't compile step", 0);
        }
    }

    public void openCompilerLogWindow() {
        if (Application.showStatusMsg) {
            Application.compilerWindow.setVisible(true);
            if (!Application.cot.isAlive()) {
                Application.cot.start();
            }
        }
    }

    public void killCompilation() {
        try {
            Application.getCompilerAccess().killCompilerThread((long)((Case)Application.m4Case).getId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void openHelp() {
    }

    private void deleteConcept(Concept aConcept) {
        Concept aSuperConcept = aConcept.getSuperConcept();
        Collection subConcepts = aConcept.getAllSubConcepts();
        Iterator i = subConcepts.iterator();
        while (i.hasNext()) {
            Concept aSubConcept = (Concept)i.next();
            try {
                aSubConcept.setSuperConcept(aSuperConcept);
            }
            catch (StorageException storageException) {}
        }
        try {
            aConcept.delete();
        }
        catch (StorageException storageException) {
            // empty catch block
        }
        Application.conceptEditor.refresh();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        Application.menuFileExit.doClick();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != "viewOpened") {
            if (evt.getPropertyName() == "viewClosing") {
                if (Application.menuWindowClose.isEnabled()) {
                    Application.menuWindowClose.doClick();
                } else {
                    Application.menuWindowClose.getAction().actionPerformed(null);
                }
            } else if (evt.getPropertyName() != "viewClosed" && evt.getPropertyName() != "viewIconified" && evt.getPropertyName() != "viewDeiconified") {
                if (evt.getPropertyName() == "viewActivated") {
                    this.updateControls();
                    Application.updateToolButtons();
                } else if (evt.getPropertyName() == "viewDeactivated") {
                    // empty if block
                }
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e.getSource() instanceof SpinTree) {
            if (e.getNewLeadSelectionPath() != null) {
                ((CoObjectTreeView)Application.documentView).setSelectedNode(Application.getSelectedNode());
            } else {
                ((CoObjectTreeView)Application.documentView).getTreePanel().clearSelection();
            }
        } else if (Application.graphDocumentView != null) {
            Application.graphDocumentView.valueChanged(e);
        }
        this.updateControls();
    }
}

