/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.gui.main;

import com.syllogic.miningmart.m4.Value;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.Sorter;
import miningmart.hci.operators.MMStep;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Concept;
import miningmart.m4.Constraint;
import miningmart.m4.M4Object;
import miningmart.m4.MultipleResultException;
import miningmart.m4.OperatorParameter;
import miningmart.m4.Parameter;

public class DataChooser
extends JDialog
implements ListSelectionListener,
ActionListener {
    public static final int CONCEPTS = 1;
    public static final int RELATIONS = 2;
    public static final int ATTRIBUTES = 3;
    public static final int CASES = 4;
    public static final int KERNEL_TYPES = 6;
    public static final int TIME_ATTRIB = 7;
    public static final int VALUE_ATTRIB = 8;
    public static final int SEGMENTATION_ATTRIB = 9;
    public static final int MULTICOLUMNFEATURE = 0;
    public static final int FEATURE = 11;
    public static final int OPERATOR = 12;
    public static final int Value = 13;
    private Object[] allData;
    private Vector selectedData = new Vector();
    private boolean singleSelection = true;
    private int dataType = 0;
    private M4Object m4Object;
    private Vector m4ObjectsFrom;
    private MmDataList dataList = new MmDataList();
    private JButton okButton = new JButton("select");
    private JButton cancelButton = new JButton("cancel");
    private boolean okButtonPressed = false;
    private Dimension defaultSize = new Dimension(200, 200);
    private Vector kernelTypes = new Vector();
    private Vector nameData = new Vector();
    private MMStep depenceFromStep = null;
    private Sorter sorter = new Sorter();

    public DataChooser() {
        this.initControls();
        this.initData();
    }

    public DataChooser(JFrame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initControls();
        this.initData();
    }

    public DataChooser(JFrame owner, String title, int typeToSelect, M4Object m4ObjectToSelectFrom, boolean modal) {
        super(owner, title, modal);
        this.setDataType(typeToSelect, m4ObjectToSelectFrom);
        this.initControls();
        this.initData();
    }

    public DataChooser(JFrame owner, String title, int typeToSelect, boolean modal) {
        super(owner, title, modal);
        this.setDataType(typeToSelect);
        this.initControls();
        this.initData();
    }

    public DataChooser(JFrame owner, String title, int typeToSelect, Vector allNames, boolean modal) {
        super(owner, title, modal);
        this.dataType = typeToSelect;
        this.nameData = allNames;
        this.allData = allNames.toArray();
        this.initControls();
    }

    public void initData() {
        if (this.dataType == 6) {
            Value value = new Value();
            value.setValue("dot");
            value.setDatatype("NOMINAL");
            value.setName("KernelType");
            this.kernelTypes.addElement(value);
            value = new Value();
            value.setValue("polynomial");
            value.setDatatype("NOMINAL");
            value.setName("KernelType");
            this.kernelTypes.addElement(value);
            value = new Value();
            value.setValue("neutral");
            value.setDatatype("NOMINAL");
            value.setName("KernelType");
            this.kernelTypes.addElement(value);
            value = new Value();
            value.setValue("radial");
            value.setDatatype("NOMINAL");
            value.setName("KernelType");
            this.kernelTypes.addElement(value);
            value = new Value();
            value.setValue("anova");
            value.setDatatype("NOMINAL");
            value.setName("KernelType");
            this.kernelTypes.addElement(value);
        }
    }

    public void setDataType(int typeToSelect, M4Object m4ObjectToSelectFrom) {
        this.m4Object = m4ObjectToSelectFrom;
        this.dataType = typeToSelect;
        this.m4ObjectsFrom = null;
    }

    public void setDataType(int typeToSelect) {
        this.m4Object = null;
        this.dataType = typeToSelect;
        this.m4ObjectsFrom = null;
    }

    public void setDataType(int typeToSelect, Vector m4ObjectsFrom) {
        this.dataType = typeToSelect;
        this.m4ObjectsFrom = m4ObjectsFrom;
        this.m4Object = null;
    }

    public void setSingleSelection(boolean singleSelection) {
        this.singleSelection = singleSelection;
        if (singleSelection) {
            this.dataList.setSelectionMode(0);
        } else {
            this.dataList.setSelectionMode(2);
        }
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setDepenceFromStep(MMStep step) {
        this.depenceFromStep = step;
    }

    private void initControls() {
        this.setSize(this.defaultSize);
        this.getContentPane().removeAll();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(this.dataList);
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dataList.addListSelectionListener(this);
        this.okButton.addActionListener(this);
        panel.add((Component)this.okButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.cancelButton.addActionListener(this);
        panel.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getRootPane());
    }

    public void updateView() {
        Vector<Object> allVectorData = new Vector<Object>();
        if (this.isSingleSelection()) {
            this.dataList.setSelectionMode(0);
        } else {
            this.dataList.setSelectionMode(2);
        }
        switch (this.dataType) {
            case 1: {
                if (this.m4Object != null) {
                    if (this.depenceFromStep != null) {
                        Vector allPreds = this.depenceFromStep.getEveryStepPredecessors();
                        Iterator it = ((Case)this.m4Object).getAllConcepts().iterator();
                        while (it.hasNext()) {
                            Parameter p = null;
                            Concept c = (Concept)it.next();
                            try {
                                p = c.getOutputParameter();
                            }
                            catch (MultipleResultException multipleResultException) {
                                // empty catch block
                            }
                            if (p != null && !allPreds.contains(p.getStep())) continue;
                            allVectorData.add(c);
                        }
                        this.allData = allVectorData.toArray();
                        break;
                    }
                    this.allData = ((Case)this.m4Object).getAllConcepts().toArray();
                    break;
                }
                this.allData = new Object[0];
                break;
            }
            case 2: {
                if (this.m4Object != null) {
                    this.allData = ((Concept)this.m4Object).getAllFromConceptRelationships().toArray();
                    break;
                }
                allVectorData.removeAllElements();
                Collection c = Application.m4Case.getAllConcepts();
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    Concept con = (Concept)it.next();
                    if (!con.getConceptType().equals("DB")) continue;
                    allVectorData.addAll(con.getAllFromConceptRelationships());
                }
                this.allData = allVectorData.toArray();
                break;
            }
            case 3: {
                allVectorData.removeAllElements();
                if (this.m4Object != null) {
                    allVectorData.addAll(((Concept)this.m4Object).getAllBaseAttributes());
                } else if (this.m4ObjectsFrom != null && this.m4ObjectsFrom.size() > 0) {
                    Concept con = null;
                    Iterator it = this.m4ObjectsFrom.iterator();
                    while (it.hasNext()) {
                        con = (Concept)it.next();
                        allVectorData.addAll(con.getAllBaseAttributes());
                    }
                }
                this.allData = this.removeLaterCreatedBas(allVectorData).toArray();
                break;
            }
            case 0: {
                allVectorData.removeAllElements();
                if (this.m4Object != null) {
                    allVectorData.add(((Concept)this.m4Object).getAllMultiColumnFeatures());
                } else if (this.m4ObjectsFrom != null && this.m4ObjectsFrom.size() > 0) {
                    Concept con = null;
                    Iterator it = this.m4ObjectsFrom.iterator();
                    while (it.hasNext()) {
                        con = (Concept)it.next();
                        allVectorData.addAll(con.getAllMultiColumnFeatures());
                    }
                }
                this.allData = allVectorData.toArray();
                break;
            }
            case 11: {
                allVectorData.removeAllElements();
                Concept con = null;
                if (this.m4Object != null) {
                    con = (Concept)this.m4Object;
                    allVectorData.addAll(this.removeLaterCreatedBas(con.getAllBaseAttributes()));
                    allVectorData.addAll(con.getAllMultiColumnFeatures());
                } else if (this.m4ObjectsFrom != null && this.m4ObjectsFrom.size() > 0) {
                    allVectorData.removeAllElements();
                    Iterator it = this.m4ObjectsFrom.iterator();
                    while (it.hasNext()) {
                        con = (Concept)it.next();
                        allVectorData.addAll(this.removeLaterCreatedBas(con.getAllBaseAttributes()));
                        allVectorData.addAll(con.getAllMultiColumnFeatures());
                    }
                }
                this.allData = allVectorData.toArray();
                break;
            }
            case 7: {
                Collection allAttribs = null;
                allVectorData.removeAllElements();
                if (this.m4Object != null) {
                    allAttribs = ((Concept)this.m4Object).getAllBaseAttributes();
                } else if (this.m4ObjectsFrom != null && this.m4ObjectsFrom.size() > 0) {
                    Concept con = null;
                    Iterator it = this.m4ObjectsFrom.iterator();
                    while (it.hasNext()) {
                        con = (Concept)it.next();
                        allAttribs.addAll(con.getAllBaseAttributes());
                    }
                }
                if (allAttribs != null) {
                    Iterator it = allAttribs.iterator();
                    while (it.hasNext()) {
                        BaseAttribute attrib = (BaseAttribute)it.next();
                        if (!attrib.getDatatype().equals("TIME")) continue;
                        allVectorData.addElement(attrib);
                    }
                }
                this.allData = this.removeLaterCreatedBas(allVectorData).toArray();
                break;
            }
            case 8: {
                Collection allAttribs = null;
                allVectorData.removeAllElements();
                if (this.m4Object != null) {
                    allAttribs = ((Concept)this.m4Object).getAllBaseAttributes();
                } else if (this.m4ObjectsFrom != null && this.m4ObjectsFrom.size() > 0) {
                    Concept con = null;
                    Iterator it = this.m4ObjectsFrom.iterator();
                    while (it.hasNext()) {
                        con = (Concept)it.next();
                        allAttribs.addAll(con.getAllBaseAttributes());
                    }
                }
                if (allAttribs != null) {
                    Iterator it = allAttribs.iterator();
                    while (it.hasNext()) {
                        BaseAttribute attrib = (BaseAttribute)it.next();
                        if (attrib.getDatatype().equals("TIME")) continue;
                        allVectorData.addElement(attrib);
                    }
                }
                this.allData = this.removeLaterCreatedBas(allVectorData).toArray();
                break;
            }
            case 4: {
                this.allData = Application.m4Interface.getAllCaseNames().toArray();
                break;
            }
            case 6: {
                this.allData = this.kernelTypes.toArray();
                break;
            }
            case 12: {
                this.allData = Application.m4Interface.getAllOperatorNames().toArray();
                break;
            }
            case 13: {
                String values = null;
                OperatorParameter op = (OperatorParameter)this.m4Object;
                Iterator it = op.getOperator().getAllConstraints().iterator();
                while (it.hasNext() && values == null) {
                    Constraint c = (Constraint)it.next();
                    if (!c.getConstraintType().equals("ONE_OF") || !c.getObject1().equals(op.getName())) continue;
                    values = c.getObject2();
                }
                Vector<String> v = new Vector<String>();
                while (values.indexOf(" ") > 0) {
                    v.addElement(values.substring(0, values.indexOf(" ")));
                    values = values.substring(values.indexOf(" ") + 1);
                }
                v.addElement(values);
                this.allData = v.toArray();
                break;
            }
        }
        Arrays.sort(this.allData);
        this.dataList.setListData(this.allData);
    }

    private Vector removeLaterCreatedBas(Collection baVector) {
        Vector<BaseAttribute> bas = new Vector<BaseAttribute>();
        if (this.depenceFromStep != null) {
            Vector allPreds = this.depenceFromStep.getEveryStepPredecessors();
            Iterator it = baVector.iterator();
            while (it.hasNext()) {
                Parameter p = null;
                BaseAttribute ba = (BaseAttribute)it.next();
                try {
                    p = ba.getOutputParameter();
                }
                catch (MultipleResultException multipleResultException) {
                    // empty catch block
                }
                if (p != null && !allPreds.contains(p.getStep())) continue;
                bas.add(ba);
            }
        }
        return bas;
    }

    public void show() {
        super.show();
    }

    public Vector showChooseDialog() {
        this.updateView();
        this.setSingleSelection(false);
        this.show();
        if (this.okButtonPressed) {
            return this.selectedData;
        }
        return null;
    }

    public Object showChooseSingleDialog() {
        this.updateView();
        this.setSingleSelection(true);
        this.show();
        if (this.okButtonPressed && this.selectedData.size() > 0) {
            return this.selectedData.get(0);
        }
        return null;
    }

    public int showChooseSingleDialog(boolean returnIndex) {
        this.updateView();
        this.setSingleSelection(true);
        this.show();
        if (this.okButtonPressed && this.selectedData.size() > 0) {
            return this.nameData.indexOf(this.selectedData.get(0));
        }
        return -1;
    }

    public void setWithContext(boolean showContext) {
        this.dataList.setListShowConcext(showContext);
    }

    public void valueChanged(ListSelectionEvent e) {
        int[] indices = this.dataList.getSelectedIndices();
        this.selectedData.removeAllElements();
        for (int i = 0; i < indices.length; ++i) {
            this.selectedData.add(this.allData[indices[i]]);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.okButtonPressed = e.getSource() == this.okButton;
        this.dispose();
    }
}

