/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.gui.main;

import cocon.CoUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;

public class ActionLog {
    public static Locale locale = Locale.US;
    public static Calendar calendar = new GregorianCalendar();
    public static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss z", locale);
    Date sessionStart = new Date();
    File actionFile;
    Vector actionBuffer = new Vector();
    int bufferLength = 100;

    public ActionLog() {
    }

    public ActionLog(File actionFile, int bufferLength) {
        this.actionFile = actionFile;
        this.bufferLength = bufferLength;
        try {
            if (!actionFile.exists()) {
                actionFile.createNewFile();
            }
        }
        catch (IOException ioe) {
            System.out.print("ERROR: Cannot create action log file.");
            this.actionFile = null;
        }
    }

    public void action(String actionName, ActionEvent evt) {
        Date currentDate = new Date();
        long timeFromStart = currentDate.getTime() - this.sessionStart.getTime();
        String actionStr = "";
        actionStr = String.valueOf(actionStr).concat(String.valueOf(dateFormatter.format(currentDate)));
        actionStr = String.valueOf(actionStr).concat(String.valueOf(String.valueOf(", ").concat(String.valueOf(timeFromStart))));
        actionStr = actionName != null ? String.valueOf(actionStr).concat(String.valueOf(String.valueOf(", ").concat(String.valueOf(actionName)))) : String.valueOf(actionStr).concat(String.valueOf(", NoActionName"));
        actionStr = evt != null && evt.getSource() != null ? String.valueOf(actionStr).concat(String.valueOf(String.valueOf(", ").concat(String.valueOf(evt.getSource().getClass().getName())))) : String.valueOf(actionStr).concat(String.valueOf(", NoActioniSourceClass"));
        actionStr = evt != null && evt.getActionCommand() != null ? String.valueOf(actionStr).concat(String.valueOf(String.valueOf(", ").concat(String.valueOf(evt.getActionCommand())))) : String.valueOf(actionStr).concat(String.valueOf(", NoActioniCommand"));
        this.actionBuffer.add(actionStr);
        if (this.bufferLength <= 0 || this.actionBuffer.size() < this.bufferLength) {
            return;
        }
        this.flush();
    }

    public void flush() {
        if (this.actionBuffer.size() == 0) {
            return;
        }
        String writeString = "";
        for (int i = 0; i < this.actionBuffer.size(); ++i) {
            writeString = String.valueOf(writeString).concat(String.valueOf(String.valueOf((String)this.actionBuffer.get(i)).concat(String.valueOf("\n"))));
        }
        if (this.actionFile != null && this.actionFile.exists()) {
            CoUtil.appendStringToFile((File)this.actionFile, (String)writeString);
        }
        this.actionBuffer.removeAllElements();
    }
}

