/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CoConnection;
import cocon.CoObject;
import cocon.CoObjectConnectionView;
import javax.swing.table.AbstractTableModel;

class ConnectionTableModel
extends AbstractTableModel {
    CoObjectConnectionView connectionView;

    public ConnectionTableModel(CoObjectConnectionView connectionView) {
        this.connectionView = connectionView;
    }

    public CoObject getModel() {
        if (this.connectionView == null) {
            return null;
        }
        if (this.connectionView.getModel() == null) {
            return null;
        }
        return this.connectionView.getModel();
    }

    public CoConnection getConnection(int index) {
        CoObject node = this.getModel();
        if (node == null) {
            return null;
        }
        if (this.connectionView.getConnectionDirection() == 1) {
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoModelConnection")) {
                return node.getOutConnection(Class.forName("cocon.CoModelConnection"), index);
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoChildConnection")) {
                return node.getOutConnection(Class.forName("cocon.CoChildConnection"), index);
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoViewConnection")) {
                return node.getOutConnection(Class.forName("cocon.CoViewConnection"), index);
            }
        } else if (this.connectionView.getConnectionDirection() == 2) {
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoModelConnection")) {
                return node.getInConnection(Class.forName("cocon.CoModelConnection"), index);
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoChildConnection")) {
                return node.getInConnection(Class.forName("cocon.CoChildConnection"), index);
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoViewConnection")) {
                return node.getInConnection(Class.forName("cocon.CoViewConnection"), index);
            }
        }
        return null;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Direction";
            }
            case 2: {
                if (this.connectionView.getConnectionDirection() == 1) {
                    return "Destination";
                }
                if (this.connectionView.getConnectionDirection() == 2) {
                    return "Source";
                }
                return "";
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        CoObject node = this.getModel();
        if (node == null) {
            return 0;
        }
        if (this.connectionView.getConnectionDirection() == 1) {
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoModelConnection")) {
                return node.getOutConnectionCount(Class.forName("cocon.CoModelConnection"));
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoChildConnection")) {
                return node.getOutConnectionCount(Class.forName("cocon.CoChildConnection"));
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoViewConnection")) {
                return node.getOutConnectionCount(Class.forName("cocon.CoViewConnection"));
            }
        } else if (this.connectionView.getConnectionDirection() == 2) {
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoModelConnection")) {
                return node.getInConnectionCount(Class.forName("cocon.CoModelConnection"));
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoChildConnection")) {
                return node.getInConnectionCount(Class.forName("cocon.CoChildConnection"));
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoViewConnection")) {
                return node.getInConnectionCount(Class.forName("cocon.CoViewConnection"));
            }
        }
        return 0;
    }

    public Object getValueAt(int row, int col) {
        CoObject node = this.getModel();
        if (node == null) {
            return null;
        }
        if (col == 0) {
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoModelConnection")) {
                return "User";
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoChildConnection")) {
                return "Child";
            }
            if (this.connectionView.getConnectionType() == Class.forName("cocon.CoViewConnection")) {
                return "View";
            }
            return "Unknown";
        }
        if (col == 1) {
            if (this.connectionView.getConnectionDirection() == 1) {
                return "Output";
            }
            if (this.connectionView.getConnectionDirection() == 2) {
                return "Input";
            }
            return "Unknown";
        }
        if (col == 2) {
            CoConnection connection = this.getConnection(row);
            if (connection == null) {
                return "Unknown";
            }
            if (connection.getSource() == node) {
                return ((CoObject)connection.getDestination()).getName();
            }
            if (connection.getDestination() == node) {
                return ((CoObject)connection.getSource()).getName();
            }
            return "Unknown";
        }
        return "Unknown";
    }
}

