/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CoObject;
import cocon.CoView;
import cocon.CoWindow;
import java.awt.Component;
import java.beans.PropertyVetoException;
import javax.swing.ButtonGroup;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CoWindowList
extends CoObject {
    static int xFrameOffset;
    static int yFrameOffset;
    JFrame frame;
    JMenu windowMenu;
    ButtonGroup windowMenuGroup;

    public CoWindowList(JFrame frame, JMenu windowMenu) {
        this.frame = frame;
        this.windowMenu = windowMenu;
        this.windowMenuGroup = new ButtonGroup();
    }

    public void addWindow(CoWindow window) {
        if (window.getParent() != null && window.getParent() instanceof CoWindowList) {
            ((CoWindowList)((Object)window.getParent())).removeWindow(window);
        }
        this.add((MutableTreeNode)((Object)window));
        if (window.windowType == 2 && window.windowInternalFrame != null) {
            this.addMenu(window);
            this.getDesktopPane().add(window.windowInternalFrame, JLayeredPane.DEFAULT_LAYER, 0);
            if (window.getWindowView().isScrollable()) {
                window.setWindowSize(this.getFrame().getWidth() / 2, this.getFrame().getHeight() / 2);
            }
        } else if (window.windowType == 3 && window.windowDialog != null) {
            this.addMenu(window);
            JDialog dialog = new JDialog(this.frame, window.windowDialog.getTitle(), true);
            dialog.getContentPane().add(window.windowDialog.getContentPane().getComponent(0));
            dialog.setDefaultCloseOperation(window.windowDialog.getDefaultCloseOperation());
            dialog.addWindowListener(window);
            dialog.setResizable(window.windowDialog.isResizable());
            dialog.pack();
            window.windowDialog = dialog;
            window.windowDialog.setLocationRelativeTo(this.frame);
        }
    }

    public void removeWindow(CoWindow window) {
        if (window.windowType == 2 && window.windowInternalFrame != null) {
            this.removeMenu(window);
            window.removeWindow();
            this.remove((MutableTreeNode)((Object)window));
            int topWindow = this.getTopWindow();
            if (topWindow >= 0) {
                this.setActiveWindow(topWindow);
            }
        } else if (window.windowType == 3 && window.windowDialog != null) {
            this.removeMenu(window);
            window.removeWindow();
            this.remove((MutableTreeNode)((Object)window));
            int topWindow = this.getTopWindow();
            if (topWindow >= 0) {
                this.setActiveWindow(topWindow);
            }
        }
        this.reorderMenu();
    }

    public void removeAllWindows() {
        for (int i = this.getWindowCount() - 1; i >= 0; --i) {
            this.removeWindow(this.getWindowAt(i));
        }
    }

    public void addMenu(CoWindow window) {
        int keyCode;
        if (window.windowMenuItem == null) {
            return;
        }
        int windowCount = this.getWindowCount() - 1;
        switch (windowCount) {
            case 0: {
                keyCode = 48;
                break;
            }
            case 1: {
                keyCode = 49;
                break;
            }
            case 2: {
                keyCode = 50;
                break;
            }
            case 3: {
                keyCode = 51;
                break;
            }
            case 4: {
                keyCode = 52;
                break;
            }
            case 5: {
                keyCode = 53;
                break;
            }
            case 6: {
                keyCode = 54;
                break;
            }
            case 7: {
                keyCode = 55;
                break;
            }
            case 8: {
                keyCode = 56;
                break;
            }
            case 9: {
                keyCode = 57;
                break;
            }
            default: {
                keyCode = -1;
            }
        }
        window.windowMenuItem.setText(String.valueOf(String.valueOf(windowCount).concat(String.valueOf(" - "))).concat(String.valueOf(window.windowMenuItem.getText())));
        if (keyCode != -1) {
            window.windowMenuItem.setMnemonic(keyCode);
            window.windowMenuItem.setAccelerator(KeyStroke.getKeyStroke(keyCode, 8));
        }
        if (this.windowMenu != null && this.windowMenuGroup != null) {
            if (this.getWindowCount() == 1 && this.windowMenu.getItem(this.windowMenu.getItemCount() - 1) != this.windowMenu) {
                this.windowMenu.addSeparator();
            }
            this.windowMenu.add(window.windowMenuItem);
            this.windowMenuGroup.add(window.windowMenuItem);
        }
    }

    public void removeMenu(CoWindow window) {
        window.windowMenuItem.removeActionListener(window);
        if (this.getWindowMenu() != null) {
            this.getWindowMenu().remove((Component)window.windowMenuItem);
        }
        if (this.getWindowMenuGroup() != null) {
            this.getWindowMenuGroup().remove(window.windowMenuItem);
        }
        if (this.getWindowCount() == 1) {
            int itemCount = this.getWindowMenu().getItemCount();
            if (this.getWindowMenu().getItem(itemCount - 1) == null) {
                this.getWindowMenu().remove(itemCount - 1);
            }
        }
    }

    public void reorderMenu() {
        for (int i = 0; i < this.getWindowCount(); ++i) {
            int keyCode;
            switch (i) {
                case 0: {
                    keyCode = 48;
                    break;
                }
                case 1: {
                    keyCode = 49;
                    break;
                }
                case 2: {
                    keyCode = 50;
                    break;
                }
                case 3: {
                    keyCode = 51;
                    break;
                }
                case 4: {
                    keyCode = 52;
                    break;
                }
                case 5: {
                    keyCode = 53;
                    break;
                }
                case 6: {
                    keyCode = 54;
                    break;
                }
                case 7: {
                    keyCode = 55;
                    break;
                }
                case 8: {
                    keyCode = 56;
                    break;
                }
                case 9: {
                    keyCode = 57;
                    break;
                }
                default: {
                    keyCode = -1;
                }
            }
            CoWindow window = this.getWindowAt(i);
            window.windowMenuItem.setText(String.valueOf(String.valueOf(i).concat(String.valueOf(" - "))).concat(String.valueOf(window.windowView.getWindowMenuName())));
            if (keyCode == -1) continue;
            window.windowMenuItem.setMnemonic(keyCode);
            window.windowMenuItem.setAccelerator(KeyStroke.getKeyStroke(keyCode, 8));
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JMenu getWindowMenu() {
        return this.windowMenu;
    }

    public ButtonGroup getWindowMenuGroup() {
        return this.windowMenuGroup;
    }

    public int getWindowCount() {
        return this.getChildCount();
    }

    public int getTopWindow() {
        int i;
        JDesktopPane desktopPane = this.getDesktopPane();
        for (i = 0; i < this.getWindowCount() && desktopPane.getPosition(((CoWindow)((Object)this.getChildAt((int)i))).windowInternalFrame) != 0; ++i) {
        }
        if (i >= this.getWindowCount()) {
            return -1;
        }
        return i;
    }

    public int getActiveWindow() {
        if (((CoWindow)((Object)this.getChildAt((int)(this.getWindowCount() - 1)))).windowType == 3) {
            return this.getWindowCount() - 1;
        }
        for (int i = 0; i < this.getWindowCount(); ++i) {
            CoWindow window = (CoWindow)((Object)this.getChildAt(i));
            if (window.windowType != 2 || window.windowInternalFrame == null || !window.windowInternalFrame.isSelected()) continue;
            return i;
        }
        return -1;
    }

    public void setActiveWindow(int windowIndex) {
        int windowCount = this.getWindowCount();
        if (windowIndex < 0 || windowIndex >= windowCount) {
            System.out.println(String.valueOf(String.valueOf("WARNING: CoWindowList::setActiveWindow: Bad window index: ").concat(String.valueOf(windowIndex))).concat(String.valueOf(".")));
            return;
        }
        CoWindow window = (CoWindow)((Object)this.getChildAt(windowIndex));
        if (window.windowType == 2 && window.windowInternalFrame != null) {
            try {
                window.windowInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                System.out.println("ERROR: CoWindowList::setActiveWindow: Cannot select window.");
            }
        }
    }

    public void setActiveWindow(CoWindow window) {
        this.setActiveWindow(this.getWindowIndex(window));
    }

    public void showWindow(CoWindow window) {
        window.showWindow();
    }

    public CoWindow getWindowAt(int index) {
        return (CoWindow)((Object)this.getChildAt(index));
    }

    public int getWindowIndex(CoWindow window) {
        return this.getIndex((TreeNode)((Object)window));
    }

    public int getWindowIndex(CoView view) {
        for (int i = 0; i < this.getWindowCount(); ++i) {
            if (this.getWindowAt((int)i).windowView != view) continue;
            return i;
        }
        return -1;
    }

    public CoWindow getWindow(Class viewClass) {
        for (int i = 0; i < this.getWindowCount(); ++i) {
            if (this.getWindowAt((int)i).windowView.getClass() != viewClass) continue;
            return this.getWindowAt(i);
        }
        return null;
    }

    public CoWindow getWindow(CoView view) {
        for (int i = 0; i < this.getWindowCount(); ++i) {
            if (this.getWindowAt((int)i).windowView != view) continue;
            return this.getWindowAt(i);
        }
        return null;
    }

    JDesktopPane getDesktopPane() {
        if (this.frame == null) {
            return null;
        }
        int i = 0;
        while (this.frame.getContentPane().getComponent(i) != null && !(this.frame.getContentPane().getComponent(i) instanceof JDesktopPane)) {
            ++i;
        }
        JDesktopPane layeredPane = (JDesktopPane)this.frame.getContentPane().getComponent(i);
        if (layeredPane == null) {
            System.out.println("WARNING: CoWindowList::getDesktopPane: DesktopPane is absent in Frame.");
            return null;
        }
        return layeredPane;
    }
}

