/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CoGraphView;
import cocon.CoObject;
import cocon.CoView;
import cocon.CoWindowList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import miningmart.hci.gui.main.Application;

public class CoWindow
extends CoObject
implements ActionListener,
InternalFrameListener,
WindowListener {
    public static final int FRAME = 1;
    public static final int INTERNALFRAME = 2;
    public static final int DIALOG = 3;
    public int windowType;
    public JFrame windowFrame;
    public JInternalFrame windowInternalFrame;
    public JDialog windowDialog;
    CoView windowView = new CoView();
    public JMenuItem windowMenuItem;
    public JMenuBar windowMenuBar;

    public CoWindow(int windowType, CoView view) {
        JMenuBar menuBar = null;
        if (view != null) {
            menuBar = view.getMenuBar();
        }
        if (windowType == 2) {
            this.windowInternalFrame = new JInternalFrame("", true, true, true, true);
            JPanel contentPane = (JPanel)this.windowInternalFrame.getContentPane();
            contentPane.setLayout(new BorderLayout());
            if (view.isScrollable()) {
                contentPane.add((Component)new JScrollPane(view.getViewPanel()), "Center");
            } else {
                contentPane.add((Component)view.getViewPanel(), "Center");
            }
            this.windowInternalFrame.addInternalFrameListener(this);
            this.windowInternalFrame.setDefaultCloseOperation(0);
            if (view instanceof CoGraphView) {
                this.windowInternalFrame.addInternalFrameListener((CoGraphView)view);
            }
            if (view.getIcons() != null && view.getIcons().size() != 0) {
                Object icon = view.getIcons().get(0);
                if (icon instanceof ImageIcon) {
                    this.windowInternalFrame.setFrameIcon((ImageIcon)icon);
                } else if (icon instanceof Icon) {
                    this.windowInternalFrame.setFrameIcon((Icon)icon);
                } else if (icon instanceof String) {
                    this.windowInternalFrame.setFrameIcon(view.getImageIcon(0));
                }
            }
            if (menuBar != null) {
                this.windowInternalFrame.setJMenuBar(menuBar);
            }
            this.windowInternalFrame.setTitle(view.getWindowTitle());
            this.windowInternalFrame.pack();
        } else if (windowType == 3) {
            this.windowDialog = new JDialog(null, view.getWindowTitle(), true);
            if (view.isScrollable()) {
                this.windowDialog.getContentPane().add((Component)new JScrollPane(view.getViewPanel()), "Center");
            } else {
                this.windowDialog.getContentPane().add(view.getViewPanel());
            }
            this.windowDialog.setDefaultCloseOperation(0);
            this.windowDialog.addWindowListener(Application.dispatcher);
            if (menuBar != null) {
                this.windowInternalFrame.setJMenuBar(menuBar);
            }
            this.windowDialog.setResizable(true);
            this.windowDialog.pack();
        }
        this.windowType = windowType;
        this.windowView = view;
        this.windowMenuItem = new JCheckBoxMenuItem(view.getWindowMenuName());
        this.windowMenuItem.addActionListener(this);
    }

    public CoWindow(JInternalFrame frame) {
        this.windowInternalFrame = frame;
        this.windowInternalFrame.addInternalFrameListener(this);
        this.windowInternalFrame.setDefaultCloseOperation(0);
        this.windowType = 2;
        this.windowMenuItem = new JCheckBoxMenuItem(frame.getTitle());
        this.windowMenuItem.addActionListener(this);
    }

    public void removeWindow() {
        if (this.windowType == 2 && this.windowInternalFrame != null) {
            this.removeInternalFrame();
        } else if (this.windowType == 3 && this.windowDialog != null) {
            this.removeDialog();
        }
    }

    public CoView getWindowView() {
        return this.windowView;
    }

    public int getWindowIndex() {
        CoWindowList windowList = this.getWindowList();
        if (windowList == null) {
            return -1;
        }
        return windowList.getWindowIndex(this);
    }

    public CoWindowList getWindowList() {
        return (CoWindowList)((Object)this.getParent());
    }

    public int getWindowCount() {
        CoWindowList windowList = this.getWindowList();
        if (windowList == null) {
            return -1;
        }
        return windowList.getWindowCount();
    }

    public void showWindow() {
        if (this.windowType == 2 && this.windowInternalFrame != null) {
            this.windowInternalFrame.show();
        } else if (this.windowType == 3 && this.windowDialog != null) {
            this.windowDialog.show();
        }
    }

    public void setWindowSize(int width, int height) {
        if (this.windowType == 2 && this.windowInternalFrame != null) {
            this.windowInternalFrame.setSize(width, height);
        } else if (this.windowType == 3 && this.windowDialog != null) {
            this.windowDialog.setSize(width, height);
        }
    }

    public void setWindowCloseable(boolean closeable) {
        this.windowInternalFrame.setClosable(closeable);
    }

    void removeInternalFrame() {
        this.windowInternalFrame.setVisible(false);
        CoWindowList windowList = this.getWindowList();
        if (windowList == null || windowList.getFrame() == null) {
            return;
        }
        JDesktopPane layeredPane = this.windowInternalFrame.getDesktopPane();
        try {
            if (this.windowInternalFrame.isIcon()) {
                this.windowInternalFrame.setIcon(false);
            }
            if (this.windowInternalFrame.isMaximum()) {
                this.windowInternalFrame.setMaximum(false);
            }
        }
        catch (PropertyVetoException e) {
            System.out.println("ERROR: CoWindow::removeInternalFrame: Cannot deiconify/demaximy window before removing.");
        }
        int frameIndex = layeredPane.getIndexOf(this.windowInternalFrame);
        if (frameIndex < 0) {
            System.out.println("ERROR: CoWindow::removeInternalFrame: Bad internal frame window index.");
            return;
        }
        this.windowInternalFrame.removeInternalFrameListener(this);
        layeredPane.remove(frameIndex);
    }

    void removeDialog() {
        this.windowDialog.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.windowMenuItem) {
            return;
        }
        CoWindowList windowList = this.getWindowList();
        if (windowList == null) {
            return;
        }
        windowList.setActiveWindow(this.getWindowIndex());
    }

    public void internalFrameOpened(InternalFrameEvent e) {
        this.windowView.firePropertyChange("viewOpened", null, null);
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        CoWindowList windowList = this.getWindowList();
        if (this.windowMenuItem != null) {
            this.windowMenuItem.doClick();
        } else if (windowList != null) {
            windowList.setActiveWindow(this.getWindowIndex());
        } else {
            return;
        }
        this.windowView.firePropertyChange("viewClosing", null, null);
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        this.windowView.firePropertyChange("viewClosed", null, null);
    }

    public void internalFrameIconified(InternalFrameEvent e) {
        CoWindowList windowList = this.getWindowList();
        if (windowList == null) {
            return;
        }
        int topWindow = windowList.getTopWindow();
        if (topWindow < 0) {
            windowList.setActiveWindow(this.getWindowIndex());
        } else {
            windowList.setActiveWindow(topWindow);
        }
        this.windowView.firePropertyChange("viewIconified", null, null);
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
        this.windowView.firePropertyChange("viewDeiconified", null, null);
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        if (this.windowMenuItem != null && !this.windowMenuItem.isSelected()) {
            this.windowMenuItem.setSelected(true);
        }
        this.windowView.firePropertyChange("viewActivated", null, null);
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
        if (this.windowMenuItem != null && this.windowMenuItem.isSelected()) {
            this.windowMenuItem.setSelected(false);
        }
        this.windowView.firePropertyChange("viewDeactivated", null, null);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        CoWindowList windowList = this.getWindowList();
        if (this.windowMenuItem != null) {
            this.windowMenuItem.doClick();
        } else if (windowList != null) {
            windowList.setActiveWindow(this.getWindowIndex());
        } else {
            return;
        }
        this.windowView.firePropertyChange("viewClosing", null, null);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("WindowName")) {
            this.windowInternalFrame.setTitle((String)evt.getNewValue());
        }
    }
}

