/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CiConnectable;
import cocon.CoChildConnection;
import cocon.CoConnection;
import cocon.CoConnectionChangeEvent;
import cocon.CoConnectionDescriptor;
import cocon.CoModel;
import cocon.CoModelConnection;
import cocon.CoObject;
import cocon.CoObjectTreeView;
import cocon.CoView;
import cocon.CoViewConnection;
import cocon.ConnectionTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import miningmart.hci.gui.main.Application;

public class CoObjectConnectionView
extends CoView
implements ActionListener,
TreeSelectionListener,
ListSelectionListener {
    JSplitPane splitPane = new JSplitPane(1);
    JComboBox connectionDirection;
    JComboBox connectionType;
    JTable connectionTable;
    ConnectionTableModel tableModel = new ConnectionTableModel(this);
    CoObjectTreeView sourceTree = new CoObjectTreeView();
    CoObjectTreeView destinationTree = new CoObjectTreeView();
    JButton buttonAdd;
    JButton buttonRemove;
    JButton buttonClose;

    public CoObjectConnectionView() {
        this.initCoObjectConnectionView();
    }

    public int initCoObjectConnectionView() {
        this.initControls();
        this.updateView();
        return 0;
    }

    public void initControls() {
        this.getViewPanel().removeAll();
        this.getViewPanel().setOpaque(true);
        this.getViewPanel().setLayout(new BorderLayout());
        this.splitPane.resetToPreferredSizes();
        this.splitPane.resetToPreferredSizes();
        this.splitPane.setContinuousLayout(true);
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.connectionType = new JComboBox<Object>(new Object[]{"Model Connections", "Child Connections", "View Connections"});
        this.connectionType.addActionListener(this);
        panel.add(this.connectionType);
        panel2.add((Component)panel, "North");
        this.connectionDirection = new JComboBox<Object>(new Object[]{"Output Connections", "Input Connections"});
        this.connectionDirection.addActionListener(this);
        panel.add(this.connectionDirection);
        panel2.add((Component)panel, "North");
        this.connectionTable = new JTable(this.tableModel);
        this.connectionTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.connectionTable);
        this.connectionTable.setPreferredScrollableViewportSize(new Dimension(200, 200));
        panel2.add((Component)scrollPane, "Center");
        panel = new JPanel(new GridLayout(1, 3));
        panel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.buttonAdd = new JButton("Add...");
        this.buttonAdd.setMnemonic(65);
        this.buttonAdd.addActionListener(this);
        panel.add(this.buttonAdd);
        this.buttonRemove = new JButton("Remove");
        this.buttonRemove.setMnemonic(82);
        this.buttonRemove.addActionListener(this);
        panel.add(this.buttonRemove);
        this.buttonClose = new JButton("Close");
        this.buttonClose.setMnemonic(67);
        this.buttonClose.addActionListener(this);
        panel.add(this.buttonClose);
        panel2.add((Component)panel, "South");
        this.splitPane.setLeftComponent(panel2);
        panel = new JPanel();
        TitledBorder border = new TitledBorder("Destination");
        border.setTitlePosition(2);
        border.setTitleJustification(1);
        panel.setBorder(border);
        this.destinationTree.getTreePanel().addTreeSelectionListener(this);
        scrollPane = new JScrollPane(this.destinationTree.getViewPanel());
        scrollPane.setPreferredSize(new Dimension(200, 200));
        panel.add(scrollPane);
        this.splitPane.setRightComponent(scrollPane);
        this.splitPane.resetToPreferredSizes();
        this.splitPane.setContinuousLayout(true);
        this.getViewPanel().add((Component)this.splitPane, "Center");
    }

    public Class getConnectionType() {
        int selectedItem = this.connectionType.getSelectedIndex();
        if (selectedItem == 0) {
            return Class.forName("cocon.CoModelConnection");
        }
        if (selectedItem == 1) {
            return Class.forName("cocon.CoChildConnection");
        }
        if (selectedItem == 2) {
            return Class.forName("cocon.CoViewConnection");
        }
        return null;
    }

    public void setConnectionType(Class connectionClass) {
        if (connectionClass == Class.forName("cocon.CoModelConnection")) {
            this.connectionType.setSelectedIndex(0);
        } else if (connectionClass == Class.forName("cocon.CoChildConnection")) {
            this.connectionType.setSelectedIndex(1);
        } else if (connectionClass == Class.forName("cocon.CoViewConnection")) {
            this.connectionType.setSelectedIndex(2);
        }
    }

    public int getConnectionDirection() {
        int selectedItem = this.connectionDirection.getSelectedIndex();
        if (selectedItem == 0) {
            return 1;
        }
        if (selectedItem == 1) {
            return 2;
        }
        return 0;
    }

    public void setConnectionDirection(int direction) {
        if (direction == 1) {
            this.connectionDirection.setSelectedIndex(0);
        } else if (direction == 2) {
            this.connectionDirection.setSelectedIndex(1);
        }
    }

    public boolean checkValues() {
        return true;
    }

    public void updateControlsState() {
        CoConnectionChangeEvent cce;
        int i;
        CoModelConnection connection;
        CoModel model = this.getModel();
        if (model == null || Application.mmWorkspace.isReadOnly()) {
            this.buttonAdd.setEnabled(false);
            this.buttonRemove.setEnabled(false);
            return;
        }
        if (this.getConnectionType() == Class.forName("cocon.CoChildConnection") || this.getConnectionType() == Class.forName("cocon.CoViewConnection")) {
            this.buttonAdd.setEnabled(false);
            this.buttonRemove.setEnabled(false);
            return;
        }
        boolean canAdd = true;
        CoObject selectedNode = this.destinationTree.getSelectedNode();
        if (this.destinationTree.getSelectionCount() != 1) {
            canAdd = false;
        } else if (selectedNode == model) {
            canAdd = false;
        } else {
            int connectionCount;
            CoObject destination;
            CoModel source;
            if (this.getConnectionDirection() == 1) {
                source = model;
                destination = selectedNode;
            } else if (this.getConnectionDirection() == 2) {
                source = selectedNode;
                destination = model;
            } else {
                return;
            }
            if (this.getConnectionType() == Class.forName("cocon.CoModelConnection")) {
                connection = new CoModelConnection();
            } else if (this.getConnectionType() == Class.forName("cocon.CoChildConnection")) {
                connection = new CoChildConnection();
            } else if (this.getConnectionType() == Class.forName("cocon.CoViewConnection")) {
                connection = new CoViewConnection();
            } else {
                return;
            }
            CoConnectionDescriptor[] srcCD = source.getConnectionDescriptors();
            for (i = 0; i < srcCD.length; ++i) {
                if (srcCD[i].direction != 1 || !srcCD[i].connectionClass.isAssignableFrom(connection.getClass()) || !srcCD[i].destinationClass.isAssignableFrom(destination.getClass())) continue;
                connectionCount = source.getOutConnectionCount(srcCD[i].connectionClass, srcCD[i].destinationClass);
                if (srcCD[i].maxConnections < 0 || srcCD[i].maxConnections > connectionCount) break;
            }
            if (i == srcCD.length) {
                canAdd = false;
            }
            CoConnectionDescriptor[] dstCD = destination.getConnectionDescriptors();
            for (i = 0; i < dstCD.length; ++i) {
                if (dstCD[i].direction != 2 || !dstCD[i].connectionClass.isAssignableFrom(connection.getClass()) || !dstCD[i].sourceClass.isAssignableFrom(source.getClass())) continue;
                connectionCount = destination.getInConnectionCount(dstCD[i].connectionClass, dstCD[i].sourceClass);
                if (dstCD[i].maxConnections < 0 || dstCD[i].maxConnections > connectionCount) break;
            }
            if (i == dstCD.length) {
                canAdd = false;
            }
            cce = new CoConnectionChangeEvent((Object)this, (CoConnection)connection, (Object)source, (Object)destination);
            source.canAddConnection(cce);
            if (cce.getError() < 0) {
                canAdd = false;
            }
            destination.canAddConnection(cce);
            if (cce.getError() < 0) {
                canAdd = false;
            }
        }
        boolean canRemove = true;
        int[] rows = this.connectionTable.getSelectedRows();
        canRemove = false;
        for (i = 0; i < rows.length; ++i) {
            connection = this.tableModel.getConnection(rows[i]);
            if (connection == null) continue;
            cce = new CoConnectionChangeEvent((Object)this, (CoConnection)connection, (Object)connection.getSource(), (Object)connection.getDestination());
            ((CoObject)connection.getSource()).canRemoveConnection(cce);
            if (cce.getError() < 0) continue;
            ((CoObject)connection.getDestination()).canRemoveConnection(cce);
            if (cce.getError() < 0) continue;
            canRemove = true;
            break;
        }
        this.buttonAdd.setEnabled(canAdd);
        this.buttonRemove.setEnabled(canRemove);
    }

    public void updateView() {
        this.connectionTable.tableChanged(new TableModelEvent(this.connectionTable.getModel()));
        this.updateControlsState();
    }

    public void updateModel() {
    }

    public boolean isScrollable() {
        return false;
    }

    public String getWindowMenuName() {
        CoModel model = this.getModel();
        if (model == null) {
            return "";
        }
        return model.getName();
    }

    public String getWindowTitle() {
        CoModel model = this.getModel();
        if (model == null) {
            return "";
        }
        return model.getName();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() != this.connectionTable.getSelectionModel()) {
            System.err.println("WARNING: CoObjectConnectionView::TreeSelectionListener. Wrong behaviour.");
            return;
        }
        this.updateControlsState();
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e.getSource() != this.destinationTree.getTreePanel()) {
            System.err.println("WARNING: CoObjectConnectionView::TreeSelectionListener. Wrong behaviour.");
            return;
        }
        this.updateControlsState();
    }

    public void actionPerformed(ActionEvent e) {
        CoModel model = this.getModel();
        if (e.getSource() == this.connectionDirection) {
            this.updateView();
        } else if (e.getSource() == this.connectionType) {
            this.updateView();
        } else if (e.getSource() == this.buttonAdd) {
            CoModelConnection connection;
            CoObject destination;
            CoModel source;
            if (model == null) {
                return;
            }
            CoObject selectedNode = this.destinationTree.getSelectedNode();
            if (selectedNode == null || selectedNode == model) {
                return;
            }
            if (this.getConnectionDirection() == 1) {
                source = model;
                destination = selectedNode;
            } else if (this.getConnectionDirection() == 2) {
                source = selectedNode;
                destination = model;
            } else {
                return;
            }
            if (this.getConnectionType() == Class.forName("cocon.CoModelConnection")) {
                connection = new CoModelConnection();
            } else if (this.getConnectionType() == Class.forName("cocon.CoChildConnection")) {
                connection = new CoChildConnection();
            } else if (this.getConnectionType() == Class.forName("cocon.CoViewConnection")) {
                connection = new CoViewConnection();
            } else {
                return;
            }
            source.addConnection((CoConnection)connection, (CiConnectable)destination);
            this.connectionTable.clearSelection();
            this.updateView();
        } else if (e.getSource() == this.buttonRemove) {
            int[] rows = this.connectionTable.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            Vector<CoConnection> connections = new Vector<CoConnection>();
            for (int i = 0; i < rows.length; ++i) {
                connections.add(this.tableModel.getConnection(rows[i]));
            }
            for (int i = 0; i < connections.size(); ++i) {
                CoConnection connection = (CoConnection)connections.get(i);
                connection.getSource().removeConnection(connection);
            }
            this.connectionTable.clearSelection();
            this.updateView();
        } else if (e.getSource() == this.buttonClose) {
            this.firePropertyChange("viewClosing", null, null);
            this.fireAutoPropertyChange("viewClosing", null, null);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        CoModel model = this.getModel();
        String propertyName = evt.getPropertyName();
        if (model != null && (propertyName == "name" || propertyName == "icons") && evt.getSource() == model) {
            this.updateView();
        }
    }

    public void addedInConnection(CoConnectionChangeEvent cce) {
        super.addedInConnection(cce);
    }

    public void addedOutConnection(CoConnectionChangeEvent cce) {
        super.addedOutConnection(cce);
    }

    public void addedConnection(CoConnectionChangeEvent cce) {
        super.addedConnection(cce);
        CoConnection connection = cce.getConnection();
        if (connection instanceof CoViewConnection && cce.getSource() == this) {
            this.destinationTree.addConnection((CoConnection)new CoViewConnection(), (CiConnectable)((CoObject)cce.getDestination()).getRoot());
            this.updateView();
        }
    }

    public void removedInConnection(CoConnectionChangeEvent cce) {
        super.removedInConnection(cce);
    }

    public void removedOutConnection(CoConnectionChangeEvent cce) {
        super.removedOutConnection(cce);
    }

    public void removedConnection(CoConnectionChangeEvent cce) {
        super.removedConnection(cce);
        CoConnection connection = cce.getConnection();
        if (connection instanceof CoViewConnection && cce.getSource() == this) {
            this.destinationTree.removeAllOutConnections(Class.forName("cocon.CoViewConnection"));
            this.updateView();
        }
    }
}

