/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CoChildConnection;
import cocon.CoConnection;
import cocon.CoConnectionChangeEvent;
import cocon.CoModel;
import cocon.CoObject;
import cocon.CoObjectTreeViewCellRenderer;
import cocon.CoView;
import cocon.CoViewConnection;
import java.beans.PropertyChangeEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CoObjectTreeView
extends CoView {
    public CoObjectTreeView() {
        this.initCoObjectTreeView();
    }

    public int initCoObjectTreeView() {
        this.viewPanel = new JTree();
        this.getTreePanel().setModel(null);
        this.getTreePanel().setCellRenderer(new CoObjectTreeViewCellRenderer());
        this.getTreePanel().setShowsRootHandles(true);
        this.getTreePanel().putClientProperty("JTree.lineStyle", "Angled");
        this.getTreePanel().setScrollsOnExpand(true);
        this.getTreePanel().getSelectionModel().setSelectionMode(1);
        return 0;
    }

    public JTree getTreePanel() {
        return (JTree)this.getViewPanel();
    }

    public CoObject getRootNode() {
        if (this.getTreePanel() == null) {
            return null;
        }
        if (this.getTreePanel().getModel() == null) {
            return null;
        }
        return (CoObject)this.getTreePanel().getModel().getRoot();
    }

    public DefaultTreeModel getTreeModel() {
        if (this.getTreePanel() == null) {
            return null;
        }
        return (DefaultTreeModel)this.getTreePanel().getModel();
    }

    public CoObject getSelectedNode() {
        if (this.getTreePanel() == null) {
            return null;
        }
        TreePath path = this.getTreePanel().getSelectionModel().getLeadSelectionPath();
        if (path == null) {
            return null;
        }
        CoObject selectedNode = (CoObject)path.getLastPathComponent();
        return selectedNode;
    }

    public void setSelectedNode(CoObject node) {
        if (this.getTreePanel() == null || this.getTreeModel() == null) {
            return;
        }
        if (this.getTreeModel().getPathToRoot(node) == null) {
            this.getTreePanel().clearSelection();
            return;
        }
        TreePath path = new TreePath(this.getTreeModel().getPathToRoot(node));
        this.getTreePanel().setSelectionPath(path);
        this.getTreePanel().scrollPathToVisible(path);
    }

    public int getSelectionCount() {
        if (this.getTreePanel() == null) {
            return -1;
        }
        return this.getTreePanel().getSelectionCount();
    }

    public void updateView() {
        CoModel model = this.getModel();
        if (model == null) {
            this.getTreePanel().setModel(null);
            return;
        }
        if (this.getRootNode() != model) {
            this.getTreePanel().setModel(new DefaultTreeModel(model));
        } else {
            this.getTreeModel().reload();
        }
    }

    public boolean isScrollable() {
        return true;
    }

    public String getWindowMenuName() {
        if (this.getRootNode() == null) {
            return "";
        }
        return this.getRootNode().getName();
    }

    public String getWindowTitle() {
        if (this.getRootNode() == null) {
            return "";
        }
        return this.getRootNode().getName();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        CoModel model = this.getModel();
        String propertyName = evt.getPropertyName();
        if (model != null && (propertyName == "name" || propertyName == "icons") && evt.getSource() instanceof CoObject && model.isNodeDescendant((CoObject)evt.getSource())) {
            this.getTreeModel().nodeChanged((CoObject)evt.getSource());
        }
    }

    public void addedInConnection(CoConnectionChangeEvent cce) {
        super.addedInConnection(cce);
    }

    public void addedOutConnection(CoConnectionChangeEvent cce) {
        super.addedOutConnection(cce);
    }

    public void addedConnection(CoConnectionChangeEvent cce) {
        super.addedConnection(cce);
        CoModel model = this.getModel();
        CoConnection connection = cce.getConnection();
        if (connection instanceof CoViewConnection && cce.getSource() == this) {
            this.updateView();
        }
        if (model != null && connection instanceof CoChildConnection && model.isNodeDescendant((CoObject)cce.getSource())) {
            this.getTreeModel().nodesWereInserted((CoObject)cce.getSource(), new int[]{((CoObject)cce.getSource()).getIndex((CoObject)cce.getDestination())});
        }
    }

    public void removedInConnection(CoConnectionChangeEvent cce) {
        super.removedInConnection(cce);
    }

    public void removedOutConnection(CoConnectionChangeEvent cce) {
        super.removedOutConnection(cce);
    }

    public void removedConnection(CoConnectionChangeEvent cce) {
        super.removedConnection(cce);
        CoModel model = this.getModel();
        CoConnection connection = cce.getConnection();
        if (connection instanceof CoViewConnection && cce.getSource() == this) {
            this.updateView();
        }
        if (model != null && connection instanceof CoChildConnection && model.isNodeDescendant((CoObject)cce.getSource())) {
            this.getTreeModel().nodeStructureChanged((CoObject)cce.getSource());
        }
    }
}

