/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import cocon.CiConnectable;
import cocon.CoConnection;
import cocon.CoObject;
import java.io.Serializable;
import java.util.Vector;

public class CoGraph
implements Cloneable,
Serializable {
    public Vector objects = new Vector();
    public Vector connections = new Vector();

    public CoGraph() {
    }

    public CoGraph(CoGraph graph) {
        this.objects = (Vector)graph.objects.clone();
        this.connections = (Vector)graph.connections.clone();
    }

    public CoGraph(CoObject object) {
        this.objects.add(object);
    }

    public CoGraph(CoObject object, Class connectionClass, Class connectedClass, int connectionDirection) {
        if (object == null) {
            return;
        }
        this.objects.add(object);
        int i = 0;
        int j = 1;
        while (i < j) {
            while (i < j) {
                CiConnectable node2;
                CoConnection connection;
                int k;
                int nodeCount;
                CiConnectable node = (CiConnectable)this.objects.get(i);
                if (connectionDirection == 1 || connectionDirection == 3) {
                    nodeCount = node.getOutConnectionCount(connectionClass);
                    for (k = 0; k < nodeCount; ++k) {
                        connection = node.getOutConnection(connectionClass, k);
                        if (connection == null || (node2 = connection.getDestination()) == null || connectedClass != null && !connectedClass.isInstance(node2)) continue;
                        if (!this.objects.contains(node2)) {
                            this.objects.add(node2);
                        }
                        if (this.connections.contains(connection)) continue;
                        this.connections.add(connection);
                    }
                }
                if (connectionDirection == 2 || connectionDirection == 3) {
                    nodeCount = node.getInConnectionCount(connectionClass);
                    for (k = 0; k < nodeCount; ++k) {
                        connection = node.getInConnection(connectionClass, k);
                        if (connection == null || (node2 = connection.getSource()) == null || connectedClass != null && !connectedClass.isInstance(node2)) continue;
                        if (!this.objects.contains(node2)) {
                            this.objects.add(node2);
                        }
                        if (this.connections.contains(connection)) continue;
                        this.connections.add(connection);
                    }
                }
                ++i;
            }
            j = this.objects.size();
        }
    }

    public void restoreConnections() {
        for (int i = 0; i < this.connections.size(); ++i) {
            CoConnection connection = (CoConnection)this.connections.get(i);
            CiConnectable source = connection.getSource();
            CiConnectable destination = connection.getDestination();
            if (source.getOutConnectionIndex(connection) >= 0 || destination.getInConnectionIndex(connection) >= 0) continue;
            connection.setSource(null);
            connection.setDestination(null);
            source.addConnection(connection, destination);
        }
    }

    public Vector getObjects() {
        return this.objects;
    }

    public void setObjects(Vector objects) {
        this.objects = objects;
    }

    public Vector getConnections() {
        return this.connections;
    }

    public void setConnections(Vector connections) {
        this.connections = connections;
    }

    public Object clone() {
        return new CoGraph(this);
    }
}

