/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.wizard;

import com.syllogic.miningmart.concepteditor.db.DBObject;
import com.syllogic.miningmart.concepteditor.db.DBUtil;
import com.syllogic.miningmart.concepteditor.dialogs.SelectUtility;
import com.syllogic.miningmart.concepteditor.util.Constants;
import com.syllogic.miningmart.concepteditor.util.PanelCreator;
import com.syllogic.miningmart.concepteditor.wizard.Wizard;
import com.syllogic.miningmart.concepteditor.wizard.WizardScreen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class M2mWizardScreen2
extends WizardScreen
implements ActionListener {
    private static Logger logger = Logger.getLogger((String)"M2mWizardSceen2");
    private static final String EMPTY_STRING = " ...                   ";
    private String titleText = "\n Step 1: Select a database object for the crosstable:\n";
    private JTextArea titleTextArea = new JTextArea(this.titleText);
    private JButton selectButton = new JButton("Select...");
    private JTextField dbObjectNameTextField = new JTextField();
    private JPanel buttonTextAreaPanel = new JPanel();
    private DBObject selectedDBObject = null;
    private Frame parentFrame = null;

    public M2mWizardScreen2() {
        this.initGUI();
    }

    public M2mWizardScreen2(Wizard wizard) {
        super(wizard);
        this.initGUI();
    }

    protected void initGUI() {
        this.setLayout(new GridLayout(1, 1));
        this.setBackground(Constants.LIGHT_GREY);
        PanelCreator aPanelCreator = new PanelCreator();
        GridBagConstraints defaultCon = new GridBagConstraints();
        this.titleTextArea.setEditable(false);
        this.titleTextArea.setLineWrap(true);
        this.titleTextArea.setWrapStyleWord(true);
        this.titleTextArea.setPreferredSize(new Dimension(580, 60));
        this.titleTextArea.setBackground(Constants.LIGHT_GREY);
        String fontName = this.titleTextArea.getFont().getName();
        this.titleTextArea.setFont(new Font(fontName, 1, 16));
        defaultCon.anchor = 17;
        defaultCon.gridx = 0;
        defaultCon.gridwidth = 0;
        defaultCon.weightx = 100.0;
        aPanelCreator.addComponent(null, (Component)this.titleTextArea, defaultCon);
        aPanelCreator.addEmptyLine();
        this.selectButton.setActionCommand("Select");
        this.selectButton.setMnemonic('S');
        this.selectButton.addActionListener(this);
        this.dbObjectNameTextField.setEditable(false);
        this.dbObjectNameTextField.setMinimumSize(new Dimension(30, 18));
        this.dbObjectNameTextField.setBackground(Constants.LIGHT_GREY);
        this.dbObjectNameTextField.setText(EMPTY_STRING);
        this.buttonTextAreaPanel.add(this.selectButton);
        this.buttonTextAreaPanel.add(this.dbObjectNameTextField);
        this.buttonTextAreaPanel.setBackground(Constants.LIGHT_GREY);
        defaultCon.anchor = 18;
        defaultCon.gridheight = 0;
        defaultCon.gridx = 0;
        defaultCon.weightx = 50.0;
        defaultCon.weighty = 1.0;
        defaultCon.gridwidth = 1;
        aPanelCreator.addComponent(null, (Component)this.buttonTextAreaPanel, defaultCon);
        JPanel centralPanel = aPanelCreator.getPanel();
        centralPanel.setBackground(Constants.LIGHT_GREY);
        this.add(centralPanel);
        this.setCanProceed(false);
    }

    protected void init() {
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("Select")) {
            this.doSelectDBObject();
        }
    }

    private void doSelectDBObject() {
        Collection dbObjects = DBUtil.getDBObjects();
        SelectUtility select = new SelectUtility();
        this.selectedDBObject = (DBObject)select.selectObject(this.parentFrame, "DBObject", dbObjects);
        if (this.selectedDBObject == null) {
            return;
        }
        String dbObjectName = this.selectedDBObject.getName();
        String dbObjectType = this.selectedDBObject.getType();
        this.dbObjectNameTextField.setText(dbObjectName);
        this.updateUI();
    }

    public boolean canProceed() {
        if (this.selectedDBObject != null) {
            this.screenInfo.clear();
            this.screenInfo.put("DBObject", this.selectedDBObject);
            return true;
        }
        return false;
    }

    public void setParentFrame(Frame parent) {
        this.parentFrame = parent;
    }
}

