/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.tree.TreeModel;

public class PanelCreator {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private JPanel panel = new JPanel(this.gridBagLayout);
    private int maxRow = -1;
    private Insets labelInsets = new Insets(0, 10, 0, 10);

    public JPanel getPanel() {
        return this.panel;
    }

    private void addLabel(int row, String txt) {
        this.addLabel(row, txt, null);
    }

    private void addLabel(int row, String txt, GridBagConstraints con) {
        JLabel lbl = new JLabel(txt);
        GridBagConstraints contraints = con;
        if (contraints == null) {
            contraints = new GridBagConstraints();
            contraints.gridx = 0;
            contraints.gridy = row;
            contraints.anchor = 13;
            contraints.fill = 0;
            contraints.insets = this.labelInsets;
        } else {
            contraints.gridx = 0;
            contraints.gridy = row;
            contraints.insets = this.labelInsets;
        }
        this.gridBagLayout.setConstraints(lbl, contraints);
        this.panel.add(lbl);
    }

    public void setLabelInsets(int top, int left, int bottom, int right) {
        this.labelInsets.top = top;
        this.labelInsets.left = left;
        this.labelInsets.bottom = bottom;
        this.labelInsets.right = right;
    }

    public JComboBox addComboBox(Object[] items) {
        JComboBox<Object> cb = new JComboBox<Object>(items);
        JScrollPane sp = new JScrollPane(cb);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 1;
        con.gridwidth = 0;
        con.gridy = this.maxRow;
        con.anchor = 17;
        con.fill = 2;
        con.weightx = 1.0;
        con.weighty = 1.0;
        this.gridBagLayout.setConstraints(sp, con);
        this.panel.add(sp);
        return cb;
    }

    public JTextField addTextField(String label, int width) {
        ++this.maxRow;
        if (label != null) {
            this.addLabel(this.maxRow, label);
        }
        JTextField tf = new JTextField(width);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 1;
        con.gridwidth = 2;
        con.gridy = this.maxRow;
        con.anchor = 17;
        con.fill = 0;
        this.gridBagLayout.setConstraints(tf, con);
        this.panel.add(tf);
        return tf;
    }

    public JTextField addTextField(int width) {
        return this.addTextField(null, width);
    }

    public JPasswordField addPasswordField(String label, int width) {
        ++this.maxRow;
        if (label != null) {
            this.addLabel(this.maxRow, label);
        }
        JPasswordField pf = new JPasswordField(width);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 1;
        con.gridwidth = 2;
        con.gridy = this.maxRow;
        con.anchor = 17;
        con.fill = 0;
        this.gridBagLayout.setConstraints(pf, con);
        this.panel.add(pf);
        return pf;
    }

    public JPasswordField addPasswordField(int width) {
        return this.addPasswordField(null, width);
    }

    public JList addJList(String label, ListModel theModel) {
        ++this.maxRow;
        if (label != null) {
            this.addLabel(this.maxRow, label);
        }
        JList lst = new JList(theModel);
        JScrollPane sp = new JScrollPane(lst);
        lst.setVisibleRowCount(5);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 1;
        con.gridwidth = 0;
        con.gridy = this.maxRow;
        con.anchor = 17;
        con.fill = 2;
        con.weightx = 1.0;
        con.weighty = 1.0;
        this.gridBagLayout.setConstraints(sp, con);
        this.panel.add(sp);
        return lst;
    }

    public JList addJList(ListModel theModel) {
        return this.addJList(null, theModel);
    }

    public JTree addJTree(String label, TreeModel theModel) {
        ++this.maxRow;
        if (label != null) {
            this.addLabel(this.maxRow, label);
        }
        JTree tree = new JTree(theModel);
        JScrollPane sp = new JScrollPane(tree);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 1;
        con.gridwidth = 0;
        con.gridy = this.maxRow;
        con.anchor = 17;
        con.fill = 0;
        this.gridBagLayout.setConstraints(sp, con);
        this.panel.add(sp);
        return tree;
    }

    public JTree addJTree(TreeModel theModel) {
        return this.addJTree(null, theModel);
    }

    public void addEmptyLine() {
        this.addComponent(null, (Component)new JLabel(" "), true);
    }

    public void addComponent(String label, Component theComp, boolean doStretch) {
        ++this.maxRow;
        if (label != null) {
            this.addLabel(this.maxRow, label);
        }
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 1;
        con.gridwidth = 0;
        con.gridy = this.maxRow;
        con.anchor = 17;
        con.fill = doStretch ? 1 : 0;
        this.gridBagLayout.setConstraints(theComp, con);
        this.panel.add(theComp);
    }

    public void addComponent(Component theComp, boolean doStretch) {
        this.addComponent(null, theComp, doStretch);
    }

    public void addComponent(String label, Component theComp) {
        this.addComponent(label, theComp, false);
    }

    public void addComponent(Component theComp) {
        this.addComponent(null, theComp, false);
    }

    public void addComponent(String label, GridBagConstraints labelCon, Component theComp, GridBagConstraints comCon) {
        ++this.maxRow;
        if (label != null) {
            this.addLabel(this.maxRow, label, labelCon);
        }
        comCon.gridy = this.maxRow;
        this.gridBagLayout.setConstraints(theComp, comCon);
        this.panel.add(theComp);
    }

    public void addComponent(String label, Component theComp, GridBagConstraints comCon) {
        this.addComponent(label, null, theComp, comCon);
    }
}

