/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.util;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.Relationship;
import org.apache.log4j.Logger;

public class MyListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static Logger logger = Logger.getLogger((String)"MyListCellRenderer");
    private String imagePath = "com/syllogic/miningmart/concepteditor/images/";
    private ImageIcon validIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "valid_ico.gif"));
    private ImageIcon invalidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "invalid_ico.gif"));
    private ImageIcon dbValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "db_valid_ico.gif"));
    private ImageIcon dbInvalidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "db_invalid_ico.gif"));
    private ImageIcon miningValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "mining_valid_ico.gif"));
    private ImageIcon miningInvalidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "mining_invalid_ico.gif"));
    private ImageIcon baseValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "base_valid_ico.gif"));
    private ImageIcon baseInvalidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "base_invalid_ico.gif"));

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof BaseAttribute) {
            BaseAttribute aBaseAttribute = (BaseAttribute)value;
            this.setText(aBaseAttribute.getName());
            String type = aBaseAttribute.getAttributeType();
            if (type != null) {
                if (type.equals("BASE")) {
                    this.setIcon(aBaseAttribute.isRelationallyValid() ? this.baseValidIcon : this.baseInvalidIcon);
                } else if (type.equals("DB")) {
                    this.setIcon(aBaseAttribute.isRelationallyValid() ? this.dbValidIcon : this.dbInvalidIcon);
                } else if (type.equals("MINING")) {
                    this.setIcon(aBaseAttribute.isRelationallyValid() ? this.miningValidIcon : this.miningInvalidIcon);
                }
            }
        } else if (value instanceof Concept) {
            Concept aConcept = (Concept)value;
            this.setText(aConcept.getName());
            this.setIcon(aConcept.isRelationallyValid() ? this.validIcon : this.invalidIcon);
        } else if (value instanceof MultiColumnFeature) {
            MultiColumnFeature aMultiColumnFeature = (MultiColumnFeature)value;
            this.setText(aMultiColumnFeature.getName());
            this.setIcon(aMultiColumnFeature.isRelationallyValid() ? this.validIcon : this.invalidIcon);
        } else if (value instanceof ColumnSet) {
            ColumnSet aColumnSet = (ColumnSet)value;
            String name = aColumnSet.getName();
            String msBranch = aColumnSet.getMultiStepBranch();
            String text = msBranch != null ? name + " " + msBranch : name;
            this.setText(text);
            this.setIcon(null);
        } else if (value instanceof Column) {
            Column aColumn = (Column)value;
            this.setText(aColumn.getName());
            this.setIcon(null);
        } else if (value instanceof Relationship) {
            Relationship aRelationship = (Relationship)value;
            this.setText(aRelationship.getName());
            this.setIcon(aRelationship.isRelationallyValid() ? this.validIcon : this.invalidIcon);
        } else {
            this.setText(value.toString());
            this.setIcon(this.invalidIcon);
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setOpaque(true);
        return this;
    }
}

