/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.util;

import com.syllogic.miningmart.concepteditor.dialogs.SelectUtility;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import java.util.Iterator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.ForeignKey;
import miningmart.m4.M4Interface;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.NameExistsException;
import miningmart.m4.PrimaryKey;
import miningmart.m4.Relationship;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ConceptCopier {
    private static Logger logger;
    private static M4Interface myInterface;

    private static void initLogger() {
        PropertyConfigurator.configure((String)"log4j.properties");
        logger = Logger.getLogger((String)"M4Test");
    }

    public static void copyConcepts(Collection selectedConcepts, Case newCase) {
        Concept aConcept;
        ConceptCopier.initLogger();
        Iterator i = selectedConcepts.iterator();
        while (i.hasNext()) {
            aConcept = (Concept)i.next();
            try {
                Concept newConcept = aConcept.copy(newCase);
                if (newConcept == null) continue;
                logger.info((Object)("Concept copied: " + newConcept.getName()));
                newConcept.store();
                logger.info((Object)("Concept stored: " + newConcept.getName()));
                Collection baseAttributes = aConcept.getAllBaseAttributes();
                ConceptCopier.copyBaseAttributes(baseAttributes, newConcept);
                Collection multiColumnFeatures = aConcept.getAllMultiColumnFeatures();
                ConceptCopier.copyMultiColumnFeatures(multiColumnFeatures, newConcept);
                Collection columnSets = aConcept.getAllColumnSets();
                ConceptCopier.copyColumnSets(columnSets, newConcept);
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a Concept ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"Concept name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a Concept ", (Throwable)e);
            }
        }
        i = selectedConcepts.iterator();
        while (i.hasNext()) {
            aConcept = (Concept)i.next();
            String aConceptName = aConcept.getName();
            Concept newConcept = newCase.getConcept(aConceptName);
            Collection subConcepts = aConcept.getAllSubConcepts();
            ConceptCopier.copySubConcepts(subConcepts, newCase, newConcept);
            Collection toProjections = aConcept.getAllToProjections();
            ConceptCopier.copyProjections(toProjections, newCase, newConcept);
            Collection fromRelationships = aConcept.getAllFromConceptRelationships();
            ConceptCopier.copyRelationships(fromRelationships, newCase, newConcept);
            Collection columnSets = aConcept.getAllColumnSets();
            ConceptCopier.copyPrimaryKey(columnSets, newCase, newConcept);
            ConceptCopier.copyForeignKeys(columnSets, newCase, newConcept);
        }
    }

    public static void copyBaseAttributes(Collection baseAttributes, Concept newConcept) {
        Iterator i = baseAttributes.iterator();
        while (i.hasNext()) {
            BaseAttribute aBaseAttribute = (BaseAttribute)i.next();
            try {
                BaseAttribute newBaseAttribute = aBaseAttribute.copy(newConcept);
                logger.info((Object)("BaseAttribute copied: " + newBaseAttribute.getName()));
                newBaseAttribute.store();
                logger.info((Object)("BaseAttribute stored: " + newBaseAttribute.getName()));
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a BaseAttribute ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"BaseAttribute name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a BaseAttribute ", (Throwable)e);
            }
        }
    }

    public static void copyMultiColumnFeatures(Collection multiColumnFeatures, Concept newConcept) {
        Iterator i = multiColumnFeatures.iterator();
        while (i.hasNext()) {
            MultiColumnFeature aMultiColumnFeature = (MultiColumnFeature)i.next();
            try {
                MultiColumnFeature newMultiColumnFeature = aMultiColumnFeature.copy(newConcept);
                logger.info((Object)("MultiColumnFeature copied: " + newMultiColumnFeature.getName()));
                newMultiColumnFeature.store();
                logger.info((Object)("MultiColumnFeature stored: " + newMultiColumnFeature.getName()));
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a MultiColumnFeature ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"MultiColumnFeature name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a MultiColumnFeature ", (Throwable)e);
            }
        }
    }

    public static void copyColumnSets(Collection columnSets, Concept newConcept) {
        Iterator i = columnSets.iterator();
        while (i.hasNext()) {
            ColumnSet aColumnSet = (ColumnSet)i.next();
            try {
                ColumnSet newColumnSet = aColumnSet.copy(newConcept);
                logger.info((Object)("ColumnSet copied: " + newColumnSet.getName()));
                newColumnSet.store();
                logger.info((Object)("ColumnSet stored: " + newColumnSet.getName()));
                ConceptCopier.copyColumns(aColumnSet, newConcept, newColumnSet);
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a ColumnSet ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"ColumnSet name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a ColumnSet ", (Throwable)e);
            }
        }
    }

    public static void copyColumns(ColumnSet aColumnSet, Concept newConcept, ColumnSet newColumnSet) {
        Collection Columns = aColumnSet.getAllColumns();
        Iterator i = Columns.iterator();
        while (i.hasNext()) {
            Column aColumn = (Column)i.next();
            try {
                Column newColumn = aColumn.copy(newColumnSet);
                logger.info((Object)("Column copied: " + newColumn.getName()));
                newColumn.store();
                logger.info((Object)("Column stored: " + newColumn.getName()));
                BaseAttribute aBaseAttribute = aColumn.getBaseAttribute();
                if (aBaseAttribute == null) continue;
                String aBaseAttributeName = aBaseAttribute.getName();
                BaseAttribute newBaseAttribute = newConcept.getBaseAttribute(aBaseAttributeName);
                newColumn.setBaseAttribute(newBaseAttribute);
                logger.info((Object)("BaseAttribute " + newBaseAttribute.getName() + " connected to Column  " + newColumn.getName()));
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a Column ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"Column name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a Column ", (Throwable)e);
            }
        }
    }

    public static void copySubConcepts(Collection subConcepts, Case newCase, Concept newConcept) {
        Iterator i = subConcepts.iterator();
        while (i.hasNext()) {
            Concept subConcept = (Concept)i.next();
            String subConceptName = subConcept.getName();
            Concept newSubConcept = newCase.getConcept(subConceptName);
            try {
                if (newSubConcept == null) continue;
                newConcept.addSubConcept(newSubConcept);
                logger.info((Object)("SubConcept copied: " + newSubConcept.getName()));
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a SubConcept relation ", (Throwable)e);
            }
        }
    }

    public static void copyProjections(Collection toProjections, Case newCase, Concept newConcept) {
        Iterator i = toProjections.iterator();
        while (i.hasNext()) {
            Concept toConcept = (Concept)i.next();
            String toConceptName = toConcept.getName();
            Concept newToConcept = newCase.getConcept(toConceptName);
            try {
                if (newToConcept == null) continue;
                newToConcept.setFromProjection(newConcept);
                logger.info((Object)("Projection copied: " + newToConcept.getName()));
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a Projection relation ", (Throwable)e);
            }
        }
    }

    public static void copyRelationships(Collection fromRelationships, Case newCase, Concept newFromConcept) {
        Iterator i = fromRelationships.iterator();
        while (i.hasNext()) {
            Relationship aRelationship = (Relationship)i.next();
            Concept toConcept = aRelationship.getToConcept();
            Concept newToConcept = null;
            if (toConcept != null) {
                String toConceptName = toConcept.getName();
                newToConcept = newCase.getConcept(toConceptName);
            }
            try {
                Relationship newRelationship = aRelationship.copy(newFromConcept, newToConcept);
                logger.info((Object)("Relationship copied: " + newRelationship.getName()));
                newRelationship.store();
                logger.info((Object)("Relationship stored: " + newRelationship.getName()));
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a Relationship ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"Relationship name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a Relationship ", (Throwable)e);
            }
        }
    }

    public static void copyPrimaryKey(Collection columnSets, Case newCase, Concept newConcept) {
        Iterator i = columnSets.iterator();
        while (i.hasNext()) {
            ColumnSet aColumnSet = (ColumnSet)i.next();
            String aColumnSetName = aColumnSet.getName();
            ColumnSet newColumnSet = newConcept.getColumnSet(aColumnSetName);
            PrimaryKey aPrimaryKey = aColumnSet.getPrimaryKey();
            if (aPrimaryKey == null) continue;
            try {
                PrimaryKey newPrimaryKey = aPrimaryKey.copy(newColumnSet);
                logger.info((Object)("PrimaryKey copied: " + newPrimaryKey.getName()));
                newPrimaryKey.store();
                logger.info((Object)("PrimaryKey stored: " + newPrimaryKey.getName()));
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a PrimaryKey ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"PrimaryKey name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a PrimaryKey ", (Throwable)e);
            }
        }
    }

    public static void copyForeignKeys(Collection columnSets, Case newCase, Concept newConcept) {
        Iterator i = columnSets.iterator();
        while (i.hasNext()) {
            ColumnSet aColumnSet = (ColumnSet)i.next();
            String aColumnSetName = aColumnSet.getName();
            ColumnSet newColumnSet = newConcept.getColumnSet(aColumnSetName);
            Collection ForeignKeys = aColumnSet.getAllForeignKeys();
            Iterator j = ForeignKeys.iterator();
            while (j.hasNext()) {
                ForeignKey aForeignKey = (ForeignKey)j.next();
                try {
                    ForeignKey newForeignKey = aForeignKey.copy(newColumnSet);
                    logger.info((Object)("ForeignKey copied: " + newForeignKey.getName()));
                    newForeignKey.store();
                    logger.info((Object)("ForeignKey stored: " + newForeignKey.getName()));
                }
                catch (CreateException e) {
                    logger.error((Object)"Exception while creating a ForeignKey ", (Throwable)e);
                }
                catch (NameExistsException e) {
                    logger.error((Object)"ForeignKey name already exists!");
                }
                catch (StorageException e) {
                    logger.error((Object)"Exception while storing a ForeignKey ", (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) {
        ConceptCopier.initLogger();
        M4Interface myInterface = M4Interface.getInstance();
        String dummyCaseName = "Dummy Case";
        Case dummyCase = null;
        try {
            dummyCase = myInterface.findCaseForUpdate(dummyCaseName, true);
            if (dummyCase == null) {
                logger.info((Object)("Case " + dummyCaseName + " not found!"));
                System.exit(0);
            }
            logger.info((Object)("Case found: " + dummyCaseName));
        }
        catch (M4Interface.CaseLockedException e) {
            logger.error((Object)"Case locked! Unlock case first.");
            System.exit(0);
        }
        Collection allCaseNames = myInterface.getAllCaseNames();
        SelectUtility select = new SelectUtility();
        Frame testFrame = new Frame();
        ((Component)testFrame).setBounds(100, 100, 60, 40);
        ((Component)testFrame).setVisible(true);
        String aCaseName = (String)select.selectObject(testFrame, "CaseName", allCaseNames);
        if (aCaseName == null) {
            myInterface.releaseCase(dummyCaseName);
            System.exit(0);
        }
        Case aCase = null;
        try {
            aCase = myInterface.findCaseForReadOnlyAccess(aCaseName, false);
            if (aCase == null) {
                logger.info((Object)("Case " + aCaseName + " not found!"));
                System.exit(0);
            }
            logger.info((Object)("Case found: " + aCase.getName()));
        }
        catch (M4Interface.CaseLockedException e) {
            logger.error((Object)"Case locked! Unlock case first.");
            System.exit(0);
        }
        logger.info((Object)("Case to be copied: " + aCase.getName()));
        Collection allConcepts = aCase.getAllConcepts();
        Collection selectedConcepts = select.selectObjects(testFrame, "Concept", allConcepts);
        if (selectedConcepts != null) {
            ConceptCopier.copyConcepts(selectedConcepts, dummyCase);
        }
        myInterface.releaseCase(aCaseName);
        myInterface.releaseCase(dummyCaseName);
        System.exit(0);
    }

    static {
        myInterface = null;
    }
}

