/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.util;

import com.syllogic.miningmart.concepteditor.dialogs.SelectUtility;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import java.util.Iterator;
import miningmart.m4.Case;
import miningmart.m4.Chain;
import miningmart.m4.CreateException;
import miningmart.m4.M4Interface;
import miningmart.m4.NameExistsException;
import miningmart.m4.Parameter;
import miningmart.m4.Step;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ChainCopier {
    private static Logger logger;
    private static M4Interface myInterface;

    private static void initLogger() {
        PropertyConfigurator.configure((String)"log4j.properties");
        logger = Logger.getLogger((String)"M4Test");
    }

    public static void copyChains(Collection selectedChains, Case newCase) {
        ChainCopier.initLogger();
        Iterator i = selectedChains.iterator();
        while (i.hasNext()) {
            Chain aChain = (Chain)i.next();
            try {
                Chain newChain = aChain.copy(newCase);
                if (newChain == null) continue;
                logger.info((Object)("Chain copied: " + newChain.getName()));
                newChain.store();
                logger.info((Object)("Chain stored: " + newChain.getName()));
                Collection steps = aChain.getAllSteps();
                ChainCopier.copySteps(steps, newCase, newChain);
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a Chain ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"Chain name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a Chain ", (Throwable)e);
            }
        }
    }

    public static void copySteps(Collection steps, Case newCase, Chain newChain) {
        Step aStep;
        Iterator i = steps.iterator();
        while (i.hasNext()) {
            aStep = (Step)i.next();
            try {
                Step newStep = aStep.copy(newCase, newChain);
                if (newStep == null) continue;
                logger.info((Object)("Step copied: " + newStep.getName()));
                newStep.store();
                logger.info((Object)("Step stored: " + newStep.getName()));
                Collection parameters = aStep.getAllParameters();
                ChainCopier.copyParameters(parameters, newStep);
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a Step ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"Step name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a Step ", (Throwable)e);
            }
        }
        i = steps.iterator();
        while (i.hasNext()) {
            aStep = (Step)i.next();
            ChainCopier.copyStepSequences(aStep, newCase);
        }
    }

    public static void copyParameters(Collection parameters, Step newStep) {
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            Parameter aParameter = (Parameter)i.next();
            try {
                Parameter newParameter = aParameter.copy(newStep);
                logger.info((Object)("Parameter copied: " + newParameter.getParameterName()));
                newParameter.store();
                logger.info((Object)("Parameter stored: " + newParameter.getParameterName()));
            }
            catch (CreateException e) {
                logger.error((Object)"Exception while creating a Parameter ", (Throwable)e);
            }
            catch (NameExistsException e) {
                logger.error((Object)"Parameter name already exists!");
            }
            catch (StorageException e) {
                logger.error((Object)"Exception while storing a Parameter ", (Throwable)e);
            }
        }
    }

    public static void copyStepSequences(Step aStep, Case newCase) {
        String aStepName = aStep.getName();
        Step newStep = newCase.getStep(aStepName);
        Collection Successors = aStep.getAllSuccessors();
        Iterator i = Successors.iterator();
        while (i.hasNext()) {
            Step successor = (Step)i.next();
            String successorName = successor.getName();
            Step newSuccessor = newCase.getStep(successorName);
            if (newSuccessor == null) continue;
            newStep.addSuccessor(newSuccessor);
            logger.info((Object)("StepSequence copied: " + newSuccessor.getName()));
        }
    }

    public static void main(String[] args) {
        ChainCopier.initLogger();
        M4Interface myInterface = M4Interface.getInstance();
        String dummyCaseName = "Dummy Case";
        Case dummyCase = null;
        try {
            dummyCase = myInterface.findCaseForUpdate(dummyCaseName, true);
            if (dummyCase == null) {
                logger.info((Object)("Case " + dummyCaseName + " not found!"));
                System.exit(0);
            }
            logger.info((Object)("Case found: " + dummyCaseName));
        }
        catch (M4Interface.CaseLockedException e) {
            logger.error((Object)"Case locked! Unlock case first.");
            System.exit(0);
        }
        Collection allCaseNames = myInterface.getAllCaseNames();
        SelectUtility select = new SelectUtility();
        Frame testFrame = new Frame();
        ((Component)testFrame).setBounds(100, 100, 60, 40);
        ((Component)testFrame).setVisible(true);
        String aCaseName = (String)select.selectObject(testFrame, "CaseName", allCaseNames);
        if (aCaseName == null) {
            myInterface.releaseCase(dummyCaseName);
            System.exit(0);
        }
        Case aCase = null;
        try {
            aCase = myInterface.findCaseForReadOnlyAccess(aCaseName, false);
            if (aCase == null) {
                logger.info((Object)("Case " + aCaseName + " not found!"));
                System.exit(0);
            }
            logger.info((Object)("Case found: " + aCase.getName()));
        }
        catch (M4Interface.CaseLockedException e) {
            logger.error((Object)"Case locked! Unlock case first.");
            System.exit(0);
        }
        logger.info((Object)("Case to be copied: " + aCase.getName()));
        Collection allChains = aCase.getAllChains();
        Collection selectedChains = select.selectObjects(testFrame, "Chain", allChains);
        if (selectedChains != null) {
            ChainCopier.copyChains(selectedChains, dummyCase);
        }
        myInterface.releaseCase(aCaseName);
        myInterface.releaseCase(dummyCaseName);
        System.exit(0);
    }

    static {
        myInterface = null;
    }
}

