/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.tree;

import com.syllogic.miningmart.concepteditor.tree.TreeNodeObject;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import miningmart.m4.Concept;
import miningmart.m4.Relationship;
import org.apache.log4j.Logger;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private static Logger logger = Logger.getLogger((String)"TreeCellRenderer");
    private String imagePath = "com/syllogic/miningmart/concepteditor/images/";
    ImageIcon conceptDBValidIcon;
    ImageIcon conceptDBInValidIcon;
    ImageIcon conceptBaseValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "base_valid_ico.gif"));
    ImageIcon conceptBaseInValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "base_invalid_ico.gif"));
    ImageIcon conceptMiningValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "mining_valid_ico.gif"));
    ImageIcon conceptMiningInValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "mining_invalid_ico.gif"));
    ImageIcon relationshipValidIcon;
    ImageIcon relationshipInValidIcon;
    ImageIcon attributeIcon;

    public TreeCellRenderer() {
        this.conceptDBValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "db_valid_ico.gif"));
        this.conceptDBInValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "db_invalid_ico.gif"));
        this.relationshipValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "valid_ico.gif"));
        this.relationshipInValidIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "invalid_ico.gif"));
        this.attributeIcon = new ImageIcon(ClassLoader.getSystemResource(this.imagePath + "attribute_ico.gif"));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object nodeUserObject = node.getUserObject();
        TreeNodeObject nodeInfo = !(nodeUserObject instanceof TreeNodeObject) ? new TreeNodeObject() : (TreeNodeObject)nodeUserObject;
        if (this.isConcept(nodeInfo)) {
            Concept aConcept = (Concept)nodeInfo.getObject();
            if (aConcept.getConceptType().equalsIgnoreCase("BASE")) {
                if (aConcept.isRelationallyValid()) {
                    this.setIcon(this.conceptBaseValidIcon);
                } else {
                    this.setIcon(this.conceptBaseInValidIcon);
                }
            }
            if (aConcept.getConceptType().equalsIgnoreCase("MINING")) {
                if (aConcept.isRelationallyValid()) {
                    this.setIcon(this.conceptMiningValidIcon);
                } else {
                    this.setIcon(this.conceptMiningInValidIcon);
                }
            }
            if (aConcept.getConceptType().equalsIgnoreCase("DB")) {
                if (aConcept.isRelationallyValid()) {
                    this.setIcon(this.conceptDBValidIcon);
                } else {
                    this.setIcon(this.conceptDBInValidIcon);
                }
            }
        } else if (this.isRelationship(nodeInfo)) {
            Relationship aRelationship = (Relationship)nodeInfo.getObject();
            if (aRelationship.isRelationallyValid()) {
                this.setIcon(this.relationshipValidIcon);
            } else {
                this.setIcon(this.relationshipInValidIcon);
            }
        } else if (this.isBaseAttribute(nodeInfo)) {
            this.setIcon(this.attributeIcon);
        } else if (this.isMultiColumnFeature(nodeInfo)) {
            this.setIcon(this.attributeIcon);
        }
        return this;
    }

    private boolean isConcept(TreeNodeObject treeNodeObject) {
        return treeNodeObject.getNodeType().equals("Concept");
    }

    private boolean isRelationship(TreeNodeObject treeNodeObject) {
        return treeNodeObject.getNodeType().equals("Relationship");
    }

    private boolean isBaseAttribute(TreeNodeObject treeNodeObject) {
        return treeNodeObject.getNodeType().equals("BaseAttribute");
    }

    private boolean isMultiColumnFeature(TreeNodeObject treeNodeObject) {
        return treeNodeObject.getNodeType().equals("MultiColumnFeature");
    }
}

