/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.db.DBConnectInfo;
import com.syllogic.miningmart.concepteditor.db.DBObject;
import com.syllogic.miningmart.concepteditor.db.DBUtil;
import com.syllogic.miningmart.concepteditor.util.Task;
import com.syllogic.miningmart.m4.Column;
import com.syllogic.miningmart.m4.ForeignKey;
import java.awt.Frame;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import miningmart.m4.ColumnSet;
import miningmart.m4.CreateException;
import miningmart.m4.NameExistsException;
import miningmart.m4.Relationship;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;

public class TaskCreateM2mRelation
implements Task {
    private static Logger logger = Logger.getLogger((String)"TaskCreateM2mRelation");
    Map inputMap = null;
    Relationship relation;
    ColumnSet fromColumnSet;
    ColumnSet toColumnSet;
    Frame parentFrame;

    public TaskCreateM2mRelation(Frame parentFrame, Relationship relationship, ColumnSet fromColumnSet, ColumnSet toColumnSet) {
        this.relation = relationship;
        this.fromColumnSet = fromColumnSet;
        this.toColumnSet = toColumnSet;
        this.parentFrame = parentFrame;
    }

    public void execute() {
        DBObject dbObject = (DBObject)this.inputMap.get("DBObject");
        List dbObjectColumnNames = (List)this.inputMap.get("DBObjectColumnNames");
        List dbObjectColumnTypes = (List)this.inputMap.get("DBObjectColumnTypes");
        Map toColumnSetColumnMap = (Map)this.inputMap.get("ToColumnSetColumns");
        Map fromColumnSetColumnMap = (Map)this.inputMap.get("FromColumnSetColumns");
        Map toColumnSetCrosstableColumnMap = (Map)this.inputMap.get("ToColumnSetCrosstableColumns");
        Map fromColumnSetCrosstableColumnMap = (Map)this.inputMap.get("FromColumnSetCrosstableColumns");
        String schema = DBConnectInfo.getDBConnectInfo().getUsername();
        ColumnSet crosstableColumnSet = this.createColumnSet(dbObject, schema);
        if (crosstableColumnSet == null) {
            return;
        }
        this.createColumns(crosstableColumnSet, dbObjectColumnNames, dbObjectColumnTypes);
        String foreignKeyName = crosstableColumnSet.getName() + "_" + this.fromColumnSet.getName() + "_FK";
        miningmart.m4.ForeignKey fromForeignKey = this.createForeignKey(crosstableColumnSet, this.fromColumnSet, foreignKeyName);
        if (fromForeignKey == null) {
            return;
        }
        this.addFKMembers(fromForeignKey, crosstableColumnSet, this.fromColumnSet, fromColumnSetCrosstableColumnMap, fromColumnSetColumnMap);
        foreignKeyName = crosstableColumnSet.getName() + "_" + this.toColumnSet.getName() + "_FK";
        miningmart.m4.ForeignKey toForeignKey = this.createForeignKey(crosstableColumnSet, this.toColumnSet, foreignKeyName);
        if (toForeignKey == null) {
            return;
        }
        this.addFKMembers(toForeignKey, crosstableColumnSet, this.toColumnSet, toColumnSetCrosstableColumnMap, toColumnSetColumnMap);
        try {
            this.relation.setM2mKeys(fromForeignKey, toForeignKey);
            this.relation.store();
        }
        catch (StorageException e) {
            logger.error((Object)"Failed to store Relationship: ");
            String message = "Failed to store Relationship: ";
            JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
        }
    }

    private ColumnSet createColumnSet(DBObject dbObject, String schema) {
        String dbObjectName = dbObject.getName();
        String type = null;
        if (dbObject.getType() == "TABLE") {
            type = "T";
        } else if (dbObject.getType() == "VIEW") {
            type = "V";
        }
        ColumnSet crosstableColumnSet = null;
        try {
            crosstableColumnSet = this.relation.createColumnSet(dbObjectName, schema, type);
            crosstableColumnSet.store();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ColumnSet created: " + dbObjectName));
                logger.debug((Object)("id = " + ((com.syllogic.miningmart.m4.ColumnSet)crosstableColumnSet).getId()));
            }
        }
        catch (CreateException e) {
            logger.error((Object)("Failed to create ColumnSet: " + dbObjectName));
            String message = "Failed to create ColumnSet: " + dbObjectName;
            JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
            return null;
        }
        catch (NameExistsException e) {
            logger.error((Object)"Failed to create ColumnSet; name exists already");
            String message = "Failed to create ColumnSet: " + dbObjectName + "\n" + "Name exists already!";
            JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
            return null;
        }
        catch (StorageException e) {
            logger.error((Object)("Failed to store ColumnSet: " + dbObjectName));
            String message = "Failed to store ColumnSet: " + dbObjectName;
            JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
            return null;
        }
        return crosstableColumnSet;
    }

    private void createColumns(ColumnSet columnSet, List names, List types) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String aColumnName = (String)i.next();
            int index = names.indexOf(aColumnName);
            String aType = (String)types.get(index);
            aType = DBUtil.convertOracleDatatype(aType);
            try {
                miningmart.m4.Column aColumn = columnSet.createColumn(aColumnName, aType);
                aColumn.store();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Column created: " + aColumnName));
                logger.debug((Object)("id = " + ((Column)aColumn).getId()));
            }
            catch (CreateException e) {
                logger.error((Object)("Failed to create Column: " + aColumnName));
                String message = "Failed to create ColumnSet: " + aColumnName;
                JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
                return;
            }
            catch (NameExistsException e) {
                logger.error((Object)"Failed to create Column; name exists already");
                String message = "Failed to create Column: " + aColumnName + "\n" + "Name exists already!";
                JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
                return;
            }
            catch (StorageException e) {
                logger.error((Object)("Failed to store Column: " + aColumnName));
                String message = "Failed to store Column: " + aColumnName;
                JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
                return;
            }
        }
    }

    private miningmart.m4.ForeignKey createForeignKey(ColumnSet columnSet, ColumnSet toColumnSet, String name) {
        miningmart.m4.ForeignKey foreignKey = null;
        try {
            foreignKey = columnSet.createForeignKey(name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ForeignKey created");
            }
            foreignKey.setIsConnectionTo(toColumnSet);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ForeignKey connected to its toColumnSet");
            }
            foreignKey.store();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ForeignKey id = " + ((ForeignKey)foreignKey).getId()));
            }
        }
        catch (NameExistsException e) {
            this.showConnectionFailedMessage("ForeignKey name already exists.");
            return null;
        }
        catch (CreateException e) {
            this.showConnectionFailedMessage("Failed to create a ForeignKey.");
            return null;
        }
        catch (StorageException e) {
            this.showConnectionFailedMessage("Failed to store the ForeignKey.");
            return null;
        }
        return foreignKey;
    }

    private void addFKMembers(miningmart.m4.ForeignKey foreignKey, ColumnSet fkColumnSet, ColumnSet pkColumnSet, Map fkColumnNamesMap, Map pkColumnNamesMap) {
        HashMap<String, String> cleanedKeyMap = new HashMap<String, String>();
        int i = 0;
        while (i < fkColumnNamesMap.size()) {
            String aFkColumnName = (String)fkColumnNamesMap.get(new Integer(i));
            String aPkColumnName = (String)pkColumnNamesMap.get(new Integer(i));
            if (!aFkColumnName.equals("<NONE...>") && !aPkColumnName.equals("<NONE...>")) {
                cleanedKeyMap.put(aFkColumnName, aPkColumnName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("FK Column: " + aFkColumnName + " maps to -> PK Column: " + aPkColumnName));
                }
            }
            ++i;
        }
        Iterator i2 = cleanedKeyMap.keySet().iterator();
        while (i2.hasNext()) {
            String aFkColumnName = (String)i2.next();
            miningmart.m4.Column aFkColumn = fkColumnSet.getColumn(aFkColumnName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(aFkColumn != null ? "Column found for: " + aFkColumnName : "No Column found for: " + aFkColumnName + "!!!"));
            }
            String aPkColumnName = (String)cleanedKeyMap.get(aFkColumnName);
            miningmart.m4.Column aPkColumn = pkColumnSet.getColumn(aPkColumnName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(aPkColumn != null ? "Column found for: " + aPkColumnName : "No Column found for: " + aPkColumnName + "!!!"));
            }
            try {
                foreignKey.addColumn(aFkColumn, aPkColumn);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Column " + aFkColumn.getName() + " added to ForeignKey"));
            }
            catch (StorageException e) {
                this.showConnectionFailedMessage("Failed to add column to the ForeignKey.");
            }
        }
    }

    private void showConnectionFailedMessage(String extraInfo) {
        logger.error((Object)"Failed to define Relationship at the data level.");
        String message = "Failed to define Relationship at the data level.\n" + extraInfo;
        JOptionPane.showMessageDialog(this.parentFrame, message, "Error...", 0);
    }

    public void setInput(Map input) {
        this.inputMap = input;
    }
}

