/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class SimpleListDialog
extends JDialog
implements ActionListener,
Closeable {
    private DefaultListModel listModel = new DefaultListModel();
    private JList list = new JList(this.listModel);
    private JScrollPane listScrollPane = new JScrollPane(this.list);
    private JButton cancelButton;
    private JButton okButton;
    private JPanel buttonPanel;
    private Container contentPane;
    private Object[] selections;
    private ArrayList selectedValues;
    private boolean cancelPressed;

    public SimpleListDialog() {
        this.initGUI();
    }

    public SimpleListDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initGUI();
        this.centralize();
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    private void initGUI() {
        this.setTitle("Select...");
        this.buttonPanel = new JPanel();
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.contentPane.add("South", this.buttonPanel);
        this.list.setSelectionMode(0);
        this.contentPane.add("Center", this.listScrollPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SimpleListDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.pack();
    }

    public void clear() {
        this.cancelPressed = false;
        this.listModel.clear();
    }

    public void fillList(Collection values, boolean sort) {
        this.listModel.clear();
        ArrayList aList = new ArrayList();
        aList.addAll(values);
        if (sort) {
            Collections.sort(aList);
        }
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            Object aValue = i.next();
            this.listModel.addElement(aValue);
        }
    }

    public void setList(JList list) {
        this.list = list;
    }

    public void setListModel(ListModel listModel) {
        this.list.setModel(listModel);
    }

    public void setSingleSelection() {
        this.list.setSelectionMode(0);
    }

    public void setMultipleSelection() {
        this.list.setSelectionMode(2);
    }

    public void setTitle(String title) {
        super.setTitle(title);
        int preferredWidth = this.getFontMetrics(this.getFont()).stringWidth(title) + 75;
        if (preferredWidth < 250) {
            preferredWidth = 250;
        }
        int preferredHeight = 300;
        ((Component)this).setSize(preferredWidth, preferredHeight);
    }

    public Collection getSelectedValues() {
        return this.selectedValues;
    }

    public boolean cancelPressed() {
        return this.cancelPressed;
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        String cmd = evt.getActionCommand();
        if (cmd.equals("OK")) {
            this.doOk();
        } else if (cmd.equals("Cancel")) {
            this.doCancel();
        }
    }

    protected void doOk() {
        this.selections = this.list.getSelectedValues();
        this.selectedValues = new ArrayList();
        int i = 0;
        while (i < this.selections.length) {
            String aName = (String)this.selections[i];
            this.selectedValues.add(aName);
            ++i;
        }
        ((Component)this).setVisible(false);
    }

    protected void doCancel() {
        this.close();
    }

    public void close() {
        this.cancelPressed = true;
        ((Component)this).setVisible(false);
    }
}

