/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.ConceptEditor;
import com.syllogic.miningmart.concepteditor.dialogs.DialogManager;
import com.syllogic.miningmart.concepteditor.dialogs.RelationshipConnectionPanel;
import com.syllogic.miningmart.concepteditor.dialogs.RelationshipDescriptionPanel;
import com.syllogic.miningmart.concepteditor.dialogs.RelationshipPropertiesPanel;
import com.syllogic.miningmart.concepteditor.dialogs.TaskCreateM2mRelation;
import com.syllogic.miningmart.concepteditor.event.RelationshipEvent;
import com.syllogic.miningmart.concepteditor.event.RelationshipListener;
import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import com.syllogic.miningmart.concepteditor.util.MyListModel;
import com.syllogic.miningmart.concepteditor.wizard.M2mWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.ForeignKey;
import miningmart.m4.M4Interface;
import miningmart.m4.MultipleResultException;
import miningmart.m4.NameExistsException;
import miningmart.m4.PrimaryKey;
import miningmart.m4.Relationship;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;

public class RelationshipDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"RelationshipDialog");
    private MyListModel fromConceptListModel = new MyListModel();
    private MyListModel toConceptListModel = new MyListModel();
    private MyListModel superRelationshipListModel = new MyListModel();
    private Relationship currentRelationship;
    private Map relationshipsMap = new HashMap();
    private DialogManager dialogManager;
    private Frame parentFrame;
    private ArrayList listenerList = new ArrayList();
    private boolean nameChanged;
    private boolean toConceptChanged;
    private boolean fromConceptChanged;
    private boolean superRelationshipChanged;
    private boolean validityChanged;
    private Concept toConcept = null;
    private Concept fromConcept = null;
    private ColumnSet fromConceptColumnSet = null;
    private ColumnSet toConceptColumnSet = null;
    private String foreignKeyName = null;
    private String toConceptForeignKeyName = null;
    private String[] dummyConcepts = new String[]{"Partner", "Contract"};
    private int numberOfProperties = 4;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel southPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JTextArea messageTextArea = new JTextArea();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton helpButton = new JButton();
    private RelationshipPropertiesPanel propertiesTab = new RelationshipPropertiesPanel();
    private RelationshipConnectionPanel connectTab = new RelationshipConnectionPanel();
    private RelationshipDescriptionPanel descriptionTab = new RelationshipDescriptionPanel();
    private boolean inputOK;

    public RelationshipDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setParent(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Relationship properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RelationshipDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.dialogManager = new DialogManager(this.parentFrame);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.southPanel.add((Component)this.buttonPanel, "North");
        this.messageTextArea.setText("");
        this.messageTextArea.setBackground(new Color(212, 208, 200));
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setVerifyInputWhenFocusTarget(false);
        this.messageTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.messageTextArea.setMinimumSize(new Dimension(479, 18));
        this.messageTextArea.setPreferredSize(new Dimension(479, 18));
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.helpButton.setText("Help");
        this.helpButton.setActionCommand("Help");
        this.helpButton.setMnemonic('H');
        HelpBroker mainHB = ConceptEditor.getHelpBroker();
        if (mainHB != null) {
            mainHB.enableHelpOnButton((Component)this.helpButton, "rel.relationshiptoc", null);
        }
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.helpButton);
        this.connectTab.addActionListener(this);
        this.tabbedPane.add((Component)new JScrollPane(this.propertiesTab), "Properties");
        this.tabbedPane.add((Component)this.connectTab, "Connect");
        this.tabbedPane.add((Component)this.descriptionTab, "Description");
        this.tabbedPane.setPreferredSize(new Dimension(500, 250));
        this.propertiesTab.getSuperRelationshipComboBox().setModel(this.superRelationshipListModel);
        this.propertiesTab.getFromConceptComboBox().setModel(this.fromConceptListModel);
        this.propertiesTab.getToConceptComboBox().setModel(this.toConceptListModel);
    }

    public void initForEdit(Relationship relationship) {
        this.tabbedPane.setSelectedIndex(0);
        this.setNameChanged(false);
        this.setFromConceptChanged(false);
        this.setToConceptChanged(false);
        this.setSuperRelationshipChanged(false);
        this.setValidityChanged(false);
        this.relationshipsMap.clear();
        this.currentRelationship = null;
        if (relationship == null) {
            this.initForNewRelationship();
            return;
        }
        Case currentCase = M4Interface.getCurrentCase();
        this.currentRelationship = relationship;
        this.fillConceptListModels();
        this.fillRelationshipListModels();
        this.propertiesTab.getNameTextField().setText(this.currentRelationship.getName());
        this.fromConcept = this.currentRelationship.getFromConcept();
        if (this.fromConcept == null) {
            this.fromConceptListModel.setSelectedItem("<NONE...>");
        } else {
            this.fromConceptListModel.setSelectedItem(this.fromConcept.getName());
        }
        this.toConcept = this.currentRelationship.getToConcept();
        if (this.toConcept == null) {
            this.toConceptListModel.setSelectedItem("<NONE...>");
        } else {
            this.toConceptListModel.setSelectedItem(this.toConcept.getName());
        }
        Relationship superRelationship = this.currentRelationship.getSuperRelationship();
        if (superRelationship == null) {
            this.superRelationshipListModel.setSelectedItem("<NONE...>");
        } else {
            this.superRelationshipListModel.setSelectedItem(superRelationship.getName());
        }
        this.updateConnectionStatus();
        this.descriptionTab.getDescriptionTextArea().setText(this.currentRelationship.getDocumentation());
    }

    private void updateConnectionStatus() {
        JTextField connectStatusTextField = this.connectTab.getConnectionTextField();
        if (this.connectionExists()) {
            connectStatusTextField.setText("Connected");
        } else {
            connectStatusTextField.setText("Not connected");
        }
    }

    private boolean connectionExists(ColumnSet fromColumnSet, String foreignKeyName) {
        if (this.currentRelationship.getForeignKey() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Connection exists; Relationship has foreignKey.");
            }
            return true;
        }
        if (fromColumnSet.getForeignKey(foreignKeyName) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Connection exists; ColumnSet has foreignKey.");
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"No Connection exists.");
        }
        return false;
    }

    private boolean connectionExists() {
        if (this.fromConcept == null || this.toConcept == null) {
            return false;
        }
        this.setFromAndToColumnSets();
        if (this.fromConceptColumnSet == null || this.toConceptColumnSet == null) {
            return false;
        }
        this.setForeignKeyName();
        return this.connectionExists(this.fromConceptColumnSet, this.foreignKeyName);
    }

    private void fillConceptListModels() {
        this.fromConceptListModel.clear();
        this.toConceptListModel.clear();
        Collection allConcepts = M4Interface.getCurrentCase().getAllConcepts();
        Iterator i = allConcepts.iterator();
        while (i.hasNext()) {
            Concept aConcept = (Concept)i.next();
            String aConceptType = aConcept.getConceptType();
            if (!aConceptType.equalsIgnoreCase("BASE") && !aConceptType.equalsIgnoreCase("DB")) continue;
            this.fromConceptListModel.addElement(aConcept.getName());
            this.toConceptListModel.addElement(aConcept.getName());
        }
    }

    private void fillRelationshipListModels() {
        this.superRelationshipListModel.clear();
        this.superRelationshipListModel.addElement("<NONE...>");
        Collection allRelationships = this.getAllRelationships();
        Iterator i = allRelationships.iterator();
        while (i.hasNext()) {
            Relationship aRelationship = (Relationship)i.next();
            this.superRelationshipListModel.addElement(aRelationship.getName());
        }
        if (this.currentRelationship != null) {
            this.superRelationshipListModel.removeElement(this.currentRelationship.getName());
        }
    }

    private Collection getAllRelationships() {
        this.relationshipsMap.clear();
        Case currentCase = M4Interface.getCurrentCase();
        if (currentCase == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No currentCase available");
            }
            return this.relationshipsMap.values();
        }
        Collection allConcepts = currentCase.getAllConcepts();
        Iterator i = allConcepts.iterator();
        while (i.hasNext()) {
            Concept aConcept = (Concept)i.next();
            Collection hasRelationships = aConcept.getAllFromConceptRelationships();
            Iterator j = hasRelationships.iterator();
            while (j.hasNext()) {
                Relationship aRelationship = (Relationship)j.next();
                this.relationshipsMap.put(aRelationship.getName(), aRelationship);
            }
        }
        return this.relationshipsMap.values();
    }

    private void initForNewRelationship() {
        Case currentCase = M4Interface.getCurrentCase();
        this.fillConceptListModels();
        this.fillRelationshipListModels();
        this.propertiesTab.getNameTextField().setText("");
        this.propertiesTab.getNameTextField().requestFocus();
        this.fromConceptListModel.setSelectedItem(null);
        this.toConceptListModel.setSelectedItem(null);
        this.superRelationshipListModel.setSelectedItem("<NONE...>");
        JTextField connectStatusTextField = this.connectTab.getConnectionTextField();
        connectStatusTextField.setText("Not connected");
        this.descriptionTab.getDescriptionTextArea().setText("");
    }

    public void setSuperRelationship(Relationship superRelationship) {
        if (superRelationship == null) {
            this.propertiesTab.getSuperRelationshipComboBox().setSelectedItem("<NONE...>");
        } else {
            this.propertiesTab.getSuperRelationshipComboBox().setSelectedItem(superRelationship.getName());
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOK();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button");
            }
            this.doCancel();
        } else if (command.equalsIgnoreCase("One to many")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"One to many button");
            }
            this.doOneToMany();
            this.updateConnectionStatus();
        } else if (command.equalsIgnoreCase("Many to many")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Many to many button");
            }
            this.doManyToMany();
            this.updateConnectionStatus();
        }
    }

    private void processInputForExistingRelationship() {
        String superRelationshipName;
        String message;
        Case currentCase = M4Interface.getCurrentCase();
        String oldName = this.currentRelationship.getName();
        Concept oldFromConcept = this.currentRelationship.getFromConcept();
        Concept oldToConcept = this.currentRelationship.getToConcept();
        Relationship oldSuperRelationship = this.currentRelationship.getSuperRelationship();
        String oldDescription = this.currentRelationship.getDocumentation();
        String fromConceptName = (String)this.propertiesTab.getFromConceptComboBox().getSelectedItem();
        String toConceptName = (String)this.propertiesTab.getToConceptComboBox().getSelectedItem();
        if (fromConceptName == null || toConceptName == null) {
            logger.info((Object)"A relationship must have a from and to Concept.");
            String message2 = "A relationship must have a from and to Concept.\nPlease select both a from and to Concept";
            JOptionPane.showMessageDialog(this, message2, "Concept...?", 1);
            this.setInputOK(false);
            return;
        }
        this.fromConcept = currentCase.getConcept(fromConceptName);
        this.toConcept = currentCase.getConcept(toConceptName);
        String name = this.propertiesTab.getNameTextField().getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Relationship name: " + name));
        }
        if (name.equalsIgnoreCase("")) {
            logger.info((Object)"Name is not allowed to be empty.");
            String message3 = "Name is not allowed to be empty.\nPlease provide a name.";
            JOptionPane.showMessageDialog(this, message3, "Name...?", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            this.setInputOK(false);
            return;
        }
        if (!name.equals(this.currentRelationship.getName())) {
            try {
                this.currentRelationship.setName(name);
                this.setNameChanged(true);
            }
            catch (NameExistsException e) {
                logger.info((Object)"There already exists a Relationship with this name.");
                String message4 = "There already exists a Relationship with this name.\nPlease provide another name.\n\n(Note: Names are case sensitive.)";
                JOptionPane.showMessageDialog(this, message4, "Duplicate name...", 1);
                this.propertiesTab.getNameTextField().requestFocus();
                this.setInputOK(false);
                return;
            }
        }
        this.setInputOK(true);
        String description = this.descriptionTab.getDescriptionTextArea().getText();
        if (!description.equalsIgnoreCase(oldDescription)) {
            this.currentRelationship.setDocumentation(description);
        }
        if (this.fromConcept != this.currentRelationship.getFromConcept()) {
            try {
                this.currentRelationship.setFromConcept(this.fromConcept);
            }
            catch (StorageException e) {
                logger.error((Object)"Could not set from concept", (Throwable)e);
                message = "A data communication error occurred!\nCould not set from concept.";
                JOptionPane.showMessageDialog(this, message, "Error", 2);
            }
            this.setFromConceptChanged(true);
        }
        if (this.toConcept != this.currentRelationship.getToConcept()) {
            try {
                this.currentRelationship.setToConcept(this.toConcept);
            }
            catch (StorageException e) {
                logger.error((Object)"Could not set to concept", (Throwable)e);
                message = "A data communication error occurred!\nCould not set to concept.";
                JOptionPane.showMessageDialog(this, message, "Error", 2);
            }
            this.setToConceptChanged(true);
        }
        if (!(superRelationshipName = (String)this.propertiesTab.getSuperRelationshipComboBox().getSelectedItem()).equalsIgnoreCase("<NONE...>") || oldSuperRelationship != null) {
            if (!superRelationshipName.equalsIgnoreCase("<NONE...>") && oldSuperRelationship == null) {
                try {
                    this.currentRelationship.setSuperRelationship((Relationship)this.relationshipsMap.get(superRelationshipName));
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not set super concept", (Throwable)e);
                    String message5 = "A data communication error occurred!\nCould not set super concept.";
                    JOptionPane.showMessageDialog(this, message5, "Error", 2);
                }
                this.setSuperRelationshipChanged(true);
            } else if (superRelationshipName != oldSuperRelationship.getName()) {
                try {
                    this.currentRelationship.setSuperRelationship((Relationship)this.relationshipsMap.get(superRelationshipName));
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not set super concept", (Throwable)e);
                    String message6 = "A data communication error occurred!\nCould not set super concept.";
                    JOptionPane.showMessageDialog(this, message6, "Error", 2);
                }
                this.setSuperRelationshipChanged(true);
            }
        }
        if (this.currentRelationship.isChanged()) {
            this.storeRelationship(this.currentRelationship);
        }
        if (this.isRelationshipChanged()) {
            this.fireRelationshipChanged(this.currentRelationship, oldName, oldFromConcept, oldToConcept, oldSuperRelationship, this.isNameChanged(), this.isFromConceptChanged(), this.isToConceptChanged(), this.isSuperRelationshipChanged(), this.isValidityChanged());
        }
    }

    private Relationship processInputForNewRelationship() {
        Relationship newRelationship;
        Case currentCase = M4Interface.getCurrentCase();
        String fromConceptName = (String)this.propertiesTab.getFromConceptComboBox().getSelectedItem();
        String toConceptName = (String)this.propertiesTab.getToConceptComboBox().getSelectedItem();
        if (fromConceptName == null || toConceptName == null) {
            logger.info((Object)"A relationship must have a from and to Concept.");
            String message = "A relationship must have a from and to Concept.\nPlease select both a from and to Concept";
            JOptionPane.showMessageDialog(this, message, "Concept...?", 1);
            this.setInputOK(false);
            return null;
        }
        this.fromConcept = currentCase.getConcept(fromConceptName);
        this.toConcept = currentCase.getConcept(toConceptName);
        String name = this.propertiesTab.getNameTextField().getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Relationship name: " + name));
        }
        if (name.equalsIgnoreCase("")) {
            logger.info((Object)"Name is not allowed to be empty.");
            String message = "Name is not allowed to be empty.\nPlease provide a name.";
            JOptionPane.showMessageDialog(this, message, "Name...?", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            this.setInputOK(false);
            return null;
        }
        String superRelationshipName = (String)this.propertiesTab.getSuperRelationshipComboBox().getSelectedItem();
        String description = this.descriptionTab.getDescriptionTextArea().getText();
        try {
            newRelationship = this.fromConcept.createFromConceptRelationship(name, this.toConcept);
            newRelationship.store();
            if (!superRelationshipName.equalsIgnoreCase("<NONE...>")) {
                newRelationship.setSuperRelationship((Relationship)this.relationshipsMap.get(superRelationshipName));
            }
            if (description != null || !description.equalsIgnoreCase("")) {
                newRelationship.setDocumentation(description);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"Could not create a new Relationship.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not create a new Relationship.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return null;
        }
        catch (NameExistsException e) {
            logger.info((Object)"There already exists a Relationship with this name between this from- and toConcept.");
            String message = "There already exists a Relationship with this name between this from- and toConcept.\nPlease provide another name.\n\n(Note: Names are case sensitive.)";
            JOptionPane.showMessageDialog(this, message, "Duplicate name...", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            this.setInputOK(false);
            return null;
        }
        catch (StorageException e) {
            logger.error((Object)"Could not set the superRelationship property.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not set the superRelationship property.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return null;
        }
        this.setInputOK(true);
        this.storeRelationship(newRelationship);
        this.fireRelationshipCreated(newRelationship);
        return newRelationship;
    }

    private void doOK() {
        this.setInputOK(false);
        if (this.currentRelationship == null) {
            this.processInputForNewRelationship();
        } else {
            this.processInputForExistingRelationship();
        }
        if (this.isInputOK()) {
            ((Component)this).setVisible(false);
        }
    }

    private void doCancel() {
        this.close();
    }

    public void close() {
        this.currentRelationship = null;
        ((Component)this).setVisible(false);
    }

    private void processInput() {
        if (this.currentRelationship == null) {
            this.currentRelationship = this.processInputForNewRelationship();
        } else {
            this.processInputForExistingRelationship();
        }
    }

    private boolean checkConceptsOK() {
        this.toConcept = this.currentRelationship.getToConcept();
        this.fromConcept = this.currentRelationship.getFromConcept();
        if (this.toConcept == null || this.fromConcept == null) {
            logger.info((Object)"From Concept and/or To Concept missing.");
            String message = "From Concept and/or To Concept missing.\nCannot display dialog to define relationship";
            JOptionPane.showMessageDialog(this, message, "Error...", 2);
            return false;
        }
        return this.conceptTypeOK(this.fromConcept) && this.conceptTypeOK(this.toConcept) && this.conceptColumnSetConnectionOK(this.fromConcept) && this.conceptColumnSetConnectionOK(this.toConcept);
    }

    /*
     * Unable to fully structure code
     */
    private void doOneToMany() {
        this.processInput();
        if (this.currentRelationship == null || !this.isInputOK()) {
            return;
        }
        if (!this.checkConceptsOK()) {
            return;
        }
        this.setFromAndToColumnSets();
        this.setForeignKeyName();
        removeOK = this.removeExistingConnection();
        if (!removeOK) {
            return;
        }
        aDialog = this.dialogManager.showOneToManyRelationDialog(this.currentRelationship);
        if (aDialog.isCancelPressed()) {
            return;
        }
        fkBaseAttributeNamesMap = aDialog.getSelectedFromConceptBaseAttributes();
        pkBaseAttributeNamesMap = aDialog.getSelectedToConceptBaseAttributes();
        cleanedKeyMap = new HashMap<String, String>();
        i = 0;
        while (i < fkBaseAttributeNamesMap.size()) {
            aFkBaseAttributeName = (String)fkBaseAttributeNamesMap.get(new Integer(i));
            aPkBaseAttributeName = (String)pkBaseAttributeNamesMap.get(new Integer(i));
            if (!aFkBaseAttributeName.equals("<NONE...>") && !aPkBaseAttributeName.equals("<NONE...>")) {
                cleanedKeyMap.put(aFkBaseAttributeName, aPkBaseAttributeName);
            }
            ++i;
        }
        fkBaseAttributeNames = cleanedKeyMap.keySet();
        fkColumns = new ArrayList<Column>();
        i = fkBaseAttributeNames.iterator();
        while (i.hasNext()) {
            aBaseAttributeName = (String)i.next();
            aBaseAttribute = this.fromConcept.getBaseAttribute(aBaseAttributeName);
            aColumn = null;
            try {
                aColumn = aBaseAttribute.getColumn();
            }
            catch (MultipleResultException e) {
                this.showConnectionFailedMessage("Failed to match BaseAttribute to one Column.");
                return;
            }
            if (aColumn == null) {
                this.showConnectionFailedMessage("Failed to match BaseAttribute to one Column.");
                return;
            }
            fkColumns.add(aColumn);
        }
        pkBaseAttributeNames = cleanedKeyMap.values();
        pkColumns = new ArrayList<Column>();
        i = pkBaseAttributeNames.iterator();
        while (i.hasNext()) {
            aBaseAttributeName = (String)i.next();
            aBaseAttribute = this.toConcept.getBaseAttribute(aBaseAttributeName);
            aColumn = null;
            try {
                aColumn = aBaseAttribute.getColumn();
            }
            catch (MultipleResultException e) {
                this.showConnectionFailedMessage("Failed to match BaseAttribute to one Column.");
                return;
            }
            if (aColumn == null) {
                this.showConnectionFailedMessage("Failed to match BaseAttribute to one Column.");
                return;
            }
            pkColumns.add(aColumn);
        }
        try {
            foreignKey = this.fromConceptColumnSet.createForeignKey(this.foreignKeyName);
            if (RelationshipDialog.logger.isDebugEnabled()) {
                RelationshipDialog.logger.debug((Object)"ForeignKey created");
            }
            foreignKey.setIsConnectionTo(this.toConceptColumnSet);
            if (RelationshipDialog.logger.isDebugEnabled()) {
                RelationshipDialog.logger.debug((Object)"ForeignKey connected to toConceptColumnSet");
            }
            foreignKey.store();
            if (RelationshipDialog.logger.isDebugEnabled()) {
                RelationshipDialog.logger.debug((Object)"ForeignKey stored");
            }
        }
        catch (NameExistsException e) {
            this.showConnectionFailedMessage("ForeignKey name already exists.");
            return;
        }
        catch (CreateException e) {
            this.showConnectionFailedMessage("Failed to create a ForeignKey.");
            return;
        }
        catch (StorageException e) {
            this.showConnectionFailedMessage("Failed to store the ForeignKey.");
            return;
        }
        i = fkColumns.iterator();
        j = pkColumns.iterator();
        while (i.hasNext() && j.hasNext()) {
            aFkColumn = (Column)i.next();
            aPkColumn = (Column)j.next();
            try {
                foreignKey.addColumn(aFkColumn, aPkColumn);
                if (!RelationshipDialog.logger.isDebugEnabled()) continue;
                RelationshipDialog.logger.debug((Object)("Column " + aFkColumn.getName() + " added to ForeignKey"));
            }
            catch (StorageException e) {
                this.showConnectionFailedMessage("Failed to create a ForeignKey.");
            }
        }
        aPK = this.toConceptColumnSet.getPrimaryKey();
        if (RelationshipDialog.logger.isDebugEnabled()) {
            RelationshipDialog.logger.debug((Object)(aPK != null ? "PrimaryKey found" : "PrimaryKey not found"));
        }
        if (aPK != null) {
            if (this.primaryKeyHasChanged(aPK, cleanedKeyMap.values())) {
                try {
                    aPK.delete();
                    if (!RelationshipDialog.logger.isDebugEnabled()) ** GOTO lbl116
                    RelationshipDialog.logger.debug((Object)"PrimaryKey deleted");
                }
                catch (StorageException e) {
                    this.showConnectionFailedMessage("Failed to remove old PrimaryKey.");
                    return;
                }
            } else {
                if (RelationshipDialog.logger.isDebugEnabled()) {
                    RelationshipDialog.logger.debug((Object)"PrimaryKey exists and has not been changed.");
                }
                this.setForeignKey(foreignKey);
                this.storeRelationship(this.currentRelationship);
                return;
            }
        }
lbl116:
        // 4 sources

        primaryKeyName = this.toConceptColumnSet.getName() + "_PK";
        try {
            primaryKey = this.toConceptColumnSet.createPrimaryKey(primaryKeyName);
            primaryKey.store();
            if (RelationshipDialog.logger.isDebugEnabled()) {
                RelationshipDialog.logger.debug((Object)"PrimaryKey created.");
            }
        }
        catch (NameExistsException e) {
            this.showConnectionFailedMessage("PrimaryKey name already exists.");
            return;
        }
        catch (CreateException e) {
            this.showConnectionFailedMessage("Failed to create a PrimaryKey.");
            return;
        }
        catch (StorageException e) {
            this.showConnectionFailedMessage("Failed to store PrimaryKey.");
            return;
        }
        i = pkColumns.iterator();
        while (i.hasNext()) {
            aPkColumn = (Column)i.next();
            try {
                primaryKey.addColumn(aPkColumn);
                if (!RelationshipDialog.logger.isDebugEnabled()) continue;
                RelationshipDialog.logger.debug((Object)("Column " + aPkColumn.getName() + " added to PrimaryKey"));
            }
            catch (StorageException e) {
                this.showConnectionFailedMessage("Failed to create a PrimaryKey.");
            }
        }
        this.setForeignKey(foreignKey);
        this.storeRelationship(this.currentRelationship);
    }

    private ColumnSet getColumnSet(Concept concept) {
        ColumnSet columnSet = null;
        Collection columnSets = concept.getAllColumnSets();
        if (columnSets.size() > 0) {
            columnSet = (ColumnSet)columnSets.iterator().next();
        }
        return columnSet;
    }

    private boolean removeExistingConnection() {
        if (this.connectionExists(this.fromConceptColumnSet, this.foreignKeyName)) {
            logger.warn((Object)"A connection exists on the relational level.");
            String message = "A connection exists on the relational level.\nContinuing will remove the connection. Do you want to continue?";
            int choice = JOptionPane.showConfirmDialog(this, message, "Connection exists", 0, 3);
            if (choice != 0) {
                return false;
            }
        }
        try {
            this.currentRelationship.removeForeignKey();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Removed foreignKey from relationship.");
            }
        }
        catch (StorageException e) {
            logger.warn((Object)"Failed to remove the old foreignKey.");
            String message = "Failed to remove the old foreignKey.";
            JOptionPane.showMessageDialog(this, message, "Error...", 2);
            return false;
        }
        try {
            ForeignKey foreignKey = this.fromConceptColumnSet.getForeignKey(this.foreignKeyName);
            if (foreignKey != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting foreignKey: " + foreignKey.getName()));
                }
                foreignKey.delete();
            }
        }
        catch (StorageException e) {
            logger.warn((Object)"Failed to delete the foreignKey.");
            String message = "Failed to delete the foreignKey.";
            JOptionPane.showMessageDialog(this, message, "Error...", 2);
            return false;
        }
        try {
            ColumnSet crosstable = this.currentRelationship.getColumnSet();
            if (crosstable != null) {
                ForeignKey toFK;
                String fromFKName = crosstable.getName() + "_" + this.fromConceptColumnSet.getName() + "_FK";
                String toFKName = crosstable.getName() + "_" + this.toConceptColumnSet.getName() + "_FK";
                ForeignKey fromFK = crosstable.getForeignKey(fromFKName);
                if (fromFK != null) {
                    fromFK.delete();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting foreignKey: " + fromFK.getName()));
                    }
                }
                if ((toFK = crosstable.getForeignKey(toFKName)) != null) {
                    toFK.delete();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting foreignKey: " + toFK.getName()));
                    }
                }
            }
        }
        catch (StorageException e) {
            logger.warn((Object)"Failed to delete foreignKeys.");
            String message = "Failed to delete foreignKeys.";
            JOptionPane.showMessageDialog(this, message, "Error...", 2);
            return false;
        }
        try {
            ColumnSet columnSet = this.currentRelationship.getColumnSet();
            if (columnSet != null) {
                this.currentRelationship.removeColumnSet();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting crosstable columnSet: " + columnSet.getName()));
                }
            }
        }
        catch (StorageException e) {
            logger.warn((Object)"Failed to delete the crosstable columnSet.");
            String message = "Failed to delete the crosstable columnSet.";
            JOptionPane.showMessageDialog(this, message, "Error...", 2);
            return false;
        }
        boolean storeOK = this.storeRelationship(this.currentRelationship);
        return storeOK;
    }

    private void setFromAndToColumnSets() {
        this.fromConceptColumnSet = this.getColumnSet(this.fromConcept);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.fromConceptColumnSet != null ? "From Concept ColumnSet name: " + this.fromConceptColumnSet.getName() : "From Concept ColumnSet is null"));
        }
        this.toConceptColumnSet = this.getColumnSet(this.toConcept);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.toConceptColumnSet != null ? "To Concept ColumnSet name: " + this.toConceptColumnSet.getName() : "To Concept ColumnSet is null"));
        }
    }

    private void setForeignKeyName() {
        this.foreignKeyName = this.fromConceptColumnSet.getName() + "_" + this.toConceptColumnSet.getName() + "_FK";
    }

    private void setToConceptForeignKeyName() {
        this.toConceptForeignKeyName = this.toConceptColumnSet.getName() + "_" + this.fromConceptColumnSet.getName() + "_FK";
    }

    private boolean storeRelationship(Relationship relationship) {
        if (relationship == null) {
            return false;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Trying to store a relationship...");
                logger.debug((Object)("Name: " + relationship.getName()));
            }
            relationship.store();
        }
        catch (StorageException e) {
            logger.error((Object)"Could not store Relationship record.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not update the settings for the Relationship.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return false;
        }
        return true;
    }

    private void setForeignKey(ForeignKey foreignKey) {
        try {
            foreignKey.setRelationship(this.currentRelationship);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ForeignKey connected to Relationship.");
            }
        }
        catch (StorageException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to connect ForeignKey to Relationship.", (Throwable)e);
            }
            this.showConnectionFailedMessage("Failed to bind ForeignKey to Relationship.");
        }
    }

    private boolean primaryKeyHasChanged(PrimaryKey primaryKey, Collection pkBaseAttributeNames) {
        Collection pkColumns = primaryKey.getAllColumns();
        if (pkColumns.size() != pkBaseAttributeNames.size()) {
            return true;
        }
        Iterator i = pkColumns.iterator();
        while (i.hasNext()) {
            Column aColumn = (Column)i.next();
            BaseAttribute aBaseAttribute = aColumn.getBaseAttribute();
            String aBaseAttributeName = aBaseAttribute.getName();
            if (pkBaseAttributeNames.contains(aBaseAttributeName)) continue;
            return true;
        }
        return false;
    }

    private void showConnectionFailedMessage(String extraInfo) {
        logger.error((Object)"Failed to define Relationship at the data level.");
        String message = "Failed to define Relationship at the data level.\n" + extraInfo;
        JOptionPane.showMessageDialog(this, message, "Error...", 0);
    }

    private void doManyToMany() {
        this.processInput();
        if (this.currentRelationship == null || !this.isInputOK()) {
            return;
        }
        if (!this.checkConceptsOK()) {
            return;
        }
        this.setFromAndToColumnSets();
        this.setForeignKeyName();
        this.setToConceptForeignKeyName();
        boolean removeOK = this.removeExistingConnection();
        if (!removeOK) {
            return;
        }
        TaskCreateM2mRelation createTask = new TaskCreateM2mRelation(this.parentFrame, this.currentRelationship, this.fromConceptColumnSet, this.toConceptColumnSet);
        M2mWizard myM2mWizard = new M2mWizard(this.parentFrame, true, createTask, this.fromConceptColumnSet, this.toConceptColumnSet);
        myM2mWizard.removeHelpButton();
        myM2mWizard.start();
        if (myM2mWizard.isCancelPressed()) {
            return;
        }
    }

    private boolean conceptTypeOK(Concept concept) {
        String type = concept.getConceptType();
        if (!type.equals("DB")) {
            logger.warn((Object)("Concept " + concept.getName() + " is not of type DB."));
            String message = "Concept " + concept.getName() + " is not of type DB." + "\n" + "Both Concepts must be of type DB and be connected to a database object.";
            JOptionPane.showMessageDialog(null, message, "Error...", 2);
            return false;
        }
        return true;
    }

    private boolean conceptColumnSetConnectionOK(Concept concept) {
        int nrOfColumnSets = concept.getAllColumnSets().size();
        if (nrOfColumnSets == 0) {
            logger.info((Object)("Concept " + concept.getName() + " is not connected to a database object."));
            String message = "Concept " + concept.getName() + " is not connected to a database object." + "\n" + "Both Concepts must be of type DB and be connected to a database object.";
            JOptionPane.showMessageDialog(null, message, "Error...", 2);
            return false;
        }
        if (nrOfColumnSets == 1) {
            return true;
        }
        if (nrOfColumnSets > 1) {
            logger.info((Object)("Concept " + concept.getName() + " has more than one ColumnSet."));
            String message = "Concept " + concept.getName() + " has more than one ColumnSet." + "\n" + "A Concept of type DB must have only one ColumnSet." + "\n" + "Please reconnect it to the proper database object.";
            JOptionPane.showMessageDialog(null, message, "Error...", 2);
            return false;
        }
        return false;
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    public void addRelationshipListener(RelationshipListener l) {
        if (!this.listenerList.contains(l)) {
            this.listenerList.add(l);
        }
    }

    public void removeRelationshipListener(RelationshipListener l) {
        if (this.listenerList.contains(l)) {
            ((AbstractCollection)this.listenerList).remove(l);
        }
    }

    public void fireRelationshipChanged(Relationship relationship, String oldName, Concept oldFromConcept, Concept oldToConcept, Relationship oldSuperRelationship, boolean nameChanged, boolean fromConceptChanged, boolean toConceptChanged, boolean superRelationshipChanged, boolean validityChanged) {
        RelationshipEvent anEvent = new RelationshipEvent(this, relationship, oldName, oldFromConcept, oldToConcept, oldSuperRelationship, nameChanged, fromConceptChanged, toConceptChanged, superRelationshipChanged, validityChanged);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            RelationshipListener aListener = (RelationshipListener)aList.get(i);
            aListener.relationshipChanged(anEvent);
            ++i;
        }
    }

    public void fireRelationshipCreated(Relationship relationship) {
        RelationshipEvent anEvent = new RelationshipEvent(this, relationship);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            RelationshipListener aListener = (RelationshipListener)aList.get(i);
            aListener.relationshipCreated(anEvent);
            ++i;
        }
    }

    public void fireRelationshipDeleted(Relationship relationship) {
        RelationshipEvent anEvent = new RelationshipEvent(this, relationship);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            RelationshipListener aListener = (RelationshipListener)aList.get(i);
            aListener.relationshipDeleted(anEvent);
            ++i;
        }
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public void setNameChanged(boolean nameChanged) {
        this.nameChanged = nameChanged;
    }

    public boolean isRelationshipChanged() {
        return this.isNameChanged() || this.isFromConceptChanged() || this.isToConceptChanged() || this.isSuperRelationshipChanged() || this.isValidityChanged();
    }

    public boolean isFromConceptChanged() {
        return this.fromConceptChanged;
    }

    public void setFromConceptChanged(boolean fromConceptChanged) {
        this.fromConceptChanged = fromConceptChanged;
    }

    public boolean isToConceptChanged() {
        return this.toConceptChanged;
    }

    public void setToConceptChanged(boolean toConceptChanged) {
        this.toConceptChanged = toConceptChanged;
    }

    public boolean isSuperRelationshipChanged() {
        return this.superRelationshipChanged;
    }

    public void setSuperRelationshipChanged(boolean superRelationshipChanged) {
        this.superRelationshipChanged = superRelationshipChanged;
    }

    public boolean isValidityChanged() {
        return this.validityChanged;
    }

    public void setValidityChanged(boolean validityChanged) {
        this.validityChanged = validityChanged;
    }

    private void setParent(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public boolean isInputOK() {
        return this.inputOK;
    }

    public void setInputOK(boolean inputOK) {
        this.inputOK = inputOK;
    }
}

