/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.dialogs.MCFeatureDescriptionPanel;
import com.syllogic.miningmart.concepteditor.dialogs.MCFeaturePropertiesPanel;
import com.syllogic.miningmart.concepteditor.event.MultiColumnFeatureEvent;
import com.syllogic.miningmart.concepteditor.event.MultiColumnFeatureListener;
import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import com.syllogic.miningmart.concepteditor.util.MyListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.NameExistsException;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;

public class MCFeatureDialog
extends JDialog
implements ActionListener,
Closeable {
    private String[] conceptTypes = new String[]{"BASE", "DB", "MINING"};
    private String[] dummyConcepts = new String[]{"Partner", "Contract"};
    private static Logger logger = Logger.getLogger((String)"MCFeatureDialog");
    private ArrayList mcfListenerList = new ArrayList();
    public static final String NEWLINE = "\n";
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel southPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JTextArea messageTextArea = new JTextArea();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private MCFeaturePropertiesPanel propertiesTab = new MCFeaturePropertiesPanel();
    private MCFeatureDescriptionPanel descriptionTab = new MCFeatureDescriptionPanel();
    private MultiColumnFeature currentMultiColumnFeature;
    private MultiColumnFeature newMultiColumnFeature;
    private Concept currentConcept;
    private JList baList;
    private MyListModel baListModel = new MyListModel();

    public MCFeatureDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("MultiColumnFeature properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MCFeatureDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.southPanel.add((Component)this.buttonPanel, "North");
        this.messageTextArea.setText("");
        this.messageTextArea.setBackground(new Color(212, 208, 200));
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setVerifyInputWhenFocusTarget(false);
        this.messageTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.messageTextArea.setMinimumSize(new Dimension(479, 18));
        this.messageTextArea.setPreferredSize(new Dimension(479, 18));
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.tabbedPane.add((Component)new JScrollPane(this.propertiesTab), "Properties");
        this.tabbedPane.add((Component)this.descriptionTab, "Description");
        this.tabbedPane.setPreferredSize(new Dimension(500, 250));
        this.baList = this.propertiesTab.getBaseAttributeList();
        this.baList.setModel(this.baListModel);
    }

    public void initForEdit(Concept concept, MultiColumnFeature multiColumnFeature) {
        if (concept == null && multiColumnFeature == null) {
            logger.error((Object)"Could properly initialize MultiColumnFeature dialog.");
            String message = "A initialization error occurred!\nCould properly initialize MultiColumnFeature dialog.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        this.setCurrentConcept(concept);
        this.currentMultiColumnFeature = null;
        if (multiColumnFeature == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"MultiColumnFeature is null, initializing for new MultiColumnFeature...");
            }
            this.initForNewMultiColumnFeature();
            return;
        }
        this.currentMultiColumnFeature = multiColumnFeature;
        this.fillBaseAttributeListModel();
        this.propertiesTab.getNameTextField().setText(this.currentMultiColumnFeature.getName());
        this.descriptionTab.getDescriptionTextArea().setText(this.currentMultiColumnFeature.getDocumentation());
        Collection allMCFeatureBaseAttributes = this.currentMultiColumnFeature.getAllBaseAttributes();
        Object[] allMCFeatureBaseAttributesArray = allMCFeatureBaseAttributes.toArray();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MultiColumnFeature  " + this.currentMultiColumnFeature.getName() + " is based on " + allMCFeatureBaseAttributes.size() + " baseAttributes."));
        }
        int[] selectedIndices = new int[allMCFeatureBaseAttributes.size()];
        int i = 0;
        while (i < allMCFeatureBaseAttributesArray.length) {
            BaseAttribute aMCFeatureBaseAttribute = (BaseAttribute)allMCFeatureBaseAttributesArray[i];
            selectedIndices[i] = this.baListModel.indexOf(aMCFeatureBaseAttribute.getName());
            ++i;
        }
        this.baList.setSelectedIndices(selectedIndices);
        this.repaint();
    }

    private void initForNewMultiColumnFeature() {
        this.newMultiColumnFeature = null;
        this.fillBaseAttributeListModel();
        this.propertiesTab.getNameTextField().setText("");
        this.descriptionTab.getDescriptionTextArea().setText("");
        JList baList = this.propertiesTab.getBaseAttributeList();
        baList.setModel(this.baListModel);
    }

    public void close() {
        this.currentConcept = null;
        this.currentMultiColumnFeature = null;
        ((Component)this).setVisible(false);
    }

    private void fillBaseAttributeListModel() {
        this.baListModel.clear();
        Concept concept = this.currentMultiColumnFeature == null ? this.currentConcept : this.currentMultiColumnFeature.getConcept();
        Collection allBaseAttributes = concept.getAllBaseAttributes();
        Iterator i = allBaseAttributes.iterator();
        while (i.hasNext()) {
            BaseAttribute aBaseAttribute = (BaseAttribute)i.next();
            this.baListModel.addElement(aBaseAttribute.getName());
        }
    }

    private void setCurrentConcept(Concept concept) {
        this.currentConcept = concept;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOKExisting();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button");
            }
            this.doCancel();
        }
    }

    private void doOKExisting() {
        String message;
        Object[] values;
        if (this.currentMultiColumnFeature == null) {
            this.doOKNew();
            return;
        }
        String name = this.propertiesTab.getNameTextField().getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MultiColumnFeature name: " + name));
        }
        if (name.equalsIgnoreCase("")) {
            logger.info((Object)"Name is not allowed to be empty.");
            String message2 = "Name is not allowed to be empty.\nPlease provide a name.";
            JOptionPane.showMessageDialog(this, message2, "Name...?", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            return;
        }
        if (!name.equals(this.currentMultiColumnFeature.getName())) {
            try {
                this.currentMultiColumnFeature.setName(name);
            }
            catch (NameExistsException e) {
                logger.info((Object)"There already exists a MultiColumnFeature with this name for this Concept.");
                String message3 = "There already exists a MultiColumnFeature with this name for this Concept.\nPlease provide another name.\n\n(Note: Names are case sensitive.)";
                JOptionPane.showMessageDialog(this, message3, "Duplicate name...", 1);
                this.propertiesTab.getNameTextField().requestFocus();
                return;
            }
        }
        if ((values = this.propertiesTab.getBaseAttributeList().getSelectedValues()).length < 2) {
            String message4 = "A MultiColumnFeature must be based on at least two BaseAttributes.\nPlease select at least two BaseAttributes.";
            JOptionPane.showMessageDialog(this, message4, "Requirement not fulfilled", 1);
            return;
        }
        ((Component)this).setVisible(false);
        Collection allBaseAttributes = this.currentMultiColumnFeature.getAllBaseAttributes();
        Iterator i = allBaseAttributes.iterator();
        while (i.hasNext()) {
            BaseAttribute oldBaseAttribute = (BaseAttribute)i.next();
            boolean attributeNotFound = true;
            int j = 0;
            do {
                BaseAttribute newBaseAttribute;
                if (oldBaseAttribute != (newBaseAttribute = this.currentConcept.getBaseAttribute((String)values[j]))) continue;
                attributeNotFound = false;
            } while (attributeNotFound && ++j < values.length);
            if (!attributeNotFound) continue;
            try {
                this.currentMultiColumnFeature.removeBaseAttribute(oldBaseAttribute.getName());
                oldBaseAttribute.store();
            }
            catch (StorageException e) {
                logger.error((Object)"Could not remove BaseAttribute from MultiColumnFeature", (Throwable)e);
                message = "A data communication error occurred!\nCould not remove BaseAttribute from MultiColumnFeature.";
                JOptionPane.showMessageDialog(this, message, "Error", 2);
            }
        }
        int j = 0;
        while (j < values.length) {
            BaseAttribute newBaseAttribute = this.currentConcept.getBaseAttribute((String)values[j]);
            boolean attributeNotFound = true;
            allBaseAttributes = this.currentMultiColumnFeature.getAllBaseAttributes();
            i = allBaseAttributes.iterator();
            while (attributeNotFound && i.hasNext()) {
                BaseAttribute oldBaseAttribute = (BaseAttribute)i.next();
                if (newBaseAttribute != oldBaseAttribute) continue;
                attributeNotFound = false;
            }
            if (attributeNotFound) {
                try {
                    this.currentMultiColumnFeature.addBaseAttribute(newBaseAttribute);
                    newBaseAttribute.store();
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not add BaseAttribute to MultiColumnFeature", (Throwable)e);
                    message = "A data communication error occurred!\nCould not add BaseAttribute to MultiColumnFeature.";
                    JOptionPane.showMessageDialog(this, message, "Error", 2);
                }
            }
            ++j;
        }
        String oldDescription = this.currentMultiColumnFeature.getDocumentation();
        String description = this.descriptionTab.getDescriptionTextArea().getText();
        if (!description.equalsIgnoreCase(oldDescription)) {
            this.currentMultiColumnFeature.setDocumentation(description);
        }
        if (this.currentMultiColumnFeature.isChanged()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Trying to store a MultiColumnFeature...");
                    logger.debug((Object)("Name: " + this.currentMultiColumnFeature.getName()));
                }
                this.currentMultiColumnFeature.store();
            }
            catch (StorageException e) {
                logger.error((Object)"Could not store MultiColumnFeature record.", (Throwable)e);
                message = "A data communication error occurred!\nCould not update the settings for the MultiColumnFeature.";
                JOptionPane.showMessageDialog(this, message, "Error", 2);
            }
            this.fireMultiColumnFeatureChanged(this.currentConcept);
        }
    }

    private void doOKNew() {
        String name = this.propertiesTab.getNameTextField().getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MultiColumnFeature name: " + name));
        }
        if (name.equalsIgnoreCase("")) {
            logger.info((Object)"Name is not allowed to be empty.");
            String message = "Name is not allowed to be empty.\nPlease provide a name.";
            JOptionPane.showMessageDialog(this, message, "Name...?", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            return;
        }
        Object[] values = this.propertiesTab.getBaseAttributeList().getSelectedValues();
        if (values.length < 2) {
            String message = "A MultiColumnFeature must be based on at least two BaseAttributes.\nPlease select at least two BaseAttributes.";
            JOptionPane.showMessageDialog(this, message, "Requirement not fulfilled", 1);
            return;
        }
        String description = this.descriptionTab.getDescriptionTextArea().getText();
        try {
            this.newMultiColumnFeature = this.currentConcept.createMultiColumnFeature(name);
        }
        catch (CreateException e) {
            logger.error((Object)"Could not create a new MultiColumnFeature.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not create a new MultiColumnFeature.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return;
        }
        catch (NameExistsException e) {
            logger.info((Object)"There already exists a MultiColumnFeature with this name for this Concept.");
            String message = "There already exists a MultiColumnFeature with this name for this Concept.\nPlease provide another name.\n\n(Note: Names are case sensitive.)";
            JOptionPane.showMessageDialog(this, message, "Duplicate name...", 1);
            this.propertiesTab.getNameTextField().requestFocus();
            return;
        }
        ((Component)this).setVisible(false);
        int j = 0;
        while (j < values.length) {
            BaseAttribute newBaseAttribute = this.currentConcept.getBaseAttribute((String)values[j]);
            try {
                this.newMultiColumnFeature.addBaseAttribute(newBaseAttribute);
                newBaseAttribute.store();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("BaseAttribute " + newBaseAttribute.getName() + " added to MultiColumnFeature"));
                }
            }
            catch (StorageException e) {
                logger.error((Object)"Could not add BaseAttribute to MultiColumnFeature", (Throwable)e);
                String message = "A data communication error occurred!\nCould not add BaseAttribute to MultiColumnFeature.";
                JOptionPane.showMessageDialog(this, message, "Error", 2);
            }
            ++j;
        }
        if (description != null || !description.equalsIgnoreCase("")) {
            this.newMultiColumnFeature.setDocumentation(description);
        }
        try {
            this.newMultiColumnFeature.store();
        }
        catch (StorageException e) {
            logger.error((Object)"Could not store MultiColumnFeature record.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not update the settings for the MultiColumnFeature.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
        }
        this.fireMultiColumnFeatureCreated(this.currentConcept);
    }

    private void doCancel() {
        this.close();
    }

    public MultiColumnFeature getCreatedMultiColumnFeature() {
        return this.newMultiColumnFeature;
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    public void addMultiColumnFeatureListener(MultiColumnFeatureListener l) {
        if (!this.mcfListenerList.contains(l)) {
            this.mcfListenerList.add(l);
        }
    }

    public void removeMultiColumnFeatureListener(MultiColumnFeatureListener l) {
        if (this.mcfListenerList.contains(l)) {
            ((AbstractCollection)this.mcfListenerList).remove(l);
        }
    }

    public void fireMultiColumnFeatureChanged(Concept concept) {
        MultiColumnFeatureEvent anEvent = new MultiColumnFeatureEvent(this, concept);
        ArrayList aList = (ArrayList)this.mcfListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            MultiColumnFeatureListener aListener = (MultiColumnFeatureListener)aList.get(i);
            aListener.multiColumnFeatureChanged(anEvent);
            ++i;
        }
    }

    public void fireMultiColumnFeatureCreated(Concept concept) {
        MultiColumnFeatureEvent anEvent = new MultiColumnFeatureEvent(this, concept);
        ArrayList aList = (ArrayList)this.mcfListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            MultiColumnFeatureListener aListener = (MultiColumnFeatureListener)aList.get(i);
            aListener.multiColumnFeatureCreated(anEvent);
            ++i;
        }
    }

    public void fireMultiColumnFeatureDeleted(Concept concept) {
        MultiColumnFeatureEvent anEvent = new MultiColumnFeatureEvent(this, concept);
        ArrayList aList = (ArrayList)this.mcfListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            MultiColumnFeatureListener aListener = (MultiColumnFeatureListener)aList.get(i);
            aListener.multiColumnFeatureDeleted(anEvent);
            ++i;
        }
    }
}

