/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.diagram.DiagramDisplayHandler;
import com.syllogic.miningmart.concepteditor.dialogs.BaseAttributeDialog;
import com.syllogic.miningmart.concepteditor.dialogs.ColumnDialog;
import com.syllogic.miningmart.concepteditor.dialogs.ColumnSetDialog;
import com.syllogic.miningmart.concepteditor.dialogs.ConceptDialog;
import com.syllogic.miningmart.concepteditor.dialogs.DataDialog;
import com.syllogic.miningmart.concepteditor.dialogs.MCFeatureDialog;
import com.syllogic.miningmart.concepteditor.dialogs.MapBaseAttributesDialog;
import com.syllogic.miningmart.concepteditor.dialogs.OneToManyRelationDialog;
import com.syllogic.miningmart.concepteditor.dialogs.RelationshipDialog;
import com.syllogic.miningmart.concepteditor.dialogs.SimpleListDialog;
import com.syllogic.miningmart.concepteditor.dialogs.StatisticsDialog;
import com.syllogic.miningmart.concepteditor.event.ConceptListener;
import com.syllogic.miningmart.concepteditor.event.RelationshipListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JFrame;
import javax.swing.ListModel;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.Relationship;
import org.apache.log4j.Logger;

public class DialogManager {
    private static Logger logger = Logger.getLogger((String)"DialogManager");
    private ConceptDialog conceptDialog;
    private DataDialog dataDialog;
    private StatisticsDialog statisticsDialog;
    private RelationshipDialog relationshipDialog;
    private BaseAttributeDialog baseAttributeDialog;
    private ColumnSetDialog columnSetDialog;
    private ColumnDialog columnDialog;
    private MCFeatureDialog mcFeatureDialog;
    private MapBaseAttributesDialog mapBaseAttributesDialog;
    private OneToManyRelationDialog oneToManyRelationDialog;
    private SimpleListDialog simpleListDialog;
    private Frame parentFrame;
    private DiagramDisplayHandler diagramDisplayHandler;

    public DialogManager() {
        this.parentFrame = new JFrame();
    }

    public DialogManager(Frame parent) {
        this.parentFrame = parent != null ? parent : new JFrame();
    }

    public ConceptDialog showConceptDialog(Concept concept) {
        ConceptDialog aDialog = this.getConceptDialog();
        aDialog.addConceptListener(this.diagramDisplayHandler);
        aDialog.initForEdit(concept);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public ConceptDialog showConceptDialog(Concept concept, ConceptListener l) {
        ConceptDialog aDialog = this.getConceptDialog();
        aDialog.addConceptListener(l);
        aDialog.addConceptListener(this.diagramDisplayHandler);
        if (logger.isDebugEnabled()) {
            if (this.diagramDisplayHandler == null) {
                logger.debug((Object)"DisplayHandler is NULL!");
            } else {
                logger.debug((Object)"DisplayHandler is not NULL");
            }
        }
        aDialog.initForEdit(concept);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        aDialog.setFocusToNameField();
        return aDialog;
    }

    public DataDialog showDataDialog(ColumnSet columnset) {
        DataDialog aDialog = this.getDataDialog();
        aDialog.initForEdit(columnset, 1000);
        aDialog.pack();
        ((Component)aDialog).setSize(new Dimension(700, 500));
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public StatisticsDialog showStatisticsDialog(ColumnSet columnset) {
        StatisticsDialog aDialog = this.getStatisticsDialog();
        aDialog.initForEdit(columnset, 1000);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public ConceptDialog showNewSubConceptDialog(Concept superConcept, ConceptListener l) {
        ConceptDialog aDialog = this.getConceptDialog();
        aDialog.addConceptListener(l);
        aDialog.addConceptListener(this.diagramDisplayHandler);
        aDialog.initForEdit(null);
        aDialog.setSuperConcept(superConcept);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public RelationshipDialog showNewSubRelationshipDialog(Relationship superRelationship, RelationshipListener l) {
        RelationshipDialog aDialog = this.getRelationshipDialog();
        aDialog.addRelationshipListener(l);
        aDialog.addRelationshipListener(this.diagramDisplayHandler);
        aDialog.initForEdit(null);
        aDialog.setSuperRelationship(superRelationship);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public RelationshipDialog showRelationshipDialog(Relationship relationship) {
        RelationshipDialog aDialog = this.getRelationshipDialog();
        aDialog.initForEdit(relationship);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public RelationshipDialog showRelationshipDialog(Relationship relationship, RelationshipListener l) {
        RelationshipDialog aDialog = this.getRelationshipDialog();
        aDialog.addRelationshipListener(l);
        aDialog.addRelationshipListener(this.diagramDisplayHandler);
        aDialog.initForEdit(relationship);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public BaseAttributeDialog showBaseAttributeDialog(Concept concept, BaseAttribute baseAttribute) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing a BaseAttributeDialog...");
        }
        BaseAttributeDialog aDialog = this.getBaseAttributeDialog();
        aDialog.addBaseAttributeListener(this.diagramDisplayHandler);
        if (logger.isDebugEnabled()) {
            if (this.diagramDisplayHandler == null) {
                logger.debug((Object)"DisplayHandler is NULL!");
            } else {
                logger.debug((Object)"DisplayHandler is not NULL");
            }
        }
        aDialog.initForEdit(concept, baseAttribute);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public MCFeatureDialog showMultiColumnFeatureDialog(Concept concept, MultiColumnFeature multiColumnFeature) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing a MCFeature dialog...");
        }
        MCFeatureDialog aDialog = this.getMultiColumnFeatureDialog();
        aDialog.initForEdit(concept, multiColumnFeature);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public ColumnSetDialog showColumnSetDialog(ColumnSet columnSet) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing a ColumnSet dialog...");
        }
        ColumnSetDialog aDialog = this.getColumnSetDialog();
        aDialog.initForDisplay(columnSet);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public ColumnDialog showColumnDialog(Column column) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing a Column dialog...");
        }
        ColumnDialog aDialog = this.getColumnDialog();
        aDialog.initForDisplay(column);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public MapBaseAttributesDialog showMapBaseAttributesDialog(Concept concept, ColumnSet columnSet) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing a MapBaseAttributes dialog...");
        }
        MapBaseAttributesDialog aDialog = this.getMapBaseAttributesDialog();
        aDialog.initForEdit(concept, columnSet);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public SimpleListDialog showSimpleListDialog(ListModel listModel, String title) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing a SimpleListDialog...");
        }
        SimpleListDialog aDialog = this.getSimpleListDialog();
        aDialog.clear();
        aDialog.setListModel(listModel);
        aDialog.setTitle(title);
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    public OneToManyRelationDialog showOneToManyRelationDialog(Relationship relationship) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing a OneToManyRelationDialog...");
        }
        OneToManyRelationDialog aDialog = this.getOneToManyRelationDialog();
        aDialog.initForEdit(relationship);
        aDialog.pack();
        aDialog.centralize();
        ((Component)aDialog).setVisible(true);
        return aDialog;
    }

    private ConceptDialog getConceptDialog() {
        if (this.conceptDialog == null) {
            this.conceptDialog = new ConceptDialog(this.parentFrame, true);
            this.conceptDialog.setDialogManager(this);
        }
        return this.conceptDialog;
    }

    private DataDialog getDataDialog() {
        if (this.dataDialog == null) {
            this.dataDialog = new DataDialog(this.parentFrame, true);
        }
        return this.dataDialog;
    }

    private StatisticsDialog getStatisticsDialog() {
        if (this.statisticsDialog == null) {
            this.statisticsDialog = new StatisticsDialog(this.parentFrame, true);
        }
        return this.statisticsDialog;
    }

    private RelationshipDialog getRelationshipDialog() {
        if (this.relationshipDialog == null) {
            this.relationshipDialog = new RelationshipDialog(this.parentFrame, true);
        }
        return this.relationshipDialog;
    }

    private BaseAttributeDialog getBaseAttributeDialog() {
        if (this.baseAttributeDialog == null) {
            this.baseAttributeDialog = new BaseAttributeDialog(this.parentFrame, true);
        }
        return this.baseAttributeDialog;
    }

    private MCFeatureDialog getMultiColumnFeatureDialog() {
        if (this.mcFeatureDialog == null) {
            this.mcFeatureDialog = new MCFeatureDialog(this.parentFrame, true);
        }
        return this.mcFeatureDialog;
    }

    private ColumnSetDialog getColumnSetDialog() {
        if (this.columnSetDialog == null) {
            this.columnSetDialog = new ColumnSetDialog(this.parentFrame, true);
            this.columnSetDialog.setDialogManager(this);
        }
        return this.columnSetDialog;
    }

    private ColumnDialog getColumnDialog() {
        if (this.columnDialog == null) {
            this.columnDialog = new ColumnDialog(this.parentFrame, true);
        }
        return this.columnDialog;
    }

    private MapBaseAttributesDialog getMapBaseAttributesDialog() {
        if (this.mapBaseAttributesDialog == null) {
            this.mapBaseAttributesDialog = new MapBaseAttributesDialog(this.parentFrame, true);
        }
        return this.mapBaseAttributesDialog;
    }

    private SimpleListDialog getSimpleListDialog() {
        if (this.simpleListDialog == null) {
            this.simpleListDialog = new SimpleListDialog(this.parentFrame, true);
        }
        return this.simpleListDialog;
    }

    private OneToManyRelationDialog getOneToManyRelationDialog() {
        if (this.oneToManyRelationDialog == null) {
            this.oneToManyRelationDialog = new OneToManyRelationDialog(this.parentFrame, true);
        }
        return this.oneToManyRelationDialog;
    }

    public void setDiagramDisplayHandler(DiagramDisplayHandler diagramDisplayHandler) {
        if (diagramDisplayHandler == null) {
            logger.debug((Object)"DisplayHandler is NULL!");
        } else {
            logger.debug((Object)"DisplayHandler is not NULL");
        }
        this.diagramDisplayHandler = diagramDisplayHandler;
    }
}

