/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.db.DBConnectInfo;
import com.syllogic.miningmart.concepteditor.db.DBUtil;
import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import com.syllogic.miningmart.concepteditor.util.MapTableModel;
import com.syllogic.miningmart.m4.Column;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import miningmart.m4.Case;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.M4Interface;
import org.apache.log4j.Logger;

public class DataDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"DataDialog");
    private DBConnectInfo dbConnectInfo;
    private Frame parentFrame;
    private ColumnSet currentColumnSet;
    private Map map = new HashMap();
    private List columnNames = new ArrayList();
    private JPanel tablePanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton();
    private JTable table = new JTable();

    public DataDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setParent(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DataDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)new JScrollPane(this.table), "Center");
        this.tablePanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.getContentPane().add((Component)this.tablePanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void initForEdit(ColumnSet columnSet, int maxRows) {
        String title = "View data";
        this.setTitle(title);
        this.currentColumnSet = columnSet;
        String schema = this.currentColumnSet.getSchema();
        String tableName = this.currentColumnSet.getName();
        String colsSQL = "";
        String theSQL = "";
        Collection columns = this.currentColumnSet.getAllColumns();
        Iterator it = columns.iterator();
        int i = 1;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            String columnName = column.getName();
            String columnSql = column.getSqlString();
            colsSQL = i == 1 ? this.isNullable(columnSql) + columnName : colsSQL + ", " + this.isNullable(columnSql) + columnName;
            ++i;
        }
        if (tableName == null) {
            theSQL = this.currentColumnSet.getSqlString();
        } else {
            theSQL = "select " + colsSQL + " from " + schema + "." + tableName;
            title = title + " for " + schema + "." + tableName;
        }
        if (this.dbConnectInfo == null) {
            this.dbConnectInfo = DBConnectInfo.getDBConnectInfo();
            if (this.dbConnectInfo == null) {
                return;
            }
        }
        try {
            this.map = DBUtil.executeSQLQ(this.dbConnectInfo, theSQL, maxRows);
            this.columnNames = (List)this.map.get("mmColumnNames");
            MapTableModel model = new MapTableModel();
            model.setMap(this.map);
            model.setColumnNames(this.columnNames);
            this.table.setModel(model);
            int nrColumns = model.getColumnCount();
            int nrRows = model.getRowCount();
            int width = 600;
            int height = 300;
            if (nrColumns > 7) {
                width = nrColumns * 100;
                this.table.setAutoResizeMode(0);
            } else {
                this.table.setAutoResizeMode(2);
            }
            this.table.setSize(new Dimension(width, height));
            logger.info((Object)("Number of columns is " + nrColumns));
            logger.info((Object)("Number of rows is " + nrRows));
            title = nrRows == 1 ? title + "  (1 row)" : (nrRows < maxRows ? title + "  (" + nrRows + " rows)" : title + "  (max " + maxRows + " rows)");
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        this.setTitle(title);
    }

    private String isNullable(String columnSql) {
        if (columnSql == null) {
            return "";
        }
        return columnSql + " ";
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOK();
        }
    }

    private void doOK() {
        this.currentColumnSet = null;
        ((Component)this).setVisible(false);
    }

    public void close() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    private void setParent(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame();
        ((Component)testFrame).setBounds(10, 10, 60, 40);
        ((Component)testFrame).setVisible(true);
        M4Interface myInterface = M4Interface.getInstance();
        Case salesCase = null;
        try {
            salesCase = myInterface.findCaseForReadOnlyAccess("DM_SALES_PREDICTION", true);
        }
        catch (M4Interface.CaseLockedException e) {
            e.printStackTrace();
        }
        Concept shopSales = salesCase.getConcept("DMTIME1");
        ColumnSet shopSalesCS = shopSales.getColumnSet("DM_TIME_VALID");
        DataDialog aDialog = new DataDialog((Frame)testFrame, true);
        aDialog.initForEdit(shopSalesCS, 1000);
        aDialog.pack();
        ((Component)aDialog).setSize(new Dimension(700, 500));
        ((Component)aDialog).setVisible(true);
        myInterface.releaseCase("DM_SALES_PREDICTION");
        System.exit(0);
    }
}

