/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.ConceptEditor;
import com.syllogic.miningmart.concepteditor.db.DBConnectInfo;
import com.syllogic.miningmart.concepteditor.db.DBObject;
import com.syllogic.miningmart.concepteditor.db.DBUtil;
import com.syllogic.miningmart.concepteditor.dialogs.BaseAttributeDialog;
import com.syllogic.miningmart.concepteditor.dialogs.ColumnSetDialog;
import com.syllogic.miningmart.concepteditor.dialogs.ConceptBaseAttributePanel;
import com.syllogic.miningmart.concepteditor.dialogs.ConceptColumnSetPanel;
import com.syllogic.miningmart.concepteditor.dialogs.ConceptConnectionPanel;
import com.syllogic.miningmart.concepteditor.dialogs.ConceptDescriptionPanel;
import com.syllogic.miningmart.concepteditor.dialogs.ConceptMCFeaturePanel;
import com.syllogic.miningmart.concepteditor.dialogs.ConceptPropertiesPanel;
import com.syllogic.miningmart.concepteditor.dialogs.DataDialog;
import com.syllogic.miningmart.concepteditor.dialogs.DialogManager;
import com.syllogic.miningmart.concepteditor.dialogs.MCFeatureDialog;
import com.syllogic.miningmart.concepteditor.dialogs.MapBaseAttributesDialog;
import com.syllogic.miningmart.concepteditor.dialogs.SelectUtility;
import com.syllogic.miningmart.concepteditor.dialogs.StatisticsDialog;
import com.syllogic.miningmart.concepteditor.event.BaseAttributeEvent;
import com.syllogic.miningmart.concepteditor.event.BaseAttributeListener;
import com.syllogic.miningmart.concepteditor.event.ConceptEvent;
import com.syllogic.miningmart.concepteditor.event.ConceptListener;
import com.syllogic.miningmart.concepteditor.event.MultiColumnFeatureEvent;
import com.syllogic.miningmart.concepteditor.event.MultiColumnFeatureListener;
import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import com.syllogic.miningmart.concepteditor.util.MyListCellRenderer;
import com.syllogic.miningmart.concepteditor.util.MyListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Case;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.CreateException;
import miningmart.m4.M4Interface;
import miningmart.m4.MultiColumnFeature;
import miningmart.m4.NameExistsException;
import miningmart.m4.PrimaryKey;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;

public class ConceptDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"ConceptDialog");
    private MyListModel superConceptListModel = new MyListModel();
    private MyListModel projectionListModel = new MyListModel();
    private MyListModel baListModel = new MyListModel();
    private MyListModel mcfListModel = new MyListModel();
    private MyListModel csListModel = new MyListModel();
    private MyListModel dbObjectsListModel = new MyListModel();
    private Concept currentConcept;
    private boolean conceptChanged;
    private DialogManager dialogManager;
    private Frame parentFrame;
    private ArrayList conListenerList = new ArrayList();
    private ArrayList baListenerList = new ArrayList();
    private ArrayList mcfListenerList = new ArrayList();
    private boolean nameChanged;
    private boolean superConceptChanged;
    private boolean typeChanged;
    private boolean projectionChanged;
    private boolean validityChanged;
    private String[] conceptTypes = new String[]{"BASE", "DB", "MINING"};
    private String[] dummyConcepts = new String[]{"Partner", "Contract"};
    private int numberOfProperties = 6;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel southPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JTextArea messageTextArea = new JTextArea();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton helpButton = new JButton();
    private ConceptPropertiesPanel propertiesTab = new ConceptPropertiesPanel();
    private ConceptBaseAttributePanel baseAttributeTab = new ConceptBaseAttributePanel();
    private ConceptMCFeaturePanel mcFeatureTab = new ConceptMCFeaturePanel();
    private ConceptColumnSetPanel columnSetTab = new ConceptColumnSetPanel();
    private ConceptConnectionPanel connectTab = new ConceptConnectionPanel();
    private ConceptDescriptionPanel descriptionTab = new ConceptDescriptionPanel();
    private boolean inputOK;

    public ConceptDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setParent(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Concept properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConceptDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.southPanel.add((Component)this.buttonPanel, "North");
        this.messageTextArea.setText("");
        this.messageTextArea.setBackground(new Color(212, 208, 200));
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setVerifyInputWhenFocusTarget(false);
        this.messageTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.messageTextArea.setMinimumSize(new Dimension(479, 18));
        this.messageTextArea.setPreferredSize(new Dimension(479, 18));
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.helpButton.setText("Help");
        this.helpButton.setActionCommand("Help");
        this.helpButton.setMnemonic('H');
        HelpBroker mainHB = ConceptEditor.getHelpBroker();
        if (mainHB != null) {
            mainHB.enableHelpOnButton((Component)this.helpButton, "con.concepttoc", null);
        }
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.helpButton);
        this.baseAttributeTab.addActionListener(this);
        this.mcFeatureTab.addActionListener(this);
        this.columnSetTab.addActionListener(this);
        this.connectTab.addActionListener(this);
        this.tabbedPane.add((Component)new JScrollPane(this.propertiesTab), "Properties");
        this.tabbedPane.add((Component)this.baseAttributeTab, "BaseAttributes");
        this.tabbedPane.add((Component)this.mcFeatureTab, "MultiColumnFeatures");
        this.tabbedPane.add((Component)this.columnSetTab, "ColumnSets");
        this.tabbedPane.add((Component)this.connectTab, "Connect");
        this.tabbedPane.add((Component)this.descriptionTab, "Description");
        int preferredHeight = (this.numberOfProperties + 1) * 20 + 80;
        this.tabbedPane.setPreferredSize(new Dimension(500, preferredHeight));
        this.propertiesTab.getSuperConceptComboBox().setModel(this.superConceptListModel);
        this.propertiesTab.getProjectionComboBox().setModel(this.projectionListModel);
        this.baseAttributeTab.getBaseAttributeList().setModel(this.baListModel);
        this.baseAttributeTab.getBaseAttributeList().setCellRenderer(new MyListCellRenderer());
        this.mcFeatureTab.getMCFeatureList().setModel(this.mcfListModel);
        this.mcFeatureTab.getMCFeatureList().setCellRenderer(new MyListCellRenderer());
        this.columnSetTab.getColumnSetList().setModel(this.csListModel);
        this.columnSetTab.getColumnSetList().setCellRenderer(new MyListCellRenderer());
        JComboBox conceptTypeComboBox = this.propertiesTab.getConceptTypeComboBox();
        conceptTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String type = (String)ConceptDialog.this.propertiesTab.getConceptTypeComboBox().getSelectedItem();
                if (type.equals("DB")) {
                    ConceptDialog.this.tabbedPane.setEnabledAt(ConceptDialog.this.tabbedPane.indexOfComponent(ConceptDialog.this.connectTab), true);
                } else {
                    ConceptDialog.this.tabbedPane.setEnabledAt(ConceptDialog.this.tabbedPane.indexOfComponent(ConceptDialog.this.connectTab), false);
                }
                if (type.equals("DB") || type.equals("BASE")) {
                    ConceptDialog.this.propertiesTab.getSuperConceptComboBox().setEnabled(true);
                    ConceptDialog.this.propertiesTab.getProjectionComboBox().setEnabled(true);
                } else {
                    ConceptDialog.this.propertiesTab.getSuperConceptComboBox().setEnabled(false);
                    ConceptDialog.this.propertiesTab.getProjectionComboBox().setEnabled(false);
                }
            }
        });
    }

    public void initForEdit(Concept concept) {
        this.tabbedPane.setSelectedIndex(0);
        this.setNameChanged(false);
        this.setSuperConceptChanged(false);
        this.setProjectionChanged(false);
        this.setTypeChanged(false);
        this.setValidityChanged(false);
        this.currentConcept = null;
        if (concept == null) {
            this.initForNewConcept();
            return;
        }
        Case currentCase = M4Interface.getCurrentCase();
        this.currentConcept = concept;
        this.fillConceptListModels();
        JTextField nameField = this.propertiesTab.getNameTextField();
        nameField.setText(this.currentConcept.getName());
        nameField.requestFocus();
        this.propertiesTab.getConceptTypeComboBox().setSelectedItem(this.currentConcept.getConceptType());
        Concept superConcept = this.currentConcept.getSuperConcept();
        if (superConcept == null) {
            this.superConceptListModel.setSelectedItem("<None>");
        } else {
            this.superConceptListModel.setSelectedItem(superConcept.getName());
        }
        Concept fromProjection = this.currentConcept.getFromProjection();
        if (fromProjection == null) {
            this.projectionListModel.setSelectedItem("<None>");
        } else {
            this.projectionListModel.setSelectedItem(fromProjection.getName());
        }
        if (currentCase.getPopulation() == this.currentConcept) {
            this.propertiesTab.getPopulationCheckBox().setSelected(true);
        } else {
            this.propertiesTab.getPopulationCheckBox().setSelected(false);
        }
        if (currentCase.getOutput() == this.currentConcept) {
            this.propertiesTab.getOutputCheckBox().setSelected(true);
        } else {
            this.propertiesTab.getOutputCheckBox().setSelected(false);
        }
        this.fillBaseAttributeListModel();
        this.fillMCFeatureListModel();
        this.fillColumnSetListModel();
        if (this.currentConcept.getConceptType().equalsIgnoreCase("DB")) {
            Object[] columnSets = this.currentConcept.getAllColumnSets().toArray();
            if (columnSets == null || columnSets.length == 0) {
                this.connectTab.getColumnSetTextField().setText("<NONE...>");
            } else if (columnSets.length == 1) {
                this.connectTab.getColumnSetTextField().setText(((ColumnSet)columnSets[0]).getName());
            } else if (columnSets.length > 1) {
                this.connectTab.getColumnSetTextField().setText("More ColumnSets exist; first remove them");
            }
        } else {
            this.connectTab.getColumnSetTextField().setText("<NONE...>");
            this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(this.connectTab), false);
        }
        this.descriptionTab.getDescriptionTextArea().setText(this.currentConcept.getDocumentation());
    }

    private void fillConceptListModels() {
        this.superConceptListModel.clear();
        this.projectionListModel.clear();
        this.superConceptListModel.addElement("<None>");
        this.projectionListModel.addElement("<None>");
        Collection allConcepts = M4Interface.getCurrentCase().getAllConcepts();
        Iterator i = allConcepts.iterator();
        while (i.hasNext()) {
            Concept aConcept = (Concept)i.next();
            String aConceptType = aConcept.getConceptType();
            if (!aConceptType.equalsIgnoreCase("BASE") && !aConceptType.equalsIgnoreCase("DB")) continue;
            this.superConceptListModel.addElement(aConcept.getName());
            this.projectionListModel.addElement(aConcept.getName());
        }
        if (this.currentConcept != null) {
            this.superConceptListModel.removeElement(this.currentConcept.getName());
            this.projectionListModel.removeElement(this.currentConcept.getName());
        }
    }

    private void fillBaseAttributeListModel() {
        this.baListModel.clear();
        Collection allBaseAttributes = this.currentConcept.getAllBaseAttributes();
        Iterator i = allBaseAttributes.iterator();
        while (i.hasNext()) {
            BaseAttribute aBaseAttribute = (BaseAttribute)i.next();
            this.baListModel.addElement(aBaseAttribute);
        }
    }

    private void fillMCFeatureListModel() {
        this.mcfListModel.clear();
        Collection allMultiColumnFeatures = this.currentConcept.getAllMultiColumnFeatures();
        Iterator i = allMultiColumnFeatures.iterator();
        while (i.hasNext()) {
            MultiColumnFeature aMultiColumnFeature = (MultiColumnFeature)i.next();
            this.mcfListModel.addElement(aMultiColumnFeature);
        }
    }

    private void fillColumnSetListModel() {
        this.csListModel.clear();
        Collection allColumnSets = this.currentConcept.getAllColumnSets();
        Iterator i = allColumnSets.iterator();
        while (i.hasNext()) {
            ColumnSet aColumnSet = (ColumnSet)i.next();
            this.csListModel.addElement(aColumnSet);
        }
    }

    private void initForNewConcept() {
        Case currentCase = M4Interface.getCurrentCase();
        this.fillConceptListModels();
        JTextField nameField = this.propertiesTab.getNameTextField();
        nameField.setText("");
        nameField.requestFocus();
        this.propertiesTab.getConceptTypeComboBox().setSelectedItem("BASE");
        this.superConceptListModel.setSelectedItem("<None>");
        this.projectionListModel.setSelectedItem("<None>");
        this.propertiesTab.getPopulationCheckBox().setSelected(false);
        this.propertiesTab.getOutputCheckBox().setSelected(false);
        this.baListModel.clear();
        this.mcfListModel.clear();
        this.csListModel.clear();
        this.connectTab.getColumnSetTextField().setText("<NONE...>");
        this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(this.connectTab), false);
        this.descriptionTab.getDescriptionTextArea().setText("");
    }

    public void setSuperConcept(Concept superConcept) {
        if (superConcept == null) {
            this.propertiesTab.getSuperConceptComboBox().setSelectedItem("<None>");
        } else {
            this.propertiesTab.getSuperConceptComboBox().setSelectedItem(superConcept.getName());
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOK();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button");
            }
            this.doCancel();
        } else if (command.equalsIgnoreCase("NewBaseAttribute")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New BaseAttribute button");
            }
            this.doNewBaseAttribute();
        } else if (command.equalsIgnoreCase("EditBaseAttribute")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Edit BaseAttribute button");
            }
            this.doEditBaseAttribute();
        } else if (command.equalsIgnoreCase("DeleteBaseAttribute")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete BaseAttribute button");
            }
            this.doDeleteBaseAttribute();
        } else if (command.equalsIgnoreCase("NewMCFeature")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New MCFeature button");
            }
            this.doNewMCFeature();
        } else if (command.equalsIgnoreCase("EditMCFeature")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Edit MCFeature button");
            }
            this.doEditMCFeature();
        } else if (command.equalsIgnoreCase("DeleteMCFeature")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete MCFeature button");
            }
            this.doDeleteMCFeature();
        } else if (command.equalsIgnoreCase("ColumnSetProperties")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Show ColumnSet properties button");
            }
            this.doShowColumnSetProperties();
        } else if (command.equalsIgnoreCase("ShowData")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Show data");
            }
            this.doShowData();
        } else if (command.equalsIgnoreCase("ShowStatistics")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Show statistics");
            }
            this.doShowStatistics();
        } else if (command.equalsIgnoreCase("DeleteColumnSet")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete ColumnSet button");
            }
            this.doDeleteColumnSet();
        } else if (command.equalsIgnoreCase("RemoveConnection")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"RemoveConnection button");
            }
            this.doRemoveConnection();
        } else if (command.equalsIgnoreCase("ConnectConcept")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Connect Concept button");
            }
            this.doConnectConcept();
        }
    }

    private void doOK() {
        this.setInputOK(false);
        if (this.currentConcept == null) {
            this.processInputForNewConcept();
        } else {
            this.processInputForExistingConcept();
        }
        if (this.isInputOK()) {
            ((Component)this).setVisible(false);
        }
    }

    private void processInputForExistingConcept() {
        String message;
        boolean isOutput;
        String message2;
        boolean isPopulation;
        String projectionName;
        String superConceptName;
        String description;
        Case currentCase = M4Interface.getCurrentCase();
        String oldName = this.currentConcept.getName();
        Concept oldSuperConcept = this.currentConcept.getSuperConcept();
        Concept oldFromProjection = this.currentConcept.getFromProjection();
        String oldDescription = this.currentConcept.getDocumentation();
        String name = this.getConceptNameFromTextField();
        if (this.conceptNameEmpty(name)) {
            this.setInputOK(false);
            return;
        }
        if (!name.equals(oldName)) {
            try {
                this.currentConcept.setName(name);
                this.setNameChanged(true);
            }
            catch (NameExistsException e) {
                logger.info((Object)"There already exists a Concept with this name.");
                String message3 = "There already exists a Concept with this name.\nPlease provide another name.\n\n(Note: Names are case sensitive.)";
                JOptionPane.showMessageDialog(this, message3, "Duplicate name...", 1);
                this.setFocusToNameField();
                this.setInputOK(false);
                return;
            }
        }
        this.setInputOK(true);
        String type = (String)this.propertiesTab.getConceptTypeComboBox().getSelectedItem();
        if (type != this.currentConcept.getConceptType()) {
            this.currentConcept.setConceptType(type);
            this.setTypeChanged(true);
        }
        if (!(description = this.descriptionTab.getDescriptionTextArea().getText()).equalsIgnoreCase(oldDescription)) {
            this.currentConcept.setDocumentation(description);
        }
        if (!(superConceptName = (String)this.propertiesTab.getSuperConceptComboBox().getSelectedItem()).equalsIgnoreCase("<None>") || oldSuperConcept != null) {
            String message4;
            if (!superConceptName.equalsIgnoreCase("<None>") && oldSuperConcept == null) {
                try {
                    this.currentConcept.setSuperConcept(currentCase.getConcept(superConceptName));
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not set super concept", (Throwable)e);
                    message4 = "A data communication error occurred!\nCould not set super concept.";
                    JOptionPane.showMessageDialog(this, message4, "Error", 0);
                }
                this.setSuperConceptChanged(true);
            } else if (superConceptName != oldSuperConcept.getName()) {
                try {
                    this.currentConcept.setSuperConcept(currentCase.getConcept(superConceptName));
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not set super concept", (Throwable)e);
                    message4 = "A data communication error occurred!\nCould not set super concept.";
                    JOptionPane.showMessageDialog(this, message4, "Error", 0);
                }
                this.setSuperConceptChanged(true);
            }
        }
        if (!(projectionName = (String)this.propertiesTab.getProjectionComboBox().getSelectedItem()).equalsIgnoreCase("<None>") || oldFromProjection != null) {
            String message5;
            if (!projectionName.equalsIgnoreCase("<None>") && oldFromProjection == null) {
                try {
                    this.currentConcept.setFromProjection(currentCase.getConcept(projectionName));
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not set projection.", (Throwable)e);
                    message5 = "A data communication error occurred!\nCould not set projection.";
                    JOptionPane.showMessageDialog(this, message5, "Error", 0);
                }
                this.setProjectionChanged(true);
            } else if (projectionName != oldFromProjection.getName()) {
                try {
                    this.currentConcept.setFromProjection(currentCase.getConcept(projectionName));
                }
                catch (StorageException e) {
                    logger.error((Object)"Could not set projection.", (Throwable)e);
                    message5 = "A data communication error occurred!\nCould not set projection.";
                    JOptionPane.showMessageDialog(this, message5, "Error", 0);
                }
                this.setProjectionChanged(true);
            }
        }
        if ((isPopulation = this.propertiesTab.getPopulationCheckBox().isSelected()) && currentCase.getPopulation() != this.currentConcept) {
            try {
                currentCase.setPopulation(this.currentConcept);
            }
            catch (StorageException e) {
                logger.error((Object)"Could not set population.", (Throwable)e);
                message2 = "A data communication error occurred!\nCould not set population.";
                JOptionPane.showMessageDialog(this, message2, "Error", 0);
            }
        }
        if (!isPopulation && currentCase.getPopulation() == this.currentConcept) {
            try {
                currentCase.setPopulation(null);
            }
            catch (StorageException e) {
                logger.error((Object)"Could not set population.", (Throwable)e);
                message2 = "A data communication error occurred!\nCould not set population.";
                JOptionPane.showMessageDialog(this, message2, "Error", 0);
            }
        }
        if ((isOutput = this.propertiesTab.getOutputCheckBox().isSelected()) && currentCase.getOutput() != this.currentConcept) {
            try {
                currentCase.setOutput(this.currentConcept);
            }
            catch (Exception e) {
                logger.error((Object)"Could not set output.", (Throwable)e);
                message = "A data communication error occurred!\nCould not set output.";
                JOptionPane.showMessageDialog(this, message, "Error", 0);
            }
        }
        if (!isOutput && currentCase.getOutput() == this.currentConcept) {
            try {
                currentCase.setOutput(null);
            }
            catch (Exception e) {
                logger.error((Object)"Could not set output.", (Throwable)e);
                message = "A data communication error occurred!\nCould not set output.";
                JOptionPane.showMessageDialog(this, message, "Error", 0);
            }
        }
        if (currentCase.isChanged()) {
            try {
                currentCase.store();
            }
            catch (StorageException e) {
                logger.error((Object)"Could not store Case record.", (Throwable)e);
                message = "A data communication error occurred!\nCould not update the output and/or population settings for the Concept.";
                JOptionPane.showMessageDialog(this, message, "Error", 0);
            }
        }
        if (this.currentConcept.isChanged()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Trying to store a concept...");
                    logger.debug((Object)("Name: " + this.currentConcept.getName()));
                }
                this.currentConcept.store();
            }
            catch (StorageException e) {
                logger.error((Object)"Could not store Concept record.", (Throwable)e);
                message = "A data communication error occurred!\nCould not update the settings for the Concept.";
                JOptionPane.showMessageDialog(this, message, "Error", 0);
            }
        }
        if (this.isConceptChanged()) {
            this.fireConceptChanged(this.currentConcept, oldName, oldSuperConcept, oldFromProjection, this.isNameChanged(), this.isSuperConceptChanged(), this.isProjectionChanged(), this.isTypeChanged(), this.isValidityChanged());
        }
    }

    private Concept processInputForNewConcept() {
        Concept newConcept;
        Case currentCase = M4Interface.getCurrentCase();
        String name = this.getConceptNameFromTextField();
        if (this.conceptNameEmpty(name)) {
            this.setInputOK(false);
            return null;
        }
        String type = (String)this.propertiesTab.getConceptTypeComboBox().getSelectedItem();
        String superConceptName = (String)this.propertiesTab.getSuperConceptComboBox().getSelectedItem();
        String projectionName = (String)this.propertiesTab.getProjectionComboBox().getSelectedItem();
        boolean isPopulation = this.propertiesTab.getPopulationCheckBox().isSelected();
        boolean isOutput = this.propertiesTab.getOutputCheckBox().isSelected();
        String description = this.descriptionTab.getDescriptionTextArea().getText();
        try {
            newConcept = currentCase.createConcept(name, type);
        }
        catch (CreateException e) {
            logger.error((Object)"Could not create a new Concept.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not create a new Concept.";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
            return null;
        }
        catch (NameExistsException e) {
            logger.info((Object)"There already exists a Concept with this name.");
            String message = "There already exists a Concept with this name.\nPlease provide another name.\n\n(Note: Names are case sensitive.)";
            JOptionPane.showMessageDialog(this, message, "Duplicate name...", 1);
            this.setFocusToNameField();
            this.setInputOK(false);
            return null;
        }
        this.setInputOK(true);
        try {
            if (!superConceptName.equalsIgnoreCase("<NONE>")) {
                newConcept.setSuperConcept(currentCase.getConcept(superConceptName));
            }
            if (!projectionName.equalsIgnoreCase("<NONE>")) {
                newConcept.setFromProjection(currentCase.getConcept(projectionName));
            }
            if (isPopulation) {
                currentCase.setPopulation(newConcept);
            }
            if (isOutput) {
                currentCase.setOutput(newConcept);
            }
            if (description != null || !description.equalsIgnoreCase("")) {
                newConcept.setDocumentation(description);
            }
        }
        catch (StorageException e) {
            logger.error((Object)"Could not store concept properties.", (Throwable)e);
            String message = "A data communication error occurred!\nCould not store concept properties.";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
        }
        this.fireConceptCreated(newConcept);
        return newConcept;
    }

    private String getConceptNameFromTextField() {
        String name = this.propertiesTab.getNameTextField().getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Concept name: " + name));
        }
        return name;
    }

    private boolean conceptNameEmpty(String name) {
        if (name.equalsIgnoreCase("")) {
            logger.info((Object)"Name is not allowed to be empty.");
            String message = "Name is not allowed to be empty.\nPlease provide a name.";
            JOptionPane.showMessageDialog(this, message, "Name...?", 1);
            this.setFocusToNameField();
            return true;
        }
        return false;
    }

    public void setFocusToNameField() {
        this.propertiesTab.getNameTextField().requestFocus();
    }

    private void doCancel() {
        this.close();
    }

    private void doNewBaseAttribute() {
        BaseAttributeDialog aDialog;
        BaseAttribute newBaseAttribute;
        if (this.currentConcept == null) {
            this.currentConcept = this.processInputForNewConcept();
            if (this.currentConcept == null) {
                return;
            }
        }
        if ((newBaseAttribute = (aDialog = this.dialogManager.showBaseAttributeDialog(this.currentConcept, null)).getCreatedBaseAttribute()) != null) {
            this.baListModel.addElement(newBaseAttribute);
        }
    }

    private void doEditBaseAttribute() {
        Object select = this.baseAttributeTab.getBaseAttributeList().getSelectedValue();
        if (select == null) {
            return;
        }
        BaseAttribute aBaseAttribute = (BaseAttribute)select;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BaseAttribute to be edited : " + aBaseAttribute.getName()));
        }
        BaseAttributeDialog baseAttributeDialog = this.dialogManager.showBaseAttributeDialog(this.currentConcept, aBaseAttribute);
    }

    private void doDeleteBaseAttribute() {
        Object select = this.baseAttributeTab.getBaseAttributeList().getSelectedValue();
        if (select == null) {
            return;
        }
        BaseAttribute aBaseAttribute = (BaseAttribute)select;
        String message = "Are you sure you want to delete BaseAttribute: " + aBaseAttribute.getName() + "?";
        int choice = JOptionPane.showConfirmDialog(this, message, "Continue?", 0, 3);
        if (choice != 0) {
            return;
        }
        try {
            aBaseAttribute.delete();
        }
        catch (StorageException e) {
            logger.error((Object)"Could not delete baseAttribute.", (Throwable)e);
            message = "A data communication error occurred!\nCould not delete baseAttribute.";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
        }
        this.baListModel.removeElement(aBaseAttribute);
        this.fireBaseAttributeDeleted(this.currentConcept);
    }

    private void doNewMCFeature() {
        Collection baseAttributes;
        if (this.currentConcept == null) {
            this.currentConcept = this.processInputForNewConcept();
            if (this.currentConcept == null) {
                return;
            }
        }
        if ((baseAttributes = this.currentConcept.getAllBaseAttributes()).size() < 2) {
            String message = "To create a MultiColumnFeature at least\ntwo BaseAttributes must exist.";
            JOptionPane.showMessageDialog(this, message, "Not fulfilled requirement", 1);
            return;
        }
        MCFeatureDialog aDialog = this.dialogManager.showMultiColumnFeatureDialog(this.currentConcept, null);
        MultiColumnFeature newMultiColumnFeature = aDialog.getCreatedMultiColumnFeature();
        if (newMultiColumnFeature != null) {
            this.mcfListModel.addElement(newMultiColumnFeature);
        }
        this.repaint();
    }

    private void doEditMCFeature() {
        Object select = this.mcFeatureTab.getMCFeatureList().getSelectedValue();
        if (select == null) {
            return;
        }
        MultiColumnFeature aMCFeature = (MultiColumnFeature)select;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MCFeature to be edited : " + aMCFeature.getName()));
        }
        MCFeatureDialog mCFeatureDialog = this.dialogManager.showMultiColumnFeatureDialog(this.currentConcept, aMCFeature);
    }

    private void doDeleteMCFeature() {
        Object select = this.mcFeatureTab.getMCFeatureList().getSelectedValue();
        if (select == null) {
            return;
        }
        MultiColumnFeature aMCFeature = (MultiColumnFeature)select;
        String message = "Are you sure you want to delete MultiColumnFeature: " + aMCFeature.getName() + "?";
        int choice = JOptionPane.showConfirmDialog(this, message, "Continue?", 0, 3);
        if (choice != 0) {
            return;
        }
        try {
            aMCFeature.delete();
        }
        catch (StorageException e) {
            logger.error((Object)"Could not delete multiColumnFeature.", (Throwable)e);
            message = "A data communication error occurred!\nCould not delete multiColumnFeature.";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
        }
        this.mcfListModel.removeElement(aMCFeature);
        this.fireMultiColumnFeatureDeleted(this.currentConcept);
    }

    private void doShowColumnSetProperties() {
        Object select = this.columnSetTab.getColumnSetList().getSelectedValue();
        if (select == null) {
            return;
        }
        ColumnSet aColumnSet = (ColumnSet)select;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ColumnSet to be edited : " + aColumnSet.getName()));
        }
        ColumnSetDialog columnSetDialog = this.dialogManager.showColumnSetDialog(aColumnSet);
    }

    private void doShowData() {
        Object select = this.columnSetTab.getColumnSetList().getSelectedValue();
        if (select == null) {
            return;
        }
        ColumnSet aColumnSet = (ColumnSet)select;
        DataDialog dataDialog = this.dialogManager.showDataDialog(aColumnSet);
    }

    private void doShowStatistics() {
        Object select = this.columnSetTab.getColumnSetList().getSelectedValue();
        if (select == null) {
            return;
        }
        ColumnSet aColumnSet = (ColumnSet)select;
        StatisticsDialog statisticsDialog = this.dialogManager.showStatisticsDialog(aColumnSet);
    }

    private void doDeleteColumnSet() {
        Object select = this.columnSetTab.getColumnSetList().getSelectedValue();
        if (select == null) {
            return;
        }
        ColumnSet aColumnSet = (ColumnSet)select;
        String message = "Are you sure you want to delete ColumnSet: " + aColumnSet.getName() + "?";
        int choice = JOptionPane.showConfirmDialog(this, message, "Continue?", 0, 3);
        if (choice != 0) {
            return;
        }
        try {
            aColumnSet.delete();
        }
        catch (StorageException e) {
            logger.error((Object)"Could not delete columnSet.", (Throwable)e);
            message = "A data communication error occurred!\nCould not delete columnSet.";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
        }
        this.csListModel.removeElement(aColumnSet);
    }

    private void doConnectConcept() {
        Collection dbObjects;
        SelectUtility select;
        DBObject selDBObject;
        Collection currentConceptCS;
        if (this.currentConcept == null) {
            this.currentConcept = this.processInputForNewConcept();
            if (this.currentConcept == null) {
                return;
            }
        }
        if ((currentConceptCS = this.currentConcept.getAllColumnSets()).size() > 0) {
            logger.warn((Object)"This Concept has one or more ColumnSets; they will be deleted");
            String message = "This Concept has one or more ColumnSets\nContinuing will remove the ColumnSets. Do you want to continue?";
            int choice = JOptionPane.showConfirmDialog(this, message, "ColumnSet exists", 0, 3);
            if (choice != 0) {
                return;
            }
            this.doRemoveConnection();
        }
        if ((selDBObject = (DBObject)(select = new SelectUtility()).selectObject(this.parentFrame, "DBObject", dbObjects = DBUtil.getDBObjects())) == null) {
            return;
        }
        String dbObjectName = selDBObject.getName();
        String dbObjectType = selDBObject.getType();
        String dbObjectCSType = null;
        dbObjectCSType = dbObjectType == "TABLE" ? "T" : "V";
        String username = DBConnectInfo.getDBConnectInfo().getUsername();
        ColumnSet dbObjectCS = null;
        try {
            dbObjectCS = this.currentConcept.createColumnSet(dbObjectName, username, dbObjectCSType);
            dbObjectCS.store();
            this.connectTab.getColumnSetTextField().setText(dbObjectName);
        }
        catch (CreateException e) {
            logger.error((Object)("Failed to create ColumnSet: " + dbObjectName));
            String message = "Failed to create ColumnSet: " + dbObjectName;
            JOptionPane.showMessageDialog(this, message, "Error", 0);
            return;
        }
        catch (NameExistsException e) {
            logger.error((Object)"Failed to create ColumnSet; name exits already");
        }
        catch (StorageException e) {
            logger.error((Object)("Failed to store ColumnSet: " + dbObjectName));
            String message = "Failed to store ColumnSet: " + dbObjectName;
            JOptionPane.showMessageDialog(this, message, "Error", 0);
            return;
        }
        if (logger.isDebugEnabled() && dbObjectCS != null) {
            logger.debug((Object)("ColumnSet created: " + dbObjectName));
        }
        String selectColumns = "SELECT column_name, data_type FROM \tUSER_TAB_COLUMNS WHERE table_name = '" + dbObjectName + "'";
        Map columnNamesMap = null;
        try {
            columnNamesMap = DBUtil.executeSQLQ(DBConnectInfo.getDBConnectInfo(), selectColumns, 5000);
        }
        catch (SQLException e) {
            logger.error((Object)"Query to find column names failed", (Throwable)e);
            String message = "Query to find column names failed";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
            return;
        }
        List columnNames = (List)columnNamesMap.get("COLUMN_NAME");
        List columnTypes = (List)columnNamesMap.get("DATA_TYPE");
        Iterator<Object> i = columnNames.iterator();
        while (i.hasNext()) {
            String aColumnName = (String)i.next();
            int index = columnNames.indexOf(aColumnName);
            String aType = (String)columnTypes.get(index);
            aType = DBUtil.convertOracleDatatype(aType);
            try {
                Column aColumn = dbObjectCS.createColumn(aColumnName, aType);
                aColumn.store();
            }
            catch (CreateException e) {
                logger.error((Object)("Failed to create Column: " + aColumnName));
                String message = "Failed to create ColumnSet: " + aColumnName;
                JOptionPane.showMessageDialog(this, message, "Error", 0);
                return;
            }
            catch (NameExistsException e) {
                logger.error((Object)"Failed to create Column; name exists already");
            }
            catch (StorageException e) {
                logger.error((Object)("Failed to store Column: " + aColumnName));
                String message = "Failed to store Column: " + aColumnName;
                JOptionPane.showMessageDialog(this, message, "Error", 0);
                return;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Column created: " + aColumnName + ", Type: " + aType));
        }
        logger.info((Object)("Created a ColumnSet and Columns for Concept: " + this.currentConcept.getName()));
        String columnSetMessage = "Successfully created a ColumnSet and Columns\nPlease continue to connect the BaseAttributes to the corresponding Columns";
        JOptionPane.showMessageDialog(this, columnSetMessage, "ColumnSet and Columns created", 1);
        MapBaseAttributesDialog aMapBaDialog = this.dialogManager.showMapBaseAttributesDialog(this.currentConcept, dbObjectCS);
        Map selectedColumns = aMapBaDialog.getSelectedColumns();
        i = selectedColumns.keySet().iterator();
        while (i.hasNext()) {
            String aBaseAttributeName = (String)i.next();
            String aColumnName = (String)selectedColumns.get(aBaseAttributeName);
            if (aColumnName.equalsIgnoreCase("<NONE...>")) continue;
            Column aColumn = dbObjectCS.getColumn(aColumnName);
            BaseAttribute aBaseAttribute = this.currentConcept.getBaseAttribute(aBaseAttributeName);
            aColumn.setBaseAttribute(aBaseAttribute);
        }
        ArrayList<Column> primaryKeyColumns = new ArrayList<Column>();
        Map selectedPrimaryKeys = aMapBaDialog.getSelectedPrimaryKeys();
        i = selectedPrimaryKeys.keySet().iterator();
        while (i.hasNext()) {
            String aBaseAttributeName = (String)i.next();
            Boolean aBoolean = (Boolean)selectedPrimaryKeys.get(aBaseAttributeName);
            if (!aBoolean.booleanValue()) continue;
            String aColumnName = (String)selectedColumns.get(aBaseAttributeName);
            Column aColumn = dbObjectCS.getColumn(aColumnName);
            primaryKeyColumns.add(aColumn);
        }
        PrimaryKey aPK = null;
        if (primaryKeyColumns.size() > 0) {
            try {
                aPK = dbObjectCS.createPrimaryKey(dbObjectCS.getName() + "_PK");
            }
            catch (CreateException e) {
                logger.error((Object)("Failed to create Primary Key for ColumnSet: " + dbObjectCS.getName()));
                String message = "Failed to create Primary Key for ColumnSet: " + dbObjectCS.getName();
                JOptionPane.showMessageDialog(this, message, "Error", 0);
                return;
            }
            catch (NameExistsException e) {
                logger.error((Object)"Failed to create PrimaryKey; name exits already");
            }
            i = primaryKeyColumns.iterator();
            while (i.hasNext()) {
                Column aColumn = (Column)i.next();
                try {
                    aPK.addColumn(aColumn);
                }
                catch (StorageException e) {
                    logger.error((Object)("Failed to add Column to Primary Key: " + aColumn.getName()));
                    String message = "Failed to add Column to Primary Key: " + aColumn.getName();
                    JOptionPane.showMessageDialog(this, message, "Error", 0);
                    return;
                }
            }
        }
        if (dbObjectCS != null) {
            this.csListModel.addElement(dbObjectCS);
        }
    }

    private void doRemoveConnection() {
        try {
            this.currentConcept.removeAllColumnSets();
            this.connectTab.getColumnSetTextField().setText("<NONE...>");
        }
        catch (StorageException e) {
            logger.error((Object)("Failed to delete all ColumnSets for Concept: " + this.currentConcept.getName()), (Throwable)e);
            String message = "Failed to delete all ColumnSets for Concept: " + this.currentConcept.getName() + "\n" + "Warning: data may be inconsistent now";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
        }
    }

    public void close() {
        this.currentConcept = null;
        ((Component)this).setVisible(false);
    }

    public boolean isConceptChanged() {
        return this.isNameChanged() || this.isTypeChanged() || this.isSuperConceptChanged() || this.isProjectionChanged() || this.isValidityChanged();
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    private void setParent(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void addConceptListener(ConceptListener l) {
        if (!this.conListenerList.contains(l)) {
            this.conListenerList.add(l);
        }
    }

    public void removeConceptListener(ConceptListener l) {
        if (this.conListenerList.contains(l)) {
            ((AbstractCollection)this.conListenerList).remove(l);
        }
    }

    public void addBaseAttributeListener(BaseAttributeListener l) {
        if (!this.baListenerList.contains(l)) {
            this.baListenerList.add(l);
        }
    }

    public void removeBaseAttributeListener(BaseAttributeListener l) {
        if (this.baListenerList.contains(l)) {
            ((AbstractCollection)this.baListenerList).remove(l);
        }
    }

    public void addMultiColumnFeatureListener(MultiColumnFeatureListener l) {
        if (!this.mcfListenerList.contains(l)) {
            this.mcfListenerList.add(l);
        }
    }

    public void removeMultiColumnFeatureListener(MultiColumnFeatureListener l) {
        if (this.mcfListenerList.contains(l)) {
            ((AbstractCollection)this.mcfListenerList).remove(l);
        }
    }

    public void fireConceptChanged(Concept concept, String oldName, Concept oldSuperConcept, Concept oldFromProjection, boolean nameChanged, boolean superConceptChanged, boolean projectionChanged, boolean typeChanged, boolean validityChanged) {
        ConceptEvent anEvent = new ConceptEvent(this, concept, oldName, oldSuperConcept, oldFromProjection, nameChanged, superConceptChanged, projectionChanged, typeChanged, validityChanged);
        ArrayList aList = (ArrayList)this.conListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            ConceptListener aListener = (ConceptListener)aList.get(i);
            aListener.conceptChanged(anEvent);
            ++i;
        }
    }

    public void fireConceptCreated(Concept concept) {
        ConceptEvent anEvent = new ConceptEvent(this, concept);
        ArrayList aList = (ArrayList)this.conListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            ConceptListener aListener = (ConceptListener)aList.get(i);
            aListener.conceptCreated(anEvent);
            ++i;
        }
    }

    public void fireConceptDeleted(Concept concept) {
        ConceptEvent anEvent = new ConceptEvent(this, concept);
        ArrayList aList = (ArrayList)this.conListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            ConceptListener aListener = (ConceptListener)aList.get(i);
            aListener.conceptDeleted(anEvent);
            ++i;
        }
    }

    public void fireBaseAttributeChanged(Concept concept) {
        BaseAttributeEvent anEvent = new BaseAttributeEvent(this, concept);
        ArrayList aList = (ArrayList)this.baListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            BaseAttributeListener aListener = (BaseAttributeListener)aList.get(i);
            aListener.baseAttributeChanged(anEvent);
            ++i;
        }
    }

    public void fireBaseAttributeCreated(Concept concept) {
        BaseAttributeEvent anEvent = new BaseAttributeEvent(this, concept);
        ArrayList aList = (ArrayList)this.baListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            BaseAttributeListener aListener = (BaseAttributeListener)aList.get(i);
            aListener.baseAttributeCreated(anEvent);
            ++i;
        }
    }

    public void fireBaseAttributeDeleted(Concept concept) {
        BaseAttributeEvent anEvent = new BaseAttributeEvent(this, concept);
        ArrayList aList = (ArrayList)this.baListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            BaseAttributeListener aListener = (BaseAttributeListener)aList.get(i);
            aListener.baseAttributeDeleted(anEvent);
            ++i;
        }
    }

    public void fireMultiColumnFeatureChanged(Concept concept) {
        MultiColumnFeatureEvent anEvent = new MultiColumnFeatureEvent(this, concept);
        ArrayList aList = (ArrayList)this.mcfListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            MultiColumnFeatureListener aListener = (MultiColumnFeatureListener)aList.get(i);
            aListener.multiColumnFeatureChanged(anEvent);
            ++i;
        }
    }

    public void fireMultiColumnFeatureCreated(Concept concept) {
        MultiColumnFeatureEvent anEvent = new MultiColumnFeatureEvent(this, concept);
        ArrayList aList = (ArrayList)this.mcfListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            MultiColumnFeatureListener aListener = (MultiColumnFeatureListener)aList.get(i);
            aListener.multiColumnFeatureCreated(anEvent);
            ++i;
        }
    }

    public void fireMultiColumnFeatureDeleted(Concept concept) {
        MultiColumnFeatureEvent anEvent = new MultiColumnFeatureEvent(this, concept);
        ArrayList aList = (ArrayList)this.mcfListenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            MultiColumnFeatureListener aListener = (MultiColumnFeatureListener)aList.get(i);
            aListener.multiColumnFeatureDeleted(anEvent);
            ++i;
        }
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public void setNameChanged(boolean nameChanged) {
        this.nameChanged = nameChanged;
    }

    public boolean isSuperConceptChanged() {
        return this.superConceptChanged;
    }

    public void setSuperConceptChanged(boolean superConceptChanged) {
        this.superConceptChanged = superConceptChanged;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public void setTypeChanged(boolean typeChanged) {
        this.typeChanged = typeChanged;
    }

    public boolean isProjectionChanged() {
        return this.projectionChanged;
    }

    public void setProjectionChanged(boolean projectionChanged) {
        this.projectionChanged = projectionChanged;
    }

    public boolean isValidityChanged() {
        return this.validityChanged;
    }

    public void setValidityChanged(boolean validityChanged) {
        this.validityChanged = validityChanged;
    }

    public boolean isInputOK() {
        return this.inputOK;
    }

    public void setInputOK(boolean inputOK) {
        this.inputOK = inputOK;
    }

    public void setDialogManager(DialogManager dialogManager) {
        this.dialogManager = dialogManager;
    }
}

