/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.DiagramRelation;
import com.syllogic.jfc.diagram.DragHandler;
import com.syllogic.jfc.diagram.DraggebleRelation;
import com.syllogic.jfc.diagram.DraggebleRelationRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class RelationDragHandler
implements DragHandler {
    private boolean firstDrag;
    private DraggebleRelation relation;
    private DraggebleRelationRenderer renderer;
    private Rectangle rect0;
    private Rectangle rect1;
    private Point[] points;
    private Point[] originalPoints;
    private int dragPoint;
    private boolean isDragging = false;

    public boolean isDragPoint(Diagram diagram, MouseEvent event) {
        Object[] anObj = diagram.getSelection();
        if (anObj.length != 1 || !(anObj[0] instanceof DraggebleRelation)) {
            return false;
        }
        DraggebleRelation aRel = (DraggebleRelation)anObj[0];
        anObj[0] = diagram.getRelationRenderer(aRel.getClass());
        if (!(anObj[0] instanceof DraggebleRelationRenderer)) {
            return false;
        }
        DraggebleRelationRenderer aRenderer = (DraggebleRelationRenderer)anObj[0];
        Point[] aList = aRenderer.getPoints(aRel, diagram.getRectangle(aRel.getFromComponent()), diagram.getRectangle(aRel.getToComponent()));
        Rectangle aRect = new Rectangle(event.getPoint());
        aRect.x -= 2;
        aRect.y -= 2;
        aRect.setSize(5, 5);
        return aRect.contains(aList[0]) || aRect.contains(aList[1]) || aRect.contains(aList[2]) || aRect.contains(aList[3]);
    }

    public boolean isDragging(Diagram diagram) {
        return this.isDragging;
    }

    private void setPoints(Point[] newPoints) {
        this.originalPoints = newPoints;
        this.points = new Point[newPoints.length];
        int i = 0;
        while (i < newPoints.length) {
            this.points[i] = (Point)newPoints[i].clone();
            ++i;
        }
    }

    private void updatePoints(int theDragPoint, Point thePoint) {
        int dx = thePoint.x - this.originalPoints[theDragPoint].x;
        int dy = thePoint.y - this.originalPoints[theDragPoint].y;
        this.points[theDragPoint].x = this.originalPoints[theDragPoint].x + dx;
        this.points[theDragPoint].y = this.originalPoints[theDragPoint].y + dy;
        if (theDragPoint == 0) {
            this.points[2].x = this.originalPoints[2].x + dx;
            this.points[2].y = this.originalPoints[2].y + dy;
        } else if (theDragPoint == 1) {
            this.points[3].x = this.originalPoints[3].x + dx;
            this.points[3].y = this.originalPoints[3].y + dy;
        }
        if (this.dragPoint == 0 && !this.rect0.contains(thePoint)) {
            if (thePoint.x > this.rect0.x + this.rect0.width) {
                this.points[this.dragPoint].x = this.rect0.x + this.rect0.width;
            } else if (thePoint.x < this.rect0.x) {
                this.points[this.dragPoint].x = this.rect0.x;
            }
            if (thePoint.y > this.rect0.y + this.rect0.height) {
                this.points[this.dragPoint].y = this.rect0.y + this.rect0.height;
            } else if (thePoint.y < this.rect0.y) {
                this.points[this.dragPoint].y = this.rect0.y;
            }
        }
        if (this.dragPoint == 1 && !this.rect1.contains(thePoint)) {
            if (thePoint.x > this.rect1.x + this.rect1.width) {
                this.points[this.dragPoint].x = this.rect1.x + this.rect1.width;
            } else if (thePoint.x < this.rect1.x) {
                this.points[this.dragPoint].x = this.rect1.x;
            }
            if (thePoint.y > this.rect1.y + this.rect1.height) {
                this.points[this.dragPoint].y = this.rect1.y + this.rect1.height;
            } else if (thePoint.y < this.rect1.y) {
                this.points[this.dragPoint].y = this.rect1.y;
            }
        }
    }

    private void paintDragShape(Graphics2D g2) {
        g2.draw(this.renderer.getDragShape((DiagramRelation)this.relation, this.rect0, this.rect1, this.points));
    }

    private void cleanup() {
        this.isDragging = false;
        this.relation = null;
        this.renderer = null;
        this.rect0 = null;
        this.rect1 = null;
        this.points = null;
        this.originalPoints = null;
    }

    public void dragStart(Diagram diagram, Graphics2D g2, MouseEvent evt) {
        this.relation = (DraggebleRelation)diagram.getSelection()[0];
        this.renderer = (DraggebleRelationRenderer)diagram.getRelationRenderer(this.relation.getClass());
        this.rect0 = diagram.getRectangle(this.relation.getFromComponent());
        this.rect1 = diagram.getRectangle(this.relation.getToComponent());
        this.setPoints(this.renderer.getPoints(this.relation, this.rect0, this.rect1));
        Rectangle aRect = new Rectangle(evt.getPoint());
        aRect.x -= 2;
        aRect.y -= 2;
        aRect.setSize(5, 5);
        if (aRect.contains(this.points[0])) {
            this.dragPoint = 0;
        } else if (aRect.contains(this.points[1])) {
            this.dragPoint = 1;
        } else if (aRect.contains(this.points[2])) {
            this.dragPoint = 2;
        } else if (aRect.contains(this.points[3])) {
            this.dragPoint = 3;
        } else {
            return;
        }
        this.firstDrag = true;
        this.isDragging = true;
    }

    public void drag(Diagram diagram, Graphics2D g2, MouseEvent evt) {
        if (!this.isDragging) {
            return;
        }
        g2.setXORMode(diagram.getBackground());
        g2.setColor(Color.black);
        if (!this.firstDrag) {
            this.paintDragShape(g2);
        } else {
            this.firstDrag = false;
        }
        Point aPoint = evt.getPoint();
        this.updatePoints(this.dragPoint, aPoint);
        this.paintDragShape(g2);
    }

    public void dragEnd(Diagram diagram, Graphics2D g2, MouseEvent evt) {
        if (!this.isDragging) {
            return;
        }
        g2.setXORMode(diagram.getBackground());
        g2.setColor(Color.black);
        if (!this.firstDrag) {
            this.paintDragShape(g2);
        }
        Point aPoint = new Point();
        int midXFrom = this.rect0.x + this.rect0.width / 2;
        int midXTo = this.rect1.x + this.rect1.width / 2;
        if (this.dragPoint == 0) {
            aPoint.x = (int)(100.0 * ((double)this.points[this.dragPoint].x - (double)this.rect0.x) / (double)this.rect0.width);
            aPoint.y = (int)(100.0 * ((double)this.points[this.dragPoint].y - (double)this.rect0.y) / (double)this.rect0.height);
            this.relation.setEndPoint(this.dragPoint, aPoint);
        } else if (this.dragPoint == 1) {
            aPoint.x = (int)(100.0 * ((double)this.points[this.dragPoint].x - (double)this.rect1.x) / (double)this.rect1.width);
            aPoint.y = (int)(100.0 * ((double)this.points[this.dragPoint].y - (double)this.rect1.y) / (double)this.rect1.height);
            this.relation.setEndPoint(this.dragPoint, aPoint);
        } else if (this.dragPoint == 2) {
            aPoint.x = midXFrom < midXTo ? this.points[this.dragPoint].x - this.originalPoints[0].x : -(this.points[this.dragPoint].x - this.originalPoints[0].x);
            aPoint.y = this.points[this.dragPoint].y - this.originalPoints[0].y;
            this.relation.setEndPoint(this.dragPoint, aPoint);
        } else if (this.dragPoint == 3) {
            aPoint.x = midXTo > midXFrom ? -(this.points[this.dragPoint].x - this.originalPoints[1].x) : this.points[this.dragPoint].x - this.originalPoints[1].x;
            aPoint.y = this.points[this.dragPoint].y - this.originalPoints[1].y;
            this.relation.setEndPoint(this.dragPoint, aPoint);
        }
        diagram.repaintLater();
        this.cleanup();
    }

    public void dragAbort(Diagram diagram, Graphics2D g2, MouseEvent evt) {
        g2.setXORMode(diagram.getBackground());
        g2.setColor(Color.black);
        if (!this.firstDrag) {
            this.paintDragShape(g2);
        } else {
            this.firstDrag = false;
        }
        System.err.println("dragAbort()");
        this.cleanup();
    }
}

