/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.ClickHandler;
import com.syllogic.jfc.event.DiagramEvent;
import com.syllogic.jfc.event.DiagramListener;
import com.syllogic.miningmart.concepteditor.ConceptEditor;
import com.syllogic.miningmart.concepteditor.diagram.ConceptComponent;
import com.syllogic.miningmart.concepteditor.diagram.DiagramDisplayHandler;
import com.syllogic.miningmart.concepteditor.diagram.RelationshipComponent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DiagramHandler
implements DiagramListener,
ClickHandler,
ActionListener {
    private JPopupMenu diagramPopUpMenu;
    private JMenuItem deleteMenuItem = new JMenuItem("Delete");
    private JMenuItem editMenuItem = new JMenuItem("Edit");
    private JMenuItem showAttributesMenuItem = new JMenuItem("Show attributes");
    private JMenuItem itsAddRelationToItselfMenuItem = new JMenuItem("Add relation to itself");
    private boolean isComponent;
    private boolean modifierPressed;
    private int numberOfClicks;
    private Point point;
    private boolean isPopUpTrigger;
    private ConceptComponent conceptComp;
    private RelationshipComponent relationshipComp;
    private DiagramDisplayHandler diagramDisplayHandler;
    private ConceptEditor manager;
    private Diagram diagram;
    private static final int MOD_MASK = 43;

    public DiagramHandler(ConceptEditor manager, Diagram diagram) {
        this.manager = manager;
        this.diagram = diagram;
        this.diagramDisplayHandler = manager.getDiagramDisplayHandler();
        this.addListeners();
    }

    public void click(Diagram diagram, MouseEvent event) {
        this.setLocalValues(event);
        if (this.modifierPressed || this.conceptComp == null & this.relationshipComp == null) {
            return;
        }
        if (this.conceptComp != null) {
            this.isComponent = true;
            this.handleComponentClicked();
            return;
        }
        if (this.relationshipComp != null) {
            this.isComponent = false;
            this.handleRelationClicked();
            return;
        }
    }

    private void setLocalValues(MouseEvent event) {
        this.modifierPressed = (event.getModifiers() & 0x2B) != 0;
        this.numberOfClicks = event.getClickCount();
        this.point = event.getPoint();
        this.isPopUpTrigger = (event.getModifiers() & 4) != 0;
        this.conceptComp = (ConceptComponent)this.diagram.findComponent(this.point);
        this.relationshipComp = (RelationshipComponent)this.diagram.findRelation(this.point);
    }

    public void componentClicked(DiagramEvent e) {
        this.setLocalValues(e.getMouseEvent());
        this.isComponent = true;
        this.handleComponentClicked();
    }

    private void handleComponentClicked() {
        if (this.numberOfClicks == 2) {
            this.manager.doShowProperties(this.conceptComp.getConcept());
        }
        if (this.isPopUpTrigger) {
            this.diagramPopUpMenu = new JPopupMenu();
            this.diagramPopUpMenu.add(this.editMenuItem);
            if (this.conceptComp.getShowAttributes()) {
                this.showAttributesMenuItem.setText("Hide attributes");
            } else {
                this.showAttributesMenuItem.setText("Show attributes");
            }
            if (this.conceptComp.getConcept().getAllBaseAttributes().size() > 0) {
                this.diagramPopUpMenu.add(this.showAttributesMenuItem);
            }
            this.diagramPopUpMenu.show((Component)this.diagram, this.point.x, this.point.y);
        }
    }

    public void relationClicked(DiagramEvent e) {
        this.setLocalValues(e.getMouseEvent());
        this.isComponent = false;
        this.handleRelationClicked();
    }

    private void handleRelationClicked() {
        if (this.numberOfClicks == 2) {
            this.manager.doShowProperties(this.relationshipComp.getRelationship());
        }
        if (this.isPopUpTrigger) {
            this.diagramPopUpMenu = new JPopupMenu();
            this.diagramPopUpMenu.add(this.editMenuItem);
            this.diagramPopUpMenu.show((Component)this.diagram, this.point.x, this.point.y);
        }
    }

    public void relationRequested(DiagramEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        this.handlePopUpMenuSelection(o);
    }

    private void handlePopUpMenuSelection(Object o) {
        if (o == this.editMenuItem) {
            if (this.isComponent) {
                this.manager.doShowProperties(this.conceptComp.getConcept());
            } else {
                this.manager.doShowProperties(this.relationshipComp.getRelationship());
            }
        } else if (o == this.showAttributesMenuItem) {
            this.conceptComp.setShowAttributes(!this.conceptComp.getShowAttributes());
            this.diagramDisplayHandler.updateDiagramView();
        }
    }

    private void addListeners() {
        this.diagram.addDiagramListener((DiagramListener)this);
        this.editMenuItem.addActionListener(this);
        this.showAttributesMenuItem.addActionListener(this);
        this.itsAddRelationToItselfMenuItem.addActionListener(this);
        this.deleteMenuItem.addActionListener(this);
    }
}

