/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.DefaultDiagramModel;
import com.syllogic.jfc.diagram.DiagramComponent;
import com.syllogic.jfc.diagram.DiagramModel;
import com.syllogic.jfc.diagram.DiagramRelation;
import com.syllogic.jfc.event.DiagramRelationListener;
import com.syllogic.miningmart.concepteditor.ConceptEditor;
import com.syllogic.miningmart.concepteditor.diagram.ConceptComponent;
import com.syllogic.miningmart.concepteditor.diagram.ConceptRenderer;
import com.syllogic.miningmart.concepteditor.diagram.DiagramComponentHandler;
import com.syllogic.miningmart.concepteditor.diagram.DraggebleRelationHandler;
import com.syllogic.miningmart.concepteditor.diagram.RelationshipComponent;
import com.syllogic.miningmart.concepteditor.event.BaseAttributeEvent;
import com.syllogic.miningmart.concepteditor.event.BaseAttributeListener;
import com.syllogic.miningmart.concepteditor.event.ConceptEvent;
import com.syllogic.miningmart.concepteditor.event.ConceptListener;
import com.syllogic.miningmart.concepteditor.event.RelationshipEvent;
import com.syllogic.miningmart.concepteditor.event.RelationshipListener;
import com.syllogic.miningmart.concepteditor.util.Constants;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import miningmart.m4.Concept;
import miningmart.m4.Relationship;
import org.apache.log4j.Logger;

public class DiagramDisplayHandler
implements ConceptListener,
RelationshipListener,
BaseAttributeListener {
    private static Logger logger = Logger.getLogger((String)"DiagramDisplayHandler");
    private ConceptEditor manager;
    private Diagram diagram;
    private ConceptRenderer conceptRenderer;
    private DiagramComponentHandler diagramComponentHandler;
    private DraggebleRelationHandler draggebleRelationHandler;
    private Dimension size = new Dimension(0, 0);
    private DefaultDiagramModel emptyDiagramModel = new DefaultDiagramModel();
    private Map diagramModels = new HashMap();
    private Map diagramComps = new HashMap();
    private Map diagramRels = new HashMap();

    public DiagramDisplayHandler(ConceptEditor manager) {
        this.manager = manager;
        this.setLocalAttributes();
    }

    public void setLocalAttributes() {
        this.diagram = this.manager.getDiagram();
        this.conceptRenderer = this.manager.getConceptRenderer();
        this.diagramComponentHandler = this.manager.getDiagramComponentHandler();
        this.draggebleRelationHandler = this.manager.getDraggebleRelationHandler();
    }

    public void updateDiagramView() {
        this.manager.setWaitCursor();
        if (this.isConceptSelectedInTree()) {
            Concept selectedConcept = (Concept)this.manager.getSelectedObject();
            if (this.diagramModels.containsKey(selectedConcept)) {
                this.initExistingModel(selectedConcept);
            } else {
                this.createDiagramModel(selectedConcept);
                this.layoutDiagram(selectedConcept);
            }
        } else {
            this.diagram.setModel((DiagramModel)this.emptyDiagramModel);
            this.diagram.setSize(100, 100);
        }
        this.diagram.clearSelection();
        this.diagram.revalidate();
        this.diagram.repaint();
        this.manager.setDefaultCursor();
    }

    private void initExistingModel(Concept selectedConcept) {
        DefaultDiagramModel aModel = (DefaultDiagramModel)this.diagramModels.get(selectedConcept);
        this.diagram.setModel((DiagramModel)aModel);
    }

    private boolean isConceptSelectedInTree() {
        Object select = this.manager.getSelectedObject();
        return select instanceof Concept;
    }

    private void createDiagramModel(Concept concept) {
        DefaultDiagramModel newModel = new DefaultDiagramModel();
        this.diagram.setModel((DiagramModel)newModel);
        this.diagramModels.put(concept, newModel);
        Map points = concept.getPointsContext();
        ConceptComponent masterConceptComponent = new ConceptComponent(concept);
        masterConceptComponent.addDiagramComponentListener(this.diagramComponentHandler);
        masterConceptComponent.setDefaultDiagramModel(newModel);
        masterConceptComponent.initLocation(concept.getPoint(points, concept));
        this.diagramComps.put(concept.getName() + concept.getName(), masterConceptComponent);
        newModel.addComponent((DiagramComponent)masterConceptComponent);
        Collection fromConceptRelationships = concept.getAllFromConceptRelationships();
        Iterator i = fromConceptRelationships.iterator();
        while (i.hasNext()) {
            Relationship aRelationship = (Relationship)i.next();
            Concept aToConcept = aRelationship.getToConcept();
            if (aToConcept == null) continue;
            ConceptComponent conceptComponent = null;
            if (aToConcept != concept) {
                conceptComponent = new ConceptComponent(aToConcept);
                conceptComponent.addDiagramComponentListener(this.diagramComponentHandler);
                conceptComponent.setDefaultDiagramModel(newModel);
                conceptComponent.initLocation(aToConcept.getPoint(points, concept));
                this.diagramComps.put(concept.getName() + aToConcept.getName(), conceptComponent);
                newModel.addComponent((DiagramComponent)conceptComponent);
            } else {
                conceptComponent = masterConceptComponent;
            }
            RelationshipComponent newRelComponent = new RelationshipComponent(aRelationship);
            newRelComponent.addDiagramRelationListener((DiagramRelationListener)this.draggebleRelationHandler);
            this.initRelationshipLocations(points, newRelComponent, concept);
            String keyName = concept.getName() + aRelationship.getName() + aToConcept.getName();
            this.diagramRels.put(keyName, newRelComponent);
            newRelComponent.setFromComponent(masterConceptComponent);
            newRelComponent.setToComponent(conceptComponent);
            newModel.addRelation((DiagramRelation)newRelComponent);
        }
        Collection toConceptRelationships = concept.getAllToConceptRelationships();
        i = toConceptRelationships.iterator();
        while (i.hasNext()) {
            Relationship aRelationship = (Relationship)i.next();
            Concept aFromConcept = aRelationship.getFromConcept();
            if (aFromConcept == null || aFromConcept == concept) continue;
            ConceptComponent conceptComponent = null;
            conceptComponent = new ConceptComponent(aFromConcept);
            conceptComponent.addDiagramComponentListener(this.diagramComponentHandler);
            conceptComponent.setDefaultDiagramModel(newModel);
            conceptComponent.initLocation(aFromConcept.getPoint(points, concept));
            this.diagramComps.put(concept.getName() + aFromConcept.getName(), conceptComponent);
            newModel.addComponent((DiagramComponent)conceptComponent);
            RelationshipComponent newRelComponent = new RelationshipComponent(aRelationship);
            newRelComponent.addDiagramRelationListener((DiagramRelationListener)this.draggebleRelationHandler);
            this.initRelationshipLocations(points, newRelComponent, concept);
            String keyName = concept.getName() + aRelationship.getName() + concept.getName();
            this.diagramRels.put(keyName, newRelComponent);
            newRelComponent.setFromComponent(conceptComponent);
            newRelComponent.setToComponent(masterConceptComponent);
            newModel.addRelation((DiagramRelation)newRelComponent);
        }
    }

    private void layoutDiagram(Concept concept) {
        int intY;
        double doubleY;
        int intX;
        double doubleX;
        double anAngle;
        Point aLocation;
        ConceptComponent aComp;
        DefaultDiagramModel selectedModel = (DefaultDiagramModel)this.diagramModels.get(concept);
        Rectangle rect = this.diagram.getVisibleRect();
        int rectWidth = (int)rect.getWidth();
        int rectHeight = (int)rect.getHeight();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Viewable area (x * y): " + rectWidth + " * " + rectHeight));
        }
        int defaultWidth = 80;
        int defaultHeight = 100;
        Point leftCenterPoint = new Point(0, rectHeight / 2);
        Point rightCenterPoint = new Point(rectWidth, rectHeight / 2);
        ConceptComponent masterComponent = (ConceptComponent)this.diagramComps.get(concept.getName() + concept.getName());
        JPanel masterPanel = (JPanel)this.conceptRenderer.getComponent(masterComponent, false);
        int masterWidth = (int)masterPanel.getPreferredSize().getWidth();
        int masterHeight = (int)masterPanel.getPreferredSize().getHeight();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Master width = " + masterWidth));
        }
        Point masterLocation = masterComponent.getLocation();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Original master location: x = " + masterLocation.x + " y = " + masterLocation.y));
        }
        if (masterLocation.equals(Constants.ORIGIN_POINT)) {
            int x = (rectWidth - masterWidth) / 2;
            int y = (rectHeight - masterHeight) / 2;
            x = x > 0 ? x : rectWidth / 2;
            y = y > 0 ? y : rectHeight / 2;
            masterComponent.setLocation(new Point(x, y));
        }
        ArrayList<ConceptComponent> fromComps = new ArrayList<ConceptComponent>();
        ArrayList<ConceptComponent> toComps = new ArrayList<ConceptComponent>();
        Iterator i = selectedModel.getRelations();
        while (i.hasNext()) {
            RelationshipComponent aRel = (RelationshipComponent)i.next();
            Relationship aRelationship = aRel.getRelationship();
            ConceptComponent fromComp = (ConceptComponent)aRel.getFromComponent();
            ConceptComponent toComp = (ConceptComponent)aRel.getToComponent();
            if (fromComp == masterComponent) {
                toComps.add(toComp);
                continue;
            }
            fromComps.add(fromComp);
        }
        int nrOfFromComps = fromComps.size();
        int nrOfToComps = toComps.size();
        double angle = 2.0 * Math.atan(rect.getHeight() / (2.0 * rect.getWidth()));
        double fromCompsAngle = angle / (double)(nrOfFromComps + 1);
        double toCompsAngle = angle / (double)(nrOfToComps + 1);
        double toRadius = 0.75 * (double)rectWidth;
        double fromRadius = 0.9 * (double)rectWidth;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Nr of from Components: " + nrOfFromComps));
            logger.debug((Object)("Nr of to Components: " + nrOfToComps));
        }
        int count = 0;
        i = toComps.iterator();
        while (i.hasNext()) {
            aComp = (ConceptComponent)i.next();
            aLocation = aComp.getLocation();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Original location for Concept: " + aComp.getConcept().getName()));
                if (aLocation != null) {
                    logger.debug((Object)("x-value: " + aLocation.x));
                    logger.debug((Object)("y-value: " + aLocation.y));
                } else {
                    logger.debug((Object)"Values are NULL");
                }
            }
            if (!aLocation.equals(Constants.ORIGIN_POINT)) continue;
            anAngle = angle / 2.0 - (double)(++count) * toCompsAngle;
            doubleX = (double)leftCenterPoint.x + toRadius * Math.cos(anAngle);
            intX = (int)doubleX;
            doubleY = (double)leftCenterPoint.y - toRadius * Math.sin(anAngle);
            intY = (int)doubleY;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calculated values for " + aComp.getConcept().getName()));
                logger.debug((Object)("x-value: " + intX + "y-value: " + intY));
            }
            intX = intX > 0 ? intX : count * 10;
            intY = intY > 0 ? intY : count * 10;
            aComp.setLocation(new Point(intX, intY));
        }
        count = 0;
        i = fromComps.iterator();
        while (i.hasNext()) {
            aComp = (ConceptComponent)i.next();
            aLocation = aComp.getLocation();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Original location for Concept: " + aComp.getConcept().getName()));
                if (aLocation != null) {
                    logger.debug((Object)("x-value: " + aLocation.x));
                    logger.debug((Object)("y-value: " + aLocation.y));
                } else {
                    logger.debug((Object)"Values are NULL");
                }
            }
            if (!aLocation.equals(Constants.ORIGIN_POINT)) continue;
            anAngle = angle / 2.0 - (double)(++count) * fromCompsAngle;
            doubleX = (double)rightCenterPoint.x - fromRadius * Math.cos(anAngle);
            intX = (int)doubleX;
            doubleY = (double)rightCenterPoint.y - fromRadius * Math.sin(anAngle);
            intY = (int)doubleY;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calculated values for " + aComp.getConcept().getName()));
                logger.debug((Object)("x-value: " + intX + "y-value: " + intY));
            }
            intX = intX > 0 ? intX : count * 10;
            intY = intY > 0 ? intY : count * 10;
            aComp.setLocation(new Point(intX, intY));
        }
    }

    public void relationshipChanged(RelationshipEvent relEvent) {
        Relationship relation = relEvent.getRelationship();
        String newName = relation.getName();
        Concept newFromConcept = relation.getFromConcept();
        Concept newToConcept = relation.getToConcept();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ");
            logger.debug((Object)("New name: " + newName));
            logger.debug((Object)("New from Concept: " + newFromConcept.getName()));
            logger.debug((Object)("New to Concept: " + newToConcept.getName()));
        }
        String oldName = relEvent.getOldName();
        Concept oldFromConcept = relEvent.getOldFromConcept();
        Concept oldToConcept = relEvent.getOldToConcept();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ");
            logger.debug((Object)("Old name: " + oldName));
            logger.debug((Object)("Old from Concept: " + oldFromConcept.getName()));
            logger.debug((Object)("Old to Concept: " + oldToConcept.getName()));
        }
        if (relEvent.isFromConceptChanged() || relEvent.isToConceptChanged()) {
            this.removeDiagramAndComponents(oldFromConcept);
            this.removeDiagramAndComponents(newFromConcept);
            this.removeDiagramAndComponents(oldToConcept);
            this.removeDiagramAndComponents(newToConcept);
        }
    }

    private void removeDiagramAndComponents(Concept masterConcept) {
        DefaultDiagramModel model = (DefaultDiagramModel)this.diagramModels.get(masterConcept);
        if (model == null) {
            return;
        }
        Iterator i = model.getComponents();
        while (i.hasNext()) {
            ConceptComponent aComp = (ConceptComponent)i.next();
            Concept aConcept = aComp.getConcept();
            String keyName = masterConcept.getName() + aConcept.getName();
            this.diagramComps.remove(keyName);
        }
        i = model.getRelations();
        while (i.hasNext()) {
            RelationshipComponent aRelComp = (RelationshipComponent)i.next();
            ConceptComponent toComp = (ConceptComponent)aRelComp.getToComponent();
            Concept toConcept = toComp.getConcept();
            String keyName = masterConcept.getName() + aRelComp.getRelationship().getName() + toConcept.getName();
            this.diagramRels.remove(keyName);
        }
        model.clear();
        this.diagramModels.remove(masterConcept);
    }

    public void relationshipCreated(RelationshipEvent e) {
        DefaultDiagramModel toModel;
        ConceptComponent fromConceptComponent;
        Relationship newRelation = e.getRelationship();
        Concept fromConcept = newRelation.getFromConcept();
        Concept toConcept = newRelation.getToConcept();
        if (fromConcept == null || toConcept == null) {
            return;
        }
        DefaultDiagramModel fromModel = (DefaultDiagramModel)this.diagramModels.get(fromConcept);
        if (fromModel != null) {
            String compKeyName = fromConcept.getName() + toConcept.getName();
            ConceptComponent toConceptComponent = (ConceptComponent)this.diagramComps.get(compKeyName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Looking up a diagram component in the cache...");
                if (toConceptComponent != null) {
                    logger.debug((Object)"\tComponent found in the cache");
                } else {
                    logger.debug((Object)"\tNo Component found in the cache");
                }
            }
            if (toConceptComponent == null) {
                toConceptComponent = new ConceptComponent(toConcept);
                toConceptComponent.addDiagramComponentListener(this.diagramComponentHandler);
                toConceptComponent.setDefaultDiagramModel(fromModel);
                toConceptComponent.initLocation(toConcept.getPoint(fromConcept));
                this.diagramComps.put(compKeyName, toConceptComponent);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Creating a new component...");
                    logger.debug((Object)("KeyName is: " + compKeyName));
                }
                fromModel.addComponent((DiagramComponent)toConceptComponent);
            }
            if ((fromConceptComponent = (ConceptComponent)this.diagramComps.get(fromConcept.getName() + fromConcept.getName())) != null) {
                RelationshipComponent newRelComponent = new RelationshipComponent(newRelation);
                newRelComponent.addDiagramRelationListener((DiagramRelationListener)this.draggebleRelationHandler);
                String keyName = fromConcept.getName() + newRelation.getName() + toConcept.getName();
                this.diagramRels.put(keyName, newRelComponent);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Creating a relation...");
                    logger.debug((Object)("KeyName is: " + keyName));
                }
                newRelComponent.setFromComponent(fromConceptComponent);
                newRelComponent.setToComponent(toConceptComponent);
                fromModel.addRelation((DiagramRelation)newRelComponent);
                this.layoutDiagram(fromConcept);
            }
        }
        if (fromConcept != toConcept && (toModel = (DefaultDiagramModel)this.diagramModels.get(toConcept)) != null) {
            ConceptComponent toConceptComponent;
            String compKeyName = toConcept.getName() + fromConcept.getName();
            fromConceptComponent = (ConceptComponent)this.diagramComps.get(compKeyName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Looking up a diagram component in the cache...");
                if (fromConceptComponent != null) {
                    logger.debug((Object)"\tComponent found in the cache");
                } else {
                    logger.debug((Object)"\tNo Component found in the cache");
                }
            }
            if (fromConceptComponent == null) {
                fromConceptComponent = new ConceptComponent(fromConcept);
                fromConceptComponent.addDiagramComponentListener(this.diagramComponentHandler);
                fromConceptComponent.setDefaultDiagramModel(toModel);
                fromConceptComponent.initLocation(fromConcept.getPoint(toConcept));
                this.diagramComps.put(compKeyName, fromConceptComponent);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Creating a new component...");
                    logger.debug((Object)("KeyName is: " + compKeyName));
                }
                toModel.addComponent((DiagramComponent)fromConceptComponent);
            }
            if ((toConceptComponent = (ConceptComponent)this.diagramComps.get(toConcept.getName() + toConcept.getName())) != null) {
                RelationshipComponent newRelComponent = new RelationshipComponent(newRelation);
                newRelComponent.addDiagramRelationListener((DiagramRelationListener)this.draggebleRelationHandler);
                String keyName = toConcept.getName() + newRelation.getName() + toConcept.getName();
                this.diagramRels.put(keyName, newRelComponent);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Creating a relation...");
                    logger.debug((Object)("KeyName is: " + keyName));
                }
                newRelComponent.setFromComponent(fromConceptComponent);
                newRelComponent.setToComponent(toConceptComponent);
                toModel.addRelation((DiagramRelation)newRelComponent);
                this.layoutDiagram(toConcept);
            }
        }
    }

    public void relationshipDeleted(RelationshipEvent e) {
        DefaultDiagramModel toModel;
        Relationship deletedRelation = e.getRelationship();
        Concept fromConcept = deletedRelation.getFromConcept();
        Concept toConcept = deletedRelation.getToConcept();
        if (fromConcept == null || toConcept == null) {
            return;
        }
        DefaultDiagramModel fromModel = (DefaultDiagramModel)this.diagramModels.get(fromConcept);
        if (fromModel != null) {
            ConceptComponent toComp;
            String keyName = fromConcept.getName() + deletedRelation.getName() + toConcept.getName();
            RelationshipComponent relComp = (RelationshipComponent)this.diagramRels.get(keyName);
            if (relComp == null) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Deleting a relation...");
                logger.debug((Object)("KeyName is: " + keyName));
            }
            fromModel.removeRelation((DiagramRelation)relComp);
            this.diagramRels.remove(keyName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Relation " + deletedRelation.getName() + " removed "));
                logger.debug((Object)("from model for Concept: " + fromConcept.getName()));
            }
            if (fromConcept != toConcept && !this.isToComponent(fromModel, toComp = (ConceptComponent)relComp.getToComponent()) && !this.isFromComponent(fromModel, toComp)) {
                fromModel.removeComponent((DiagramComponent)toComp);
                this.diagramComps.remove(fromConcept.getName() + toConcept.getName());
            }
        }
        if (fromConcept != toConcept && (toModel = (DefaultDiagramModel)this.diagramModels.get(toConcept)) != null) {
            ConceptComponent fromComp;
            String keyName = toConcept.getName() + deletedRelation.getName() + toConcept.getName();
            RelationshipComponent relComp = (RelationshipComponent)this.diagramRels.get(keyName);
            if (relComp == null) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Deleting a relation...");
                logger.debug((Object)("KeyName is: " + keyName));
            }
            toModel.removeRelation((DiagramRelation)relComp);
            this.diagramRels.remove(keyName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Relation " + deletedRelation.getName() + " removed "));
                logger.debug((Object)("from model for Concept: " + toConcept.getName()));
            }
            if (!this.isFromComponent(toModel, fromComp = (ConceptComponent)relComp.getFromComponent()) && !this.isToComponent(toModel, fromComp)) {
                toModel.removeComponent((DiagramComponent)fromComp);
                this.diagramComps.remove(fromConcept.getName() + fromConcept.getName());
            }
        }
    }

    private boolean isToComponent(DefaultDiagramModel model, ConceptComponent comp) {
        Iterator i = model.getRelations();
        while (i.hasNext()) {
            RelationshipComponent aRel = (RelationshipComponent)i.next();
            ConceptComponent toComponent = (ConceptComponent)aRel.getToComponent();
            if (toComponent != comp) continue;
            return true;
        }
        return false;
    }

    private boolean isFromComponent(DefaultDiagramModel model, ConceptComponent comp) {
        Iterator i = model.getRelations();
        while (i.hasNext()) {
            RelationshipComponent aRel = (RelationshipComponent)i.next();
            ConceptComponent fromComponent = (ConceptComponent)aRel.getFromComponent();
            if (fromComponent != comp) continue;
            return true;
        }
        return false;
    }

    public void conceptChanged(ConceptEvent e) {
    }

    public void conceptCreated(ConceptEvent e) {
    }

    public void conceptDeleted(ConceptEvent e) {
        Object aKey;
        this.diagram.setModel((DiagramModel)this.emptyDiagramModel);
        this.diagram.revalidate();
        this.diagram.repaint();
        Concept deletedConcept = e.getConcept();
        String conceptName = deletedConcept.getName();
        ArrayList effectedComps = new ArrayList();
        ArrayList<String> relevantKeys = new ArrayList<String>();
        Set compKeys = this.diagramComps.keySet();
        Iterator i = compKeys.iterator();
        while (i.hasNext()) {
            String keyName = (String)i.next();
            if (!keyName.endsWith(conceptName)) continue;
            relevantKeys.add(keyName);
        }
        i = ((AbstractList)relevantKeys).iterator();
        while (i.hasNext()) {
            aKey = i.next();
            Object conceptComp = this.diagramComps.get(aKey);
            effectedComps.add(conceptComp);
        }
        i = ((AbstractList)effectedComps).iterator();
        while (i.hasNext()) {
            ConceptComponent aComp = (ConceptComponent)i.next();
            DefaultDiagramModel aModel = aComp.getDefaultDiagramModel();
            aModel.removeComponent((DiagramComponent)aComp);
        }
        i = ((AbstractList)relevantKeys).iterator();
        while (i.hasNext()) {
            aKey = i.next();
            this.diagramComps.remove(aKey);
        }
    }

    public void baseAttributeChanged(BaseAttributeEvent e) {
    }

    public void baseAttributeCreated(BaseAttributeEvent e) {
    }

    public void baseAttributeDeleted(BaseAttributeEvent e) {
        this.diagram.revalidate();
        this.diagram.repaint();
    }

    private void initRelationshipLocations(Map points, RelationshipComponent relComp, Concept context) {
        Relationship relation = relComp.getRelationship();
        Point point = relation.getPoint(points, context, "FromCtrlpoint");
        relComp.initEndPoint(2, point);
        point = relation.getPoint(points, context, "ToCtrlpoint");
        relComp.initEndPoint(3, point);
        point = relation.getPoint(points, context, "FromEndpoint");
        relComp.initEndPoint(0, point);
        point = relation.getPoint(points, context, "ToEndpoint");
        relComp.initEndPoint(1, point);
    }
}

