/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.diagram;

import com.syllogic.jfc.diagram.ComponentRenderer;
import com.syllogic.miningmart.concepteditor.diagram.ConceptComponent;
import com.syllogic.miningmart.concepteditor.util.Resizable;
import com.syllogic.miningmart.concepteditor.util.Scalable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;

public class ConceptRenderer
extends JPanel
implements ComponentRenderer {
    private boolean selected = false;
    private Color selectionColor = Color.red;
    private Color defaultColor = Color.gray;
    private int selectionWidth = 2;
    private int defaultWidth = 1;
    private JLabel titleLabel;
    private JTextArea attributeTextArea;
    private JLabel methodLabel;

    public ConceptRenderer() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.titleLabel = new JLabel();
        this.attributeTextArea = new JTextArea();
        this.attributeTextArea.setBackground(this.getBackground());
        this.attributeTextArea.setForeground(this.getForeground());
        this.attributeTextArea.setFont(this.getFont());
        this.methodLabel = new JLabel();
        this.titleLabel.setBorder(BorderFactory.createLineBorder(this.defaultColor, this.defaultWidth));
        this.attributeTextArea.setBorder(BorderFactory.createLineBorder(this.defaultColor, this.defaultWidth));
        this.methodLabel.setText(" ");
        this.methodLabel.setBorder(BorderFactory.createLineBorder(this.defaultColor, this.defaultWidth));
        this.add("North", this.titleLabel);
        this.add("Center", this.attributeTextArea);
        this.add("South", this.methodLabel);
    }

    public boolean isShowing() {
        return true;
    }

    public JComponent getComponent(Object object, boolean selected) {
        ConceptComponent aComponent = (ConceptComponent)object;
        Concept aConcept = aComponent.getConcept();
        this.titleLabel.setText(" " + aConcept.getName() + " ");
        if (selected) {
            this.setSelected();
        } else {
            this.setNotSelected();
        }
        if (aComponent.getShowAttributes()) {
            this.setAttributeNames(aConcept);
        } else {
            this.attributeTextArea.setText(" ");
        }
        if (aComponent instanceof Resizable && aComponent instanceof Scalable) {
            if (aComponent.getUseSize() || !aComponent.getShowAttributes()) {
                int scale = aComponent.getScale();
                Dimension aDim = aComponent.getSize();
                aDim.setSize(aDim.width * scale / 100, aDim.height * scale / 100);
                this.setPreferredSize(aDim);
            } else {
                this.setPreferredSize(null);
            }
        } else {
            this.setPreferredSize(null);
        }
        return this;
    }

    private void setAttributeNames(Concept concept) {
        Collection baseAttributes = concept.getAllBaseAttributes();
        StringBuffer anAttributeNameList = new StringBuffer();
        Iterator i = baseAttributes.iterator();
        while (i.hasNext()) {
            BaseAttribute aBaseAttribute = (BaseAttribute)i.next();
            if (aBaseAttribute == null) continue;
            anAttributeNameList.append(" ").append(aBaseAttribute.getName()).append(" ").append("\n");
        }
        if (anAttributeNameList != null && anAttributeNameList.length() >= 1) {
            String attributeList = anAttributeNameList.substring(0, anAttributeNameList.length() - 1);
            this.attributeTextArea.setText(attributeList);
        } else {
            this.attributeTextArea.setText(" ");
        }
    }

    private void setSelected() {
        this.setBorder(BorderFactory.createLineBorder(this.selectionColor, this.selectionWidth));
    }

    private void setNotSelected() {
        this.setBorder(BorderFactory.createLineBorder(this.defaultColor, this.defaultWidth));
    }
}

