/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.db;

import com.syllogic.miningmart.concepteditor.db.DBConnectInfo;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ReadDbConfigFile {
    private static Logger logger = Logger.getLogger((String)"ReadDbConfigFile");
    private String fileName;

    public ReadDbConfigFile() {
        this.fileName = "db.config";
    }

    public ReadDbConfigFile(String fileName) {
        this.fileName = fileName;
    }

    public DBConnectInfo getDBConnectInfo() {
        FileReader fr;
        String sid = null;
        String username = null;
        String password = null;
        String driver = null;
        String location = null;
        String connectStr = null;
        try {
            fr = new FileReader(this.fileName);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Database configuration file not found.");
            String message = "Database configuration file not found!";
            JOptionPane.showMessageDialog(null, message, "Error", 2);
            return null;
        }
        LineNumberReader lnr = new LineNumberReader(fr);
        ArrayList<String> stringValues = new ArrayList<String>();
        try {
            String aString = lnr.readLine();
            while (aString != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reading line from db configuration file:" + aString));
                }
                stringValues.add(aString);
                aString = lnr.readLine();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Problem reading from the db configuration file.", (Throwable)e);
            String message = "Problem reading from the db configuration file!";
            JOptionPane.showMessageDialog(null, message, "Error", 2);
            return null;
        }
        try {
            lnr.close();
            fr.close();
        }
        catch (IOException e) {
            logger.error((Object)"Could not close reader streams.", (Throwable)e);
        }
        if (stringValues.size() >= 5) {
            sid = (String)stringValues.get(0);
            username = (String)stringValues.get(1);
            password = (String)stringValues.get(2);
            driver = (String)stringValues.get(3);
            location = (String)stringValues.get(4);
        }
        if (stringValues.size() >= 11) {
            sid = (String)stringValues.get(6);
            username = (String)stringValues.get(7);
            password = (String)stringValues.get(8);
            driver = (String)stringValues.get(9);
            location = (String)stringValues.get(10);
        }
        if (sid == null || username == null || password == null || driver == null || location == null) {
            logger.error((Object)"Database configuration file seems not properly formed.");
            String message = "Database configuration file should have the following format:\nLine 1: SID name MiningMart Metadata schema \nLine 2: username\nLine 3: password\nLine 4: driver (e.g. jdbc:oracle:thin:)\nLine 5: location (e.g. @server:1521:)\nLine 6: empty\nLine 7: SID name business data\nLine 8: username\nLine 9: password\nLine 4: driver (e.g. jdbc:oracle:thin:)\nLine 5: location (e.g. @server:1521)";
            JOptionPane.showMessageDialog(null, message, "Error reading db connect info", 2);
            return null;
        }
        connectStr = driver + location;
        DBConnectInfo dbConnectInfo = new DBConnectInfo();
        dbConnectInfo.setSid(sid);
        dbConnectInfo.setUsername(username);
        dbConnectInfo.setPassword(password);
        dbConnectInfo.setConnectStr(connectStr);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read the following info from " + this.fileName + ": "));
            logger.debug((Object)("SID: " + sid));
            logger.debug((Object)("Username: " + username));
            logger.debug((Object)("Password: " + password));
            logger.debug((Object)("Driver: " + driver));
            logger.debug((Object)("Location: " + location));
            logger.debug((Object)("Connect string: " + connectStr));
        }
        return dbConnectInfo;
    }
}

