/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.db;

import com.syllogic.miningmart.concepteditor.db.DBConnectInfo;
import com.syllogic.miningmart.concepteditor.db.DBObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import miningmart.m4.M4Interface;
import org.apache.log4j.Logger;

public class DBUtil {
    private static Logger logger = Logger.getLogger((String)"DBUtil");

    public static List executeSQLQC1(DBConnectInfo dbConnectInfo, String sqlString, int maxRows) throws SQLException {
        List columnNames;
        String firstColumnName;
        Map tableData = DBUtil.executeSQLQ(dbConnectInfo, sqlString, maxRows);
        List firstColumnData = (List)tableData.get(firstColumnName = (columnNames = (List)tableData.get("mmColumnNames")).get(0).toString());
        return firstColumnData != null ? firstColumnData : new ArrayList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map executeSQLQ(DBConnectInfo dbConnectInfo, String sqlString, int maxRows) throws SQLException {
        String sid = dbConnectInfo.getSid();
        String username = dbConnectInfo.getUsername();
        String password = dbConnectInfo.getPassword();
        String connectStr = dbConnectInfo.getConnectStr();
        String url = connectStr + sid;
        Connection con = null;
        ResultSet resultSet = null;
        HashMap aMap = new HashMap();
        int numColumns = 0;
        String columnName = "";
        try {
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                con = DriverManager.getConnection(url, username, password);
                resultSet = con.prepareCall(sqlString).executeQuery();
                ResultSetMetaData rsmd = resultSet.getMetaData();
                numColumns = rsmd.getColumnCount();
                int rowNum = 0;
                while (resultSet.next() && rowNum < maxRows) {
                    int i = 1;
                    while (i <= numColumns) {
                        columnName = rsmd.getColumnName(i);
                        ArrayList<Object> aList = (ArrayList<Object>)aMap.get(columnName);
                        if (aList == null) {
                            aList = new ArrayList<Object>();
                            aMap.put(columnName, aList);
                        }
                        aList.add(resultSet.getObject(i));
                        ++i;
                    }
                    ++rowNum;
                }
                ArrayList<String> cList = new ArrayList<String>();
                int i = 1;
                while (i <= numColumns) {
                    columnName = rsmd.getColumnName(i);
                    cList.add(columnName);
                    ++i;
                }
                aMap.put("mmColumnNames", cList);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"Could not load oracle database driver", (Throwable)e);
                String message = "Could not load oracle database driver";
                JOptionPane.showMessageDialog(null, message, "Error", 0);
                Map map = null;
                Object var18_23 = null;
                if (resultSet == null) return map;
                resultSet.close();
                return map;
            }
            Object var18_22 = null;
            if (resultSet == null) return aMap;
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            if (resultSet == null) throw throwable;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        return aMap;
    }

    public static String convertOracleDatatype(String oracleDatatype) {
        if (oracleDatatype.equalsIgnoreCase("VARCHAR2")) {
            return "STRING";
        }
        if (oracleDatatype.equalsIgnoreCase("NUMBER")) {
            return "NUMBER";
        }
        if (oracleDatatype.equalsIgnoreCase("DATE")) {
            return "DATE";
        }
        if (oracleDatatype.equalsIgnoreCase("CHAR")) {
            return "STRING";
        }
        if (oracleDatatype.equalsIgnoreCase("FLOAT")) {
            return "NUMBER";
        }
        if (oracleDatatype.equalsIgnoreCase("LONG")) {
            return "NUMBER";
        }
        if (oracleDatatype.equalsIgnoreCase("VARCHAR")) {
            return "STRING";
        }
        return null;
    }

    public static Collection getDBObjects() {
        ArrayList<DBObject> dbObjects = new ArrayList<DBObject>();
        DBConnectInfo dbConnectInfo = DBConnectInfo.getDBConnectInfo();
        M4Interface m4Interface = M4Interface.getInstance();
        if (dbConnectInfo == null) {
            return dbObjects;
        }
        String username = dbConnectInfo.getUsername();
        int maxRows = 1000;
        try {
            List dbTables = DBUtil.executeSQLQC1(dbConnectInfo, "SELECT TABLE_NAME FROM USER_TABLES", maxRows);
            String SELECT_MM_TABLENAMES = "SELECT OBJNAME FROM\t\tDBTRASH_T WHERE\tOBJTYPE = 'T' AND\t\tUPPER(schemaname) = UPPER('" + username + "')";
            List mmTables = m4Interface.executeSQLQC1(SELECT_MM_TABLENAMES, maxRows);
            if (mmTables != null) {
                dbTables.removeAll(mmTables);
            }
            Iterator it = dbTables.iterator();
            while (it.hasNext()) {
                DBObject aDBObject = new DBObject((String)it.next(), "TABLE");
                dbObjects.add(aDBObject);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Table added");
            }
            List dbViews = DBUtil.executeSQLQC1(dbConnectInfo, "SELECT VIEW_NAME FROM USER_VIEWS", maxRows);
            String SELECT_MM_VIEWNAMES = "SELECT OBJNAME FROM\t\tDBTRASH_T WHERE\tOBJTYPE = 'V' AND\t\tUPPER(schemaname) = UPPER('" + username + "')";
            List mmViews = m4Interface.executeSQLQC1(SELECT_MM_VIEWNAMES, maxRows);
            if (mmViews != null) {
                dbViews.removeAll(mmViews);
            }
            it = dbViews.iterator();
            while (it.hasNext()) {
                DBObject aDBObject = new DBObject((String)it.next(), "VIEW");
                dbObjects.add(aDBObject);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"View added");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return dbObjects;
    }
}

