/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.DragHandler;
import com.syllogic.jfc.diagram.DraggebleRelation;
import com.syllogic.jfc.diagram.DraggebleRelationRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class RelationDragHandler
implements DragHandler {
    private static final int MOD_MASK = 47;
    private boolean itsIsDragging = false;
    private boolean itsFirstDrag;
    private DraggebleRelation itsRel;
    private DraggebleRelationRenderer itsRenderer;
    private Rectangle itsRect0;
    private Rectangle itsRect1;
    private Point[] itsPoints;
    private Point[] itsOrigPoints;
    private int itsDragPoint;

    public boolean isDragPoint(Diagram theDiagram, MouseEvent theEvent) {
        if ((theEvent.getModifiers() & 0x2F) != 2) {
            return false;
        }
        Object[] anObj = theDiagram.getSelection();
        if (anObj.length != 1 || !(anObj[0] instanceof DraggebleRelation)) {
            return false;
        }
        DraggebleRelation aRel = (DraggebleRelation)anObj[0];
        anObj[0] = theDiagram.getRelationRenderer(aRel.getClass());
        if (!(anObj[0] instanceof DraggebleRelationRenderer)) {
            return false;
        }
        DraggebleRelationRenderer aRenderer = (DraggebleRelationRenderer)anObj[0];
        Point[] aList = aRenderer.getPoints(aRel, theDiagram.getRectangle(aRel.getFromComponent()), theDiagram.getRectangle(aRel.getToComponent()));
        Rectangle aRect = new Rectangle(theEvent.getPoint());
        aRect.x -= 2;
        aRect.y -= 2;
        aRect.setSize(5, 5);
        return aRect.contains(aList[0]) || aRect.contains(aList[1]) || aRect.contains(aList[2]) || aRect.contains(aList[3]);
    }

    public boolean isDragging(Diagram theDiagram) {
        return this.itsIsDragging;
    }

    private void setPoints(Point[] thePoints) {
        this.itsOrigPoints = thePoints;
        this.itsPoints = new Point[thePoints.length];
        int i = 0;
        while (i < thePoints.length) {
            this.itsPoints[i] = (Point)thePoints[i].clone();
            ++i;
        }
    }

    private void updatePoints(int theDragPoint, Point thePoint) {
        int dx = thePoint.x - this.itsOrigPoints[theDragPoint].x;
        int dy = thePoint.y - this.itsOrigPoints[theDragPoint].y;
        this.itsPoints[theDragPoint].x = this.itsOrigPoints[theDragPoint].x + dx;
        this.itsPoints[theDragPoint].y = this.itsOrigPoints[theDragPoint].y + dy;
        if (theDragPoint == 0) {
            this.itsPoints[2].x = this.itsOrigPoints[2].x + dx;
            this.itsPoints[2].y = this.itsOrigPoints[2].y + dy;
        } else if (theDragPoint == 1) {
            this.itsPoints[3].x = this.itsOrigPoints[3].x + dx;
            this.itsPoints[3].y = this.itsOrigPoints[3].y + dy;
        }
    }

    private void paintDragShape(Graphics2D g2) {
        g2.draw(this.itsRenderer.getDragShape(this.itsRel, this.itsRect0, this.itsRect1, this.itsPoints));
    }

    private void cleanup() {
        this.itsIsDragging = false;
        this.itsRel = null;
        this.itsRenderer = null;
        this.itsRect0 = null;
        this.itsRect1 = null;
        this.itsPoints = null;
        this.itsOrigPoints = null;
    }

    public void dragStart(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        this.itsRel = (DraggebleRelation)theDiagram.getSelection()[0];
        this.itsRenderer = (DraggebleRelationRenderer)theDiagram.getRelationRenderer(this.itsRel.getClass());
        this.itsRect0 = theDiagram.getRectangle(this.itsRel.getFromComponent());
        this.itsRect1 = theDiagram.getRectangle(this.itsRel.getToComponent());
        this.setPoints(this.itsRenderer.getPoints(this.itsRel, this.itsRect0, this.itsRect1));
        Rectangle aRect = new Rectangle(evt.getPoint());
        aRect.x -= 2;
        aRect.y -= 2;
        aRect.setSize(5, 5);
        this.itsDragPoint = aRect.contains(this.itsPoints[0]) ? 0 : (aRect.contains(this.itsPoints[1]) ? 1 : (aRect.contains(this.itsPoints[2]) ? 2 : 3));
        this.itsFirstDrag = true;
        this.itsIsDragging = true;
    }

    public void drag(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (!this.itsIsDragging) {
            return;
        }
        if (this.itsDragPoint == 0 && !this.itsRect0.contains(evt.getPoint())) {
            return;
        }
        if (this.itsDragPoint == 1 && !this.itsRect1.contains(evt.getPoint())) {
            return;
        }
        g2.setXORMode(theDiagram.getBackground());
        g2.setColor(Color.black);
        if (!this.itsFirstDrag) {
            this.paintDragShape(g2);
        } else {
            this.itsFirstDrag = false;
        }
        this.updatePoints(this.itsDragPoint, evt.getPoint());
        this.paintDragShape(g2);
    }

    public void dragEnd(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (!this.itsIsDragging) {
            return;
        }
        g2.setXORMode(theDiagram.getBackground());
        g2.setColor(Color.black);
        if (!this.itsFirstDrag) {
            this.paintDragShape(g2);
        }
        Point aPoint = evt.getPoint();
        if (this.itsDragPoint == 0 && !this.itsRect0.contains(evt.getPoint())) {
            aPoint = null;
        } else if (this.itsDragPoint == 1 && !this.itsRect1.contains(evt.getPoint())) {
            aPoint = null;
        }
        if (aPoint != null) {
            this.updatePoints(this.itsDragPoint, aPoint);
        }
        int dx = this.itsPoints[this.itsDragPoint].x - this.itsOrigPoints[this.itsDragPoint].x;
        int dy = this.itsPoints[this.itsDragPoint].y - this.itsOrigPoints[this.itsDragPoint].y;
        aPoint = this.itsRel.getEndPoint(this.itsDragPoint);
        aPoint.x += dx;
        aPoint.y += dy;
        this.itsRel.setEndPoint(this.itsDragPoint, aPoint);
        theDiagram.repaintLater();
        this.cleanup();
    }

    public void dragAbort(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        g2.setXORMode(theDiagram.getBackground());
        g2.setColor(Color.black);
        if (!this.itsFirstDrag) {
            this.paintDragShape(g2);
        } else {
            this.itsFirstDrag = false;
        }
        System.err.println("dragAbort()");
        this.cleanup();
    }
}

