/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.ClickHandler;
import com.syllogic.jfc.diagram.ComponentRenderer;
import com.syllogic.jfc.diagram.DefaultDiagramModel;
import com.syllogic.jfc.diagram.DefaultDraggebleRelationRenderer;
import com.syllogic.jfc.diagram.DefaultRelationRenderer;
import com.syllogic.jfc.diagram.DiagramComponent;
import com.syllogic.jfc.diagram.DiagramRelation;
import com.syllogic.jfc.diagram.DraggebleRelation;
import com.syllogic.jfc.diagram.MoveDragHandler;
import com.syllogic.jfc.diagram.PersistentStyleRelation;
import com.syllogic.jfc.diagram.RelationDragHandler;
import com.syllogic.jfc.diagram.SelectionClickHandler;
import com.syllogic.jfc.diagram.SelectionDragHandler;
import com.syllogic.jfc.event.DiagramComponentListener;
import com.syllogic.jfc.event.DiagramRelationListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DiagramTester {
    static /* synthetic */ Class class$com$syllogic$jfc$diagram$DiagramTester$TestComponent;
    static /* synthetic */ Class class$com$syllogic$jfc$diagram$DiagramTester$DTestRelation;
    static /* synthetic */ Class class$java$lang$Object;

    private static DiagramRelation makeRelation(DiagramComponent theFrom, DiagramComponent theTo, boolean wantArrow, boolean wantCubic) {
        DTestRelation aRel = new DTestRelation(theFrom, theTo);
        aRel.setStyleOption("Cubic", new Boolean(wantCubic));
        aRel.setStyleOption("ArrowHalfway", new Boolean(wantArrow));
        return aRel;
    }

    public static void main(String[] args) {
        DefaultDiagramModel m = new DefaultDiagramModel();
        TestComponent c1 = new TestComponent("Component 1", 10, 10);
        Test2Component c2 = new Test2Component("Component 2", 150, 20);
        TestComponent c3 = new TestComponent("Component 3", 50, 100);
        Test2Component c4 = new Test2Component("Component 4", 200, 100);
        m.addComponent(c1);
        m.addComponent(c2);
        m.addComponent(c3);
        m.addComponent(c4);
        m.addRelation(DiagramTester.makeRelation(c1, c2, true, false));
        m.addRelation(DiagramTester.makeRelation(c2, c3, true, false));
        m.addRelation(DiagramTester.makeRelation(c1, c3, false, true));
        m.addRelation(DiagramTester.makeRelation(c4, c2, false, false));
        DTestRelation dr = (DTestRelation)DiagramTester.makeRelation(c1, c1, true, true);
        dr.setEndPoint(0, new Point(5, 5));
        dr.setEndPoint(2, new Point(100, 0));
        dr.setEndPoint(3, new Point(0, 100));
        dr.setEndPoint(1, new Point(-5, -5));
        m.addRelation(dr);
        Diagram d = new Diagram(m);
        d.addDragHandler(new SelectionDragHandler());
        d.addDragHandler(new MoveDragHandler());
        d.addDragHandler(new RelationDragHandler());
        d.addClickHandler(new SelectionClickHandler());
        d.addClickHandler(new ClickHandler(){

            public void click(Diagram theDiagram, MouseEvent theEvent) {
                DiagramRelation aRel = theDiagram.findRelation(theEvent.getPoint());
                if (aRel != null) {
                    System.err.println("Clicked on relation \"" + aRel + "\"");
                }
            }
        });
        d.setComponentRenderer(class$com$syllogic$jfc$diagram$DiagramTester$TestComponent == null ? (class$com$syllogic$jfc$diagram$DiagramTester$TestComponent = DiagramTester.class$("com.syllogic.jfc.diagram.DiagramTester$TestComponent")) : class$com$syllogic$jfc$diagram$DiagramTester$TestComponent, new TestRenderer());
        DefaultDraggebleRelationRenderer aRenderer = new DefaultDraggebleRelationRenderer();
        aRenderer.setCubicLine(true);
        aRenderer.setArrow(true);
        d.setRelationRenderer(class$com$syllogic$jfc$diagram$DiagramTester$DTestRelation == null ? (class$com$syllogic$jfc$diagram$DiagramTester$DTestRelation = DiagramTester.class$("com.syllogic.jfc.diagram.DiagramTester$DTestRelation")) : class$com$syllogic$jfc$diagram$DiagramTester$DTestRelation, aRenderer);
        DefaultRelationRenderer ar = (DefaultRelationRenderer)d.getRelationRenderer(class$java$lang$Object == null ? (class$java$lang$Object = DiagramTester.class$("java.lang.Object")) : class$java$lang$Object);
        ar.setArrow(true);
        ar.setCubicLine(true);
        JFrame aFrame = new JFrame("Diagram test");
        aFrame.setContentPane(d);
        ((Component)aFrame).setSize(200, 200);
        ((Component)aFrame).setLocation(200, 200);
        aFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        ((Component)aFrame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TestRenderer
    extends JPanel
    implements ComponentRenderer {
        private JLabel itsLabel = new JLabel();

        public boolean isShowing() {
            return true;
        }

        public TestRenderer() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            this.setOpaque(true);
            this.add((Component)this.itsLabel, "North");
            JPanel aPanel = new JPanel();
            aPanel.setOpaque(false);
            aPanel.setLayout(new BoxLayout(aPanel, 1));
            aPanel.add(new JLabel("Row 1"));
            aPanel.add(new JLabel("Row 2"));
            aPanel.add(new JLabel("Row 3"));
            aPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add((Component)aPanel, "Center");
            this.add((Component)new JLabel("South"), "South");
        }

        public JComponent getComponent(Object theObject, boolean isSelected) {
            this.setForeground(isSelected ? Color.white : Color.black);
            this.setBackground(isSelected ? Color.black : Color.lightGray);
            this.itsLabel.setText(theObject.toString());
            this.doLayout();
            return this;
        }
    }

    static class DTestRelation
    extends TestRelation
    implements DraggebleRelation,
    PersistentStyleRelation {
        private HashMap itsOptions = new HashMap();
        private Point[] itsPoints = new Point[4];

        public DTestRelation(DiagramComponent theFrom, DiagramComponent theTo) {
            super(theFrom, theTo);
        }

        public Object getStyleOption(String theOption) {
            return this.itsOptions.get(theOption);
        }

        public void setStyleOption(String theOption, Object theValue) {
            this.itsOptions.put(theOption, theValue);
        }

        public Point getEndPoint(int theEndPoint) {
            return this.itsPoints[theEndPoint];
        }

        public void setEndPoint(int theEndPoint, Point thePoint) {
            this.itsPoints[theEndPoint] = thePoint;
        }
    }

    static class TestRelation
    implements DiagramRelation {
        private DiagramComponent itsFrom;
        private DiagramComponent itsTo;

        public TestRelation(DiagramComponent theFrom, DiagramComponent theTo) {
            this.itsFrom = theFrom;
            this.itsTo = theTo;
        }

        public void setFromComponent(DiagramComponent theFromComponent) {
            this.itsFrom = theFromComponent;
        }

        public void setToComponent(DiagramComponent theToComponent) {
            this.itsTo = theToComponent;
        }

        public DiagramComponent getFromComponent() {
            return this.itsFrom;
        }

        public DiagramComponent getToComponent() {
            return this.itsTo;
        }

        public void addDiagramRelationListener(DiagramRelationListener l) {
        }

        public void removeDiagramRelationListener(DiagramRelationListener l) {
        }
    }

    static class Test2Component
    implements DiagramComponent {
        private String itsText = "text";
        private Point itsLocation = new Point(0, 0);

        public Test2Component(String text, int x, int y) {
            this.itsText = text;
            this.setLocation(x, y);
        }

        public String toString() {
            return this.itsText;
        }

        public void setLocation(Point p) {
            this.setLocation(p.x, p.y);
        }

        public void setLocation(int x, int y) {
            this.itsLocation.x = x;
            this.itsLocation.y = y;
        }

        public Point getLocation() {
            return (Point)this.itsLocation.clone();
        }

        public void addDiagramComponentListener(DiagramComponentListener l) {
        }

        public void removeDiagramComponentListener(DiagramComponentListener l) {
        }
    }

    static class TestComponent
    implements DiagramComponent {
        private String itsText = "text";
        private Point itsLocation = new Point(0, 0);

        public TestComponent(String text, int x, int y) {
            this.itsText = text;
            this.setLocation(x, y);
        }

        public String toString() {
            return this.itsText;
        }

        public void setLocation(Point p) {
            this.setLocation(p.x, p.y);
        }

        public void setLocation(int x, int y) {
            this.itsLocation.x = x;
            this.itsLocation.y = y;
        }

        public Point getLocation() {
            return (Point)this.itsLocation.clone();
        }

        public void addDiagramComponentListener(DiagramComponentListener l) {
        }

        public void removeDiagramComponentListener(DiagramComponentListener l) {
        }
    }
}

