/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.util.Objects;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.property.BoundPropertyAdapter;
import org.jboss.util.property.PropertyEvent;
import org.jboss.util.property.PropertyException;
import org.jboss.util.property.PropertyMap;

public class MethodBoundPropertyListener
extends BoundPropertyAdapter {
    protected final String propertyName;
    protected final Object instance;
    protected final Method setter;
    protected final PropertyDescriptor descriptor;

    public MethodBoundPropertyListener(Object instance, String propertyName, String beanPropertyName) {
        this.instance = instance;
        this.propertyName = propertyName;
        try {
            this.descriptor = this.getPropertyDescriptor(beanPropertyName);
            if (this.descriptor == null) {
                throw new PropertyException("missing method for: " + beanPropertyName);
            }
            this.setter = this.descriptor.getWriteMethod();
            if (this.setter == null) {
                throw new PropertyException("missing setter method for: " + beanPropertyName);
            }
            try {
                this.setter.setAccessible(true);
            }
            catch (SecurityException e) {
                ThrowableHandler.add(e);
            }
        }
        catch (IntrospectionException e) {
            throw new PropertyException(e);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String beanPropertyName) throws IntrospectionException {
        Class<?> instanceType = this.instance.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(instanceType);
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        PropertyDescriptor descriptor = null;
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getName().equals(beanPropertyName)) {
                descriptor = descriptors[i];
                break;
            }
            ++i;
        }
        return descriptor;
    }

    public MethodBoundPropertyListener(Object instance, String propertyName) {
        this(instance, propertyName, propertyName);
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    protected void invokeSetter(String value) {
        try {
            Class<?> type = this.descriptor.getPropertyType();
            Object coerced = Objects.coerce(value, type);
            this.setter.invoke(this.instance, coerced);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof PropertyException) {
                throw (PropertyException)target;
            }
            throw new PropertyException(target);
        }
        catch (Exception e) {
            throw new PropertyException(e);
        }
    }

    public void propertyAdded(PropertyEvent event) {
        this.invokeSetter(event.getPropertyValue());
    }

    public void propertyChanged(PropertyEvent event) {
        this.invokeSetter(event.getPropertyValue());
    }

    public void propertyBound(PropertyMap map) {
        if (map.containsProperty(this.propertyName)) {
            this.invokeSetter(map.getProperty(this.propertyName));
        }
    }
}

